<nav id="sidebar" class="sidebar">
    <div class="sidebar-content">
        <!-- Logo -->
        <div class="sidebar-brand d-flex align-items-center justify-content-center py-3 mb-3">
            <a href="<?php echo e(url('admin')); ?>" class="px-3">
                <img src="<?php echo e(asset('assets/images/logo.png')); ?>" alt="Socialink Logo" class="sidebar-logo">
            </a>
        </div>

        <div class="sidebar-user mb-4">
            <div class="d-flex justify-content-center">
                <div class="user-avatar">
                    <img src="<?php echo e(auth()->user()->profile_photo ?? asset('assets/images/default-avatar.png')); ?>" alt="User" class="img-fluid rounded-circle">
                    <span class="user-status online"></span>
                </div>
            </div>
            <div class="text-center mt-2">
                <h5 class="user-name mb-0"><?php echo e(auth()->user()->name); ?></h5>
                <span class="user-role"><?php echo e(__('Administrator')); ?></span>
            </div>
        </div>

        <!-- Navigation -->
        <ul class="sidebar-nav">
            <!-- Main Section -->
            <li class="sidebar-header">
                <span><?php echo e(__('MAIN')); ?></span>
            </li>

            <li class="sidebar-item <?php echo e(request()->is('admin/dashboard') ? 'active' : ''); ?>">
                <a href="<?php echo e(url('admin/dashboard')); ?>" class="sidebar-link">
                    <i class="fas fa-tachometer-alt sidebar-icon"></i>
                    <span><?php echo e(__('Dashboard')); ?></span>
                </a>
            </li>

            <!-- User & Community Management -->
            <li class="sidebar-header">
                <span><?php echo e(__('COMMUNITY')); ?></span>
            </li>
            
            <li class="sidebar-item <?php echo e(request()->is('admin/groups*') ? 'active' : ''); ?>">
                <a href="#" class="sidebar-link collapsed" data-bs-toggle="collapse" data-bs-target="#groupsMenu" aria-expanded="<?php echo e(request()->is('admin/groups*') ? 'true' : 'false'); ?>">
                    <i class="fas fa-users sidebar-icon"></i>
                    <span><?php echo e(__('Groups')); ?></span>
                    <i class="fas fa-chevron-right sidebar-arrow ms-auto"></i>
                </a>
                <ul id="groupsMenu" class="sidebar-dropdown list-unstyled collapse <?php echo e(request()->is('admin/groups*') ? 'show' : ''); ?>">
                    <li class="sidebar-item <?php echo e(request()->is('admin/groups') || request()->is('admin/groups/show/*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.groups.index')); ?>" class="sidebar-link">
                            <i class="fas fa-list sidebar-icon-small"></i> 
                            <span>All Groups</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/groups/featured/list') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.groups.featured')); ?>" class="sidebar-link">
                            <i class="fas fa-star sidebar-icon-small"></i> 
                            <span>Featured Groups</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/groups/reported/list') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.groups.reported')); ?>" class="sidebar-link">
                            <i class="fas fa-flag sidebar-icon-small"></i> 
                            <span>Reported Groups</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/groups/categories/list') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.groups.categories')); ?>" class="sidebar-link">
                            <i class="fas fa-tags sidebar-icon-small"></i> 
                            <span>Group Categories</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/groups/statistics/view') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.groups.statistics')); ?>" class="sidebar-link">
                            <i class="fas fa-chart-bar sidebar-icon-small"></i> 
                            <span>Group Statistics</span>
                        </a>
                    </li>
                </ul>
            </li>

            <li class="sidebar-item <?php echo e(request()->is('admin/pages*') ? 'active' : ''); ?>">
                <a href="#" class="sidebar-link collapsed" data-bs-toggle="collapse" data-bs-target="#pagesMenu" aria-expanded="<?php echo e(request()->is('admin/pages*') ? 'true' : 'false'); ?>">
                    <i class="fas fa-file-alt sidebar-icon"></i>
                    <span>Pages</span>
                    <i class="fas fa-chevron-right sidebar-arrow ms-auto"></i>
                </a>
                <ul id="pagesMenu" class="sidebar-dropdown list-unstyled collapse <?php echo e(request()->is('admin/pages*') ? 'show' : ''); ?>">
                    <li class="sidebar-item <?php echo e(request()->is('admin/pages') || request()->is('admin/pages/show/*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.pages.index')); ?>" class="sidebar-link">
                            <i class="fas fa-list sidebar-icon-small"></i> 
                            <span>All Pages</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/pages/featured') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.pages.featured')); ?>" class="sidebar-link">
                            <i class="fas fa-star sidebar-icon-small"></i> 
                            <span>Featured Pages</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/pages/statistics') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.pages.statistics')); ?>" class="sidebar-link">
                            <i class="fas fa-chart-bar sidebar-icon-small"></i> 
                            <span>Page Statistics</span>
                        </a>
                    </li>
                </ul>
            </li>
            
            <li class="sidebar-item <?php echo e(request()->is('admin/events*') ? 'active' : ''); ?>">
                <a href="#" class="sidebar-link collapsed" data-bs-toggle="collapse" data-bs-target="#eventsMenu" aria-expanded="<?php echo e(request()->is('admin/events*') ? 'true' : 'false'); ?>">
                    <i class="fas fa-calendar-alt sidebar-icon"></i>
                    <span>Events</span>
                    <i class="fas fa-chevron-right sidebar-arrow ms-auto"></i>
                </a>
                <ul id="eventsMenu" class="sidebar-dropdown list-unstyled collapse <?php echo e(request()->is('admin/events*') ? 'show' : ''); ?>">
                    <li class="sidebar-item <?php echo e(request()->is('admin/events') || request()->is('admin/events/show/*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.events.index')); ?>" class="sidebar-link">
                            <i class="fas fa-list sidebar-icon-small"></i> 
                            <span>All Events</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/events/featured') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.events.featured')); ?>" class="sidebar-link">
                            <i class="fas fa-star sidebar-icon-small"></i> 
                            <span>Featured Events</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/events/statistics') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.events.statistics')); ?>" class="sidebar-link">
                            <i class="fas fa-chart-bar sidebar-icon-small"></i> 
                            <span>Event Statistics</span>
                        </a>
                    </li>
                </ul>
            </li>
            
            <li class="sidebar-item <?php echo e(request()->is('admin/pokes') ? 'active' : ''); ?>">
                <a href="<?php echo e(url('admin/pokes')); ?>" class="sidebar-link">
                    <i class="fas fa-hand-point-right sidebar-icon"></i>
                    <span>Pokes</span>
                </a>
            </li>
            
            <li class="sidebar-item <?php echo e(request()->is('admin/verification*') ? 'active' : ''); ?>">
                <a href="#" class="sidebar-link collapsed" data-bs-toggle="collapse" data-bs-target="#verificationMenu" aria-expanded="<?php echo e(request()->is('admin/verification*') ? 'true' : 'false'); ?>">
                    <i class="fas fa-check-circle sidebar-icon"></i>
                    <span>Verification</span>
                    <i class="fas fa-chevron-right sidebar-arrow ms-auto"></i>
                </a>
                <ul id="verificationMenu" class="sidebar-dropdown list-unstyled collapse <?php echo e(request()->is('admin/verification*') ? 'show' : ''); ?>">
                    <li class="sidebar-item <?php echo e(request()->is('admin/verification') && request()->query('status') == 'pending' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.verification.index', ['status' => 'pending'])); ?>" class="sidebar-link">
                            <i class="fas fa-clock sidebar-icon-small"></i> 
                            <span>Pending Requests</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/verification') && request()->query('status') == 'approved' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.verification.index', ['status' => 'approved'])); ?>" class="sidebar-link">
                            <i class="fas fa-check sidebar-icon-small"></i> 
                            <span>Approved Requests</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/verification') && request()->query('status') == 'rejected' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.verification.index', ['status' => 'rejected'])); ?>" class="sidebar-link">
                            <i class="fas fa-times sidebar-icon-small"></i> 
                            <span>Rejected Requests</span>
                        </a>
                    </li>
                </ul>
            </li>

            <!-- Content Management -->
            <li class="sidebar-header">
                <span>CONTENT</span>
            </li>
            
            <li class="sidebar-item <?php echo e(request()->is('admin/blogs*') || request()->is('admin/blog-categories*') ? 'active' : ''); ?>">
                <a href="#" class="sidebar-link collapsed" data-bs-toggle="collapse" data-bs-target="#blogMenu" aria-expanded="<?php echo e(request()->is('admin/blogs*') || request()->is('admin/blog-categories*') ? 'true' : 'false'); ?>">
                    <i class="fas fa-blog sidebar-icon"></i>
                    <span>Blog</span>
                    <i class="fas fa-chevron-right sidebar-arrow ms-auto"></i>
                </a>
                <ul id="blogMenu" class="sidebar-dropdown list-unstyled collapse <?php echo e(request()->is('admin/blogs*') || request()->is('admin/blog-categories*') ? 'show' : ''); ?>">
                    <li class="sidebar-item <?php echo e(request()->is('admin/blogs') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.blogs.index')); ?>" class="sidebar-link">
                            <i class="fas fa-list sidebar-icon-small"></i> 
                            <span>All Blogs</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/blog-categories*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.blog-categories.index')); ?>" class="sidebar-link">
                            <i class="fas fa-tags sidebar-icon-small"></i> 
                            <span>Categories</span>
                        </a>
                    </li>
                </ul>
            </li>
            
            <li class="sidebar-item <?php echo e(request()->is('admin/games*') ? 'active' : ''); ?>">
                <a href="#" class="sidebar-link collapsed" data-bs-toggle="collapse" data-bs-target="#gamesMenu" aria-expanded="<?php echo e(request()->is('admin/games*') ? 'true' : 'false'); ?>">
                    <i class="fas fa-gamepad sidebar-icon"></i>
                    <span>Games</span>
                    <i class="fas fa-chevron-right sidebar-arrow ms-auto"></i>
                </a>
                <ul id="gamesMenu" class="sidebar-dropdown list-unstyled collapse <?php echo e(request()->is('admin/games*') ? 'show' : ''); ?>">
                    <li class="sidebar-item <?php echo e(request()->is('admin/games') ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('admin/games')); ?>" class="sidebar-link">
                            <i class="fas fa-list sidebar-icon-small"></i> 
                            <span>Games List</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/games/game-categories') ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('admin/games/categories')); ?>" class="sidebar-link">
                            <i class="fas fa-tags sidebar-icon-small"></i> 
                            <span>Game Categories</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/games/create') ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('admin/games/create')); ?>" class="sidebar-link">
                            <i class="fas fa-plus-circle sidebar-icon-small"></i> 
                            <span>Add Game</span>
                        </a>
                    </li>
                </ul>
            </li>

            <li class="sidebar-item <?php echo e(request()->is('admin/movies*') ? 'active' : ''); ?>">
                <a href="#" class="sidebar-link collapsed" data-bs-toggle="collapse" data-bs-target="#moviesMenu" aria-expanded="<?php echo e(request()->is('admin/movies*') ? 'true' : 'false'); ?>">
                    <i class="fas fa-film sidebar-icon"></i>
                    <span>Movies</span>
                    <i class="fas fa-chevron-right sidebar-arrow ms-auto"></i>
                </a>
                <ul id="moviesMenu" class="sidebar-dropdown list-unstyled collapse <?php echo e(request()->is('admin/movies*') ? 'show' : ''); ?>">
                    <li class="sidebar-item <?php echo e(request()->is('admin/movies') ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('admin/movies')); ?>" class="sidebar-link">
                            <i class="fas fa-list sidebar-icon-small"></i> 
                            <span>Movies List</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/movies/create') ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('admin/movies/create')); ?>" class="sidebar-link">
                            <i class="fas fa-plus-circle sidebar-icon-small"></i> 
                            <span>Add Movie</span>
                        </a>
                    </li>
                </ul>
            </li>
            
            <li class="sidebar-item <?php echo e(request()->is('admin/custom-pages*') ? 'active' : ''); ?>">
                <a href="<?php echo e(url('admin/custom-pages')); ?>" class="sidebar-link">
                    <i class="fas fa-file-alt sidebar-icon"></i>
                    <span>Custom Pages</span>
                </a>
            </li>

            <li class="sidebar-item <?php echo e(request()->is('admin/help-center*') ? 'active' : ''); ?>">
                <a href="#" class="sidebar-link collapsed" data-bs-toggle="collapse" data-bs-target="#helpCenterMenu" aria-expanded="<?php echo e(request()->is('admin/help-center*') ? 'true' : 'false'); ?>">
                    <i class="fas fa-life-ring sidebar-icon"></i>
                    <span>Help Center</span>
                    <i class="fas fa-chevron-right sidebar-arrow ms-auto"></i>
                </a>
                <ul id="helpCenterMenu" class="sidebar-dropdown list-unstyled collapse <?php echo e(request()->is('admin/help-center*') ? 'show' : ''); ?>">
                    <li class="sidebar-item <?php echo e(request()->is('admin/help-center/topics*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.help-center.topics.index')); ?>" class="sidebar-link">
                            <i class="fas fa-layer-group sidebar-icon-small"></i>
                            <span>Topics</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/help-center/articles*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.help-center.articles.index')); ?>" class="sidebar-link">
                            <i class="fas fa-file-alt sidebar-icon-small"></i>
                            <span>Articles</span>
                        </a>
                    </li>
                </ul>
            </li>

            <!-- Commerce Section -->
            <li class="sidebar-header">
                <span>COMMERCE</span>
            </li>
            
            <li class="sidebar-item <?php echo e(request()->is('admin/marketplace*') ? 'active' : ''); ?>">
                <a href="#" class="sidebar-link collapsed" data-bs-toggle="collapse" data-bs-target="#marketplaceMenu" aria-expanded="<?php echo e(request()->is('admin/marketplace*') ? 'true' : 'false'); ?>">
                    <i class="fas fa-shopping-cart sidebar-icon"></i>
                    <span>Marketplace</span>
                    <i class="fas fa-chevron-right sidebar-arrow ms-auto"></i>
                </a>
                <ul id="marketplaceMenu" class="sidebar-dropdown list-unstyled collapse <?php echo e(request()->is('admin/marketplace*') ? 'show' : ''); ?>">
                    <li class="sidebar-item <?php echo e(request()->is('admin/marketplace/dashboard') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.marketplace.dashboard')); ?>" class="sidebar-link">
                            <i class="fas fa-tachometer-alt sidebar-icon-small"></i> 
                            <span><?php echo e(__('Dashboard')); ?></span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/marketplace/products*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.marketplace.products')); ?>" class="sidebar-link">
                            <i class="fas fa-box sidebar-icon-small"></i> 
                            <span>Products</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/marketplace/stores*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.marketplace.stores')); ?>" class="sidebar-link">
                            <i class="fas fa-store sidebar-icon-small"></i> 
                            <span>Stores</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/marketplace/orders*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.marketplace.orders')); ?>" class="sidebar-link">
                            <i class="fas fa-shipping-fast sidebar-icon-small"></i> 
                            <span>Orders</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/marketplace/reviews*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.marketplace.reviews')); ?>" class="sidebar-link">
                            <i class="fas fa-star-half-alt sidebar-icon-small"></i> 
                            <span>Reviews</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/marketplace/categories*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.marketplace.categories')); ?>" class="sidebar-link">
                            <i class="fas fa-tags sidebar-icon-small"></i> 
                            <span>Categories</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/marketplace/settings*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.marketplace.settings')); ?>" class="sidebar-link">
                            <i class="fas fa-cogs sidebar-icon-small"></i> 
                            <span>Settings</span>
                        </a>
                    </li>
                </ul>
            </li>
            
            <li class="sidebar-item <?php echo e(request()->is('admin/jobs*') || request()->is('admin/job-categories*') ? 'active' : ''); ?>">
                <a href="#" class="sidebar-link collapsed" data-bs-toggle="collapse" data-bs-target="#jobsMenu" aria-expanded="<?php echo e(request()->is('admin/jobs*') || request()->is('admin/job-categories*') ? 'true' : 'false'); ?>">
                    <i class="fas fa-briefcase sidebar-icon"></i>
                    <span>Jobs</span>
                    <i class="fas fa-chevron-right sidebar-arrow ms-auto"></i>
                </a>
                <ul id="jobsMenu" class="sidebar-dropdown list-unstyled collapse <?php echo e(request()->is('admin/jobs*') || request()->is('admin/job-categories*') ? 'show' : ''); ?>">
                    <li class="sidebar-item <?php echo e(request()->is('admin/jobs') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.jobs.index')); ?>" class="sidebar-link">
                            <i class="fas fa-list sidebar-icon-small"></i> 
                            <span>All Jobs</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/job-categories*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.job-categories.index')); ?>" class="sidebar-link">
                            <i class="fas fa-tags sidebar-icon-small"></i> 
                            <span>Job Categories</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/jobs/dashboard/stats') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.jobs.stats')); ?>" class="sidebar-link">
                            <i class="fas fa-chart-pie sidebar-icon-small"></i> 
                            <span>Job Statistics</span>
                        </a>
                    </li>
                </ul>
            </li>
            
            <li class="sidebar-item <?php echo e(request()->is('admin/deposits*') || request()->is('admin/withdraw-requests*') || request()->is('admin/reward-settings*') || request()->is('admin/withdrawals*') ? 'active' : ''); ?>">
                <a href="#" class="sidebar-link collapsed" data-bs-toggle="collapse" data-bs-target="#rewardMenu" aria-expanded="<?php echo e(request()->is('admin/deposits*') || request()->is('admin/withdraw-requests*') || request()->is('admin/reward-settings*') || request()->is('admin/withdrawals*') ? 'true' : 'false'); ?>">
                    <i class="fas fa-gift sidebar-icon"></i>
                    <span>Rewards & Transactions</span>
                    <i class="fas fa-chevron-right sidebar-arrow ms-auto"></i>
                </a>
                <ul id="rewardMenu" class="sidebar-dropdown list-unstyled collapse <?php echo e(request()->is('admin/deposits*') || request()->is('admin/withdraw-requests*') || request()->is('admin/reward-settings*') || request()->is('admin/withdrawals*') ? 'show' : ''); ?>">
                    <li class="sidebar-item <?php echo e(request()->is('admin/reward-settings*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.reward-settings.index')); ?>" class="sidebar-link">
                            <i class="fas fa-cog sidebar-icon-small"></i> 
                            <span>Reward Settings</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/deposits*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.deposits.index')); ?>" class="sidebar-link">
                            <i class="fas fa-money-bill-wave sidebar-icon-small"></i> 
                            <span>Deposits</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/withdraw-requests*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.withdraw-requests.index')); ?>" class="sidebar-link">
                            <i class="fas fa-hand-holding-usd sidebar-icon-small"></i> 
                            <span>Withdraw Requests</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/withdrawals*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.withdrawals.index')); ?>" class="sidebar-link">
                            <i class="fas fa-wallet sidebar-icon-small"></i> 
                            <span>Withdrawal Requests</span>
                        </a>
                    </li>
                </ul>
            </li>
            
            <li class="sidebar-item <?php echo e(request()->is('admin/pro-system') ? 'active' : ''); ?>">
                <a href="<?php echo e(url('admin/pro-system')); ?>" class="sidebar-link">
                    <i class="fas fa-crown sidebar-icon"></i>
                    <span>Pro System</span>
                </a>
            </li>

            <!-- Reports & Moderation -->
            <li class="sidebar-header">
                <span>MODERATION</span>
            </li>
            
            <li class="sidebar-item <?php echo e(request()->is('admin/reports*') ? 'active' : ''); ?>">
                <a href="#" class="sidebar-link collapsed" data-bs-toggle="collapse" data-bs-target="#reportsMenu" aria-expanded="<?php echo e(request()->is('admin/reports*') ? 'true' : 'false'); ?>">
                    <i class="fas fa-flag sidebar-icon"></i>
                    <span>Reports</span>
                    <i class="fas fa-chevron-right sidebar-arrow ms-auto"></i>
                </a>
                <ul id="reportsMenu" class="sidebar-dropdown list-unstyled collapse <?php echo e(request()->is('admin/reports*') ? 'show' : ''); ?>">
                    <li class="sidebar-item <?php echo e(request()->is('admin/reports') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.reports.index')); ?>" class="sidebar-link">
                            <i class="fas fa-tachometer-alt sidebar-icon-small"></i> 
                            <span><?php echo e(__('Dashboard')); ?></span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/reports/user-reports*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.reports.user-reports')); ?>" class="sidebar-link">
                            <i class="fas fa-user-shield sidebar-icon-small"></i> 
                            <span>User Reports</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/reports/post-reports*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.reports.post-reports')); ?>" class="sidebar-link">
                            <i class="fas fa-newspaper sidebar-icon-small"></i> 
                            <span>Post Reports</span>
                        </a>
                    </li>
                </ul>
            </li>
            
            <li class="sidebar-item <?php echo e(request()->is('admin/tools*') ? 'active' : ''); ?>">
                <a href="#" class="sidebar-link collapsed" data-bs-toggle="collapse" data-bs-target="#toolsMenu" aria-expanded="<?php echo e(request()->is('admin/tools*') ? 'true' : 'false'); ?>">
                    <i class="fas fa-tools sidebar-icon"></i>
                    <span>Moderation Tools</span>
                    <i class="fas fa-chevron-right sidebar-arrow ms-auto"></i>
                </a>
                <ul id="toolsMenu" class="sidebar-dropdown list-unstyled collapse <?php echo e(request()->is('admin/tools*') ? 'show' : ''); ?>">
                    <li class="sidebar-item <?php echo e(request()->is('admin/tools') && !request()->is('admin/tools/*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.tools.index')); ?>" class="sidebar-link">
                            <i class="fas fa-trash-alt sidebar-icon-small"></i> 
                            <span>Data Cleanup</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/tools/blacklist') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.tools.blacklist')); ?>" class="sidebar-link">
                            <i class="fas fa-ban sidebar-icon-small"></i> 
                            <span>Blacklist Users</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/tools/backup') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.tools.backup')); ?>" class="sidebar-link">
                            <i class="fas fa-database sidebar-icon-small"></i> 
                            <span>Database Backup</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/tools/backups') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.tools.backups')); ?>" class="sidebar-link">
                            <i class="fas fa-server sidebar-icon-small"></i> 
                            <span>Manage Backups</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/tools/fake-user-generator') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.tools.fake-user-generator')); ?>" class="sidebar-link">
                            <i class="fas fa-user-friends sidebar-icon-small"></i> 
                            <span>Fake User Generator</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/tools/sitemap') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.tools.sitemap')); ?>" class="sidebar-link">
                            <i class="fas fa-sitemap sidebar-icon-small"></i> 
                            <span>Sitemap Generator</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/tools/send-email') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.tools.send-email')); ?>" class="sidebar-link">
                            <i class="fas fa-envelope sidebar-icon-small"></i> 
                            <span>Send Emails</span>
                        </a>
                    </li>
                </ul>
            </li>

            <!-- Settings Section -->
            <li class="sidebar-header">
                <span>SETTINGS</span>
            </li>
            
            <li class="sidebar-item <?php echo e(request()->is('admin/general-settings*') ? 'active' : ''); ?>">
                <a href="#" class="sidebar-link collapsed" data-bs-toggle="collapse" data-bs-target="#settingsMenu" aria-expanded="<?php echo e(request()->is('admin/general-settings*') ? 'true' : 'false'); ?>">
                    <i class="fas fa-cogs sidebar-icon"></i>
                    <span>System Settings</span>
                    <i class="fas fa-chevron-right sidebar-arrow ms-auto"></i>
                </a>
                <ul id="settingsMenu" class="sidebar-dropdown list-unstyled collapse <?php echo e(request()->is('admin/general-settings*') ? 'show' : ''); ?>">
                    <li class="sidebar-item <?php echo e(request()->is('admin/general-settings') ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('admin/general-settings')); ?>" class="sidebar-link">
                            <i class="fas fa-sliders-h sidebar-icon-small"></i> 
                            <span>General Settings</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/website-info') ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('admin/website-info')); ?>" class="sidebar-link">
                            <i class="fas fa-info-circle sidebar-icon-small"></i> 
                            <span>Website Information</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/mail-configurations') ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('admin/mail-configurations')); ?>" class="sidebar-link">
                            <i class="fas fa-envelope sidebar-icon-small"></i> 
                            <span>Mail Configurations</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/enable-disable-features') ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('admin/enable-disable-features')); ?>" class="sidebar-link">
                            <i class="fas fa-toggle-on sidebar-icon-small"></i> 
                            <span>Enable/Disable Features</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/payment-settings') ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('admin/payment-settings')); ?>" class="sidebar-link">
                            <i class="fas fa-credit-card sidebar-icon-small"></i> 
                            <span>Payment Settings</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/social-logins') ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('admin/social-logins')); ?>" class="sidebar-link">
                            <i class="fas fa-users-cog sidebar-icon-small"></i> 
                            <span>Social Login</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/upload-config') ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('admin/upload-config')); ?>" class="sidebar-link">
                            <i class="fas fa-cloud-upload-alt sidebar-icon-small"></i> 
                            <span>Upload Config</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/storage-config') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.storage.config')); ?>" class="sidebar-link">
                            <i class="fas fa-database sidebar-icon-small"></i> 
                            <span>Storage Configuration</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/audio-video-settings') ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('admin/audio-video-settings')); ?>" class="sidebar-link">
                            <i class="fas fa-video sidebar-icon-small"></i> 
                            <span>Audio & Video Settings</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/nodejs-settings') ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('admin/nodejs-settings')); ?>" class="sidebar-link">
                            <i class="fab fa-node-js sidebar-icon-small"></i> 
                            <span>NodeJs Settings</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/cronjob-settings') ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('admin/cronjob-settings')); ?>" class="sidebar-link">
                            <i class="fas fa-clock sidebar-icon-small"></i> 
                            <span>CronJob Settings</span>
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->is('admin/ai-settings') ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('admin/ai-settings')); ?>" class="sidebar-link">
                            <i class="fas fa-robot sidebar-icon"></i>
                            <span>AI Settings</span>
                        </a>
                    </li>
                </ul>
            </li>
            <li class="sidebar-item <?php echo e(request()->is('admin/post-settings*') ? 'active' : ''); ?>">
                <a href="#" class="sidebar-link collapsed" data-bs-toggle="collapse" data-bs-target="#settingsMenu" aria-expanded="<?php echo e(request()->is('admin/post-settings*') ? 'true' : 'false'); ?>">
                    <i class="fas fa-newspaper sidebar-icon"></i>
                    <span>Post Settings</span>
                    <i class="fas fa-chevron-right sidebar-arrow ms-auto"></i>
                </a>
                <ul id="settingsMenu" class="sidebar-dropdown list-unstyled collapse <?php echo e(request()->is('admin/post-settings*') ? 'show' : ''); ?>">
                    <li class="sidebar-item <?php echo e(request()->is('admin/post-settings') ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('admin/post-settings')); ?>" class="sidebar-link">
                            <i class="fas fa-sliders-h sidebar-icon-small"></i> 
                            <span>Post Settings</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?php echo e(request()->is('admin/manage-colored-posts') ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('admin/manage-colored-posts')); ?>" class="sidebar-link">
                            <i class="fas fa-palette sidebar-icon-small"></i> 
                            <span>Manage Colored Post</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?php echo e(request()->is('admin/manage-reactions') ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('admin/manage-reactions')); ?>" class="sidebar-link">
                            <i class="fas fa-smile sidebar-icon-small"></i> 
                            <span>Manage Reactions</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?php echo e(request()->is('admin/live-streaming') ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('admin/live-streaming')); ?>" class="sidebar-link">
                            <i class="fas fa-video-camera sidebar-icon-small"></i> 
                            <span>Setup Live Streaming</span>
                        </a>
                    </li>
                </ul>
            </li>

        </ul>

        <div class="sidebar-footer">
            <div class="mt-2 text-center">
                <a href="<?php echo e(url('/')); ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                    <i class="fas fa-globe"></i> Visit Site
                </a>
                <a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();" class="btn btn-sm btn-outline-danger ms-2">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                    <?php echo csrf_field(); ?>
                </form>
            </div>
        </div>
    </div>
</nav>

<style>
/* Enhanced Sidebar Styling */
.sidebar {
    min-width: 260px;
    max-width: 260px;
    background: #2c3e50;
    color: #fff;
    transition: all 0.3s;
    position: fixed;
    height: 100%;
    box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
    z-index: 1000;
    overflow-y: auto;
}

.sidebar-content {
    height: 100%;
    display: flex;
    flex-direction: column;
}

.sidebar-brand {
    background: rgba(0, 0, 0, 0.1);
    padding: 15px 20px;
    font-size: 18px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
    color: rgba(255, 255, 255, 0.8);
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.sidebar-logo {
    max-height: 40px;
}

.sidebar-user {
    padding: 10px 15px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}


.user-avatar {
    position: relative;
    width: 60px;
    height: 60px;
}

.user-avatar img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    border: 2px solid rgba(255, 255, 255, 0.2);
}

.user-status {
    position: absolute;
    bottom: 0;
    right: 0;
    width: 12px;
    height: 12px;
    border-radius: 50%;
    background-color: #28a745;
    border: 2px solid #2c3e50;
}

.user-name {
    color: white;
    font-size: 16px;
    font-weight: 500;
}

.user-role {
    color: rgba(255, 255, 255, 0.7);
    font-size: 12px;
}

.sidebar-header {
    padding: 15px 20px 5px;
    font-size: 10px;
    text-transform: uppercase;
    font-weight: 600;
    letter-spacing: 1px;
    color: rgba(255, 255, 255, 0.5);
    margin-top: 10px;
}

.sidebar-item {
    position: relative;
    margin-bottom: 2px;
}

.sidebar-link {
    padding: 10px 20px;
    display: block;
    color: rgba(255, 255, 255, 0.7);
    text-decoration: none;
    transition: all 0.3s;
    font-size: 14px;
    border-left: 3px solid transparent;
}

.sidebar-link:hover, .sidebar-item.active > .sidebar-link {
    color: #fff;
    background: rgba(255, 255, 255, 0.1);
    border-left-color: #3498db;
}

.sidebar-icon {
    margin-right: 10px;
    font-size: 16px;
    width: 20px;
    text-align: center;
}

.sidebar-icon-small {
    margin-right: 8px;
    font-size: 14px;
    width: 16px;
    text-align: center;
}

.sidebar-arrow {
    font-size: 12px;
    transition: transform 0.3s;
}

.sidebar-item.active > .sidebar-link .sidebar-arrow,
.sidebar-link[aria-expanded="true"] .sidebar-arrow {
    transform: rotate(90deg);
}

.sidebar-dropdown {
    background: rgba(0, 0, 0, 0.15);
    padding-left: 32px;
}

.sidebar-dropdown .sidebar-link {
    padding: 8px 15px;
    font-size: 13px;
}

.sidebar-footer {
    margin-top: auto;
    padding: 15px;
    border-top: 1px solid rgba(255, 255, 255, 0.1);
}

/* Scrollbar styling */
.sidebar::-webkit-scrollbar {
    width: 5px;
}

.sidebar::-webkit-scrollbar-track {
    background: rgba(0, 0, 0, 0.1);
}

.sidebar::-webkit-scrollbar-thumb {
    background: rgba(255, 255, 255, 0.2);
    border-radius: 3px;
}

.sidebar::-webkit-scrollbar-thumb:hover {
    background: rgba(255, 255, 255, 0.3);
}
</style>
<?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/admin/components/sidebar.blade.php ENDPATH**/ ?>