<?php
    $showRightSidebar = false;
?>

<?php $__env->startSection('title', $article->title . ' - Help Center'); ?>

<?php $__env->startSection('meta'); ?>
    <?php if($article->meta_title): ?>
        <meta name="title" content="<?php echo e($article->meta_title); ?>">
    <?php endif; ?>
    <?php if($article->meta_description): ?>
        <meta name="description" content="<?php echo e($article->meta_description); ?>">
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container px-0 px-lg-3 help-center-article">
    <div class="row g-4">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-2">
                    <?php $__currentLoopData = $breadcrumbs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crumb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($crumb['url']): ?>
                            <li class="breadcrumb-item"><a href="<?php echo e($crumb['url']); ?>"><?php echo e($crumb['label']); ?></a></li>
                        <?php else: ?>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo e($crumb['label']); ?></li>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ol>
            </nav>
            <h1 class="display-6 fw-bold"><?php echo e($article->title); ?></h1>
            <div class="text-muted small mb-3">
                <i class="fas fa-layer-group me-1"></i><a href="<?php echo e(route('help-center.topic', $topic->slug)); ?>" class="text-decoration-none"><?php echo e($topic->title); ?></a>
                <span class="mx-2">•</span>
                <i class="far fa-clock me-1"></i><?php echo e($article->estimated_reading_time ?? '—'); ?> min read
                <span class="mx-2">•</span>
                Updated <?php echo e($article->updated_at?->diffForHumans() ?? 'recently'); ?>

            </div>
        </div>

        <div class="col-lg-8">
            <div class="card border-0 shadow-sm rounded-4 overflow-hidden">
                <?php if($article->hero_image): ?>
                    <img src="<?php echo e($article->hero_image); ?>" class="img-fluid" alt="<?php echo e($article->title); ?>">
                <?php endif; ?>
                <div class="card-body">
                    <?php if($article->summary): ?>
                        <div class="alert alert-primary bg-primary bg-opacity-10 border-0 text-primary rounded-3">
                            <i class="fas fa-info-circle me-2"></i><?php echo e($article->summary); ?>

                        </div>
                    <?php endif; ?>
                    <article class="article-content">
                        <?php echo $article->content; ?>

                    </article>
                </div>
            </div>

            <div class="card border-0 shadow-sm rounded-4 mt-4">
                <div class="card-body">
                    <h6 class="fw-semibold mb-3">Was this article helpful?</h6>
                    <div class="d-flex gap-2">
                        <button class="btn btn-outline-success btn-sm">
                            <i class="far fa-thumbs-up me-2"></i>Yes
                        </button>
                        <button class="btn btn-outline-danger btn-sm">
                            <i class="far fa-thumbs-down me-2"></i>No
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card border-0 shadow-sm rounded-4 mb-4">
                <div class="card-body">
                    <h6 class="fw-semibold mb-3">Related articles</h6>
                    <div class="list-group list-group-flush">
                        <?php $__empty_1 = true; $__currentLoopData = $relatedArticles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $related): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <a href="<?php echo e(route('help-center.article', [$topic->slug, $related->slug])); ?>" class="list-group-item list-group-item-action">
                                <?php echo e($related->title); ?>

                                <div class="small text-muted">
                                    <i class="far fa-clock me-1"></i><?php echo e($related->estimated_reading_time ?? '—'); ?> min
                                </div>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <span class="list-group-item text-muted">No related articles yet.</span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="card border-0 shadow-sm rounded-4">
                <div class="card-body">
                    <h6 class="fw-semibold mb-3">Need more help?</h6>
                    <p class="text-muted">If you still have questions or feedback, let us know. We're always listening.</p>
                    <a href="mailto:support@socialink.com" class="btn btn-primary w-100 mb-2">
                        <i class="fas fa-envelope me-2"></i>Email Support
                    </a>
                    <a href="<?php echo e(route('help-center.index')); ?>" class="btn btn-outline-primary w-100">
                        <i class="fas fa-life-ring me-2"></i>Back to Help Center
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('front_end.layouts.home', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/front_end/pages/help_center/article.blade.php ENDPATH**/ ?>