<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>


<div class="container-fluid p-0">
    <div class="content-wrapper p-3">
        <!-- Page Header with Breadcrumbs -->
        <div class="content-header mb-4">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="card bg-primary text-white mb-3">
                            <div class="card-body py-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-lg rounded-circle bg-white text-primary me-3">
                                        <i class="bi bi-cloud-upload-fill fs-1"></i>
                                    </div>
                                    <div>
                                        <h1 class="m-0 fw-bold">Upload Configuration</h1>
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb mb-0 text-white-50">
                                                <li class="breadcrumb-item"><i class="bi bi-speedometer2 me-1"></i><a href="index.html" class="text-white-50">Dashboard</a></li>
                                                <li class="breadcrumb-item active text-white" aria-current="page">Upload Configuration</li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons Row -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-body p-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-0">Upload & File Sharing Configuration</h5>
                                <p class="text-muted mb-0">Configure file upload settings and storage options</p>
                            </div>
                            <div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-6 col-md-6">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-primary text-white me-3">
                                <i class="bi bi-file-earmark-arrow-up"></i>
                            </div>
                            <h5 class="card-title mb-0">Upload & File Sharing Configuration</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="upload-settings-alert"></div>
                        <form class="upload-settings" method="POST">
                            <!-- File Upload & Sharing -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-fileSharing" class="form-label fw-bold mb-0">File Upload & Sharing</label>
                                    <p class="text-muted mb-0 small">By enabling this feature, the user can share and upload files in your site.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="fileSharing" value="0">
                                    <input class="form-check-input" type="checkbox" name="fileSharing" id="chck-fileSharing" value="1" <?php echo e(active_value_check(setting('fileSharing') ?? 1)); ?>> 
                                </div>
                            </div>

                            <!-- Video Upload & Sharing -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-video_upload" class="form-label fw-bold mb-0">Video Upload & Sharing</label>
                                    <div class="dropdown mt-1 mb-1">
                                        <button class="btn btn-sm btn-light dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                            <i class="bi bi-sliders me-1"></i> Permission Settings
                                        </button>
                                        <ul class="dropdown-menu p-3" style="width: 250px;">
                                            <li class="mb-2"><strong>Who can use this feature?</strong></li>
                                            <li class="mb-2">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="video_upload_request" id="video_upload_request-admin" value="admin" <?php echo e(setting('video_upload_request') == 'admin' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" for="video_upload_request-admin">
                                                        <i class="bi bi-shield me-1"></i> Admin Only
                                                    </label>
                                                </div>
                                            </li>
                                            <li class="mb-2">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="video_upload_request" id="video_upload_request-all" value="all" <?php echo e(setting('video_upload_request') == 'all' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" for="video_upload_request-all">
                                                        <i class="bi bi-people me-1"></i> All Users
                                                    </label>
                                                </div>
                                            </li>
                                            <li class="mb-2">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="video_upload_request" id="video_upload_request-verified" value="verified" <?php echo e(setting('video_upload_request') == 'verified' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" for="video_upload_request-verified">
                                                        <i class="bi bi-patch-check me-1"></i> Verified Users Only
                                                    </label>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="video_upload_request" id="video_upload_request-pro" value="pro" <?php echo e(setting('video_upload_request') == 'pro' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" for="video_upload_request-pro">
                                                        <i class="bi bi-star me-1"></i> Pro Users Only
                                                    </label>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                    <p class="text-muted mb-0 small">Turn on the ability for users to share and upload videos. <br>You can configure the video converter settings from FFMPEG Settings below.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="video_upload" value="0">
                                    <input class="form-check-input" type="checkbox" name="video_upload" id="chck-video_upload" value="1" <?php echo e(active_value_check(setting('video_upload') ?? 1)); ?>> 
                                </div>
                            </div>

                            <!-- Reels Upload -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-reels_upload" class="form-label fw-bold mb-0">Reels Upload</label>
                                    <div class="dropdown mt-1 mb-1">
                                        <button class="btn btn-sm btn-light dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                            <i class="bi bi-sliders me-1"></i> Permission Settings
                                        </button>
                                        <ul class="dropdown-menu p-3" style="width: 250px;">
                                            <li class="mb-2"><strong>Who can use this feature?</strong></li>
                                            <li class="mb-2">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="reels_upload_request" id="reels_upload_request-admin" value="admin" <?php echo e(setting('reels_upload_request') == 'admin' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" for="reels_upload_request-admin">
                                                        <i class="bi bi-shield me-1"></i> Admin Only
                                                    </label>
                                                </div>
                                            </li>
                                            <li class="mb-2">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="reels_upload_request" id="reels_upload_request-all" value="all" <?php echo e(setting('reels_upload_request') == 'all' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" for="reels_upload_request-all">
                                                        <i class="bi bi-people me-1"></i> All Users
                                                    </label>
                                                </div>
                                            </li>
                                            <li class="mb-2">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="reels_upload_request" id="reels_upload_request-verified" value="verified" <?php echo e(setting('reels_upload_request') == 'verified' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" for="reels_upload_request-verified">
                                                        <i class="bi bi-patch-check me-1"></i> Verified Users Only
                                                    </label>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="reels_upload_request" id="reels_upload_request-pro" value="pro" <?php echo e(setting('reels_upload_request') == 'pro' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" for="reels_upload_request-pro">
                                                        <i class="bi bi-star me-1"></i> Pro Users Only
                                                    </label>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                    <p class="text-muted mb-0 small">Turn on the ability for users to share and upload reels. <br>You can configure the video converter settings from FFMPEG Settings below.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="reels_upload" value="0">
                                    <input class="form-check-input" type="checkbox" name="reels_upload" id="chck-reels_upload" value="1" <?php echo e(active_value_check(setting('reels_upload') ?? 1)); ?>> 
                                </div>
                            </div>

                            <!-- Audio Upload & Sharing -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-audio_upload" class="form-label fw-bold mb-0">Audio Upload & Sharing</label>
                                    <div class="dropdown mt-1 mb-1">
                                        <button class="btn btn-sm btn-light dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                            <i class="bi bi-sliders me-1"></i> Permission Settings
                                        </button>
                                        <ul class="dropdown-menu p-3" style="width: 250px;">
                                            <li class="mb-2"><strong>Who can use this feature?</strong></li>
                                            <li class="mb-2">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="audio_upload_request" id="audio_upload_request-admin" value="admin" <?php echo e(setting('audio_upload_request') == 'admin' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" for="audio_upload_request-admin">
                                                        <i class="bi bi-shield me-1"></i> Admin Only
                                                    </label>
                                                </div>
                                            </li>
                                            <li class="mb-2">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="audio_upload_request" id="audio_upload_request-all" value="all" <?php echo e(setting('audio_upload_request') == 'all' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" for="audio_upload_request-all">
                                                        <i class="bi bi-people me-1"></i> All Users
                                                    </label>
                                                </div>
                                            </li>
                                            <li class="mb-2">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="audio_upload_request" id="audio_upload_request-verified" value="verified" <?php echo e(setting('audio_upload_request') == 'verified' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" for="audio_upload_request-verified">
                                                        <i class="bi bi-patch-check me-1"></i> Verified Users Only
                                                    </label>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="audio_upload_request" id="audio_upload_request-pro" value="pro" <?php echo e(setting('audio_upload_request') == 'pro' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" for="audio_upload_request-pro">
                                                        <i class="bi bi-star me-1"></i> Pro Users Only
                                                    </label>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                    <p class="text-muted mb-0 small">Turn on the ability for users to share and upload music and audio files.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="audio_upload" value="0">
                                    <input class="form-check-input" type="checkbox" name="audio_upload" id="chck-audio_upload" value="1" <?php echo e(active_value_check(setting('audio_upload') ?? 1)); ?>> 
                                </div>
                            </div>

                            <!-- CSS Upload & Modifications -->
                            <div class="mb-3 d-flex justify-content-between align-items-center">
                                <div>
                                    <label for="chck-css_upload" class="form-label fw-bold mb-0">CSS Upload & Modifications</label>
                                    <p class="text-muted mb-0 small">Allow users to upload their own CSS file to design their profile.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="css_upload" value="0">
                                    <input class="form-check-input" type="checkbox" name="css_upload" id="chck-css_upload" value="1" checked>
                                </div>
                            </div>

                            <input type="hidden" name="hash_id" value="00ddcc06d83d0faf07a6899229ca696359406f2a">
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-lg-6 col-md-6">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-primary text-white me-3">
                                <i class="bi bi-file-earmark-lock"></i>
                            </div>
                            <h5 class="card-title mb-0">Upload & File Limits</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-warning py-2">
                            <i class="bi bi-exclamation-triangle-fill me-2"></i> <strong>Important:</strong> Make sure you don't allow PHP, JS, HTML, XML, XPHP, PHP5 files, your site could be at risk if you do so.
                        </div>

                        <form class="upload-settings" method="POST">
                            <div class="mb-3">
                                <label for="allowedExtenstion" class="form-label">Allowed Extensions</label>
                                <input type="text" id="allowedExtenstion" name="allowedExtenstion" class="form-control" value="jpg,png,jpeg,gif,mkv,docx,zip,rar,pdf,doc,mp3,mp4,flv,wav,txt,mov,avi,webm,wav,mpeg,php,phar,env,shtml,php5">
                                <small class="text-muted">Only those type of files user can upload to your site. (separated with comma,)</small>
                            </div>

                            <div class="mb-3">
                                <label for="mime_types" class="form-label">Allowed MIME Types</label>
                                <input type="text" id="mime_types" name="mime_types" class="form-control" value="video/mp4,video/mov,video/mpeg,video/flv,video/avi,video/webm,audio/wav,audio/mpeg,video/quicktime,audio/mp3,image/png,image/jpeg,image/gif,application/pdf,application/msword,application/zip,application/x-rar-compressed,text/pdf,application/x-pointplus,text/css,text/txt">
                                <small class="text-muted">Only those MIME-type of files user can upload to your site. (separated with comma,)</small>
                            </div>

                            <div class="mb-3">
                                <label for="maxUpload" class="form-label">Max Upload Size</label>
                                <select class="form-select" id="maxUpload" name="maxUpload">
                                    <option value="2000000">2 MB</option>
                                    <option value="6000000">6 MB</option>
                                    <option value="12000000">12 MB</option>
                                    <option value="24000000">24 MB</option>
                                    <option value="48000000">48 MB</option>
                                    <option value="96000000">96 MB</option>
                                    <option value="256000000">256 MB</option>
                                    <option value="512000000">512 MB</option>
                                    <option value="1000000000" selected>1 GB</option>
                                    <option value="5000000000">5 GB</option>
                                    <option value="10000000000">10 GB</option>
                                </select>
                                <small class="text-muted">Set the max upload size a user can use for uploading files, videos, music and images.</small>
                            </div>

                            <div class="mb-3">
                                <label for="images_quality" class="form-label">Image Compression Level</label>
                                <select class="form-select" id="images_quality" name="images_quality">
                                    <option value="99">Very Low</option>
                                    <option value="90" selected>Low</option>
                                    <option value="60">Medium</option>
                                    <option value="20">High</option>
                                    <option value="20">Very High</option>
                                </select>
                                <small class="text-muted">Set the image compression level, the higher you choose the less quality you'll get.</small>
                            </div>

                            <input type="hidden" name="hash_id" value="00ddcc06d83d0faf07a6899229ca696359406f2a">
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-12 col-md-12 mb-3">
            <div class="d-flex align-items-center">
                <div class="icon-circle bg-primary text-white me-3">
                    <i class="bi bi-film"></i>
                </div>
                <h4 class="mb-0">FFMPEG Video Converter Settings</h4>
            </div>
            <hr>
        </div>

        <div class="col-lg-6 col-md-6">
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-white py-3">
                    <div class="d-flex align-items-center">
                        <div class="icon-circle bg-primary text-white me-3">
                            <i class="bi bi-gear-wide-connected"></i>
                        </div>
                        <h5 class="card-title mb-0">FFMPEG Configuration</h5>
                    </div>
                </div>
                <div class="card-body">
                    <form class="ffmpeg-settings" method="POST">
                        <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                            <div>
                                <label for="chck-ffmpeg_system" class="form-label fw-bold mb-0">FFMPEG System</label>
                                <p class="text-muted mb-0 small">This system will compress, convert, and optimize videos to mp4. <br>This system requires "ffmpeg" to be installed in your server.</p>
                            </div>
                            <div class="form-check form-switch">
                                <input type="hidden" name="ffmpeg_system" value="0">
                                <input class="form-check-input" type="checkbox" name="ffmpeg_system" id="chck-ffmpeg_system" value="1" checked>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="ffmpeg_binary_file" class="form-label">FFMPEG Binary File Path</label>
                            <input type="text" id="ffmpeg_binary_file" name="ffmpeg_binary_file" class="form-control" value="./ffmpeg/ffmpegnew/ffmpeg">
                            <small class="text-muted">Example: Linux(/usr/bin/ffmpeg) or Windows(C:\\ffmpeg\bin\ffmpeg.exe)</small>
                        </div>

                        <div class="mb-3">
                            <label for="convert_speed" class="form-label">Convert video speed</label>
                            <select class="form-select" id="convert_speed" name="convert_speed">
                                <option value="ultrafast">Ultrafast</option>
                                <option value="superfast">Superfast</option>
                                <option value="veryfast" selected>Veryfast</option>
                                <option value="faster">Faster</option>
                                <option value="fast">Fast</option>
                                <option value="medium">Medium</option>
                                <option value="slow">Slow</option>
                                <option value="slower">Slower</option>
                                <option value="veryslow">Veryslow</option>
                            </select>
                            <small class="text-muted">This affects the encoding speed. Using a slower preset gives you better compression, or quality per filesize, whereas faster presets give you worse compression and higher filesize.</small>
                        </div>

                        <div class="mb-3">
                            <label for="allowedffmpegExtenstion" class="form-label">Allowed Extensions</label>
                            <input type="text" id="allowedffmpegExtenstion" name="allowedffmpegExtenstion" class="form-control" value="mov,mp4,m4a,3gp,3g2,mj2,asf,avi,flv,webm,m4v,mpeg,mpeg,mpeg,ogv,mkv,webm,mov">
                            <small class="text-muted">Only those type of videos user can upload to your site. (separated with comma,)</small>
                        </div>

                        <div class="mb-3">
                            <label for="ffmpeg_mime_types" class="form-label">Allowed MIME Types</label>
                            <input type="text" id="ffmpeg_mime_types" name="ffmpeg_mime_types" class="form-control" value="application/vnd.ms-asf,video/x-msvideo,video/x-flv,video/webm,video/x-m4v,video/mp4,video/mpeg,video/ogg,video/x-matroska,video/quicktime,video/x-ms-wmv,video/x-msvideo">
                            <small class="text-muted">Only those MIME-type of videos user can upload to your site. (separated with comma,)</small>
                        </div>

                        <div class="alert alert-info py-2 mb-3">
                            <i class="bi bi-info-circle-fill me-2"></i> <strong>Info:</strong> For more information on how to setup FFMPEG, please visit our <a href="https://docs.wowonder.com/#idocs_ffmpeg" target="_blank">Documentation</a> page.
                        </div>

                        <div class="alert alert-warning py-2 mb-3">
                            <i class="bi bi-exclamation-triangle-fill me-2"></i> Make sure to debug FFMPEG below after configuring ffmpeg.
                        </div>

                        <div class="ffmpeg-settings-alert"></div>
                        <input type="hidden" name="hash_id" value="00ddcc06d83d0faf07a6899229ca696359406f2a">
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-6 col-md-6">
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-white py-3">
                    <div class="d-flex align-items-center">
                        <div class="icon-circle bg-primary text-white me-3">
                            <i class="bi bi-bug"></i>
                        </div>
                        <h5 class="card-title mb-0">Debug FFMPEG</h5>
                    </div>
                </div>
                <div class="card-body">
                    <div class="alert alert-info py-2 mb-3">
                        <i class="bi bi-info-circle-fill me-2"></i> This feature will test the FFMPEG Configuration and make sure the system is working fine.
                    </div>

                    <form class="debug-settings" method="POST">
                        <div class="mb-3">
                            <label for="debug_ffmpeg" class="form-label">Debug Log</label>
                            <textarea name="debug_ffmpeg" id="debug_ffmpeg" class="form-control" rows="15" disabled>Click on Debug FFMPEG to show test results.</textarea>
                        </div>

                        <input type="hidden" name="hash_id" value="00ddcc06d83d0faf07a6899229ca696359406f2a">
                        <div class="debug-settings-alert"></div>
                        <button type="submit" class="btn btn-success">
                            <i class="bi bi-bug-fill me-1"></i> Debug FFMPEG
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-12 col-md-12 mb-3">
            <div class="d-flex align-items-center">
                <div class="icon-circle bg-primary text-white me-3">
                    <i class="bi bi-cloud"></i>
                </div>
                <h4 class="mb-0">Storage & CDN Configuration</h4>
            </div>
            <hr>
            <div class="alert alert-warning py-2 mb-3">
                <i class="bi bi-exclamation-triangle-fill me-2"></i> <strong>Important:</strong> You can't enable two or three storages at the same time, if you enable FTP, amazon s3 will be automatically disabled, same for amazon s3, Digitalocean and Google.
            </div>
            <div class="alert alert-info py-2 mb-3">
                <i class="bi bi-info-circle-fill me-2"></i> <strong>Info:</strong> For more information on how to setup third party storage, please visit our <a href="https://docs.wowonder.com/#idocs_storage" target="_blank">Documentation</a> page.
            </div>
        </div>

        <!-- Storage providers would continue here with the same pattern -->

    </div>

    <!-- Save Changes Button -->
    <div class="row mt-3 mb-4">
        <div class="col-12">
            <div class="card bg-light">
                <div class="card-body p-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="mb-0"><i class="bi bi-info-circle me-1"></i> Changes will be applied to all upload settings immediately.</p>
                        </div>
                        <div>
                            <button type="button" class="btn btn-outline-secondary me-2">
                                <i class="bi bi-arrow-counterclockwise me-1"></i> Reset
                            </button>
                            <button type="submit" class="btn btn-success">
                                <i class="bi bi-save me-1"></i> Save Configuration
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('admin.update_settings', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.home', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/admin/pages/settings/website_info.blade.php ENDPATH**/ ?>