<?php $__env->startSection('title', 'Forgot Password - Socialink'); ?>

<?php $__env->startSection('content'); ?>
<div class="auth-page d-flex align-items-center py-5">
    <div class="auth-inner container">
        <div class="row justify-content-between align-items-center">
            <div class="col-lg-6 col-xl-7 mb-5 mb-lg-0">
                <div class="brand-panel">
                    <img src="<?php echo e(asset('assets/images/logo.png')); ?>" alt="Socialink" class="brand-mark mb-3">
                    <h1 class="brand-heading">We’ve got your back&mdash;reset your password and jump back in.</h1>
                    <p class="brand-tagline">Recovery keeps your conversations, groups, and memories protected.</p>

                    <div class="brand-highlight">
                        <div class="brand-highlight-icon">
                            <i class="fas fa-shield-heart"></i>
                        </div>
                        <div class="brand-highlight-text">
                            <strong>Secure recovery in a few taps.</strong>
                            <span>We verify every request to keep your data locked to you.</span>
                        </div>
                    </div>

                    
                </div>
            </div>

            <div class="col-lg-5 col-xl-4">
                <div class="auth-card card border-0 shadow-sm">
                    <div class="card-body">
                        <h2 class="card-title text-center mb-2">Find your account</h2>
                        <p class="auth-subtitle text-center mb-4">
                            Enter the email associated with your account and we’ll send you a secure reset link.
                        </p>

                        <?php if(session('status')): ?>
                            <div class="alert alert-success"><?php echo e(session('status')); ?></div>
                        <?php endif; ?>

                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        <form method="POST" action="<?php echo e(route('password.email')); ?>" novalidate>
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <label for="reset-email" class="form-label text-secondary mb-1">Email address</label>
                                <input type="email"
                                       class="form-control"
                                       id="reset-email"
                                       name="email"
                                       placeholder="Enter your email address"
                                       value="<?php echo e(old('email')); ?>"
                                       required>
                            </div>

                            <button type="submit" class="btn btn-primary w-100">Send reset link</button>
                        </form>

                        <p class="text-center text-secondary mt-4 mb-0">
                            <a href="<?php echo e(url('login')); ?>" class="link-blue text-decoration-none">Back to login</a>
                        </p>
                    </div>
                </div>
                <div class="auth-card-secondary mt-3">
                    <div class="headline">Keep access effortless</div>
                    <div class="subline">Turn on two-factor authentication once you’re back in to make future logins even smoother.</div>
                    <a href="<?php echo e(url('login')); ?>" class="btn btn-outline-primary w-100">Return to login</a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('front_end.layouts.auth', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/front_end/pages/auth/forgot_password.blade.php ENDPATH**/ ?>