<?php
$showRightSidebar = false;
?>
<?php $__env->startSection('title', 'Friends'); ?>

<?php $__env->startSection('left_sidebar'); ?>
<?php echo $__env->make('front_end.pages.pages.page_left_sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


<div class="bg-white shadow-sm border-0 rounded-3">

    <!-- Create Story Header -->
    <div class="card border-0">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="<?php echo e(url('/')); ?>" class="text-white me-3">
                                    <i class="fas fa-arrow-left fa-lg"></i>
                                </a>

                                <div class="d-flex justify-content-between align-items-center ">
                                    <div>
                                        <h4 class="mb-0 text-white">Create Your Page</h4>
                                        <p class="mb-0 text-white">Build a community, promote your business, or showcase your talent with a custom page.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>


    <!-- Pages section start -->
    <div class="">

        <!-- Page Creation Form -->
        <div class="card border-0 ">
            <div class="card-body p-4">

                <div class="row g-4">
                    <div class="col-lg-8">
                        <!-- Page Name -->
                        <div class="mb-3">
                            <label for="page-name" class="form-label">Page Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="page-name" name="page_name" placeholder="Enter your page name" required>
                        </div>
                        <!-- Page URL -->
                        <div class="mb-3">
                            <label for="page-url" class="form-label">Your Page URL</label>
                            <div class="input-group">
                                <span class="input-group-text" id="page-url-addon">https://example.com/pages/</span>
                                <input type="text" class="form-control" id="page-url" name="page_url" aria-describedby="page-url-addon" placeholder="Enter page name">
                            </div>
                            <small class="text-muted">Your final URL will be: https://example.com/pages/yourpage</small>
                        </div>



                        <!-- Category -->
                        <div class="mb-3">
                            <label for="category" class="form-label">Category <span class="text-danger">*</span></label>
                            <select class="form-select" id="category" name="category" required>
                                <option value="">Select a category</option>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- Description -->
                        <div class="mb-3">
                            <label for="description" class="form-label">Description</label>
                            <textarea class="form-control" id="description" name="description" rows="4" placeholder="Tell people what your page is about"></textarea>
                        </div>

                        <!-- Contact Email -->
                        <div class="mb-3">
                            <label for="contact-email" class="form-label">Contact Email</label>
                            <input type="email" class="form-control" id="contact-email" name="contact_email" placeholder="Enter business email">
                        </div>

                        <!-- Location -->
                        <div class="mb-3">
                            <label for="location" class="form-label">Location</label>
                            <input type="text" class="form-control" id="location" name="location" placeholder="Enter your location">
                        </div>

                    </div>


                    <div class="col-lg-4">
                        <div class="card bg-light border-0 rounded-4">
                            <div class="card-body">
                                <h6 class="mb-3">Tips for Basic Info</h6>
                                <ul class="list-unstyled mb-0">
                                    <li class="mb-2">
                                        <i class="fas fa-check-circle text-success me-2"></i>
                                        Choose a clear, memorable name
                                    </li>
                                    <li class="mb-2">
                                        <i class="fas fa-check-circle text-success me-2"></i>
                                        Select the most relevant category
                                    </li>
                                    <li class="mb-2">
                                        <i class="fas fa-check-circle text-success me-2"></i>
                                        Write a compelling description
                                    </li>
                                    <li>
                                        <i class="fas fa-check-circle text-success me-2"></i>
                                        Add accurate contact information
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <form id="create-page-form">
                <!-- Form Actions -->
                <div class="card-footer bg-transparent border-top p-4">
                    <div class="d-flex justify-content-between">
                        <a href="<?php echo e(url('pages')); ?>" class="btn btn-light">Cancel</a>
                        <div>
                            <button class="btn btn-primary">Create Page</button>
                        </div>
                    </div>
                </div>
            </form>

        </div>


    </div>
    <!-- Pages section ends -->

</div>

<?php $__env->startPush('scripts'); ?>
<script src="<?php echo e(asset('assets/js/pages.js')); ?>"></script>
<?php $__env->stopPush(); ?>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('front_end.layouts.home', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/front_end/pages/pages/create_page.blade.php ENDPATH**/ ?>