<?php $__env->startSection('title', 'Profile Settings - Socialink'); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/notification-settings.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('settings_content'); ?>
<div class="card mb-4">
    <div class="card-header with-icon p-4">
        <div class="main-icon">
            <i class="bi bi-person-circle fs-3 text-primary"></i>
        </div>
        <h5 class="mb-0 ms-2">Profile Information</h5>
    </div>
    <div class="card-body p-4">
        <?php if(session('success')): ?>
        <div class="alert alert-success mb-4">
            <?php echo e(session('success')); ?>

        </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
        <div class="alert alert-danger mb-4">
            <?php echo e(session('error')); ?>

        </div>
        <?php endif; ?>

        <p class="text-muted mb-4">Manage your personal information, work experience, location, and education details.</p>

        <!-- Profile Photo Section -->
        <div class="row mb-5">
            <div class="col-12 text-center">
                <div class="position-relative d-inline-block">
                    <img src="<?php echo e(Auth::check() ? getMedia(Auth::user()->avatar) : asset('assets/images/avatar/07.jpg')); ?>" class="rounded-circle avatar-xl mb-3" alt="Profile Picture">
                    <label for="avatar" class="position-absolute bottom-10 end-0 bg-primary text-white rounded-circle px-2 py-1 cursor-pointer">
                        <i class="bi bi-camera"></i>
                        <input type="file" id="avatar" name="avatar" class="d-none">
                    </label>
                </div>
                <h4 class="mb-1"><?php echo e(auth()->user()->name); ?></h4>
                <p class="text-muted">{{auth()->user()->username}}</p>
            </div>
        </div>

        <!-- Basic Information Section -->
        <h6 class="heading-small mb-3 mt-4">
            <i class="bi bi-person me-2"></i>Basic Information
        </h6>
        <div class="ps-0 ps-md-3 mb-5">
            <form action="<?php echo e(route('settings.profile.update')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="section" value="basic">
                
                <div class="form-table-row mb-3 p-3 border rounded">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="avatar-icon">
                                <i class="bi bi-person-badge fs-2"></i>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-label h6 mb-3">Name</div>
                            <div class="row">
                                <div class="col-md-6 mb-3 mb-md-0">
                                    <input type="text" class="form-control <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="first_name" name="first_name" value="<?php echo e(old('first_name', auth()->user()->first_name)); ?>" placeholder="First Name" required>
                                    <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-md-6">
                                    <input type="text" class="form-control <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="last_name" name="last_name" value="<?php echo e(old('last_name', auth()->user()->last_name)); ?>" placeholder="Last Name" required>
                                    <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="form-table-row mb-3 p-3 border rounded">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="avatar-icon">
                                <i class="bi bi-chat-quote fs-2"></i>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-label h6 mb-1">Bio</div>
                            <textarea class="form-control <?php $__errorArgs = ['bio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="bio" name="bio" rows="4" placeholder="Tell others a little about yourself"><?php echo e(old('bio', auth()->user()->bio)); ?></textarea>
                            <?php $__errorArgs = ['bio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>
                
                <div class="form-table-row mb-3 p-3 border rounded">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="avatar-icon">
                                <i class="bi bi-calendar-date fs-2"></i>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-label h6 mb-3">Personal Information</div>
                            <div class="row">
                                <div class="col-md-6 mb-3 mb-md-0">
                                    <label class="form-label" for="date_of_birth">Birthday</label>
                                    <input type="date" class="form-control <?php $__errorArgs = ['date_of_birth'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="date_of_birth" name="date_of_birth" value="<?php echo e(old('date_of_birth', auth()->user()->date_of_birth ? date('Y-m-d', strtotime(auth()->user()->date_of_birth)) : '')); ?>">
                                    <?php $__errorArgs = ['date_of_birth'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label" for="gender">Gender</label>
                                    <select class="form-select <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="gender" name="gender">
                                        <option value="">Select Gender</option>
                                        <option value="male" <?php echo e(old('gender', auth()->user()->gender) == 'male' ? 'selected' : ''); ?>>Male</option>
                                        <option value="female" <?php echo e(old('gender', auth()->user()->gender) == 'female' ? 'selected' : ''); ?>>Female</option>
                                        <option value="other" <?php echo e(old('gender', auth()->user()->gender) == 'other' ? 'selected' : ''); ?>>Other</option>
                                        <option value="prefer_not_to_say" <?php echo e(old('gender', auth()->user()->gender) == 'prefer_not_to_say' ? 'selected' : ''); ?>>Prefer not to say</option>
                                    </select>
                                    <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-grid d-md-flex justify-content-md-end mt-4">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle me-2"></i>Save Basic Information
                    </button>
                </div>
            </form>
        </div>
        
        <!-- Work Experience Section -->
        <h6 class="heading-small mb-3 mt-4 border-top pt-4">
            <i class="bi bi-briefcase me-2"></i>Work Experience
        </h6>
        <div class="ps-0 ps-md-3 mb-5">
            <form action="<?php echo e(route('settings.profile.update')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="section" value="work">
                
                <div class="form-table-row mb-3 p-3 border rounded">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="avatar-icon">
                                <i class="bi bi-building fs-2"></i>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-label h6 mb-3">Current Position</div>
                            <div class="row mb-3">
                                <div class="col-md-6 mb-3 mb-md-0">
                                    <label class="form-label" for="job_title">Job Title</label>
                                    <input type="text" class="form-control <?php $__errorArgs = ['job_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="job_title" name="job_title" value="<?php echo e(old('job_title', auth()->user()->getMeta('job_title'))); ?>" placeholder="e.g. Software Engineer">
                                    <?php $__errorArgs = ['job_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label" for="company">Company</label>
                                    <input type="text" class="form-control <?php $__errorArgs = ['company'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="company" name="company" value="<?php echo e(old('company', auth()->user()->getMeta('company'))); ?>" placeholder="e.g. Google">
                                    <?php $__errorArgs = ['company'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div class="row mb-3">
                                <div class="col-md-6 mb-3 mb-md-0">
                                    <label class="form-label" for="work_started">Started</label>
                                    <input type="month" class="form-control <?php $__errorArgs = ['work_started'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="work_started" name="work_started" value="<?php echo e(old('work_started', auth()->user()->getMeta('work_started'))); ?>">
                                    <?php $__errorArgs = ['work_started'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label" for="work_ended">Ended (leave blank if current)</label>
                                    <input type="month" class="form-control <?php $__errorArgs = ['work_ended'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="work_ended" name="work_ended" value="<?php echo e(old('work_ended', auth()->user()->getMeta('work_ended'))); ?>">
                                    <?php $__errorArgs = ['work_ended'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div>
                                <label class="form-label" for="work_description">Description</label>
                                <textarea class="form-control <?php $__errorArgs = ['work_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="work_description" name="work_description" rows="3" placeholder="Describe your role and responsibilities"><?php echo e(old('work_description', auth()->user()->getMeta('work_description'))); ?></textarea>
                                <?php $__errorArgs = ['work_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-grid d-md-flex justify-content-md-end mt-4">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle me-2"></i>Save Work Experience
                    </button>
                </div>
            </form>
        </div>
        
        <!-- Location Section -->
        <h6 class="heading-small mb-3 mt-4 border-top pt-4">
            <i class="bi bi-geo-alt me-2"></i>Location
        </h6>
        <div class="ps-0 ps-md-3 mb-5">
            <form action="<?php echo e(route('settings.profile.update')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="section" value="location">
                
                <div class="form-table-row mb-3 p-3 border rounded">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="avatar-icon">
                                <i class="bi bi-globe fs-2"></i>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-label h6 mb-3">Where You Live</div>
                            <div class="row mb-3">
                                <div class="col-md-6 mb-3 mb-md-0">
                                    <label class="form-label" for="country">Country</label>
                                    <select class="form-select <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="country" name="country">
                                        <option value="">Select Country</option>
                                        <option value="US" <?php echo e(old('country', auth()->user()->getMeta('country')) == 'US' ? 'selected' : ''); ?>>United States</option>
                                        <option value="UK" <?php echo e(old('country', auth()->user()->getMeta('country')) == 'UK' ? 'selected' : ''); ?>>United Kingdom</option>
                                        <option value="CA" <?php echo e(old('country', auth()->user()->getMeta('country')) == 'CA' ? 'selected' : ''); ?>>Canada</option>
                                        <option value="AU" <?php echo e(old('country', auth()->user()->getMeta('country')) == 'AU' ? 'selected' : ''); ?>>Australia</option>
                                        <option value="IN" <?php echo e(old('country', auth()->user()->getMeta('country')) == 'IN' ? 'selected' : ''); ?>>India</option>
                                        <!-- Add more countries as needed -->
                                    </select>
                                    <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label" for="city">City</label>
                                    <input type="text" class="form-control <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="city" name="city" value="<?php echo e(old('city', auth()->user()->getMeta('city'))); ?>" placeholder="e.g. San Francisco">
                                    <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div>
                                <label class="form-label" for="address">Address (only visible to you)</label>
                                <textarea class="form-control <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="address" name="address" rows="2" placeholder="Your street address"><?php echo e(old('address', auth()->user()->getMeta('address'))); ?></textarea>
                                <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <small class="form-text text-muted">This is only used for location-based features and will not be shown publicly.</small>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-grid d-md-flex justify-content-md-end mt-4">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle me-2"></i>Save Location
                    </button>
                </div>
            </form>
        </div>
        
        <!-- Education Section -->
        <h6 class="heading-small mb-3 mt-4 border-top pt-4">
            <i class="bi bi-mortarboard me-2"></i>Education
        </h6>
        <div class="ps-0 ps-md-3">
            <form action="<?php echo e(route('settings.profile.update')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="section" value="education">
                
                <div class="form-table-row mb-3 p-3 border rounded">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="avatar-icon">
                                <i class="bi bi-book fs-2"></i>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-label h6 mb-3">Educational Background</div>
                            <div class="row mb-3">
                                <div class="col-md-6 mb-3 mb-md-0">
                                    <label class="form-label" for="school">School/University</label>
                                    <input type="text" class="form-control <?php $__errorArgs = ['school'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="school" name="school" value="<?php echo e(old('school', auth()->user()->getMeta('school'))); ?>" placeholder="e.g. Stanford University">
                                    <?php $__errorArgs = ['school'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label" for="degree">Degree</label>
                                    <input type="text" class="form-control <?php $__errorArgs = ['degree'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="degree" name="degree" value="<?php echo e(old('degree', auth()->user()->getMeta('degree'))); ?>" placeholder="e.g. Bachelor of Science in Computer Science">
                                    <?php $__errorArgs = ['degree'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div class="row mb-3">
                                <div class="col-md-6 mb-3 mb-md-0">
                                    <label class="form-label" for="edu_started">Started</label>
                                    <input type="month" class="form-control <?php $__errorArgs = ['edu_started'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="edu_started" name="edu_started" value="<?php echo e(old('edu_started', auth()->user()->getMeta('edu_started'))); ?>">
                                    <?php $__errorArgs = ['edu_started'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label" for="edu_ended">Ended (leave blank if current)</label>
                                    <input type="month" class="form-control <?php $__errorArgs = ['edu_ended'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="edu_ended" name="edu_ended" value="<?php echo e(old('edu_ended', auth()->user()->getMeta('edu_ended'))); ?>">
                                    <?php $__errorArgs = ['edu_ended'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div>
                                <label class="form-label" for="edu_description">Description</label>
                                <textarea class="form-control <?php $__errorArgs = ['edu_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="edu_description" name="edu_description" rows="3" placeholder="Describe your field of study and achievements"><?php echo e(old('edu_description', auth()->user()->getMeta('edu_description'))); ?></textarea>
                                <?php $__errorArgs = ['edu_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-grid d-md-flex justify-content-md-end mt-4">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle me-2"></i>Save Education
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('front_end.pages.settings.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/front_end/pages/settings/profile.blade.php ENDPATH**/ ?>