@extends('front_end.layouts.home')

@section('title', 'Deposit via Stripe')

@section('content')
<div class="card border-0 shadow-sm rounded-3">
    <div class="card-header bg-primary text-white">
        <div class="d-flex align-items-center">
            {{-- <a href="{{ route('wallet.index') }}" class="text-white me-3"><i class="fas fa-arrow-left"></i></a> --}}
            <div>
                <h5 class="mb-0">Deposit via Stripe</h5>
                <small>Pay with your card securely</small>
            </div>
        </div>
    </div>
    <div class="card-body">
        <form method="POST" action="{{ route('wallet.deposit.stripe.create') }}" id="stripeCheckoutForm">
            @csrf
            <div class="mb-3">
                <label class="form-label">Amount (USD)</label>
                <div class="input-group">
                    <span class="input-group-text">$</span>
                    <input type="number" min="1" step="0.01" class="form-control" name="amount" placeholder="0.00" required />
                </div>
                <small class="text-muted">Minimum $1</small>
            </div>
            <div class="d-flex justify-content-end gap-2">
                {{-- <a href="{{ route('wallet.index') }}" class="btn btn-light">Cancel</a> --}}
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-lock me-2"></i>Continue to Stripe
                </button>
            </div>
        </form>
    </div>
</div>
 
@endsection


