@extends('front_end.layouts.home')

@section('title', 'Deposit via Flutterwave')

@section('content')
    <div class="card border-0 shadow-sm rounded-3">
        <div class="card-header bg-primary text-white">
            <div class="d-flex align-items-center">
                <a href="{{ route('wallet.index') }}" class="text-white me-3"><i class="fas fa-arrow-left"></i></a>
                <div>
                    <h5 class="mb-0">Deposit via Flutterwave</h5>
                    <small>Secure African payments</small>
                </div>
            </div>
        </div>
        <div class="card-body">
            <form action="{{ route('wallet.deposit.flutterwave.create') }}" method="POST">
                @csrf
                <div class="mb-3">
                    <label class="form-label">Amount (USD)</label>
                    <div class="input-group">
                        <span class="input-group-text">$</span>
                        <input type="number" name="amount" min="1" step="0.01" class="form-control"
                            placeholder="0.00" required>
                    </div>
                </div>
                <div class="d-flex justify-content-end gap-2">
                    <a href="{{ route('wallet.index') }}" class="btn btn-light">Cancel</a>
                    <button type="submit" class="btn btn-primary">Continue to Flutterwave</button>
                </div>
            </form>
        </div>
    </div>
@endsection
