@extends('front_end.pages.settings.layout')

@section('title', 'Account Verification - Socialink')

@section('settings_content')
<div class="card mb-4">
    <div class="card-header with-icon p-4">
        <div class="main-icon">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32"><path d="M28 16a4 4 0 0 1 .59-1.38 3.76 3.76 0 0 0 .73-2.95 3.81 3.81 0 0 0-2.38-2A4.18 4.18 0 0 1 25.71 9a4 4 0 0 1-.31-1.42 3.79 3.79 0 0 0-1.17-2.86 3.75 3.75 0 0 0-3.06-.22 3.78 3.78 0 0 1-1.46.13 3.63 3.63 0 0 1-1-.93A3.85 3.85 0 0 0 16 2a3.85 3.85 0 0 0-2.67 1.65 3.63 3.63 0 0 1-1 .93 3.78 3.78 0 0 1-1.46-.13 3.75 3.75 0 0 0-3.06.22A3.79 3.79 0 0 0 6.6 7.53 4 4 0 0 1 6.29 9a4.18 4.18 0 0 1-1.23.72 3.81 3.81 0 0 0-2.38 2 3.76 3.76 0 0 0 .73 2.95A4 4 0 0 1 4 16a4 4 0 0 1-.59 1.38 3.76 3.76 0 0 0-.73 2.95 3.81 3.81 0 0 0 2.38 2 4.18 4.18 0 0 1 1.23.72 4 4 0 0 1 .31 1.42 3.79 3.79 0 0 0 1.17 2.86 3.75 3.75 0 0 0 3.06.22 3.78 3.78 0 0 1 1.46-.13 3.63 3.63 0 0 1 1 .93A3.85 3.85 0 0 0 16 30a3.85 3.85 0 0 0 2.67-1.65 3.63 3.63 0 0 1 1-.93 3.78 3.78 0 0 1 1.46.13 3.75 3.75 0 0 0 3.06-.22 3.79 3.79 0 0 0 1.17-2.86 4 4 0 0 1 .31-1.42 4.18 4.18 0 0 1 1.23-.72 3.81 3.81 0 0 0 2.38-2 3.76 3.76 0 0 0-.73-2.95A4 4 0 0 1 28 16Zm-1.15 2.36c.22.4.64 1.13.57 1.35s-.82.58-1.3.8a4.88 4.88 0 0 0-2 1.37 4.77 4.77 0 0 0-.68 2.36c-.06.5-.15 1.32-.36 1.47s-1 0-1.48-.12a5 5 0 0 0-2.48-.08A4.78 4.78 0 0 0 17.19 27c-.36.4-.91 1-1.19 1s-.83-.6-1.19-1a4.78 4.78 0 0 0-1.9-1.49 3.11 3.11 0 0 0-.9-.13 8.45 8.45 0 0 0-1.58.21c-.48.1-1.29.26-1.48.12s-.3-1-.36-1.47a4.77 4.77 0 0 0-.68-2.36 4.88 4.88 0 0 0-2-1.37c-.48-.22-1.21-.55-1.3-.8s.35-.95.57-1.35A5 5 0 0 0 6 16a5 5 0 0 0-.85-2.36c-.22-.4-.64-1.13-.57-1.35s.82-.58 1.3-.8a4.88 4.88 0 0 0 2-1.37 4.77 4.77 0 0 0 .68-2.36c.06-.5.15-1.32.36-1.47s1 0 1.48.12a5 5 0 0 0 2.48.08A4.78 4.78 0 0 0 14.81 5c.36-.4.91-1 1.19-1s.83.6 1.19 1a4.78 4.78 0 0 0 1.9 1.49 5 5 0 0 0 2.48-.08 3.36 3.36 0 0 1 1.48-.12c.21.15.3 1 .36 1.47a4.77 4.77 0 0 0 .68 2.36 4.88 4.88 0 0 0 2 1.37c.48.22 1.21.55 1.3.8s-.35 1-.57 1.35A5 5 0 0 0 26 16a5 5 0 0 0 .85 2.36Z" fill="currentColor"/><path d="m19.79 12.29-5.29 5.3-1.79-1.8a1 1 0 0 0-1.42 1.42l2.5 2.5a1 1 0 0 0 1.42 0l6-6a1 1 0 0 0-1.42-1.42Z" fill="currentColor"/></svg>
        </div>
        <h5 class="mb-0 ms-2">Account Verification</h5>
    </div>
    <div class="card-body p-4">
        @if(session('success'))
        <div class="alert alert-success mb-4">
            {{ session('success') }}
        </div>
        @endif

        @if(session('error'))
        <div class="alert alert-danger mb-4">
            {{ session('error') }}
        </div>
        @endif

        @php
            $verificationRequest = Auth::user()->verificationRequest ?? null;
        @endphp

        @if($verificationRequest && $verificationRequest->status === 'pending')
            <div class="alert alert-info">
                <i class="fas fa-info-circle me-2"></i> Your verification request is currently under review. We'll notify you once it's processed.
            </div>
            <div class="card bg-light mb-4">
                <div class="card-body">
                    <h6 class="card-title">Verification Request Details</h6>
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <p><strong>Submitted:</strong> {{ $verificationRequest->created_at->format('M d, Y') }}</p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Status:</strong> <span class="badge bg-warning">Pending Review</span></p>
                        </div>
                    </div>
                </div>
            </div>
        @elseif($verificationRequest && $verificationRequest->status === 'approved')
            <div class="alert alert-success">
                <i class="fas fa-check-circle me-2"></i> Congratulations! Your account has been verified.
            </div>
            <div class="card bg-light mb-4">
                <div class="card-body">
                    <h6 class="card-title">Verification Status</h6>
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <p><strong>Verified on:</strong> {{ $verificationRequest->reviewed_at->format('M d, Y') }}</p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Status:</strong> <span class="badge bg-success">Verified</span></p>
                        </div>
                    </div>
                </div>
            </div>
        @elseif($verificationRequest && $verificationRequest->status === 'rejected')
            <div class="alert alert-danger">
                <i class="fas fa-times-circle me-2"></i> Your verification request was not approved.
            </div>
            <div class="card bg-light mb-4">
                <div class="card-body">
                    <h6 class="card-title">Verification Status</h6>
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <p><strong>Reviewed on:</strong> {{ $verificationRequest->reviewed_at->format('M d, Y') }}</p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Status:</strong> <span class="badge bg-danger">Not Approved</span></p>
                        </div>
                    </div>
                    @if($verificationRequest->admin_notes)
                    <div class="mt-3">
                        <p><strong>Feedback:</strong></p>
                        <p class="mb-0">{{ $verificationRequest->admin_notes }}</p>
                    </div>
                    @endif
                    <div class="mt-3">
                        <form action="{{ route('settings.verification.reapply') }}" method="POST">
                            @csrf
                            <button type="submit" class="btn btn-primary">Submit New Request</button>
                        </form>
                    </div>
                </div>
            </div>
        @else
            <div class="mb-4">
                <h6 class="mb-3">Get Verified</h6>
                <p class="text-muted">Verified accounts have a checkmark next to their name, confirming that Socialink has verified the authenticity of the account. Submit your verification request by providing the required information below.</p>
            </div>
            
            <form action="{{ route('settings.verification.submit') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row form-group mb-4">
                    <label class="col-md-3 form-label">Verification Documents</label>
                    <div class="col-md-9">
                        <div class="row">
                            <div class="col-sm-6 mb-4">
                                <div class="mb-3">
                                    <strong>Your Photo</strong>
                                </div>
                                <div class="mb-3">
                                    <input type="file" class="form-control @error('photo') is-invalid @enderror" name="photo" accept=".png, .jpg, .jpeg, .webp">
                                    @error('photo')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-text">
                                    Upload a clear photo of yourself holding your ID document.
                                </div>
                            </div>
                            <div class="col-sm-6 mb-4">
                                <div class="mb-3">
                                    <strong>Passport or National ID</strong>
                                </div>
                                <div class="mb-3">
                                    <input type="file" class="form-control @error('document') is-invalid @enderror" name="document" accept=".png, .jpg, .jpeg, .webp, .pdf">
                                    @error('document')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-text">
                                    Upload a scan or photo of your passport or national ID card.
                                </div>
                            </div>
                        </div>
                        <div class="form-text">
                            Please attach your photo and your Passport or National ID. Supported formats: JPG, PNG, WEBP (PDF for documents only).
                        </div>
                    </div>
                </div>
                
                <div class="row form-group mb-4">
                    <label class="col-md-3 form-label">Additional Information</label>
                    <div class="col-md-9">
                        <textarea class="form-control @error('message') is-invalid @enderror" name="message" rows="4"></textarea>
                        @error('message')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">
                            Please share why your account should be verified. For example, if you're a public figure, organization, or business.
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-9 offset-md-3">
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle me-2"></i> By submitting this form, you confirm that all information provided is accurate and authentic. Providing false information may result in permanent account suspension.
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-9 offset-md-3">
                        <button type="submit" class="btn btn-primary">Submit Verification Request</button>
                    </div>
                </div>
            </form>
        @endif
    </div>
</div>
@endsection