@extends('front_end.pages.settings.layout')

@section('title', 'Security Settings - Socialink')

@push('styles')
<link rel="stylesheet" href="{{ asset('css/notification-settings.css') }}">
@if (setting('password_complexity') == 1)
<style>
.password-strength-meter {
    margin-top: 8px;
    height: 4px;
    border-radius: 2px;
    background-color: #e9ecef;
    overflow: hidden;
}

.password-strength-meter .strength-bar {
    height: 100%;
    transition: all 0.3s ease;
    width: 0%;
}

.password-strength-meter .strength-bar.weak {
    background-color: #dc3545;
    width: 25%;
}

.password-strength-meter .strength-bar.medium {
    background-color: #ffc107;
    width: 50%;
}

.password-strength-meter .strength-bar.strong {
    background-color: #28a745;
    width: 75%;
}

.password-strength-meter .strength-bar.very-strong {
    background-color: #20c997;
    width: 100%;
}

.password-requirements {
    margin-top: 8px;
    font-size: 0.875rem;
    color: #6c757d;
}

.password-requirements .requirement {
    display: flex;
    align-items: center;
    margin-bottom: 4px;
}

.password-requirements .requirement i {
    margin-right: 6px;
    font-size: 12px;
}

.password-requirements .requirement.met {
    color: #28a745;
}

.password-requirements .requirement.not-met {
    color: #6c757d;
}

.password-strength-text {
    font-size: 0.875rem;
    margin-top: 4px;
    font-weight: 500;
}

.password-strength-text.weak {
    color: #dc3545;
}

.password-strength-text.medium {
    color: #ffc107;
}

.password-strength-text.strong {
    color: #28a745;
}

.password-strength-text.very-strong {
    color: #20c997;
}
</style>
@endif
@endpush

@section('settings_content')
<div class="card mb-4">
    <div class="card-header with-icon p-4">
        <div class="main-icon">
            <i class="bi bi-shield-lock fs-3 text-primary"></i>
        </div>
        <h5 class="mb-0 ms-2">Security Settings</h5>
    </div>
    <div class="card-body p-4">
        @if(session('success'))
        <div class="alert alert-success mb-4">
            {{ session('success') }}
        </div>
        @endif

        @if(session('error'))
        <div class="alert alert-danger mb-4">
            {{ session('error') }}
        </div>
        @endif

        <p class="text-muted mb-4">Manage your account security settings, active sessions, and two-factor authentication.</p>

        <!-- Password Section -->
        <h6 class="heading-small mb-3 mt-4">
            <i class="bi bi-key me-2"></i>Password Settings
        </h6>
        <div class="ps-0 ps-md-3 mb-5">
            <form action="{{ route('settings.security.update') }}" method="POST">
                @csrf
                <input type="hidden" name="section" value="password">
                
                <div class="form-table-row mb-3 p-3 border rounded">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="avatar-icon">
                                <i class="bi bi-shield-lock fs-2"></i>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-label h6 mb-1">Current Password</div>
                            <input type="password" class="form-control @error('current_password') is-invalid @enderror" id="current_password" name="current_password" required>
                            @error('current_password')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="form-table-row mb-3 p-3 border rounded">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="avatar-icon">
                                <i class="bi bi-key fs-2"></i>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-label h6 mb-1">New Password</div>
                            <input type="password" class="form-control @error('new_password') is-invalid @enderror" id="new_password" name="new_password" required>
                            @error('new_password')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            @if (setting('password_complexity') == 1)
                            <div class="password-strength-meter">
                                <div class="strength-bar"></div>
                            </div>
                            <div class="password-strength-text"></div>
                            <div class="password-requirements">
                                <div class="requirement requirement-length not-met">
                                    <i class="bi bi-circle"></i>
                                    <span>At least 8 characters</span>
                                </div>
                                <div class="requirement requirement-uppercase not-met">
                                    <i class="bi bi-circle"></i>
                                    <span>At least one uppercase letter</span>
                                </div>
                                <div class="requirement requirement-lowercase not-met">
                                    <i class="bi bi-circle"></i>
                                    <span>At least one lowercase letter</span>
                                </div>
                                <div class="requirement requirement-numbers not-met">
                                    <i class="bi bi-circle"></i>
                                    <span>At least one number</span>
                                </div>
                                <div class="requirement requirement-special not-met">
                                    <i class="bi bi-circle"></i>
                                    <span>At least one special character</span>
                                </div>
                            </div>
                            @else
                            <small class="form-text">Password must be at least 8 characters long and include at least one uppercase letter, one lowercase letter, one number, and one special character.</small>
                            @endif
                        </div>
                    </div>
                </div>
                
                <div class="form-table-row mb-3 p-3 border rounded">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="avatar-icon">
                                <i class="bi bi-check-circle fs-2"></i>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-label h6 mb-1">Confirm New Password</div>
                            <input type="password" class="form-control @error('new_password_confirmation') is-invalid @enderror" id="new_password_confirmation" name="new_password_confirmation" required>
                            @error('new_password_confirmation')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="d-grid d-md-flex justify-content-md-end mt-4">
                    <button type="submit" class="btn btn-primary">Update Password</button>
                </div>
            </form>
        </div>
        
        <!-- Sessions Section -->
        <h6 class="heading-small mb-3 mt-4 border-top pt-4">
            <i class="bi bi-devices me-2"></i>Active Sessions
        </h6>
        <div class="ps-0 ps-md-3 mb-5">
            <div class="d-flex align-items-center mb-4">
                <i class="bi bi-info-circle me-2 fs-5 text-primary"></i>
                <p class="text-muted mb-0">These are devices that have logged into your account. Revoke any sessions that you don't recognize.</p>
            </div>
            
            <div class="mb-4">
                @if(count($formattedSessions) > 0)
                    @foreach($formattedSessions as $session)
                        <div class="form-table-row mb-3 p-3 border rounded @if($session['is_current']) border-primary @endif">
                            <div class="row align-items-center">
                                <div class="col-md-3">
                                    <div class="d-flex align-items-center">
                                        @if($session['device_type'] == 'Desktop')
                                            <i class="bi bi-laptop me-3 fs-3 text-muted"></i>
                                        @elseif($session['device_type'] == 'Phone')
                                            <i class="bi bi-phone me-3 fs-3 text-muted"></i>
                                        @elseif($session['device_type'] == 'Tablet')
                                            <i class="bi bi-tablet me-3 fs-3 text-muted"></i>
                                        @else
                                            <i class="bi bi-device-unknown me-3 fs-3 text-muted"></i>
                                        @endif
                                        <div>
                                            <div class="fw-bold">{{ $session['device_name'] }}</div>
                                            <small class="text-muted">{{ $session['browser'] }} · {{ $session['platform'] }}</small>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 mt-3 mt-md-0">
                                    <div>{{ $session['location'] }}</div>
                                    <small class="text-muted">{{ $session['country'] }}</small>
                                </div>
                                <div class="col-md-3 mt-3 mt-md-0">
                                    @if($session['is_current'])
                                        <div class="fw-bold">Current session</div>
                                        <small class="text-muted">Active now</small>
                                    @else
                                        <div>{{ $session['last_activity'] }}</div>
                                        <small class="text-muted">{{ $session['last_activity_date'] }}</small>
                                    @endif
                                </div>
                                <div class="col-md-3 mt-3 mt-md-0 text-end">
                                    @if($session['is_current'])
                                        <span class="badge bg-success">Current</span>
                                    @else
                                        <form action="{{ route('settings.security.revoke_session') }}" method="POST" style="display: inline;">
                                            @csrf
                                            <input type="hidden" name="session_id" value="{{ $session['id'] }}">
                                            <button type="submit" class="btn btn-sm btn-outline-danger">
                                                <i class="bi bi-x-circle me-1"></i>Revoke
                                            </button>
                                        </form>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="alert alert-info">
                        <i class="bi bi-info-circle me-2"></i>No active sessions found.
                    </div>
                @endif
            </div>
            
            <div class="mt-4 p-3 border rounded bg-light">
                <div class="d-flex align-items-center mb-3">
                    <i class="bi bi-exclamation-triangle-fill me-2 text-warning fs-4"></i>
                    <h6 class="mb-0">Revoke All Other Sessions</h6>
                </div>
                <p class="text-muted mb-3">This will log you out from all devices except your current one. Use this if you suspect unauthorized access to your account.</p>
                <form action="{{ route('settings.security.revoke_all_sessions') }}" method="POST">
                    @csrf
                    <button type="submit" class="btn btn-danger">
                        <i class="bi bi-shield-exclamation me-2"></i>Revoke All Other Sessions
                    </button>
                </form>
            </div>
        </div>
        
       
    </div>
</div>

@if (setting('password_complexity') == 1)
@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Password complexity system
    const passwordInput = document.getElementById('new_password');
    
    if (passwordInput) {
        passwordInput.addEventListener('input', function() {
            checkPasswordComplexity(this.value);
        });
    }

    function checkPasswordComplexity(password) {
        const requirements = {
            length: password.length >= 8,
            uppercase: /[A-Z]/.test(password),
            lowercase: /[a-z]/.test(password),
            numbers: /\d/.test(password),
            special: /[!@#$%^&*()_+\-=\[\]{};':"\\|,.<>\/?]/.test(password)
        };

        // Update requirement indicators
        Object.keys(requirements).forEach(req => {
            const element = document.querySelector(`.requirement-${req}`);
            if (element) {
                const icon = element.querySelector('i');
                if (requirements[req]) {
                    element.classList.add('met');
                    element.classList.remove('not-met');
                    icon.className = 'bi bi-check-circle-fill';
                } else {
                    element.classList.add('not-met');
                    element.classList.remove('met');
                    icon.className = 'bi bi-circle';
                }
            }
        });

        // Calculate strength score
        const score = Object.values(requirements).filter(Boolean).length;
        const strengthBar = document.querySelector('.strength-bar');
        const strengthText = document.querySelector('.password-strength-text');
        
        if (strengthBar && strengthText) {
            strengthBar.className = 'strength-bar';
            
            if (score <= 2) {
                strengthBar.classList.add('weak');
                strengthText.textContent = 'Weak';
                strengthText.className = 'password-strength-text weak';
            } else if (score === 3) {
                strengthBar.classList.add('medium');
                strengthText.textContent = 'Medium';
                strengthText.className = 'password-strength-text medium';
            } else if (score === 4) {
                strengthBar.classList.add('strong');
                strengthText.textContent = 'Strong';
                strengthText.className = 'password-strength-text strong';
            } else {
                strengthBar.classList.add('very-strong');
                strengthText.textContent = 'Very Strong';
                strengthText.className = 'password-strength-text very-strong';
            }
        }

        return { requirements, score };
    }
});
</script>
@endpush
@endif
@endsection