@php
$showLeftSidebar = false;
$showRightSidebar = false;
$mainContentClass = 'col-12';
@endphp

@extends('front_end.layouts.home')

@section('title', $user->first_name . ' ' . $user->last_name . ' - Profile - Socialink')

@push('styles')
@include('front_end.layouts.newsfeed_styles')
<style>
    :root {
        --primary-color: #1877f2;
        --secondary-color: #42b72a;
        --text-dark: #050505;
        --text-muted: #65676b;
        --border-light: #e4e6eb;
        --bg-light: #f0f2f5;
        --card-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
        --card-hover-shadow: 0 2px 12px rgba(0, 0, 0, 0.15);
    }

    body {
        background-color: var(--bg-light);
    }

    /* Layout */
    .profile-page-container {
        max-width: 1080px;
        margin: 0 auto;
        padding: 0 16px;
        width: 100%;
    }

    @media (min-width: 1200px) {
        .profile-page-container {
            max-width: 1080px;
            padding: 0 24px;
        }
    }

    @media (max-width: 991px) {
        .profile-page-container {
            padding: 0 12px;
        }
    }

    .profile-content-wrapper {
        width: 100%;
    }

    /* Profile Cover */
    .profile-cover-section {
        background: white;
        border-radius: 8px;
        overflow: hidden;
        box-shadow: var(--card-shadow);
        margin-bottom: 16px;
    }

    .profile-cover {
        height: 300px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        background-size: cover;
        background-position: center;
        position: relative;
    }

    .profile-cover::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 100px;
        background: linear-gradient(to bottom, transparent, rgba(0,0,0,0.3));
    }

    /* Profile Info Section */
    .profile-info-section {
        padding: 0 24px 20px;
        position: relative;
        display: flex;
        flex-direction: column;
        align-items: center;
        text-align: center;
    }

    @media (max-width: 768px) {
        .profile-info-section {
            padding: 0 16px 16px;
        }
    }

    .profile-avatar-container {
        margin-top: -110px;
        position: relative;
        z-index: 10;
        margin-bottom: 12px;
    }

    .profile-avatar {
        width: 180px;
        height: 180px;
        border: 6px solid white;
        border-radius: 50%;
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.18);
        object-fit: cover;
        background: white;
    }

    .profile-name-title {
        font-size: 32px;
        font-weight: 700;
        color: var(--text-dark);
        margin: 0 0 16px;
        line-height: 1.2;
    }

    /* Action Buttons */
    .profile-action-bar {
        display: flex;
        gap: 10px;
        flex-wrap: wrap;
        align-items: center;
        justify-content: center;
    }

    .btn-profile-action {
        padding: 10px 18px;
        font-size: 15px;
        font-weight: 600;
        border-radius: 999px;
        border: none;
        cursor: pointer;
        transition: all 0.2s;
        display: inline-flex;
        align-items: center;
        gap: 6px;
    }

    .btn-primary-custom {
        background: var(--primary-color);
        color: white;
    }

    .btn-primary-custom:hover {
        background: #166fe5;
        color: white;
    }

    .btn-secondary-custom {
        background: var(--border-light);
        color: var(--text-dark);
    }

    .btn-secondary-custom:hover {
        background: #d8dadf;
        color: var(--text-dark);
    }

    .btn-success-custom {
        background: var(--secondary-color);
        color: white;
    }

    .btn-outline-custom {
        background: white;
        border: 1px solid var(--border-light);
        color: var(--text-dark);
    }

    .btn-outline-custom:hover {
        background: var(--bg-light);
        color: var(--text-dark);
    }

    /* Navigation Tabs */
    .profile-tabs {
        background: white;
        border-radius: 8px;
        box-shadow: var(--card-shadow);
        padding: 0 16px;
        margin-bottom: 16px;
    }

    .profile-nav-tabs {
        display: flex;
        gap: 8px;
        border: none;
    }

    .profile-nav-tabs .nav-link {
        padding: 16px 20px;
        color: var(--text-muted);
        font-weight: 600;
        font-size: 15px;
        border: none;
        border-radius: 0;
        border-bottom: 3px solid transparent;
        background: transparent;
        transition: all 0.2s;
        position: relative;
    }

    .profile-nav-tabs .nav-link:hover {
        background: var(--bg-light);
        color: var(--text-dark);
    }

    .profile-nav-tabs .nav-link.active {
        color: var(--primary-color);
        border-bottom-color: var(--primary-color);
        background: transparent;
    }

    /* Cards */
    .profile-card {
        background: white;
        border-radius: 8px;
        box-shadow: var(--card-shadow);
        margin-bottom: 16px;
        overflow: hidden;
    }

    .profile-card + .profile-card {
        margin-top: 16px;
    }

    .profile-card-header {
        padding: 16px 16px 12px;
        border-bottom: 1px solid var(--border-light);
    }

    .profile-card-title {
        font-size: 17px;
        font-weight: 700;
        color: var(--text-dark);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .profile-card-body {
        padding: 16px;
    }

    /* Info Items */
    .info-list {
        display: flex;
        flex-direction: column;
        gap: 16px;
    }

    .info-item {
        display: flex;
        align-items: flex-start;
        gap: 12px;
    }

    .info-icon {
        width: 36px;
        height: 36px;
        border-radius: 50%;
        background: var(--bg-light);
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
        font-size: 16px;
    }

    .info-content {
        flex: 1;
        padding-top: 4px;
    }

    .info-label {
        font-size: 13px;
        color: var(--text-muted);
        margin-bottom: 2px;
    }

    .info-value {
        font-size: 15px;
        color: var(--text-dark);
        font-weight: 500;
    }

    .intro-list {
        list-style: none;
        padding: 0;
        margin: 0;
        display: flex;
        flex-direction: column;
        gap: 12px;
    }

    .intro-list li {
        display: flex;
        align-items: flex-start;
        gap: 10px;
        font-size: 15px;
        color: var(--text-dark);
        line-height: 1.4;
    }

    .intro-list li i {
        color: var(--primary-color);
        font-size: 18px;
        margin-top: 2px;
    }

    .profile-section-header {
        font-size: 16px;
        font-weight: 700;
        color: var(--text-dark);
        margin-bottom: 12px;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .profile-section-header i {
        color: var(--primary-color);
    }

    .profile-photo-grid,
    .profile-friend-grid {
        display: grid;
        gap: 8px;
    }

    .profile-photo-grid {
        grid-template-columns: repeat(3, 1fr);
    }

    .profile-photo-grid .photo-item {
        padding-bottom: 100%;
        border-radius: 8px;
        overflow: hidden;
        position: relative;
        background: var(--bg-light);
    }

    .profile-photo-grid .photo-item img {
        position: absolute;
        inset: 0;
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .profile-friend-grid {
        grid-template-columns: repeat(2, 1fr);
    }

    .profile-friend-grid .friend-tile {
        display: flex;
        align-items: center;
        gap: 10px;
        padding: 8px;
        border-radius: 10px;
        transition: background 0.2s ease;
        text-decoration: none;
    }

    .profile-friend-grid .friend-tile:hover {
        background: var(--bg-light);
    }

    .profile-friend-grid .friend-tile img {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        object-fit: cover;
    }

    .profile-friend-grid .friend-name {
        display: block;
        font-weight: 600;
        color: var(--text-dark);
        font-size: 14px;
    }

    .profile-friend-grid .friend-username {
        display: block;
        font-size: 12px;
        color: var(--text-muted);
    }

    .profile-posts-empty {
        text-align: center;
        color: var(--text-muted);
        padding: 40px 0;
    }



    .timeline-toolbar {
        background: white;
        border-radius: 12px;
        padding: 12px 18px;
        box-shadow: var(--card-shadow);
        display: flex;
        align-items: center;
        justify-content: space-between;
        gap: 12px;
        position: sticky;
        top: 70px;
        z-index: 15;
        margin-bottom: 16px;
    }

    .timeline-filters {
        display: flex;
        gap: 8px;
        flex-wrap: wrap;
        align-items: center;
    }

    .timeline-filter-chip {
        border: 1px solid var(--border-light);
        background: white;
        color: var(--text-dark);
        border-radius: 20px;
        padding: 6px 14px;
        font-size: 13px;
        font-weight: 600;
        transition: all 0.2s ease;
        display: inline-flex;
        align-items: center;
        gap: 6px;
    }

    .timeline-filter-chip i {
        font-size: 16px;
    }

    .timeline-filter-chip.active,
    .timeline-filter-chip:hover {
        border-color: var(--primary-color);
        color: var(--primary-color);
        background: rgba(24, 119, 242, 0.08);
    }

    .timeline-actions {
        display: flex;
        gap: 8px;
        flex-wrap: wrap;
    }

    .timeline-actions .btn {
        border-radius: 20px;
        font-size: 13px;
        font-weight: 600;
        padding: 6px 14px;
    }

    .featured-collections {
        display: grid;
        gap: 12px;
    }

    .featured-collection-card {
        position: relative;
        border-radius: 14px;
        overflow: hidden;
        min-height: 120px;
        background-size: cover;
        background-position: center;
        display: flex;
        align-items: flex-end;
        box-shadow: 0 4px 14px rgba(0, 0, 0, 0.12);
    }

    .featured-collection-card::after {
        content: "";
        position: absolute;
        inset: 0;
        background: linear-gradient(to top, rgba(0,0,0,0.65), rgba(0,0,0,0.1));
    }

    .featured-collection-content {
        position: relative;
        padding: 16px;
        color: white;
    }

    .featured-collection-title {
        font-size: 16px;
        font-weight: 700;
        margin: 0;
    }

    .featured-collection-meta {
        font-size: 12px;
        opacity: 0.85;
        margin-top: 4px;
    }

    .profile-shortcut-button {
        width: 100%;
        text-align: left;
        border: 1px solid var(--border-light);
        border-radius: 12px;
        padding: 12px 16px;
        background: white;
        display: flex;
        align-items: center;
        gap: 12px;
        font-weight: 600;
        transition: all 0.2s ease;
        text-decoration: none;
        color: var(--text-dark);
    }

    .profile-shortcut-button i {
        width: 36px;
        height: 36px;
        border-radius: 10px;
        background: rgba(24, 119, 242, 0.1);
        display: flex;
        align-items: center;
        justify-content: center;
        color: var(--primary-color);
        font-size: 16px;
    }

    .profile-shortcut-button:hover {
        border-color: rgba(24, 119, 242, 0.25);
        transform: translateY(-2px);
        box-shadow: var(--card-hover-shadow);
    }

    /* Friends Grid */
    .friends-grid {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 8px;
    }

    .friend-item {
        text-align: center;
        padding: 12px 8px;
        border-radius: 8px;
        transition: all 0.2s;
        text-decoration: none;
    }

    .friend-item:hover {
        background: var(--bg-light);
        transform: translateY(-2px);
    }

    .friend-avatar {
        width: 64px;
        height: 64px;
        border-radius: 8px;
        object-fit: cover;
        margin-bottom: 8px;
    }

    .friend-name {
        font-size: 13px;
        font-weight: 600;
        color: var(--text-dark);
        display: block;
    }

    /* Photos Grid */
    .photos-grid {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 4px;
    }

    .photo-item {
        position: relative;
        padding-bottom: 100%;
        overflow: hidden;
        border-radius: 8px;
        cursor: pointer;
        background: var(--bg-light);
    }

    .photo-item img {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.3s ease;
    }

    .photo-item:hover img {
        transform: scale(1.05);
    }

    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 48px 24px;
    }

    .empty-state i {
        font-size: 64px;
        color: var(--text-muted);
        opacity: 0.5;
        margin-bottom: 16px;
        display: block;
    }

    .empty-state p {
        font-size: 15px;
        color: var(--text-muted);
        margin: 0;
    }

    /* See More Link */
    .see-more-link {
        color: var(--primary-color);
        font-size: 14px;
        font-weight: 600;
        text-decoration: none;
        transition: color 0.2s;
    }

    .see-more-link:hover {
        color: #166fe5;
        text-decoration: underline;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .profile-name-title {
            font-size: 26px;
        }

        .profile-cover {
            height: 220px;
        }

        .profile-avatar {
            width: 140px;
            height: 140px;
        }

        .profile-avatar-container {
            margin-top: -70px;
        }

        .profile-action-bar {
            justify-content: center;
        }

        .friends-grid {
            grid-template-columns: repeat(2, 1fr);
        }

        .photos-grid {
            grid-template-columns: repeat(2, 1fr);
        }

        .profile-photo-grid {
            grid-template-columns: repeat(2, 1fr);
        }

        .profile-friend-grid {
            grid-template-columns: repeat(1, 1fr);
        }

        .timeline-toolbar {
            position: static;
            flex-direction: column;
            align-items: flex-start;
        }

        .timeline-actions {
            width: 100%;
            justify-content: flex-start;
        }

        .profile-action-bar {
            justify-content: center;
        }
    }
</style>
@endpush

@section('content')

@php
    $isOwnProfile = $loggedInUserId && $loggedInUserId === $user->id;
@endphp

<div class="profile-page-container">
    <!-- Profile Cover and Info -->
    <div class="profile-cover-section">
        <div class="profile-cover" style="background-image: url('{{ $user->cover ? getMedia($user->cover) : asset('assets/images/bg/04.jpg') }}');"></div>

        <div class="profile-info-section">
            <div class="profile-avatar-container">
                <img src="{{ $user->avatar ? getMedia($user->avatar) : asset('assets/images/avatar/07.jpg') }}" 
                     alt="{{ $user->first_name }}" 
                     class="profile-avatar">
            </div>

            <h1 class="profile-name-title">{{ $user->first_name }} {{ $user->last_name }}</h1>

            @auth
                <div class="profile-action-bar">
                    @if(!$isOwnProfile)
                        @if($isFriend)
                            <button class="btn-profile-action btn-success-custom" disabled>
                                <i class="bi bi-check-circle-fill"></i> Friends
                            </button>
                        @elseif($friendRequestStatus === 'pending')
                            <button class="btn-profile-action btn-secondary-custom" disabled>
                                <i class="bi bi-clock-fill"></i> Request Sent
                            </button>
                        @elseif($friendRequestStatus === 'received')
                            <button class="btn-profile-action btn-primary-custom" id="acceptFriendBtn" data-user-id="{{ $user->id }}">
                                <i class="bi bi-person-check-fill"></i> Accept Request
                            </button>
                        @else
                            <button class="btn-profile-action btn-primary-custom" id="addFriendBtn" data-user-id="{{ $user->id }}">
                                <i class="bi bi-person-plus-fill"></i> Add Friend
                            </button>
                        @endif

                        <button class="btn-profile-action btn-outline-custom" id="messageBtn" data-user-id="{{ $user->id }}">
                            <i class="bi bi-chat-dots-fill"></i> Message
                        </button>

                        @if($isFollowing)
                            <button class="btn-profile-action btn-secondary-custom" id="unfollowBtn" data-user-id="{{ $user->id }}">
                                <i class="bi bi-person-check-fill"></i> Following
                            </button>
                        @else
                            <button class="btn-profile-action btn-outline-custom" id="followBtn" data-user-id="{{ $user->id }}">
                                <i class="bi bi-person-plus"></i> Follow
                            </button>
                        @endif
                    @else
                        <a href="{{ url('create_story') }}" class="btn-profile-action btn-primary-custom">
                            <i class="bi bi-plus-circle"></i> Add to story
                        </a>
                        <a href="{{ route('settings.profile') }}" class="btn-profile-action btn-outline-custom">
                            <i class="bi bi-pencil-square"></i> Edit profile
                        </a>
                        <a href="{{ route('settings.privacy') }}" class="btn-profile-action btn-outline-custom d-none d-md-inline-flex">
                            <i class="bi bi-shield-lock"></i> Privacy Settings
                        </a>
                    @endif
                </div>
            @endauth
        </div>
    </div>

    <!-- Navigation Tabs -->
    <div class="profile-tabs">
        <ul class="profile-nav-tabs nav" id="profileTabs" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="timeline-tab" data-bs-toggle="tab" data-bs-target="#timeline" type="button" role="tab">
                    <i class="bi bi-newspaper me-1"></i> Timeline
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="about-tab" data-bs-toggle="tab" data-bs-target="#about" type="button" role="tab">
                    <i class="bi bi-info-circle me-1"></i> About
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="friends-tab" data-bs-toggle="tab" data-bs-target="#friends" type="button" role="tab">
                    <i class="bi bi-people me-1"></i> Friends
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="photos-tab" data-bs-toggle="tab" data-bs-target="#photos" type="button" role="tab">
                    <i class="bi bi-images me-1"></i> Photos
                </button>
            </li>
        </ul>
    </div>

    <!-- Profile Content -->
    <div class="profile-content-wrapper">
        <!-- Main Content - Full Width -->
        <div>
            <!-- Tab Content -->
            <div class="tab-content" id="profileTabsContent">
                @php
                    $photoThumbs = [];
                    foreach ($photos as $photo) {
                        if($photo->media && $photo->media->count() > 0) {
                            foreach ($photo->media as $media) {
                                if($media->isImage()) {
                                    $photoThumbs[] = $media->media_path;
                                    if (count($photoThumbs) >= 6) {
                                        break 2;
                                    }
                                }
                            }
                        }
                    }
                @endphp

                <!-- Timeline Tab -->
                <div class="tab-pane fade show active" id="timeline" role="tabpanel" aria-labelledby="timeline-tab">
                    <div class="row g-4">
                        <div class="col-12 col-xl-4">
                            <div class="profile-card">
                                <div class="profile-card-body">
                                    <div class="profile-section-header">
                                        <i class="bi bi-person-lines-fill"></i> Intro
                                    </div>
                                    @if($user->bio)
                                        <p class="text-muted mb-3">{{ $user->bio }}</p>
                                    @endif
                                    <ul class="intro-list">
                                        <li>
                                            <i class="bi bi-people-fill"></i>
                                            <span>
                                                <strong>{{ number_format($friendsCount) }}</strong>
                                                @if($mutualFriendsCount && $loggedInUserId && $loggedInUserId !== $user->id)
                                                    <span class="text-muted"> ({{ $mutualFriendsCount }} mutual)</span>
                                                @endif
                                                Friends
                                            </span>
                                        </li>
                                        <li>
                                            <i class="bi bi-person-heart"></i>
                                            <span><strong>{{ $followersCount }}</strong> Followers · <strong>{{ $followingCount }}</strong> Following</span>
                                        </li>
                                        @if($user->workspace)
                                            <li>
                                                <i class="bi bi-briefcase"></i>
                                                <span>Works at <strong>{{ $user->workspace }}</strong></span>
                                            </li>
                                        @endif
                                        @if($user->relationship)
                                            <li>
                                                <i class="bi bi-heart-fill"></i>
                                                <span>{{ ucfirst($user->relationship) }}</span>
                                            </li>
                                        @endif
                                        @if($user->address)
                                            <li>
                                                <i class="bi bi-geo-alt-fill"></i>
                                                <span>Lives in <strong>{{ $user->address }}</strong></span>
                                            </li>
                                        @endif
                                        @if($user->country)
                                            <li>
                                                <i class="bi bi-flag"></i>
                                                <span>From <strong>{{ $user->country }}</strong></span>
                                            </li>
                                        @endif
                                        <li>
                                            <i class="bi bi-calendar-check"></i>
                                            <span>Joined {{ $user->created_at->format('M Y') }}</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>

                            <div class="profile-card">
                                <div class="profile-card-body">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <div class="profile-section-header mb-0">
                                            <i class="bi bi-images"></i> Photos
                                        </div>
                                        <a href="#photos" class="see-more-link" data-bs-toggle="tab" data-bs-target="#photos" role="tab">See all</a>
                                    </div>
                                    @if(count($photoThumbs) > 0)
                                        <div class="profile-photo-grid">
                                            @foreach($photoThumbs as $image)
                                                <div class="photo-item">
                                                    <img src="{{ getMedia($image) }}" alt="Photo">
                                                </div>
                                            @endforeach
                                        </div>
                                    @else
                                        <p class="text-muted mb-0">No photos to show</p>
                                    @endif
                                </div>
                            </div>

                            <div class="profile-card">
                                <div class="profile-card-body">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <div class="profile-section-header mb-0">
                                            <i class="bi bi-people"></i> 
                                            <span>
                                                {{ number_format($friendsCount) }}
                                                @if($mutualFriendsCount && $loggedInUserId && $loggedInUserId !== $user->id)
                                                    <span class="text-muted"> ({{ $mutualFriendsCount }} mutual)</span>
                                                @endif
                                                Friends
                                            </span>
                                        </div>
                                        <a href="#friends" class="see-more-link" data-bs-toggle="tab" data-bs-target="#friends" role="tab">See all</a>
                                    </div>
                                    @if($friends->count() > 0)
                                        <div class="profile-friend-grid">
                                            @foreach($friends as $friend)
                                                <a href="{{ route('user.detail', ['username' => $friend->username]) }}" class="friend-tile">
                                                    <img src="{{ $friend->avatar ? getMedia($friend->avatar) : asset('assets/images/avatar/07.jpg') }}" alt="{{ $friend->first_name }}">
                                                    <div>
                                                        <span class="friend-name">{{ $friend->first_name }} {{ $friend->last_name }}</span>
                                                        <span class="friend-username">{{"@" . $friend->username }}</span>
                                                    </div>
                                                </a>
                                            @endforeach
                                        </div>
                                    @else
                                        <p class="text-muted mb-0">No friends to show</p>
                                    @endif
                                </div>
                            </div>

                            @if(count($photoThumbs) > 0)
                            <div class="profile-card">
                                <div class="profile-card-body">
                                    <div class="profile-section-header mb-3">
                                        <i class="bi bi-stars"></i> Highlights
                                    </div>
                                    @php
                                        $highlightImage = $photoThumbs[0] ?? null;
                                    @endphp
                                    @if($highlightImage)
                                    <div class="featured-collections">
                                        <div class="featured-collection-card" style="background-image: url('{{ getMedia($highlightImage) }}');">
                                            <div class="featured-collection-content">
                                                <p class="featured-collection-title mb-1">Recent Memories</p>
                                                <p class="featured-collection-meta mb-0">{{ count($photoThumbs) }} recent photos</p>
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                                </div>
                            </div>
                            @endif

                        </div>
                        <div class="col-12 col-xl-8">
                            <div class="timeline-toolbar">
                                <div class="timeline-filters">
                                    <button type="button" class="timeline-filter-chip active" data-post-type="all">
                                        <i class="bi bi-columns-gap"></i> All
                                    </button>
                                    <button type="button" class="timeline-filter-chip" data-post-type="post">
                                        <i class="bi bi-chat-square-text"></i> Posts
                                    </button>
                                    <button type="button" class="timeline-filter-chip" data-post-type="reel">
                                        <i class="bi bi-camera-reels"></i> Reels
                                    </button>
                                    <button type="button" class="timeline-filter-chip" data-post-type="group_post">
                                        <i class="bi bi-people"></i> Groups
                                    </button>
                                </div>
                                <div class="timeline-actions">
                                    <button class="btn btn-outline-secondary btn-sm" id="refreshTimeline">
                                        <i class="bi bi-arrow-clockwise"></i> Refresh
                                    </button>
                                    <button class="btn btn-outline-secondary btn-sm" id="toggleTimelineSort" data-sort="recent">
                                        <i class="bi bi-sliders"></i> Most recent
                                    </button>
                                </div>
                            </div>
                            @if($isOwnProfile)
                                @php
                                    $postType = 'post';
                                    $boxAvatar = Auth::user()->avatar;
                                @endphp
                                @include('front_end.layouts.newsfeed_box')
                            @else
                                <input type="hidden" id="postType" value="all">
                                <input type="hidden" id="selectedPageId" value="">
                                <input type="hidden" id="selectedGroupId" value="">
                                <input type="hidden" id="pageId" value="">
                                <input type="hidden" id="groupId" value="">
                            @endif
                            <div class="mt-4" id="postholder"></div>
                        </div>
                    </div>
                </div>

                <!-- About Tab -->
                <div class="tab-pane fade" id="about" role="tabpanel" aria-labelledby="about-tab">
                    <div class="profile-card">
                        <div class="profile-card-body">
                            <h5 class="mb-4" style="font-size: 20px; font-weight: 700;">About {{ $user->first_name }}</h5>
                            
                            @if($user->bio)
                            <div class="mb-4 p-3" style="background: var(--bg-light); border-radius: 8px;">
                                <h6 style="font-size: 17px; font-weight: 600; margin-bottom: 12px;">
                                    <i class="bi bi-quote me-2"></i>Bio
                                </h6>
                                <p style="margin-left: 32px; color: var(--text-dark); line-height: 1.6; margin-bottom: 0;">{{ $user->bio }}</p>
                            </div>
                            @endif

                            <div class="row g-3">
                                <!-- Personal Information Section -->
                                <div class="col-md-6">
                                    <div class="profile-card" style="margin-bottom: 0; height: 100%;">
                                        <div class="profile-card-header">
                                            <h6 class="profile-card-title" style="font-size: 16px;">
                                                <i class="bi bi-person-circle text-primary"></i> Personal Information
                                            </h6>
                                        </div>
                                        <div class="profile-card-body">
                                            <div class="info-list">
                                                <div class="info-item">
                                                    <div class="info-icon">
                                                        <i class="bi bi-person-fill text-primary"></i>
                                                    </div>
                                                    <div class="info-content">
                                                        <div class="info-label">Full Name</div>
                                                        <div class="info-value">{{ $user->first_name }} {{ $user->last_name }}</div>
                                                    </div>
                                                </div>

                                                <div class="info-item">
                                                    <div class="info-icon">
                                                        <i class="bi bi-at text-primary"></i>
                                                    </div>
                                                    <div class="info-content">
                                                        <div class="info-label">Username</div>
                                                        <div class="info-value">{{ $user->username }}</div>
                                                    </div>
                                                </div>

                                                @if($user->email)
                                                <div class="info-item">
                                                    <div class="info-icon">
                                                        <i class="bi bi-envelope-fill text-primary"></i>
                                                    </div>
                                                    <div class="info-content">
                                                        <div class="info-label">Email</div>
                                                        <div class="info-value">{{ $user->email }}</div>
                                                    </div>
                                                </div>
                                                @endif

                                                @if($user->phone)
                                                <div class="info-item">
                                                    <div class="info-icon">
                                                        <i class="bi bi-telephone-fill text-warning"></i>
                                                    </div>
                                                    <div class="info-content">
                                                        <div class="info-label">Phone</div>
                                                        <div class="info-value">{{ $user->phone }}</div>
                                                    </div>
                                                </div>
                                                @endif

                                                @if($user->gender)
                                                <div class="info-item">
                                                    <div class="info-icon">
                                                        <i class="bi bi-gender-ambiguous text-secondary"></i>
                                                    </div>
                                                    <div class="info-content">
                                                        <div class="info-label">Gender</div>
                                                        <div class="info-value">{{ ucfirst($user->gender) }}</div>
                                                    </div>
                                                </div>
                                                @endif

                                                @if($user->date_of_birth)
                                                <div class="info-item">
                                                    <div class="info-icon">
                                                        <i class="bi bi-cake2-fill text-danger"></i>
                                                    </div>
                                                    <div class="info-content">
                                                        <div class="info-label">Birthday</div>
                                                        <div class="info-value">{{ $user->date_of_birth->format('M d, Y') }}</div>
                                                    </div>
                                                </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Work & Relationship Section -->
                                @if($user->workspace || $user->relationship)
                                <div class="col-md-6">
                                    <div class="profile-card" style="margin-bottom: 0; height: 100%;">
                                        <div class="profile-card-header">
                                            <h6 class="profile-card-title" style="font-size: 16px;">
                                                <i class="bi bi-briefcase-fill text-primary"></i> Work & Life
                                            </h6>
                                        </div>
                                        <div class="profile-card-body">
                                            <div class="info-list">
                                                @if($user->workspace)
                                                <div class="info-item">
                                                    <div class="info-icon">
                                                        <i class="bi bi-building-fill text-primary"></i>
                                                    </div>
                                                    <div class="info-content">
                                                        <div class="info-label">Works at</div>
                                                        <div class="info-value">{{ $user->workspace }}</div>
                                                    </div>
                                                </div>
                                                @endif

                                                @if($user->relationship)
                                                <div class="info-item">
                                                    <div class="info-icon">
                                                        <i class="bi bi-heart-fill text-danger"></i>
                                                    </div>
                                                    <div class="info-content">
                                                        <div class="info-label">Relationship Status</div>
                                                        <div class="info-value">{{ ucfirst($user->relationship) }}</div>
                                                    </div>
                                                </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endif

                                <!-- Location Section -->
                                @if($user->address || $user->country || $user->state)
                                <div class="col-md-6">
                                    <div class="profile-card" style="margin-bottom: 0; height: 100%;">
                                        <div class="profile-card-header">
                                            <h6 class="profile-card-title" style="font-size: 16px;">
                                                <i class="bi bi-geo-alt-fill text-success"></i> Location
                                            </h6>
                                        </div>
                                        <div class="profile-card-body">
                                            <div class="info-list">
                                                @if($user->address)
                                                <div class="info-item">
                                                    <div class="info-icon">
                                                        <i class="bi bi-house-fill text-success"></i>
                                                    </div>
                                                    <div class="info-content">
                                                        <div class="info-label">Lives in</div>
                                                        <div class="info-value">{{ $user->address }}</div>
                                                    </div>
                                                </div>
                                                @endif

                                                @if($user->country)
                                                <div class="info-item">
                                                    <div class="info-icon">
                                                        <i class="bi bi-flag-fill text-info"></i>
                                                    </div>
                                                    <div class="info-content">
                                                        <div class="info-label">From</div>
                                                        <div class="info-value">{{ $user->country }}</div>
                                                    </div>
                                                </div>
                                                @endif

                                                @if($user->state)
                                                <div class="info-item">
                                                    <div class="info-icon">
                                                        <i class="bi bi-pin-map-fill text-info"></i>
                                                    </div>
                                                    <div class="info-content">
                                                        <div class="info-label">State</div>
                                                        <div class="info-value">{{ $user->state }}</div>
                                                    </div>
                                                </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endif

                                <!-- Account Information Section -->
                                <div class="col-md-6">
                                    <div class="profile-card" style="margin-bottom: 0; height: 100%;">
                                        <div class="profile-card-header">
                                            <h6 class="profile-card-title" style="font-size: 16px;">
                                                <i class="bi bi-info-circle-fill text-primary"></i> Account Info
                                            </h6>
                                        </div>
                                        <div class="profile-card-body">
                                            <div class="info-list">
                                                <div class="info-item">
                                                    <div class="info-icon">
                                                        <i class="bi bi-calendar-check-fill text-primary"></i>
                                                    </div>
                                                    <div class="info-content">
                                                        <div class="info-label">Member Since</div>
                                                        <div class="info-value">{{ $user->created_at->format('M d, Y') }}</div>
                                                    </div>
                                                </div>

                                                <div class="info-item">
                                                    <div class="info-icon">
                                                        <i class="bi bi-clock-fill text-secondary"></i>
                                                    </div>
                                                    <div class="info-content">
                                                        <div class="info-label">Last Active</div>
                                                        <div class="info-value">{{ $user->updated_at->diffForHumans() }}</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Friends Tab -->
                <div class="tab-pane fade" id="friends" role="tabpanel">
                    @if($friends->count() > 0)
                    <div class="row g-3">
                        @foreach($friends as $friend)
                        <div class="col-md-6">
                            <div class="profile-card">
                                <div class="profile-card-body">
                                    <div class="d-flex align-items-center">
                                        <img src="{{ $friend->avatar ? getMedia($friend->avatar) : asset('assets/images/avatar/07.jpg') }}" 
                                             alt="{{ $friend->first_name }}" 
                                             class="rounded-circle me-3" 
                                             style="width: 56px; height: 56px; object-fit: cover;">
                                        <div class="flex-grow-1">
                                            <h6 class="mb-0" style="font-weight: 600;">{{ $friend->first_name }} {{ $friend->last_name }}</h6>
                                            <small style="color: var(--text-muted);">{{"@". $friend->username }}</small>
                                        </div>
                                        <a href="{{ route('user.detail', ['username' => $friend->username]) }}" 
                                           class="btn-profile-action btn-outline-custom"
                                           style="padding: 6px 12px; font-size: 14px;">View</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    @else
                    <div class="profile-card">
                        <div class="empty-state">
                            <i class="bi bi-people"></i>
                            <p>No friends to show</p>
                        </div>
                    </div>
                    @endif
                </div>

                <!-- Photos Tab -->
                <div class="tab-pane fade" id="photos" role="tabpanel">
                    @php
                        $allPhotos = [];
                        foreach($photos as $photo) {
                            if($photo->media && $photo->media->count() > 0) {
                                foreach($photo->media as $media) {
                                    if($media->isImage()) {
                                        $allPhotos[] = $media;
                                    }
                                }
                            }
                        }
                    @endphp
                    @if(count($allPhotos) > 0)
                    <div class="photos-grid" style="grid-template-columns: repeat(4, 1fr); gap: 8px;">
                        @foreach($allPhotos as $media)
                        <div class="photo-item">
                            <img src="{{ getMedia($media->media_path) }}" alt="Photo">
                        </div>
                        @endforeach
                    </div>
                    @else
                    <div class="profile-card">
                        <div class="empty-state">
                            <i class="bi bi-images"></i>
                            <p>No photos to show</p>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<input type="hidden" id="profileUserId" value="{{ $user->id }}">

@endsection

@push('scripts')
@include('front_end.layouts.newsfeed_scripts')
<script>
    $(document).ready(function () {
        // Friend request actions
        $('#addFriendBtn').on('click', function () {
            const userId = $(this).data('user-id');
            $.ajax({
                url: '/webapi/friends/send-request',
                method: 'POST',
                data: {
                    to_user_id: userId,
                    _token: '{{ csrf_token() }}'
                },
                success: function (response) {
                    if (response.status === 200) {
                        $('#addFriendBtn').replaceWith('<button class="btn-profile-action btn-secondary-custom" disabled><i class="bi bi-clock-fill"></i> Request Sent</button>');
                        window.toastr?.success(response.message || 'Friend request sent successfully');
                    } else {
                        window.toastr?.error(response.message || 'Failed to send friend request');
                    }
                },
                error: function () {
                    window.toastr?.error('An error occurred. Please try again.');
                }
            });
        });

        $('#acceptFriendBtn').on('click', function () {
            const userId = $(this).data('user-id');
            $.ajax({
                url: '/webapi/friends/request-action',
                method: 'POST',
                data: {
                    from_user_id: userId,
                    action: 'accept',
                    _token: '{{ csrf_token() }}'
                },
                success: function (response) {
                    if (response.status === 200) {
                        $('#acceptFriendBtn').replaceWith('<button class="btn-profile-action btn-success-custom" disabled><i class="bi bi-check-circle-fill"></i> Friends</button>');
                        window.toastr?.success(response.message || 'Friend request accepted');
                    } else {
                        window.toastr?.error(response.message || 'Failed to accept friend request');
                    }
                },
                error: function () {
                    window.toastr?.error('An error occurred. Please try again.');
                }
            });
        });

        $('#followBtn').on('click', function () {
            const userId = $(this).data('user-id');
            $.ajax({
                url: '/webapi/friends/send-request',
                method: 'POST',
                data: {
                    to_user_id: userId,
                    _token: '{{ csrf_token() }}'
                },
                success: function () {
                    $('#followBtn').replaceWith('<button class="btn-profile-action btn-secondary-custom" id="unfollowBtn" data-user-id="' + userId + '"><i class="bi bi-person-check-fill"></i> Following</button>');
                    window.toastr?.success('Now following');
                    setTimeout(function () {
                        location.reload();
                    }, 1000);
                },
                error: function () {
                    window.toastr?.error('An error occurred. Please try again.');
                }
            });
        });

        $('#messageBtn').on('click', function () {
            const userId = $(this).data('user-id');
            window.location.href = '/messenger?user=' + userId;
        });
    });
</script>
@endpush

@section('extra-js')
<script>
    (function () {
        const timelineTabId = 'timeline-tab';
        const postholder = document.getElementById('postholder');
        const filterChips = Array.from(document.querySelectorAll('.timeline-filter-chip'));
        const refreshButton = document.getElementById('refreshTimeline');
        const sortButton = document.getElementById('toggleTimelineSort');
        const postTypeField = $('#postType');

        function setPostType(value) {
            const normalized = value || 'all';
            if (postTypeField.length) {
                postTypeField.val(normalized);
            }
            filterChips.forEach((chip) => {
                const chipType = chip.getAttribute('data-post-type') || 'all';
                chip.classList.toggle('active', chipType === normalized);
            });
        }

        function initializeTimelineFeed(reload = false) {
            if (!postholder) {
                return;
            }

            if (reload) {
                offset = 0;
                isLoading = false;
                $("#postholder").empty();
                loadNewsFeed();
            }

            $(window).off("scroll", handleScroll);
            $(window).on("scroll", handleScroll);
        }

        document.addEventListener('DOMContentLoaded', function () {
            if (postTypeField.length) {
                setPostType('all');
            }
            initializeTimelineFeed(true);
        });

        filterChips.forEach(function (chip) {
            chip.addEventListener('click', function () {
                const selectedType = chip.getAttribute('data-post-type') || 'all';
                setPostType(selectedType);
                initializeTimelineFeed(true);
            });
        });

        if (refreshButton) {
            refreshButton.addEventListener('click', function () {
                initializeTimelineFeed(true);
            });
        }

        if (sortButton) {
            sortButton.addEventListener('click', function () {
                const current = this.getAttribute('data-sort') || 'recent';
                if (current === 'recent') {
                    this.setAttribute('data-sort', 'top');
                    this.innerHTML = '<i class="bi bi-sliders"></i> Top posts';
                } else {
                    this.setAttribute('data-sort', 'recent');
                    this.innerHTML = '<i class="bi bi-sliders"></i> Most recent';
                }
                initializeTimelineFeed(true);
            });
        }

        document.querySelectorAll('#profileTabs button[data-bs-toggle="tab"]').forEach(function (tabButton) {
            tabButton.addEventListener('shown.bs.tab', function (event) {
                if (event.target.id === timelineTabId) {
                    const hasPosts = $('#postholder').children().length > 0;
                    initializeTimelineFeed(!hasPosts);
                } else {
                    $(window).off("scroll", handleScroll);
                }
            });
        });
    })();
</script>
@endsection
