@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', 'Pokes Dashboard')


@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Header Section -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="{{ url('/social') }}" class="text-white me-3">
                                    <i class="fas fa-arrow-left fa-lg"></i>
                                </a>
                                <div>
                                    <h4 class="mb-0 text-white">Pokes</h4>
                                    <p class="mb-0 text-white">Interact with your friends in a fun way</p>
                                </div>
                            </div>
                            <div>
                                @if($unreadCount > 0)
                                <form action="{{ route('pokes.markAllAsRead') }}" method="POST" class="d-inline">
                                    @csrf
                                    <button type="submit" class="btn btn-light">
                                        <i class="fas fa-check-double me-2"></i>Mark All as Read
                                    </button>
                                </form>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container py-5">
        <!-- Poke Stats -->
        <div class="row mb-5">
            <div class="col-md-4">
                <div class="card border-0 shadow-sm text-center h-100">
                    <div class="card-body">
                        <div class="mb-3">
                            <i class="fas fa-hand-point-right fa-3x text-primary opacity-75"></i>
                        </div>
                        <h2 class="mb-1">{{ $receivedPokes->count() }}</h2>
                        <p class="text-muted mb-0">Received Pokes</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card border-0 shadow-sm text-center h-100">
                    <div class="card-body">
                        <div class="mb-3">
                            <i class="fas fa-hand-point-left fa-3x text-success opacity-75"></i>
                        </div>
                        <h2 class="mb-1">{{ $sentPokes->count() }}</h2>
                        <p class="text-muted mb-0">Sent Pokes</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card border-0 shadow-sm text-center h-100">
                    <div class="card-body">
                        <div class="mb-3">
                            <i class="fas fa-bell fa-3x text-danger opacity-75"></i>
                        </div>
                        <h2 class="mb-1">{{ $unreadCount }}</h2>
                        <p class="text-muted mb-0">Unread Pokes</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Pokes Section -->
        <div class="row mb-5">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="mb-0">Recent Received Pokes</h3>
                    <a href="{{ route('pokes.received') }}" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                
                @if($receivedPokes->count() > 0)
                <div class="card border-0 shadow-sm">
                    <div class="list-group list-group-flush">
                        @foreach($receivedPokes as $poke)
                        <div class="list-group-item {{ $poke->is_read ? '' : 'bg-light' }}">
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="d-flex align-items-center">
                                    <img src="{{ getMedia($poke->sender->profile_photo,'avatar')}}" 
                                         class="rounded-circle me-3" alt="{{ $poke->sender->name }}" width="50" height="50">
                                    <div>
                                        <h6 class="mb-1">{{ $poke->sender->name }} poked you!</h6>
                                        @if($poke->message)
                                        <p class="mb-1 text-muted">{{ $poke->message }}</p>
                                        @endif
                                        <div class="text-muted small">{{ $poke->created_at->diffForHumans() }}</div>
                                    </div>
                                </div>
                                <div>
                                    @if(!$poke->is_read)
                                    <form action="{{ route('pokes.markAsRead', $poke->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-sm btn-outline-secondary me-2">
                                            <i class="fas fa-check me-1"></i>Mark as Read
                                        </button>
                                    </form>
                                    @endif
                                    <form action="{{ route('pokes.pokeBack', $poke->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-sm btn-primary">
                                            <i class="fas fa-hand-point-left me-1"></i>Poke Back
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
                @else
                <div class="card border-0 shadow-sm">
                    <div class="card-body p-5 text-center">
                        <i class="fas fa-hand-point-right fa-4x text-muted mb-3"></i>
                        <h5>No Pokes Yet</h5>
                        <p class="text-muted mb-0">When friends poke you, they'll appear here.</p>
                    </div>
                </div>
                @endif
            </div>
        </div>

        <!-- Sent Pokes Section -->
        <div class="row mb-5">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="mb-0">Recently Sent Pokes</h3>
                    <a href="{{ route('pokes.sent') }}" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                
                @if($sentPokes->count() > 0)
                <div class="card border-0 shadow-sm">
                    <div class="list-group list-group-flush">
                        @foreach($sentPokes as $poke)
                        <div class="list-group-item">
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="d-flex align-items-center">
                                    <img src="{{ $poke->receiver->profile_photo ? asset('storage/' . $poke->receiver->profile_photo) : asset('assets/images/default-avatar.jpg') }}" 
                                         class="rounded-circle me-3" alt="{{ $poke->receiver->name }}" width="50" height="50">
                                    <div>
                                        <h6 class="mb-1">You poked {{ $poke->receiver->name }}</h6>
                                        @if($poke->message)
                                        <p class="mb-1 text-muted">{{ $poke->message }}</p>
                                        @endif
                                        <div class="text-muted small">{{ $poke->created_at->diffForHumans() }}</div>
                                    </div>
                                </div>
                                <div>
                                    <span class="badge {{ $poke->is_read ? 'bg-success' : 'bg-secondary' }}">
                                        {{ $poke->is_read ? 'Read' : 'Unread' }}
                                    </span>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
                @else
                <div class="card border-0 shadow-sm">
                    <div class="card-body p-5 text-center">
                        <i class="fas fa-hand-point-left fa-4x text-muted mb-3"></i>
                        <h5>No Sent Pokes</h5>
                        <p class="text-muted mb-0">Pokes you've sent to friends will appear here.</p>
                    </div>
                </div>
                @endif
            </div>
        </div>

        <!-- Top Pokers Section -->
        @if($topPokers->count() > 0)
        <div class="row">
            <div class="col-12">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-transparent border-0">
                        <h5 class="mb-0">Your Top Pokers</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            @foreach($topPokers as $poker)
                            <div class="col-md-2 col-sm-4 col-6 text-center mb-4">
                                <img src="{{ $poker->sender->profile_photo ? asset('storage/' . $poker->sender->profile_photo) : asset('assets/images/default-avatar.jpg') }}" 
                                     class="rounded-circle mb-2" alt="{{ $poker->sender->name }}" width="80" height="80">
                                <h6 class="mb-1">{{ $poker->sender->name }}</h6>
                                <div class="text-muted small">{{ $poker->poke_count }} pokes</div>
                                <form action="{{ route('pokes.send', $poker->sender_id) }}" method="POST" class="mt-2">
                                    @csrf
                                    <button type="submit" class="btn btn-sm btn-primary">
                                        <i class="fas fa-hand-point-right me-1"></i>Poke
                                    </button>
                                </form>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>

@push('scripts')
<script>
    // Any JavaScript if needed
</script>
@endpush
@endsection