@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', 'Liked Pages')

@section('left_sidebar')
@include('front_end.pages.pages.page_left_sidebar')
@endsection


@section('content')


<div class="bg-white shadow-sm border-0 rounded-3">

    <!-- Breadcrumb Navigation -->
    <div class="card border-0 mb-3">
        <div class="card-body py-3">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="{{ url('/') }}" class="text-decoration-none d-flex align-items-center">
                            <i class="fas fa-home me-1 text-primary"></i>
                            <span class="text-primary fw-medium">Home</span>
                        </a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="{{ url('pages') }}" class="text-decoration-none text-muted">
                            <i class="fas fa-compass me-1"></i>
                            Pages
                        </a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        <i class="fas fa-heart me-1 text-danger"></i>
                        Liked Pages
                    </li>
                </ol>
            </nav>
        </div>
    </div>

    <!-- Create Story Header -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="{{ url('/') }}" class="text-white me-3 d-flex align-items-center">
                                    <i class="fas fa-arrow-left fa-lg me-2"></i>
                                    <span class="fw-medium">Back to Home</span>
                                </a>

                                <div class="d-flex justify-content-between align-items-center ">
                                    <div>
                                        <h4 class="mb-0 text-white">Liked Pages</h4>
                                        <p class="mb-0 text-white">Pages you've liked and are following</p>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex align-items-center">
                                <a href="{{ route('pages.create') }}" class="btn btn-light btn-sm me-2">
                                    <i class="fas fa-plus-circle me-1"></i>Create Page
                                </a>
                                <a href="{{ url('pages') }}" class="btn btn-outline-light btn-sm">
                                    <i class="fas fa-compass me-1"></i>Explore
                                </a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>


    <!-- Pages section start -->
    <div class="container mt-4">

        <!-- Search and Filter Section -->
        <div class="row mb-4">
            <div class="col-md-8">
                <div class="input-group">
                    <span class="input-group-text bg-white">
                        <i class="fas fa-search"></i>
                    </span>
                    <input type="text" class="form-control search-page" placeholder="Search liked pages by name or category" id="searchInput">
                    <button class="btn btn-outline-secondary clear-search-btn" type="button" style="display: none;">
                        <i class="fas fa-times"></i>
                    </button>
                    <button class="btn btn-primary search-btn" type="button">Search</button>
                </div>
            </div>
            <div class="col-md-4">
                <select class="form-select category-filter" id="categoryFilter">
                    <option value="">All Categories</option>
                    <option value="business">Business</option>
                    <option value="entertainment">Entertainment</option>
                    <option value="education">Education</option>
                    <option value="technology">Technology</option>
                    <option value="health">Health</option>
                    <option value="sports">Sports</option>
                    <option value="news">News</option>
                    <option value="other">Other</option>
                </select>
            </div>
        </div>

        <!-- Pages Grid -->
        <div class="row" id="pages_list">
            <!-- Loading placeholder cards will be shown here initially -->
            <div class="col-md-4">
                <div class="card p-3">
                    <div class="shimmer placeholder-img"></div>
                    <div class="shimmer placeholder-title"></div>
                    <div class="shimmer placeholder-text w-100"></div>
                    <div class="shimmer placeholder-text w-75"></div>
                    <div class="shimmer placeholder-btn mt-3"></div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card p-3">
                    <div class="shimmer placeholder-img"></div>
                    <div class="shimmer placeholder-title"></div>
                    <div class="shimmer placeholder-text w-100"></div>
                    <div class="shimmer placeholder-text w-75"></div>
                    <div class="shimmer placeholder-btn mt-3"></div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card p-3">
                    <div class="shimmer placeholder-img"></div>
                    <div class="shimmer placeholder-title"></div>
                    <div class="shimmer placeholder-text w-100"></div>
                    <div class="shimmer placeholder-text w-75"></div>
                    <div class="shimmer placeholder-btn mt-3"></div>
                </div>
            </div>
        </div>

        <!-- Discover More Pages -->
        <div class="row mt-4" id="discover-section">
            <div class="col-12">
                <div class="card border-0 bg-primary bg-opacity-10 p-4">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h4 class="text-primary mb-2">Want to discover more pages?</h4>
                            <p class="mb-md-0">Explore and follow more pages to stay updated with your interests</p>
                        </div>
                        <div class="col-md-4 text-md-end">
                            <a href="{{ route('pages') }}" class="btn btn-primary">
                                <i class="fas fa-compass me-2"></i>Explore Pages
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Pagination -->
        <div class="row mt-4 mb-4">
            <div class="col-12">
                <nav aria-label="Page navigation">
                    <ul class="pagination justify-content-center" id="pagination">
                        <!-- Pagination will be dynamically populated via JavaScript -->
                    </ul>
                </nav>
            </div>
        </div>

    </div>
    <!-- Pages section ends -->

</div>

@push('styles')
<style>
    .hover-shadow-md:hover {
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
        transform: translateY(-2px);
        transition: all 0.3s ease;
    }
    
    .transition-hover {
        transition: all 0.3s ease;
    }
    
    .shimmer {
        background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
        background-size: 200% 100%;
        animation: shimmer 1.5s infinite;
    }
    
    @keyframes shimmer {
        0% { background-position: -200% 0; }
        100% { background-position: 200% 0; }
    }
    
    .placeholder-img {
        height: 140px;
        border-radius: 0.375rem 0.375rem 0 0;
        margin-bottom: 1rem;
    }
    
    .placeholder-title {
        height: 1.5rem;
        width: 70%;
        margin-bottom: 0.5rem;
        border-radius: 0.25rem;
    }
    
    .placeholder-text {
        height: 0.875rem;
        margin-bottom: 0.5rem;
        border-radius: 0.25rem;
    }
    
    .placeholder-btn {
        height: 2.5rem;
        width: 100%;
        border-radius: 0.375rem;
    }
    
    .search-page:focus {
        border-color: #0d6efd;
        box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
    }
    
    .category-filter:focus {
        border-color: #0d6efd;
        box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
    }
    
    /* Beautiful breadcrumb styling */
    .breadcrumb {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        border-radius: 0.5rem;
        padding: 0.75rem 1rem;
        margin: 0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }
    
    .breadcrumb-item a {
        transition: all 0.3s ease;
        border-radius: 0.375rem;
        padding: 0.25rem 0.5rem;
        margin: -0.25rem 0;
    }
    
    .breadcrumb-item a:hover {
        background-color: rgba(13, 110, 253, 0.1);
        transform: translateY(-1px);
    }
    
    .breadcrumb-item.active {
        color: #6c757d;
        font-weight: 500;
    }
    
    .breadcrumb-item + .breadcrumb-item::before {
        content: "›";
        color: #6c757d;
        font-weight: bold;
        font-size: 1.2rem;
    }
    
    /* Enhanced header styling */
    .bg-primary {
        background: linear-gradient(135deg, #0d6efd 0%, #0b5ed7 100%) !important;
    }
    
    .btn-light:hover {
        background-color: rgba(255, 255, 255, 0.9);
        transform: translateY(-1px);
        transition: all 0.3s ease;
    }
    
    .btn-outline-light:hover {
        background-color: rgba(255, 255, 255, 0.2);
        transform: translateY(-1px);
        transition: all 0.3s ease;
    }
</style>
@endpush

@push('scripts')
<script src="{{ asset('assets/js/pages.js') }}"></script>
@endpush

@section('extra-js')
<script>
    $(document).ready(function() {
        get_liked_pages(1);
    });
</script>
@endsection




@endsection
