@php
$showLeftSidebar = false;
$showRightSidebar = false;
$mainContentClass = 'col-12';
$boxAvatar = Auth::user()->avatar ?? null;
@endphp

@extends('front_end.layouts.home')

@section('title', $page->page_title . ' - Page - Socialink')

@push('styles')
@include('front_end.layouts.newsfeed_styles')
<style>
    :root {
        --primary-color: #1877f2;
        --secondary-color: #42b72a;
        --text-dark: #050505;
        --text-muted: #65676b;
        --border-light: #e4e6eb;
        --bg-light: #f0f2f5;
        --card-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
        --card-hover-shadow: 0 2px 12px rgba(0, 0, 0, 0.15);
    }

    body {
        background-color: var(--bg-light);
    }

    /* Layout */
    .profile-page-container {
        max-width: 1080px;
        margin: 0 auto;
        padding: 0 16px;
        width: 100%;
    }

    @media (min-width: 1200px) {
        .profile-page-container {
            max-width: 1080px;
            padding: 0 24px;
        }
    }

    @media (max-width: 991px) {
        .profile-page-container {
            padding: 0 12px;
        }
    }

    /* Profile Cover */
    .profile-cover-section {
        background: white;
        border-radius: 8px;
        overflow: hidden;
        box-shadow: var(--card-shadow);
        margin-bottom: 16px;
    }

    .profile-cover {
        height: 300px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        background-size: cover;
        background-position: center;
        position: relative;
    }

    .profile-cover::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 100px;
        background: linear-gradient(to bottom, transparent, rgba(0,0,0,0.3));
    }

    /* Profile Info Section */
    .profile-info-section {
        padding: 16px 24px 20px;
        position: relative;
        display: flex;
        align-items: flex-end;
        gap: 16px;
    }

    @media (max-width: 768px) {
        .profile-info-section {
            padding: 16px 16px 16px;
            flex-direction: column;
            align-items: center;
        }
    }

    .profile-avatar-container {
        margin-top: -100px;
        position: relative;
        z-index: 10;
        flex-shrink: 0;
    }

    .profile-avatar {
        width: 180px;
        height: 180px;
        border: 6px solid white;
        border-radius: 50%;
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.18);
        object-fit: cover;
        background: white;
    }

    .profile-header-details {
        flex: 1;
        display: flex;
        flex-direction: column;
        justify-content: flex-end;
        padding-bottom: 8px;
    }

    .profile-name-section h1 {
        font-size: 32px;
        font-weight: 700;
        color: var(--text-dark);
        margin: 0 0 8px;
        line-height: 1.2;
    }

    /* Action Buttons */
    .profile-action-bar {
        display: flex;
        gap: 10px;
        flex-wrap: wrap;
        align-items: center;
        margin-top: 16px;
    }

    .btn-profile-action {
        padding: 10px 18px;
        font-size: 15px;
        font-weight: 600;
        border-radius: 999px;
        border: none;
        cursor: pointer;
        transition: all 0.2s;
        display: inline-flex;
        align-items: center;
        gap: 6px;
        text-decoration: none;
    }

    .btn-primary-custom {
        background: var(--primary-color);
        color: white;
    }

    .btn-primary-custom:hover {
        background: #166fe5;
        color: white;
    }

    .btn-secondary-custom {
        background: var(--border-light);
        color: var(--text-dark);
    }

    .btn-secondary-custom:hover {
        background: #d8dadf;
        color: var(--text-dark);
    }

    .btn-outline-custom {
        background: white;
        border: 1px solid var(--border-light);
        color: var(--text-dark);
    }

    .btn-outline-custom:hover {
        background: var(--bg-light);
        color: var(--text-dark);
    }

    /* Navigation Tabs */
    .profile-tabs {
        background: white;
        border-radius: 8px;
        box-shadow: var(--card-shadow);
        padding: 0 16px;
        margin-bottom: 16px;
    }

    .profile-nav-tabs {
        display: flex;
        gap: 8px;
        border: none;
    }

    .profile-nav-tabs .nav-link {
        padding: 16px 20px;
        color: var(--text-muted);
        font-weight: 600;
        font-size: 15px;
        border: none;
        border-bottom: 3px solid transparent;
        background: transparent;
        transition: all 0.2s;
    }

    .profile-nav-tabs .nav-link:hover {
        background: var(--bg-light);
        color: var(--text-dark);
    }

    .profile-nav-tabs .nav-link.active {
        color: var(--primary-color);
        border-bottom-color: var(--primary-color);
        background: transparent;
    }

    /* Content Area */
    .profile-content-wrapper {
        display: grid;
        grid-template-columns: 360px 1fr;
        gap: 16px;
        align-items: start;
    }

    @media (max-width: 991px) {
        .profile-content-wrapper {
            grid-template-columns: 1fr;
        }
    }

    /* Sidebar Cards */
    .profile-card {
        background: white;
        border-radius: 8px;
        box-shadow: var(--card-shadow);
        margin-bottom: 16px;
        overflow: hidden;
    }

    .profile-card-body {
        padding: 16px;
    }

    .profile-section-header {
        font-size: 16px;
        font-weight: 700;
        color: var(--text-dark);
        margin-bottom: 12px;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .profile-section-header i {
        color: var(--primary-color);
    }

    .intro-list {
        list-style: none;
        padding: 0;
        margin: 0;
        display: flex;
        flex-direction: column;
        gap: 12px;
    }

    .intro-list li {
        display: flex;
        align-items: flex-start;
        gap: 10px;
        font-size: 15px;
        color: var(--text-dark);
        line-height: 1.4;
    }

    .intro-list li i {
        color: var(--primary-color);
        font-size: 18px;
        margin-top: 2px;
    }

    .profile-friend-grid {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 8px;
    }

    .profile-friend-grid .friend-tile {
        display: flex;
        flex-direction: column;
        align-items: center;
        text-align: center;
        padding: 8px;
        border-radius: 8px;
        text-decoration: none;
        color: var(--text-dark);
        transition: background 0.2s;
    }

    .profile-friend-grid .friend-tile:hover {
        background: var(--bg-light);
    }

    .profile-friend-grid .friend-tile img {
        width: 100%;
        aspect-ratio: 1;
        border-radius: 8px;
        object-fit: cover;
        margin-bottom: 8px;
    }

    .friend-name {
        font-size: 13px;
        font-weight: 600;
        color: var(--text-dark);
        line-height: 1.2;
    }

    .friend-username {
        font-size: 12px;
        color: var(--text-muted);
        margin-top: 2px;
    }

    .see-more-link {
        font-size: 15px;
        color: var(--primary-color);
        text-decoration: none;
        font-weight: 600;
    }

    .see-more-link:hover {
        text-decoration: underline;
    }

    .empty-state {
        text-align: center;
        padding: 40px 20px;
        color: var(--text-muted);
    }

    .empty-state i {
        font-size: 48px;
        margin-bottom: 12px;
        opacity: 0.5;
    }

    .empty-state p {
        margin: 0;
        font-size: 15px;
    }

    .profile-photo-grid {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 8px;
    }

    .profile-photo-grid .photo-item {
        padding-bottom: 100%;
        border-radius: 8px;
        overflow: hidden;
        position: relative;
        background: var(--bg-light);
        cursor: pointer;
    }

    .profile-photo-grid .photo-item img {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    /* About Tab Styling */
    .about-section {
        background: white;
        border-radius: 8px;
        box-shadow: var(--card-shadow);
        padding: 20px;
    }

    .about-item {
        padding: 16px 0;
        border-bottom: 1px solid var(--border-light);
    }

    .about-item:last-child {
        border-bottom: none;
    }

    .about-label {
        font-size: 13px;
        color: var(--text-muted);
        margin-bottom: 6px;
        font-weight: 500;
    }

    .about-value {
        font-size: 15px;
        color: var(--text-dark);
        line-height: 1.5;
    }

    .about-value a {
        color: var(--primary-color);
        text-decoration: none;
        font-weight: 500;
    }

    .about-value a:hover {
        text-decoration: underline;
    }
</style>
@endpush

@section('content')
<div class="profile-page-container">
    <!-- Profile Cover and Info -->
    <div class="profile-cover-section">
        <div class="profile-cover" style="background-image: url('{{ $page->cover_url ?? asset('assets/images/bg/04.jpg') }}');"></div>

        <div class="profile-info-section">
            <div class="profile-avatar-container">
                <img src="{{ $page->avatar_url ?? asset('assets/images/avatar/07.jpg') }}" 
                     alt="{{ $page->page_title }}" 
                     class="profile-avatar">
            </div>

            <div class="profile-header-details">
                <div class="profile-name-section">
                    <h1>{{ $page->page_title }}</h1>
                </div>

                <div class="profile-action-bar">
                    @if(!$isOwner)
                        <button class="btn-profile-action {{ $isFollowing ? 'btn-secondary-custom' : 'btn-primary-custom' }}" 
                                onclick="likeUnlikePage({{ $page->id }}, this)">
                            <i class="bi bi-{{ $isFollowing ? 'check-circle-fill' : 'person-plus-fill' }}"></i>
                            {{ $isFollowing ? 'Following' : 'Follow' }}
                        </button>
                        <button class="btn-profile-action btn-outline-custom">
                            <i class="bi bi-share"></i> Share
                        </button>
                    @else
                        <a href="#" class="btn-profile-action btn-primary-custom">
                            <i class="bi bi-pencil-square"></i> Edit Page
                        </a>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Navigation Tabs -->
    <div class="profile-tabs">
        <ul class="nav profile-nav-tabs" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="posts-tab" data-bs-toggle="tab" data-bs-target="#posts" type="button" role="tab">
                    <i class="bi bi-grid-3x3-gap me-1"></i> Posts
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="photos-tab" data-bs-toggle="tab" data-bs-target="#photos" type="button" role="tab">
                    <i class="bi bi-images me-1"></i> Photos
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="videos-tab" data-bs-toggle="tab" data-bs-target="#videos" type="button" role="tab">
                    <i class="bi bi-camera-video me-1"></i> Videos
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="about-tab" data-bs-toggle="tab" data-bs-target="#about" type="button" role="tab">
                    <i class="bi bi-info-circle me-1"></i> About
                </button>
            </li>
        </ul>
    </div>

    <!-- Tab Content -->
    <div class="tab-content">
        <!-- Posts Tab -->
        <div class="tab-pane fade show active" id="posts" role="tabpanel">
            <div class="profile-content-wrapper">
                <!-- Sidebar -->
                <div class="profile-sidebar">
                    <!-- Intro Card -->
                    <div class="profile-card">
                        <div class="profile-card-body">
                            <div class="profile-section-header mb-3">
                                <i class="bi bi-person-lines-fill"></i> Intro
                            </div>
                            @if($page->page_description)
                                <p class="text-muted mb-3">{{ $page->page_description }}</p>
                            @endif
                            <ul class="intro-list">
                                <li>
                                    <i class="bi bi-people-fill"></i>
                                    <span><strong>{{ number_format($page->likes_count ?? 0) }}</strong> Followers</span>
                                </li>
                                <li>
                                    <i class="bi bi-building"></i>
                                    <span>{{ str_replace('_', ' ', ucfirst($page->page_category ?? 'General')) }}</span>
                                </li>
                                @if($page->creator)
                                <li>
                                    <i class="bi bi-person"></i>
                                    <span>Created by <strong>{{ $page->creator->name ?? 'Unknown' }}</strong></span>
                                </li>
                                @endif
                            </ul>
                        </div>
                    </div>

                    <!-- Photos Widget -->
                    @php
                        $allPhotos = [];
                        foreach($photos as $photo) {
                            if($photo->media && $photo->media->count() > 0) {
                                foreach($photo->media as $media) {
                                    if($media->isImage()) {
                                        $allPhotos[] = $media;
                                    }
                                }
                            }
                        }
                    @endphp
                    @if(count($allPhotos) > 0)
                    <div class="profile-card">
                        <div class="profile-card-body">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <div class="profile-section-header mb-0">
                                    <i class="bi bi-images"></i> Photos
                                </div>
                                <a href="#photos" class="see-more-link" data-bs-toggle="tab" data-bs-target="#photos" role="tab">See all</a>
                            </div>
                            <div class="profile-photo-grid">
                                @foreach(array_slice($allPhotos, 0, 9) as $media)
                                <div class="photo-item" onclick="window.location.href='#photos'; document.getElementById('photos-tab').click();">
                                    <img src="{{ getMedia($media->media_path) }}" alt="Photo">
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Recent Followers -->
                    @if($recentFollowers && $recentFollowers->count() > 0)
                    <div class="profile-card">
                        <div class="profile-card-body">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <div class="profile-section-header mb-0">
                                    <i class="bi bi-people"></i> Recent Followers
                                </div>
                            </div>
                            <div class="profile-friend-grid">
                                @foreach($recentFollowers->take(6) as $like)
                                    @if($like->user)
                                    <a href="{{ route('user.detail', ['username' => $like->user->username]) }}" class="friend-tile">
                                        <img src="{{ $like->user->avatar_url ?? asset('assets/images/avatar/07.jpg') }}" alt="{{ $like->user->name }}">
                                        <div>
                                            <span class="friend-name">{{ $like->user->name }}</span>
                                        </div>
                                    </a>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    </div>
                    @endif
                </div>

                <!-- Main Content -->
                <div class="profile-main-content">
                    @php
                        $postType = 'page_post';
                        $pageId = $page->id;
                    @endphp
                    <input type="hidden" id="postType" value="{{ $postType }}">
                    <input type="hidden" id="pageId" value="{{ $pageId }}">
                    
                    @if($canPost)
                        @include('front_end.layouts.newsfeed_box')
                    @endif

                    <!-- Posts will be loaded here -->
                    <div id="postholder"></div>
                </div>
            </div>
        </div>

        <!-- Photos Tab -->
        <div class="tab-pane fade" id="photos" role="tabpanel">
            @php
                $allPhotos = [];
                foreach($photos as $photo) {
                    if($photo->media && $photo->media->count() > 0) {
                        foreach($photo->media as $media) {
                            if($media->isImage()) {
                                $allPhotos[] = $media;
                            }
                        }
                    }
                }
            @endphp
            @if(count($allPhotos) > 0)
            <div class="profile-card">
                <div class="profile-card-body">
                    <div class="profile-section-header mb-3">
                        <i class="bi bi-images"></i> Photos
                    </div>
                    <div class="profile-photo-grid" style="grid-template-columns: repeat(4, 1fr); gap: 8px;">
                        @foreach($allPhotos as $media)
                        <div class="photo-item">
                            <img src="{{ getMedia($media->media_path) }}" alt="Photo">
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
            @else
            <div class="profile-card">
                <div class="profile-card-body">
                    <div class="empty-state">
                        <i class="bi bi-images"></i>
                        <p>No photos to show</p>
                    </div>
                </div>
            </div>
            @endif
        </div>

        <!-- Videos Tab -->
        <div class="tab-pane fade" id="videos" role="tabpanel">
            @php
                $allVideos = [];
                foreach($photos as $post) {
                    if($post->media && $post->media->count() > 0) {
                        foreach($post->media as $media) {
                            if($media->isVideo()) {
                                $allVideos[] = $media;
                            }
                        }
                    }
                }
            @endphp
            @if(count($allVideos) > 0)
            <div class="profile-card">
                <div class="profile-card-body">
                    <div class="profile-section-header mb-3">
                        <i class="bi bi-camera-video"></i> Videos
                    </div>
                    <div class="profile-photo-grid" style="grid-template-columns: repeat(4, 1fr); gap: 8px;">
                        @foreach($allVideos as $media)
                        <div class="photo-item">
                            <video src="{{ getMedia($media->media_path) }}" style="width: 100%; height: 100%; object-fit: cover;"></video>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
            @else
            <div class="profile-card">
                <div class="profile-card-body">
                    <div class="empty-state">
                        <i class="bi bi-camera-video"></i>
                        <p>No videos to show</p>
                    </div>
                </div>
            </div>
            @endif
        </div>

        <!-- About Tab -->
        <div class="tab-pane fade" id="about" role="tabpanel">
            <div class="about-section">
                <div class="profile-section-header mb-4">
                    <i class="bi bi-info-circle"></i> About
                </div>
                
                @if($page->page_description)
                <div class="about-item">
                    <div class="about-label">Description</div>
                    <div class="about-value">{{ $page->page_description }}</div>
                </div>
                @endif

                <div class="about-item">
                    <div class="about-label">Category</div>
                    <div class="about-value">{{ str_replace('_', ' ', ucfirst($page->page_category ?? 'General')) }}</div>
                </div>

                @if($page->creator)
                <div class="about-item">
                    <div class="about-label">Created by</div>
                    <div class="about-value">
                        <div class="d-flex align-items-center">
                            <img src="{{ $page->creator->avatar_url ?? asset('assets/images/avatar/07.jpg') }}" 
                                class="rounded-circle me-2" 
                                style="width: 36px; height: 36px;"
                                alt="Creator Avatar">
                            <div>
                                <a href="{{ route('user.detail', ['username' => $page->creator->username]) }}">{{ $page->creator->name ?? 'Unknown' }}</a>
                            </div>
                        </div>
                    </div>
                </div>
                @endif

                <div class="about-item">
                    <div class="about-label">Created</div>
                    <div class="about-value">{{ $page->created_at->format('F d, Y') }}</div>
                </div>

                <div class="about-item">
                    <div class="about-label">Followers</div>
                    <div class="about-value"><strong>{{ number_format($page->likes_count ?? 0) }}</strong> people follow this page</div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
@include('front_end.layouts.newsfeed_scripts')
<script>
    function likeUnlikePage(pageId, button) {
        axios.post(`${base_url}/webapi/page/like-unlike`, { page_id: pageId })
            .then(response => {
                if (response.data.code === 200) {
                    if (response.data.data.action === 'liked') {
                        $(button).removeClass('btn-primary-custom').addClass('btn-secondary-custom');
                        $(button).html('<i class="bi bi-check-circle-fill"></i> Following');
                    } else {
                        $(button).removeClass('btn-secondary-custom').addClass('btn-primary-custom');
                        $(button).html('<i class="bi bi-person-plus-fill"></i> Follow');
                    }
                    // Reload page after 1 second to update followers count
                    setTimeout(() => {
                        window.location.reload();
                    }, 1000);
                }
            })
            .catch(error => {
                console.error("Error liking/unliking page:", error);
            });
    }

    function deletePage(pageId) {
        if (confirm('Are you sure you want to delete this page? This action cannot be undone.')) {
            axios.post(`${base_url}/webapi/page/delete-page`, { page_id: pageId })
                .then(response => {
                    if (response.data.code === 200) {
                        window.location.href = '{{ route("my_pages") }}';
                    }
                })
                .catch(error => {
                    console.error("Error deleting page:", error);
                    alert('Failed to delete page. Please try again.');
                });
        }
    }

    $(document).ready(function() {
        // Load newsfeed for page posts
        loadNewsFeed();
    });
</script>
@endpush
