@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', 'Notifications')

@push('styles')
<style>
    .notifications-page {
        background: linear-gradient(135deg, #f5f7fa 0%, #e9ecef 100%);
        min-height: 100vh;
        padding: 2rem 0;
    }

    .notification-card {
        background: white;
        border-radius: 20px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.06);
        overflow: hidden;
        border: none;
    }

    .notification-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        padding: 2rem;
        color: white;
        position: relative;
        overflow: hidden;
    }

    .notification-header::before {
        content: '';
        position: absolute;
        top: -50%;
        right: -20%;
        width: 300px;
        height: 300px;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.1);
    }

    .notification-header h2 {
        font-size: 2rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
        position: relative;
        z-index: 1;
    }

    .notification-header p {
        font-size: 1rem;
        opacity: 0.95;
        margin: 0;
        position: relative;
        z-index: 1;
    }

    .nav-tabs-notification {
        border-bottom: 2px solid #e9ecef;
        padding: 0 1.5rem;
        background: white;
    }

    .nav-tabs-notification .nav-link {
        border: none;
        color: #6c757d;
        font-weight: 600;
        padding: 1rem 1.5rem;
        margin-bottom: -2px;
        transition: all 0.3s ease;
        position: relative;
    }

    .nav-tabs-notification .nav-link:hover {
        color: #667eea;
        background: transparent;
    }

    .nav-tabs-notification .nav-link.active {
        color: #667eea;
        border-bottom: 3px solid #667eea;
        background: transparent;
    }

    .notification-item {
        padding: 1.5rem;
        border-bottom: 1px solid #f1f3f5;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
        background: white;
    }

    .notification-item::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 4px;
        height: 0;
        background: linear-gradient(180deg, #667eea 0%, #764ba2 100%);
        transition: height 0.3s ease;
        border-radius: 0 2px 2px 0;
    }

    .notification-item.unread {
        background: linear-gradient(to right, #f8f9ff 0%, #ffffff 5%);
    }

    .notification-item.unread::before {
        height: 100%;
    }

    .notification-item.unread::after {
        content: '';
        position: absolute;
        top: 50%;
        right: 1rem;
        transform: translateY(-50%);
        width: 8px;
        height: 8px;
        background: #667eea;
        border-radius: 50%;
        opacity: 0;
        transition: opacity 0.3s ease;
    }

    .notification-item:hover.unread::after {
        opacity: 1;
    }

    .notification-item:hover {
        background: linear-gradient(to right, #f5f9ff 0%, #ffffff 10%);
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);
    }

    .notification-avatar {
        width: 56px;
        height: 56px;
        border-radius: 50%;
        object-fit: cover;
        border: 3px solid #e9ecef;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        transition: all 0.3s ease;
        background: white;
    }

    .notification-item:hover .notification-avatar {
        border-color: #667eea;
        box-shadow: 0 4px 16px rgba(102, 126, 234, 0.15);
    }

    .notification-badge {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 0.25rem 0.75rem;
        border-radius: 20px;
        font-size: 0.75rem;
        font-weight: 600;
        letter-spacing: 0.5px;
        display: inline-block;
        vertical-align: middle;
        margin-bottom: 0.25rem;
    }

    .notification-text {
        font-size: 1rem;
        font-weight: 500;
        color: #2d3748;
        line-height: 1.6;
        margin: 0;
    }

    .notification-time {
        font-size: 0.875rem;
        color: #a0aec0;
        font-weight: 400;
        white-space: nowrap;
    }

    .dropdown {
        position: relative;
    }

    .dropdown-custom {
        background: white !important;
        border: 1px solid #e9ecef !important;
        border-radius: 12px !important;
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15) !important;
        padding: 0.5rem 0 !important;
        min-width: 180px !important;
        margin-top: 0.5rem !important;
    }

    .dropdown-item-custom {
        padding: 0.75rem 1.5rem !important;
        font-size: 0.9rem;
        color: #4a5568 !important;
        transition: all 0.2s ease;
        border-bottom: 1px solid #f1f3f5;
        display: flex;
        align-items: center;
        width: 100%;
        text-align: left;
        background: none !important;
        border-left: none;
        border-right: none;
        border-top: none;
        cursor: pointer;
    }

    .dropdown-item-custom:last-child {
        border-bottom: none;
    }

    .dropdown-item-custom:hover {
        background: linear-gradient(135deg, #f5f7fa 0%, #e9ecef 100%) !important;
        color: #667eea !important;
        transform: translateX(4px);
    }

    .dropdown-item-custom.text-danger:hover {
        background: linear-gradient(135deg, #fff5f5 0%, #ffe5e5 100%) !important;
        color: #e53e3e !important;
    }

    .dropdown-item-custom svg {
        flex-shrink: 0;
    }

    /* Make dropdown button more responsive */
    .dropdown button.btn-link {
        display: flex;
        align-items: center;
        justify-content: center;
        min-width: 40px;
        min-height: 40px;
        padding: 0 !important;
    }

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .dropdown-custom {
            min-width: 160px !important;
            font-size: 0.85rem !important;
        }

        .dropdown-item-custom {
            padding: 0.6rem 1rem !important;
        }
    }

    .btn-action {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border: none;
        padding: 0.5rem 1.25rem;
        border-radius: 12px;
        font-weight: 600;
        transition: all 0.3s ease;
        box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
    }

    .btn-action:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
        color: white;
    }

    .btn-outline-action {
        border: 2px solid #667eea;
        color: #667eea;
        background: transparent;
        padding: 0.5rem 1.25rem;
        border-radius: 12px;
        font-weight: 600;
        transition: all 0.3s ease;
    }

    .btn-outline-action:hover {
        background: #667eea;
        color: white;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
    }

    .empty-state {
        padding: 4rem 2rem;
        text-align: center;
    }

    .empty-state-icon {
        font-size: 5rem;
        color: #cbd5e0;
        margin-bottom: 1.5rem;
    }

    .empty-state h5 {
        color: #4a5568;
        font-weight: 700;
        margin-bottom: 0.5rem;
    }

    .empty-state p {
        color: #718096;
        font-size: 0.95rem;
    }
</style>
@endpush

@section('content')
<div class="notifications-page">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <div class="notification-card">
    <!-- Header Section -->
                    <div class="notification-header">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <a href="{{ url('/social') }}" class="text-white me-3" style="text-decoration: none;">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M19 12H5M12 19l-7-7 7-7"/></svg>
                                </a>
                                <h2 class="mb-0 d-inline">Notifications</h2>
                            </div>
                            <div>
                                @if($unreadCount > 0)
                                <form action="{{ route('notifications.markAllAsSeen') }}" method="POST" class="d-inline">
                                    @csrf
                                    <button type="submit" class="btn btn-light" style="border-radius: 12px; font-weight: 600;">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-2"><polyline points="20 6 9 17 4 12"></polyline></svg>
                                        Mark All as Read
                                    </button>
                                </form>
                                @endif
                            </div>
                        </div>
                        <p class="mb-0 mt-2">Stay updated with what's happening</p>
    </div>

                <!-- Filter Tabs -->
                    <div class="nav-tabs-notification">
                        <ul class="nav nav-tabs border-0" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="all-tab" data-bs-toggle="tab" data-bs-target="#all-notifications" type="button" role="tab" aria-controls="all-notifications" aria-selected="true">All</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="unread-tab" data-bs-toggle="tab" data-bs-target="#unread-notifications" type="button" role="tab" aria-controls="unread-notifications" aria-selected="false">
                                Unread 
                                @if($unreadCount > 0)
                                    <span class="badge bg-danger ms-1 rounded-pill">{{ $unreadCount }}</span>
                                @endif
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="friends-tab" data-bs-toggle="tab" data-bs-target="#friends-notifications" type="button" role="tab" aria-controls="friends-notifications" aria-selected="false">Friends</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="posts-tab" data-bs-toggle="tab" data-bs-target="#posts-notifications" type="button" role="tab" aria-controls="posts-notifications" aria-selected="false">Posts</button>
                        </li>
                    </ul>
                </div>

                <!-- Notifications List -->
                <div class="tab-content">
                    <!-- All Notifications Tab -->
                    <div class="tab-pane fade show active" id="all-notifications" role="tabpanel" aria-labelledby="all-tab">
                        @if($notifications->count() > 0)
                            <div>
                            @foreach($notifications as $notification)
                            <div class="notification-item {{ $notification->seen ? '' : 'unread' }}" id="notification-{{ $notification->id }}">
                                <div class="d-flex align-items-start">
                                    <img src="{{ $notification->sender->profile_photo ? asset('storage/' . $notification->sender->profile_photo) : asset('assets/images/default-avatar.jpg') }}" 
                                         class="notification-avatar me-3" alt="{{ $notification->sender->name }}">
                                    
                                    <div class="flex-grow-1">
                                        <div class="d-flex justify-content-between align-items-start mb-2">
                                            <div class="flex-grow-1">
                                                @if(!$notification->seen)
                                                <span class="notification-badge me-2">New</span>
                                                @endif
                                                
                                                <p class="notification-text mb-1">
                                                    <strong>{{ $notification->sender->name }}</strong> {{ $notification->text }}
                                                </p>
                                            </div>
                                            <div class="notification-time ms-2">{{ $notification->created_at->diffForHumans() }}</div>
                                        </div>
                                        
                                        <!-- Dynamic content based on notification type -->
                                        @switch($notification->type)
                                            @case('friend_request')
                                                <div class="mt-2 d-flex gap-2 flex-wrap">
                                                    <form action="{{ route('notifications.react', $notification->id) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        <button type="submit" class="btn btn-action btn-sm">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-1"><path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"></path><circle cx="12" cy="7" r="4"></circle></svg>
                                                            Accept Request
                                                        </button>
                                                    </form>
                                                    <a href="{{ route('social.profile.show', $notification->sender->id) }}" class="btn btn-outline-action btn-sm">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-1"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path><polyline points="14 2 14 8 20 8"></polyline><line x1="16" y1="13" x2="8" y2="13"></line><line x1="16" y1="17" x2="8" y2="17"></line><polyline points="10 9 9 9 8 9"></polyline></svg>
                                                        View Profile
                                                    </a>
                                                </div>
                                                @break
                                                
                                            @case('post_like')
                                            @case('post_comment')
                                            @case('post_mention')
                                                <div class="mt-2">
                                                    <a href="{{ route('social.posts.show', $notification->post_id) }}" class="btn btn-action btn-sm">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-1"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path></svg>
                                                        View Post
                                                    </a>
                                                </div>
                                                @break
                                                
                                            @case('group_invite')
                                                <div class="mt-2 d-flex gap-2 flex-wrap">
                                                    <form action="{{ route('notifications.react', $notification->id) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        <button type="submit" class="btn btn-action btn-sm">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-1"><path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path><circle cx="9" cy="7" r="4"></circle><path d="M23 21v-2a4 4 0 0 0-3-3.87"></path><path d="M16 3.13a4 4 0 0 1 0 7.75"></path></svg>
                                                            Join Group
                                                        </button>
                                                    </form>
                                                    <a href="{{ route('social.groups.show', $notification->group_id) }}" class="btn btn-outline-action btn-sm">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-1"><path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path><circle cx="12" cy="10" r="3"></circle></svg>
                                                        View Group
                                                    </a>
                                                </div>
                                                @break
                                                
                                            @default
                                                @if(!$notification->seen)
                                                <div class="mt-2">
                                                    <form action="{{ route('notifications.markAsSeen', $notification->id) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        <button type="submit" class="btn btn-outline-action btn-sm">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-1"><polyline points="20 6 9 17 4 12"></polyline></svg>
                                                            Mark as Read
                                                        </button>
                                                    </form>
                                                </div>
                                                @endif
                                        @endswitch
                                    </div>
                                    
                                    <div class="dropdown ms-2">
                                        <button class="btn btn-sm btn-link text-muted" type="button" id="dropdownMenuButton{{ $notification->id }}" data-bs-toggle="dropdown" aria-expanded="false">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="1"></circle><circle cx="12" cy="5" r="1"></circle><circle cx="12" cy="19" r="1"></circle></svg>
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-end dropdown-custom" aria-labelledby="dropdownMenuButton{{ $notification->id }}">
                                            @if(!$notification->seen)
                                            <li>
                                                <form action="{{ route('notifications.markAsSeen', $notification->id) }}" method="POST">
                                                    @csrf
                                                    <button type="submit" class="dropdown-item-custom">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-2"><polyline points="20 6 9 17 4 12"></polyline></svg>
                                                        Mark as Read
                                                    </button>
                                                </form>
                                            </li>
                                            @endif
                                            <li>
                                                <form action="{{ route('notifications.delete', $notification->id) }}" method="POST">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="dropdown-item-custom text-danger">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-2"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg>
                                                        Delete
                                                    </button>
                                                </form>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                        
                        <!-- Pagination -->
                        <div class="d-flex justify-content-center p-4" style="border-top: 1px solid #f1f3f5;">
                            {{ $notifications->links('pagination::bootstrap-5') }}
                        </div>
                        @else
                        <div class="empty-state">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" class="empty-state-icon">
                                <path d="M18 8A6 6 0 0 0 6 8c0 7-3 9-3 9h18s-3-2-3-9"></path>
                                <path d="M13.73 21a2 2 0 0 1-3.46 0"></path>
                            </svg>
                            <h5>No Notifications</h5>
                            <p>You don't have any notifications yet.</p>
                        </div>
                        @endif
                    </div>
                    
                    <!-- Unread Notifications Tab -->
                    <div class="tab-pane fade" id="unread-notifications" role="tabpanel" aria-labelledby="unread-tab">
                        @php
                        $unreadNotifications = $notifications->where('seen', false);
                        @endphp
                        
                        @if($unreadNotifications->count() > 0)
                        <div>
                            @foreach($unreadNotifications as $notification)
                            <div class="notification-item unread" id="unread-notification-{{ $notification->id }}">
                                <div class="d-flex align-items-start">
                                    <img src="{{ $notification->sender->profile_photo ? asset('storage/' . $notification->sender->profile_photo) : asset('assets/images/default-avatar.jpg') }}" 
                                         class="notification-avatar me-3" alt="{{ $notification->sender->name }}">
                                    
                                    <div class="flex-grow-1">
                                        <div class="d-flex justify-content-between align-items-start mb-2">
                                            <div class="flex-grow-1">
                                                <span class="notification-badge me-2">New</span>
                                                <p class="notification-text mb-1">
                                                    <strong>{{ $notification->sender->name }}</strong> {{ $notification->text }}
                                                </p>
                                            </div>
                                            <div class="notification-time ms-2">{{ $notification->created_at->diffForHumans() }}</div>
                                        </div>
                                        
                                        @switch($notification->type)
                                            @case('friend_request')
                                                <div class="mt-2 d-flex gap-2 flex-wrap">
                                                    <form action="{{ route('notifications.react', $notification->id) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        <button type="submit" class="btn btn-action btn-sm">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-1"><path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"></path><circle cx="12" cy="7" r="4"></circle></svg>
                                                            Accept Request
                                                        </button>
                                                        </form>
                                                    <a href="{{ route('social.profile.show', $notification->sender->id) }}" class="btn btn-outline-action btn-sm">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-1"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path><polyline points="14 2 14 8 20 8"></polyline><line x1="16" y1="13" x2="8" y2="13"></line><line x1="16" y1="17" x2="8" y2="17"></line><polyline points="10 9 9 9 8 9"></polyline></svg>
                                                        View Profile
                                                    </a>
                                                </div>
                                                @break
                                                
                                            @case('post_like')
                                            @case('post_comment')
                                            @case('post_mention')
                                                <div class="mt-2">
                                                    <a href="{{ route('social.posts.show', $notification->post_id) }}" class="btn btn-action btn-sm">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-1"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path></svg>
                                                        View Post
                                                    </a>
                                                </div>
                                                @break
                                                
                                            @case('group_invite')
                                                <div class="mt-2 d-flex gap-2 flex-wrap">
                                                    <form action="{{ route('notifications.react', $notification->id) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        <button type="submit" class="btn btn-action btn-sm">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-1"><path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path><circle cx="9" cy="7" r="4"></circle><path d="M23 21v-2a4 4 0 0 0-3-3.87"></path><path d="M16 3.13a4 4 0 0 1 0 7.75"></path></svg>
                                                            Join Group
                                                        </button>
                                                    </form>
                                                    <a href="{{ route('social.groups.show', $notification->group_id) }}" class="btn btn-outline-action btn-sm">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-1"><path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path><circle cx="12" cy="10" r="3"></circle></svg>
                                                        View Group
                                                    </a>
                                                </div>
                                                @break
                                                
                                            @default
                                                <div class="mt-2">
                                                    <form action="{{ route('notifications.markAsSeen', $notification->id) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        <button type="submit" class="btn btn-outline-action btn-sm">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-1"><polyline points="20 6 9 17 4 12"></polyline></svg>
                                                            Mark as Read
                                                        </button>
                                                    </form>
                                                </div>
                                        @endswitch
                                    </div>
                                    
                                    <div class="dropdown ms-2">
                                        <button class="btn btn-sm btn-link text-muted" type="button" id="dropdownMenuButtonUnread{{ $notification->id }}" data-bs-toggle="dropdown" aria-expanded="false">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="1"></circle><circle cx="12" cy="5" r="1"></circle><circle cx="12" cy="19" r="1"></circle></svg>
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-end dropdown-custom" aria-labelledby="dropdownMenuButtonUnread{{ $notification->id }}">
                                            <li>
                                                <form action="{{ route('notifications.markAsSeen', $notification->id) }}" method="POST">
                                                    @csrf
                                                    <button type="submit" class="dropdown-item-custom">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-2"><polyline points="20 6 9 17 4 12"></polyline></svg>
                                                        Mark as Read
                                                    </button>
                                                </form>
                                            </li>
                                            <li>
                                                <form action="{{ route('notifications.delete', $notification->id) }}" method="POST">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="dropdown-item-custom text-danger">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-2"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg>
                                                        Delete
                                                    </button>
                                                </form>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                        @else
                        <div class="empty-state">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" class="empty-state-icon">
                                <polyline points="22 12 18 12 15 21 9 3 6 12 2 12"></polyline>
                            </svg>
                            <h5>No Unread Notifications</h5>
                            <p>You've read all your notifications.</p>
                        </div>
                        @endif
                    </div>
                    
                    <!-- Friends Notifications Tab -->
                    <div class="tab-pane fade" id="friends-notifications" role="tabpanel" aria-labelledby="friends-tab">
                        @php
                        $friendNotifications = $notifications->filter(function($notification) {
                            return in_array($notification->type, ['friend_request', 'friend_accept']);
                        });
                        @endphp
                        
                        @if($friendNotifications->count() > 0)
                        <div>
                            @foreach($friendNotifications as $notification)
                            <div class="notification-item {{ $notification->seen ? '' : 'unread' }}" id="friend-notification-{{ $notification->id }}">
                                <div class="d-flex align-items-start">
                                    <img src="{{ $notification->sender->profile_photo ? asset('storage/' . $notification->sender->profile_photo) : asset('assets/images/default-avatar.jpg') }}" 
                                         class="notification-avatar me-3" alt="{{ $notification->sender->name }}">
                                    
                                    <div class="flex-grow-1">
                                        <div class="d-flex justify-content-between align-items-start mb-2">
                                            <div class="flex-grow-1">
                                                @if(!$notification->seen)
                                                <span class="notification-badge me-2">New</span>
                                                @endif
                                                <p class="notification-text mb-1">
                                                    <strong>{{ $notification->sender->name }}</strong> {{ $notification->text }}
                                                </p>
                                            </div>
                                            <div class="notification-time ms-2">{{ $notification->created_at->diffForHumans() }}</div>
                                        </div>
                                        
                                        @if($notification->type == 'friend_request' && !$notification->is_reacted)
                                        <div class="mt-2 d-flex gap-2 flex-wrap">
                                            <form action="{{ route('notifications.react', $notification->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-action btn-sm">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-1"><path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"></path><circle cx="12" cy="7" r="4"></circle></svg>
                                                    Accept Request
                                                </button>
                                            </form>
                                            <a href="{{ route('social.profile.show', $notification->sender->id) }}" class="btn btn-outline-action btn-sm">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-1"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path><polyline points="14 2 14 8 20 8"></polyline><line x1="16" y1="13" x2="8" y2="13"></line><line x1="16" y1="17" x2="8" y2="17"></line><polyline points="10 9 9 9 8 9"></polyline></svg>
                                                View Profile
                                            </a>
                                        </div>
                                        @elseif($notification->type == 'friend_accept')
                                        <div class="mt-2">
                                            <a href="{{ route('social.profile.show', $notification->sender->id) }}" class="btn btn-action btn-sm">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-1"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path><polyline points="14 2 14 8 20 8"></polyline><line x1="16" y1="13" x2="8" y2="13"></line><line x1="16" y1="17" x2="8" y2="17"></line><polyline points="10 9 9 9 8 9"></polyline></svg>
                                                View Profile
                                            </a>
                                        </div>
                                        @endif
                                    </div>
                                    
                                    <div class="dropdown ms-2">
                                        <button class="btn btn-sm btn-link text-muted" type="button" id="dropdownMenuButtonFriend{{ $notification->id }}" data-bs-toggle="dropdown" aria-expanded="false">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="1"></circle><circle cx="12" cy="5" r="1"></circle><circle cx="12" cy="19" r="1"></circle></svg>
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-end dropdown-custom" aria-labelledby="dropdownMenuButtonFriend{{ $notification->id }}">
                                            @if(!$notification->seen)
                                            <li>
                                                <form action="{{ route('notifications.markAsSeen', $notification->id) }}" method="POST">
                                                    @csrf
                                                    <button type="submit" class="dropdown-item-custom">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-2"><polyline points="20 6 9 17 4 12"></polyline></svg>
                                                        Mark as Read
                                                    </button>
                                                </form>
                                            </li>
                                            @endif
                                            <li>
                                                <form action="{{ route('notifications.delete', $notification->id) }}" method="POST">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="dropdown-item-custom text-danger">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-2"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg>
                                                        Delete
                                                    </button>
                                                </form>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                        @else
                        <div class="empty-state">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" class="empty-state-icon">
                                <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                                <circle cx="9" cy="7" r="4"></circle>
                                <path d="M23 21v-2a4 4 0 0 0-3-3.87"></path>
                                <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                            </svg>
                            <h5>No Friend Notifications</h5>
                            <p>You don't have any friend-related notifications.</p>
                        </div>
                        @endif
                    </div>
                    
                    <!-- Posts Notifications Tab -->
                    <div class="tab-pane fade" id="posts-notifications" role="tabpanel" aria-labelledby="posts-tab">
                        @php
                        $postNotifications = $notifications->filter(function($notification) {
                            return in_array($notification->type, ['post_like', 'post_comment', 'comment_reply', 'post_mention']);
                        });
                        @endphp
                        
                        @if($postNotifications->count() > 0)
                        <div>
                            @foreach($postNotifications as $notification)
                            <div class="notification-item {{ $notification->seen ? '' : 'unread' }}" id="post-notification-{{ $notification->id }}">
                                <div class="d-flex align-items-start">
                                    <img src="{{ $notification->sender->profile_photo ? asset('storage/' . $notification->sender->profile_photo) : asset('assets/images/default-avatar.jpg') }}" 
                                         class="notification-avatar me-3" alt="{{ $notification->sender->name }}">
                                    
                                    <div class="flex-grow-1">
                                        <div class="d-flex justify-content-between align-items-start mb-2">
                                            <div class="flex-grow-1">
                                                @if(!$notification->seen)
                                                <span class="notification-badge me-2">New</span>
                                                @endif
                                                <p class="notification-text mb-1">
                                                    <strong>{{ $notification->sender->name }}</strong> {{ $notification->text }}
                                                </p>
                                            </div>
                                            <div class="notification-time ms-2">{{ $notification->created_at->diffForHumans() }}</div>
                                        </div>
                                        
                                        <div class="mt-2 d-flex gap-2 flex-wrap">
                                            <a href="{{ route('social.posts.show', $notification->post_id) }}" class="btn btn-action btn-sm">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-1"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path></svg>
                                                View Post
                                            </a>
                                            
                                            @if(!$notification->seen)
                                            <form action="{{ route('notifications.markAsSeen', $notification->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-outline-action btn-sm">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-1"><polyline points="20 6 9 17 4 12"></polyline></svg>
                                                    Mark as Read
                                                </button>
                                            </form>
                                            @endif
                                        </div>
                                    </div>
                                    
                                    <div class="dropdown ms-2">
                                        <button class="btn btn-sm btn-link text-muted" type="button" id="dropdownMenuButtonPost{{ $notification->id }}" data-bs-toggle="dropdown" aria-expanded="false">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="1"></circle><circle cx="12" cy="5" r="1"></circle><circle cx="12" cy="19" r="1"></circle></svg>
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-end dropdown-custom" aria-labelledby="dropdownMenuButtonPost{{ $notification->id }}">
                                            @if(!$notification->seen)
                                            <li>
                                                <form action="{{ route('notifications.markAsSeen', $notification->id) }}" method="POST">
                                                    @csrf
                                                    <button type="submit" class="dropdown-item-custom">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-2"><polyline points="20 6 9 17 4 12"></polyline></svg>
                                                        Mark as Read
                                                    </button>
                                                </form>
                                            </li>
                                            @endif
                                            <li>
                                                <form action="{{ route('notifications.delete', $notification->id) }}" method="POST">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="dropdown-item-custom text-danger">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-2"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg>
                                                        Delete
                                                    </button>
                                                </form>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                        @else
                        <div class="empty-state">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" class="empty-state-icon">
                                <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                                <polyline points="14 2 14 8 20 8"></polyline>
                                <line x1="16" y1="13" x2="8" y2="13"></line>
                                <line x1="16" y1="17" x2="8" y2="17"></line>
                            </svg>
                            <h5>No Post Notifications</h5>
                            <p>You don't have any post-related notifications.</p>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Update notification count on page load
    $(document).ready(function() {
        // Function to update notification counter in navbar
        function updateNotificationCounter() {
            $.ajax({
                url: "{{ route('notifications.getUnreadCount') }}",
                type: 'GET',
                success: function(response) {
                    const count = response.count;
                    if (count > 0) {
                        $('#navNotificationCount').text(count).show();
                    } else {
                        $('#navNotificationCount').hide();
                    }
                }
            });
        }
        
        // Mark notification as read when clicked
        $('.notification-content').on('click', function() {
            const notificationId = $(this).closest('.list-group-item').attr('id').replace('notification-', '');
            
            $.ajax({
                url: "/notifications/mark-seen/" + notificationId,
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function() {
                    $('#notification-' + notificationId).removeClass('bg-light');
                    updateNotificationCounter();
                }
            });
        });
    });
</script>
@endpush
@endsection