@extends('admin.layouts.home')

@section('title', 'Notification Management')

@section('content')
<div class="container-fluid px-4">
    <h1 class="mt-4">Notification Management</h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item"><a href="{{ url('home') }}">Dashboard</a></li>
        <li class="breadcrumb-item active">Notifications</li>
    </ol>
    
    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6">
            <div class="card bg-primary text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h2 class="mb-0">{{ number_format($totalNotifications) }}</h2>
                            <div>Total Notifications</div>
                        </div>
                        <div>
                            <i class="fas fa-bell fa-3x opacity-50"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="{{ route('admin.notifications.list') }}">View Details</a>
                    <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card bg-success text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h2 class="mb-0">{{ number_format($todayNotifications) }}</h2>
                            <div>Today's Notifications</div>
                        </div>
                        <div>
                            <i class="fas fa-calendar-day fa-3x opacity-50"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="{{ route('admin.notifications.list', ['date_from' => date('Y-m-d')]) }}">View Details</a>
                    <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card bg-warning text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h2 class="mb-0">{{ number_format($unreadNotifications) }}</h2>
                            <div>Unread Notifications</div>
                        </div>
                        <div>
                            <i class="fas fa-envelope fa-3x opacity-50"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="{{ route('admin.notifications.list', ['seen_status' => 'unseen']) }}">View Details</a>
                    <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card bg-danger text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h2 class="mb-0">{{ $notificationsByType->count() }}</h2>
                            <div>Notification Types</div>
                        </div>
                        <div>
                            <i class="fas fa-tags fa-3x opacity-50"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="#notificationTypes">View Details</a>
                    <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Chart & Table Row -->
    <div class="row">
        <div class="col-xl-6">
            <div class="card mb-4">
                <div class="card-header">
                    <i class="fas fa-chart-area me-1"></i>
                    Notifications Over Time
                </div>
                <div class="card-body">
                    <canvas id="notificationChart" width="100%" height="40"></canvas>
                </div>
            </div>
        </div>
        <div class="col-xl-6">
            <div class="card mb-4" id="notificationTypes">
                <div class="card-header">
                    <i class="fas fa-table me-1"></i>
                    Notification Types
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Type</th>
                                    <th>Count</th>
                                    <th>Percentage</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($notificationsByType as $type)
                                <tr>
                                    <td>{{ ucwords(str_replace('_', ' ', $type->type)) }}</td>
                                    <td>{{ number_format($type->count) }}</td>
                                    <td>{{ number_format(($type->count / $totalNotifications) * 100, 1) }}%</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Top Users & System Actions -->
    <div class="row">
        <div class="col-lg-6">
            <div class="card mb-4">
                <div class="card-header">
                    <i class="fas fa-users me-1"></i>
                    Top Notification Recipients
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>User</th>
                                    <th>Notifications</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($topReceivers as $user)
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <img src="{{ $user->profile_photo ? asset('storage/' . $user->profile_photo) : asset('assets/images/default-avatar.jpg') }}" 
                                                 class="rounded-circle me-2" alt="{{ $user->name }}" width="40" height="40">
                                            <div>
                                                <div class="fw-bold">{{ $user->name }}</div>
                                                <div class="small text-muted">ID: {{ $user->id }}</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td>{{ number_format($user->notification_count) }}</td>
                                    <td>
                                        <a href="{{ route('admin.notifications.list', ['receiver' => $user->id]) }}" class="btn btn-sm btn-primary">
                                            View Notifications
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="card mb-4">
                <div class="card-header">
                    <i class="fas fa-paper-plane me-1"></i>
                    Send System Notification
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.notifications.sendAnnouncement') }}" method="POST">
                        @csrf
                        <div class="mb-3">
                            <label for="text" class="form-label">Announcement Message</label>
                            <textarea class="form-control" id="text" name="text" rows="3" required></textarea>
                            <div class="form-text">This will be sent to all active users on the platform.</div>
                        </div>
                        <button type="submit" class="btn btn-primary">Send Announcement</button>
                    </form>
                    
                    <hr class="my-4">
                    
                    <form action="{{ route('admin.notifications.sendSystem') }}" method="POST">
                        @csrf
                        <div class="mb-3">
                            <label for="users" class="form-label">Select Users</label>
                            <select class="form-select" id="users" name="users[]" multiple required>
                                <!-- This would be populated with users -->
                                <option value="1">User 1</option>
                                <option value="2">User 2</option>
                                <!-- And so on... -->
                            </select>
                            <div class="form-text">Hold Ctrl/Cmd to select multiple users.</div>
                        </div>
                        <div class="mb-3">
                            <label for="type" class="form-label">Notification Type</label>
                            <select class="form-select" id="type" name="type" required>
                                <option value="system_message">System Message</option>
                                <option value="warning">Warning</option>
                                <option value="account_update">Account Update</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="notificationText" class="form-label">Message</label>
                            <textarea class="form-control" id="notificationText" name="text" rows="3" required></textarea>
                        </div>
                        <button type="submit" class="btn btn-primary">Send Notification</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Chart
    document.addEventListener('DOMContentLoaded', function () {
        var ctx = document.getElementById('notificationChart').getContext('2d');
        
        // Convert the PHP data for chart.js
        var dates = @json($notificationsByDay->pluck('date'));
        var counts = @json($notificationsByDay->pluck('total'));
        
        // Create the chart
        var myChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: dates,
                datasets: [{
                    label: 'Notifications',
                    data: counts,
                    backgroundColor: 'rgba(0, 123, 255, 0.1)',
                    borderColor: 'rgba(0, 123, 255, 1)',
                    borderWidth: 2,
                    tension: 0.3,
                    fill: true
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    });
</script>
@endpush
@endsection