@extends('front_end.layouts.home')

@section('title', 'Watch ' . $movie->title)
@section('left_sidebar')
@include('front_end.pages.movies.movies_left_sidebar')
@endsection

@section('content')
<div class="container-fluid py-4">
    <div class="row">
        <div class="col-12">
            <nav aria-label="breadcrumb" class="mb-3">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ url('/') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('movies.index') }}">Movies</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('movies.show', $movie->slug) }}">{{ $movie->title }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Watch</li>
                </ol>
            </nav>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-12">
            <!-- Video Player -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-body p-0">
                    <div class="ratio ratio-16x9">
                        <iframe src="{{ $movie->video_url }}" allowfullscreen></iframe>
                    </div>
                </div>
            </div>
            
            <!-- Movie Info -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-body">
                    <h1 class="mb-2">{{ $movie->title }}</h1>
                    <div class="d-flex align-items-center mb-3">
                        <div class="movie-rating me-2" data-rating="{{ $movie->avg_rating }}"></div>
                        <span class="text-muted">({{ $movie->ratings->count() }} ratings)</span>
                        <span class="mx-2">•</span>
                        <span>{{ $movie->release_year }}</span>
                        <span class="mx-2">•</span>
                        <span>{{ $movie->duration }} min</span>
                        <span class="mx-2">•</span>
                        <span class="badge bg-primary">{{ $movie->content_rating }}</span>
                    </div>
                    <p>{{ $movie->description }}</p>
                    <div class="row">
                        <div class="col-md-6">
                            <p class="mb-1"><strong>Genre:</strong> {{ $movie->genre->name }}</p>
                            <p class="mb-1"><strong>Director:</strong> {{ $movie->director ?? 'N/A' }}</p>
                        </div>
                        <div class="col-md-6">
                            <p class="mb-1"><strong>Cast:</strong> {{ implode(', ', $movie->cast ?? []) }}</p>
                            <p class="mb-1"><strong>Views:</strong> {{ number_format($movie->views_count) }}</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Comments Section (if you want to add this feature) -->
            <!--
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <h4 class="mb-4">Comments</h4>
                    // Comments feature can be added here
                </div>
            </div>
            -->
        </div>
        
        @if(isset($relatedMovies) && $relatedMovies->isNotEmpty())
        <div class="col-md-3">
            <!-- Related Movies -->
            <h4 class="mb-3">More Like This</h4>
            @foreach($relatedMovies as $relatedMovie)
            <div class="card mb-3 border-0 shadow-sm">
                <div class="row g-0">
                    <div class="col-4">
                        <a href="{{ route('movies.show', $relatedMovie->slug) }}">
                            <img src="{{ $relatedMovie->poster_url ?? asset('images/movie-placeholder.jpg') }}" class="img-fluid rounded-start" alt="{{ $relatedMovie->title }}" style="object-fit: cover; height: 100%;">
                        </a>
                    </div>
                    <div class="col-8">
                        <div class="card-body py-2">
                            <h6 class="card-title mb-1">
                                <a href="{{ route('movies.show', $relatedMovie->slug) }}" class="text-decoration-none">{{ $relatedMovie->title }}</a>
                            </h6>
                            <div class="movie-rating" data-rating="{{ $relatedMovie->avg_rating }}"></div>
                            <p class="card-text small text-muted mb-0">{{ $relatedMovie->duration }} min</p>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        @endif



    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        $('.movie-rating').each(function() {
            const rating = $(this).data('rating');
            $(this).rateYo({
                rating: rating,
                readOnly: true,
                starWidth: "16px"
            });
        });
    });
</script>
@endpush
@endsection