
@extends('front_end.layouts.home')

@section('title', $movie->title)

@section('content')
<div class="container py-4">
    <div class="row">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ url('/') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('movies.index') }}">Movies</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('movies.genre', $movie->genre->slug) }}">{{ $movie->genre->name }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ $movie->title }}</li>
                </ol>
            </nav>
        </div>
    </div>
    
    <div class="row mb-5">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="row g-0">
                    <div class="col-md-4">
                        <img src="{{ $movie->poster_url ?? asset('images/movie-placeholder.jpg') }}" class="img-fluid rounded-start h-100" style="object-fit: cover;" alt="{{ $movie->title }}">
                    </div>
                    <div class="col-md-8">
                        <div class="card-body p-4">
                            <div class="d-flex justify-content-between align-items-start mb-3">
                                <h1 class="card-title mb-0">{{ $movie->title }}</h1>
                                <span class="badge bg-primary">{{ $movie->content_rating }}</span>
                            </div>
                            
                            <div class="d-flex align-items-center mb-3">
                                <div class="movie-rating me-2" data-rating="{{ $movie->avg_rating }}"></div>
                                <span class="text-muted">({{ $movie->ratings->count() }} ratings)</span>
                            </div>
                            
                            <p class="card-text">{{ $movie->description }}</p>
                            
                            <div class="row mb-4">
                                <div class="col-sm-6">
                                    <p class="mb-1"><strong>Genre:</strong> {{ $movie->genre->name }}</p>
                                    <p class="mb-1"><strong>Release Year:</strong> {{ $movie->release_year }}</p>
                                    <p class="mb-1"><strong>Duration:</strong> {{ $movie->duration }} minutes</p>
                                </div>
                                <div class="col-sm-6">
                                    <p class="mb-1"><strong>Director:</strong> {{ $movie->director ?? 'N/A' }}</p>
                                    <p class="mb-1"><strong>Cast:</strong> {{ implode(', ', $movie->cast ?? []) }}</p>
                                    <p class="mb-1"><strong>Views:</strong> {{ number_format($movie->views_count) }}</p>
                                </div>
                            </div>
                            
                            <div class="d-flex gap-2">
                                <a href="{{ route('movies.watch', $movie->slug) }}" class="btn btn-primary">
                                    <i class="fas fa-play me-2"></i>Watch Now
                                </a>
                                @if($movie->trailer_url)
                                <button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#trailerModal">
                                    <i class="fas fa-film me-2"></i>Watch Trailer
                                </button>
                                @endif
                            </div>
                            
                            <!-- Rating Form -->
                            @auth
                            <div class="mt-4">
                                <h4>Rate this movie</h4>
                                <form action="{{ route('movies.rate', $movie) }}" method="POST">
                                    @csrf
                                    <div class="mb-3">
                                        <label for="rating">Your Rating:</label>
                                        <div id="user-rating"></div>
                                        <input type="hidden" name="rating" id="rating-value" value="{{ $userRating->rating ?? 0 }}">
                                    </div>
                                    <div class="mb-3">
                                        <label for="review">Your Review (Optional):</label>
                                        <textarea class="form-control" id="review" name="review" rows="3">{{ $userRating->review ?? '' }}</textarea>
                                    </div>
                                    <button type="submit" class="btn btn-primary">Submit Rating</button>
                                </form>
                            </div>
                            @else
                            <div class="mt-4">
                                <p>Please <a href="{{ route('login') }}">login</a> to rate this movie.</p>
                            </div>
                            @endauth
                        </div>
                    </div>
                </div>
            </div>
            </div>
    </div>
    
    @if(isset($relatedMovies) && $relatedMovies->isNotEmpty())
    <!-- Related Movies Section -->
    <div class="row mt-5">
        <div class="col-12">
            <h3 class="mb-4">You May Also Like</h3>
            <div class="row g-4">
                @foreach($relatedMovies as $relatedMovie)
                <div class="col-lg-3 col-md-6">
                    @include('front_end.pages.movies.partials.movie_card', ['movie' => $relatedMovie])
                </div>
                @endforeach
            </div>
        </div>
    </div>
    @endif
    
    <!-- Movie Reviews Section -->
    <div class="row mt-5">
        <div class="col-12">
            <h3 class="mb-4">User Reviews</h3>
            @if($movie->ratings->count() > 0)
                @foreach($movie->ratings as $rating)
                <div class="card mb-3 border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div>
                                <h5 class="mb-0">{{ $rating->user->name }}</h5>
                                <div class="movie-rating" data-rating="{{ $rating->rating }}"></div>
                            </div>
                            <small class="text-muted">{{ $rating->created_at->diffForHumans() }}</small>
                        </div>
                        @if($rating->review)
                        <p class="card-text">{{ $rating->review }}</p>
                        @else
                        <p class="text-muted"><em>No written review</em></p>
                        @endif
                    </div>
                </div>
                @endforeach
            @else
                <div class="alert alert-info">
                    No reviews yet. Be the first to review this movie!
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Trailer Modal -->
@if($movie->trailer_url)
<div class="modal fade" id="trailerModal" tabindex="-1" aria-labelledby="trailerModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="trailerModalLabel">{{ $movie->title }} - Trailer</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-0">
                <div class="ratio ratio-16x9">
                    <iframe src="{{ $movie->trailer_url }}" allowfullscreen></iframe>
                </div>
            </div>
        </div>
    </div>
</div>
@endif

@push('scripts')
<script>
    $(document).ready(function() {
        // Initialize readonly movie ratings
        $('.movie-rating').each(function() {
            const rating = $(this).data('rating');
            $(this).rateYo({
                rating: rating,
                readOnly: true,
                starWidth: "18px"
            });
        });
        
        // Initialize user rating input
        $("#user-rating").rateYo({
            rating: {{ $userRating->rating ?? 0 }},
            fullStar: true,
            starWidth: "24px",
            onChange: function(rating, rateYoInstance) {
                $("#rating-value").val(rating);
            }
        });
    });
</script>
@endpush
@endsection