@extends('front_end.layouts.home')

@section('title', 'Search Movies')
@section('left_sidebar')
@include('front_end.pages.movies.movies_left_sidebar')
@endsection

@section('content')
<div class="container py-4">
    <div class="row">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ url('/') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('movies.index') }}">Movies</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Search</li>
                </ol>
            </nav>
        </div>
    </div>
    
    <div class="row mb-4">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <h2 class="mb-4">Search Movies</h2>
                    <form action="{{ route('search.movies') }}" method="GET">
                        <div class="row g-3">
                            <div class="col-md-4">
                                <div class="form-floating">
                                    <input type="text" class="form-control" id="q" name="q" placeholder="Search by title" value="{{ request('q') }}">
                                    <label for="q">Search by title</label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-floating">
                                    <select class="form-select" id="genre" name="genre">
                                        <option value="">All Genres</option>
                                        @foreach($genres as $genre)
                                        <option value="{{ $genre->id }}" {{ request('genre') == $genre->id ? 'selected' : '' }}>{{ $genre->name }}</option>
                                        @endforeach
                                    </select>
                                    <label for="genre">Genre</label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-floating">
                                    <select class="form-select" id="sort" name="sort">
                                        <option value="newest" {{ request('sort') == 'newest' ? 'selected' : '' }}>Newest</option>
                                        <option value="popularity" {{ request('sort') == 'popularity' ? 'selected' : '' }}>Most Popular</option>
                                        <option value="rating" {{ request('sort') == 'rating' ? 'selected' : '' }}>Top Rated</option>
                                    </select>
                                    <label for="sort">Sort By</label>
                                </div>
                            </div>
                            <div class="col-md-2 d-flex align-items-center">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="featured" name="featured" value="1" {{ request('featured') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="featured">
                                        Featured Only
                                    </label>
                                </div>
                            </div>
                            <div class="col-12 text-end">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search me-2"></i>Search
                                </button>
                                <a href="{{ route('search.movies') }}" class="btn btn-outline-secondary">Reset</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <div class="row mb-3">
        <div class="col-12">
            <h3>Search Results <small class="text-muted">({{ $movies->total() }} movies found)</small></h3>
        </div>
    </div>
    
    <div class="row g-4">
        @forelse($movies as $movie)
        <div class="col-lg-3 col-md-4 col-sm-6">
            @include('front_end.pages.movies.partials.movie_card', ['movie' => $movie])
        </div>
        @empty
        <div class="col-12">
            <div class="alert alert-info">
                No movies found matching your criteria. Try adjusting your search parameters.
            </div>
        </div>
        @endforelse
    </div>
    
    <div class="row mt-4">
        <div class="col-12 d-flex justify-content-center">
            {{ $movies->links('pagination::bootstrap-5') }}
        </div>
    </div>
</div>
@endsection