@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', 'Movie Streaming')

@section('left_sidebar')
@include('front_end.pages.movies.movies_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Header Section -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="{{ url('/') }}" class="text-white me-3">
                                    <i class="fas fa-arrow-left fa-lg"></i>
                                </a>
                                <div>
                                    <h4 class="mb-0 text-white">Movie Streaming</h4>
                                    <p class="mb-0 text-white">Discover, watch, and enjoy our collection of movies</p>
                                </div>
                            </div>
                            <div class="d-flex align-items-center">
                                <a href="{{ route('search.movies') }}" class="btn btn-info">
                                    <i class="fas fa-search me-2"></i>Browse All Movies
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container mt-4">
        <!-- Genres Section -->
        <div class="row mb-5">
            <div class="col-12">
                <h3 class="mb-4">Browse Genres</h3>
                <div class="row g-3">
                    @foreach($genres as $genre)
                    <div class="col-md-3 col-sm-6">
                        <a href="{{ route('movies.genre', $genre->slug) }}" class="text-decoration-none">
                            <div class="card h-100 border-0 shadow-sm hover-shadow transition-all">
                                <div class="card-body text-center p-4">
                                    <div class="rounded-circle bg-primary bg-opacity-10 p-3 mx-auto mb-3" style="width: 62px; height: 62px;">
                                        <i class="{{ $genre->icon ?? 'fas fa-film' }} fa-2x text-primary"></i>
                                    </div>
                                    <h5 class="card-title">{{ $genre->name }}</h5>
                                    <p class="text-muted small mb-0">{{ $genre->movies_count ?? 0 }} movies</p>
                                </div>
                            </div>
                        </a>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>

        <!-- Featured Movies -->
        @if($featuredMovies->count() > 0)
        <div class="row mb-5">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="mb-0">Featured Movies</h3>
                    <a href="{{ route('search.movies') }}?featured=1" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                <div class="row g-4">
                    @foreach($featuredMovies as $movie)
                    <div class="col-lg-3 col-md-6">
                        @include('front_end.pages.movies.partials.movie_card', ['movie' => $movie])
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
        @endif

        <!-- Popular Movies -->
        <div class="row mb-5">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="mb-0">Most Popular</h3>
                    <a href="{{ route('search.movies') }}?sort=popularity" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                <div class="row g-4">
                    @foreach($popularMovies as $movie)
                    <div class="col-lg-3 col-md-6">
                        @include('front_end.pages.movies.partials.movie_card', ['movie' => $movie])
                    </div>
                    @endforeach
                </div>
            </div>
        </div>

        <!-- New Movies -->
        <div class="row mb-5">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="mb-0">Newest Releases</h3>
                    <a href="{{ route('search.movies') }}?sort=newest" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                <div class="row g-4">
                    @foreach($newestMovies as $movie)
                    <div class="col-lg-3 col-md-6">
                        @include('front_end.pages.movies.partials.movie_card', ['movie' => $movie])
                    </div>
                    @endforeach
                </div>
            </div>
        </div>

        <!-- Top Rated Movies -->
        @if($topRatedMovies->count() > 0)
        <div class="row mb-5">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="mb-0">Top Rated</h3>
                    <a href="{{ route('search.movies') }}?sort=rating" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                <div class="row g-4">
                    @foreach($topRatedMovies as $movie)
                    <div class="col-lg-3 col-md-6">
                        @include('front_end.pages.movies.partials.movie_card', ['movie' => $movie])
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
        @endif

      
    </div>
</div>

@push('scripts')
<script>
    // Movie rating initialization
    $(document).ready(function() {
        $('.movie-rating').each(function() {
            const rating = $(this).data('rating');
            $(this).rateYo({
                rating: rating,
                readOnly: true,
                starWidth: "18px"
            });
        });
    });
</script>
@endpush
@endsection