@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', 'Marketplace')

@section('left_sidebar')
@include('front_end.pages.marketplace.marketplace_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Header Section -->
    <div class="card border-0">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="{{ url('/') }}" class="text-white me-3">
                                    <i class="fas fa-arrow-left fa-lg"></i>
                                </a>
                                <div>
                                    <h4 class="mb-0 text-white">Marketplace</h4>
                                    <p class="mb-0 text-white">Buy and sell items with people in your community</p>
                                </div>
                            </div>
                            <div class="d-flex align-items-center">
                                <a href="{{ route('marketplace.create') }}" class="btn btn-light">
                                    <i class="fas fa-plus-circle me-2"></i>List an Item
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container py-4">
        <!-- Stats Overview -->
        <div class="row mb-4">
            <div class="col-sm-6 col-lg-3">
                <div class="card border-0 bg-primary bg-opacity-10 hover-shadow-lg transition-hover">
                    <div class="card-body text-center">
                        <div class="icon-xl bg-primary bg-opacity-10 rounded-circle mb-2 mx-auto">
                            <i class="fas fa-shopping-bag fa-2x text-primary"></i>
                        </div>
                        <h3 class="mb-0" id="totalProducts">0</h3>
                        <p class="mb-0">Products</p>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-3">
                <div class="card border-0 bg-success bg-opacity-10 hover-shadow-lg transition-hover">
                    <div class="card-body text-center">
                        <div class="icon-xl bg-success bg-opacity-10 rounded-circle mb-2 mx-auto">
                            <i class="fas fa-store fa-2x text-success"></i>
                        </div>
                        <h3 class="mb-0" id="totalShops">0</h3>
                        <p class="mb-0">Shops</p>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-3">
                <div class="card border-0 bg-warning bg-opacity-10 hover-shadow-lg transition-hover">
                    <div class="card-body text-center">
                        <div class="icon-xl bg-warning bg-opacity-10 rounded-circle mb-2 mx-auto">
                            <i class="fas fa-box fa-2x text-warning"></i>
                        </div>
                        <h3 class="mb-0" id="totalOrders">0</h3>
                        <p class="mb-0">Orders</p>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-3">
                <div class="card border-0 bg-info bg-opacity-10 hover-shadow-lg transition-hover">
                    <div class="card-body text-center">
                        <div class="icon-xl bg-info bg-opacity-10 rounded-circle mb-2 mx-auto">
                            <i class="fas fa-heart fa-2x text-info"></i>
                        </div>
                        <h3 class="mb-0" id="savedItems">0</h3>
                        <p class="mb-0">Saved</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Category Pills -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex flex-wrap gap-2" id="categoryFilters">
                    <button class="btn btn-sm btn-outline-primary rounded-pill category-filter active" data-id="">
                        All Items <span class="badge bg-primary ms-2" id="allItemsCount">0</span>
                    </button>
                    @foreach($categories as $category)
                        <button class="btn btn-sm btn-outline-primary rounded-pill category-filter" 
                                data-id="{{ $category->id }}">
                            {{ $category->name }} 
                            <span class="badge bg-secondary ms-2">{{ $category->products_count }}</span>
                        </button>
                    @endforeach
                </div>
            </div>
        </div>

        <!-- Search and Filter Section -->
        <div class="row mb-4">
            <div class="col-md-8">
                <div class="input-group">
                    <span class="input-group-text bg-white">
                        <i class="fas fa-search"></i>
                    </span>
                    <input type="text" class="form-control" id="searchInput" 
                           placeholder="Search items by name, category, or description">
                    <span class="input-group-text bg-white">
                        <i class="fas fa-map-marker-alt"></i>
                    </span>
                    <input type="text" class="form-control" id="locationInput" placeholder="Location">
                    <button class="btn btn-primary" type="button" id="searchButton">Search</button>
                </div>
            </div>
            <div class="col-md-4">
                <button class="btn btn-outline-secondary w-100" type="button" 
                        data-bs-toggle="collapse" data-bs-target="#filterOptions">
                    <i class="fas fa-sliders-h me-2"></i>Advanced Filters
                </button>
            </div>
        </div>

        <!-- Advanced Filters -->
        <div class="collapse mb-4" id="filterOptions">
            <div class="card card-body border-0 bg-light-subtle">
                <div class="row g-4">
                    <!-- Price Range -->
                    <div class="col-md-3">
                        <label class="form-label fw-bold">Price Range</label>
                        <div id="priceRange"></div>
                        <div class="d-flex justify-content-between mt-2">
                            <small class="text-muted" id="minPrice">$0</small>
                            <small class="text-muted" id="maxPrice">$1000</small>
                        </div>
                    </div>

                    <!-- Item Condition -->
                    <div class="col-md-3">
                        <label class="form-label fw-bold">Item Condition</label>
                        <div class="vstack gap-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="type" value="new" id="conditionNew">
                                <label class="form-check-label" for="conditionNew">New</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="type" value="like_new" id="conditionLikeNew">
                                <label class="form-check-label" for="conditionLikeNew">Like New</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="type" value="used" id="conditionUsed">
                                <label class="form-check-label" for="conditionUsed">Used</label>
                            </div>
                        </div>
                    </div>

                    <!-- Seller Type -->
                    <div class="col-md-3">
                        <label class="form-label fw-bold">Seller Type</label>
                        <div class="vstack gap-2">
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="seller_type" 
                                       value="individual" id="sellerIndividual">
                                <label class="form-check-label" for="sellerIndividual">Individual</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="seller_type" 
                                       value="business" id="sellerBusiness">
                                <label class="form-check-label" for="sellerBusiness">Business</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="seller_type" 
                                       value="all" id="sellerAll" checked>
                                <label class="form-check-label" for="sellerAll">All Sellers</label>
                            </div>
                        </div>
                    </div>

                    <!-- Delivery Options -->
                    <div class="col-md-3">
                        <label class="form-label fw-bold">Delivery Options</label>
                        <div class="vstack gap-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="delivery_options" 
                                       value="shipping" id="optionShipping">
                                <label class="form-check-label" for="optionShipping">Shipping Available</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="delivery_options" 
                                       value="pickup" id="optionPickup">
                                <label class="form-check-label" for="optionPickup">Local Pickup</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="delivery_options" 
                                       value="free_delivery" id="optionFreeDelivery">
                                <label class="form-check-label" for="optionFreeDelivery">Free Delivery</label>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Filter Actions -->
                <div class="row mt-4">
                    <div class="col-12">
                        <button class="btn btn-primary me-2" id="applyFilters">Apply Filters</button>
                        <button class="btn btn-outline-secondary" id="resetFilters">Reset</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sort Options -->
        <div class="row mb-4">
            <div class="col-md-6">
                <p class="mb-0">
                    Showing <span id="totalResults">0</span> results
                </p>
            </div>
            <div class="col-md-6 text-md-end">
                <div class="btn-group">
                    <select class="form-select form-select-sm" id="sortBy">
                        <option value="created_at">Latest</option>
                        <option value="price_asc">Price: Low to High</option>
                        <option value="price_desc">Price: High to Low</option>
                        <option value="popularity">Most Popular</option>
                    </select>
                </div>
            </div>
        </div>

        <!-- Products Grid -->
        <div class="row" id="productsGrid">
            <!-- Products will be dynamically added here -->
        </div>

        <!-- Load More Button -->
        <div class="text-center mt-4" id="loadMoreContainer" style="display: none;">
            <button class="btn btn-outline-primary" id="loadMoreBtn">
                Load More
            </button>
        </div>

        <!-- Recommended Items -->
        <div class="row mt-5">
            <div class="col-12">
                <h3 class="mb-4">Recommended For You</h3>
            </div>
            <div class="col-12" id="recommendedProducts">
                <!-- Recommended products will be dynamically added here -->
            </div>
        </div>

        <!-- Popular Shops -->
        <div class="row mt-5" id="popularSellers">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="mb-0">Popular Shops</h3>
                    <a href="{{ url('marketplace.shops') }}" class="btn btn-link text-decoration-none">
                        View All
                    </a>
                </div>
            </div>
            <!-- Popular sellers will be dynamically added here -->
        </div>

        <!-- Marketplace Tips -->
        <div class="row mt-5">
            <div class="col-12">
                <div class="card border-0 bg-primary bg-opacity-10 p-4">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h4 class="text-primary mb-2">Want to sell your items?</h4>
                            <p class="mb-md-0">List your items and reach thousands of potential buyers in your area</p>
                        </div>
                        <div class="col-md-4 text-md-end">
                            <a href="{{ route('marketplace.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus-circle me-2"></i>List an Item
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Contact Seller Modal -->
<!-- Contact Seller Modal -->
<div class="modal fade" id="contactSellerModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Contact Seller</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="contactSellerForm">
                    <input type="hidden" id="productId" name="product_id">
                    
                    <div class="mb-3">
                        <label for="messageSubject" class="form-label">Subject</label>
                        <input type="text" class="form-control" id="messageSubject" name="subject" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="messageContent" class="form-label">Message</label>
                        <textarea class="form-control" id="messageContent" name="message" rows="5" required></textarea>
                        <div class="form-text">Be clear about what you want to know about the item</div>
                    </div>
                    
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" id="shareContact" name="share_contact" value="1">
                        <label class="form-check-label" for="shareContact">
                            Share my phone number with the seller
                        </label>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="sendMessage">Send Message</button>
            </div>
        </div>
    </div>
</div>

@push('styles')
<link rel="stylesheet" href="{{ asset('assets/css/noUiSlider.min.css') }}">
<style>
.icon-xl {
    width: 48px;
    height: 48px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.transition-hover {
    transition: all 0.3s ease;
}

.hover-shadow-lg:hover {
    box-shadow: 0 1rem 3rem rgba(0,0,0,.175)!important;
    transform: translateY(-3px);
}

.category-filter {
    transition: all 0.2s ease;
}

.category-filter:hover {
    transform: translateY(-2px);
}
</style>
@endpush

@push('scripts')
<script src="{{ asset('assets/js/noUiSlider.min.js') }}"></script>
<script src="{{ asset('assets/js/moment.min.js') }}"></script>
<script src="{{ asset('assets/js/marketplace.js') }}"></script>
@endpush

@endsection