@extends('front_end.layouts.home')

@php
    $showRightSidebar = false;
@endphp

@section('title', 'Create Group')

@section('left_sidebar')
    @include('front_end.pages.groups.group_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Header -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center">
                            <a href="{{ route('groups') }}" class="text-white me-3">
                                <i class="fas fa-arrow-left fa-lg"></i>
                            </a>
                            <div>
                                <h4 class="mb-0 text-white">Create New Group</h4>
                                <p class="mb-0 text-white">Create a group to connect with people who share your interests</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Create Group Form -->
    <div class="container pb-4">
        <form id="createGroupForm" class="needs-validation" novalidate>
            <!-- Group Cover Image -->
            <div class="mb-4">
                <label class="form-label">Group Cover Image*</label>
                <div class="d-flex align-items-center justify-content-center bg-light rounded p-5 border cursor-pointer group-cover-box" id="coverImagePreview" style="min-height: 200px; position: relative;">
                    <div class="text-center" id="coverImagePlaceholder">
                        <i class="fas fa-image fa-3x text-muted mb-3"></i>
                        <p class="text-muted mb-2">Click to upload cover image</p>
                        <input type="file" class="form-control d-none" id="groupCover" name="cover_image" accept="image/jpeg,image/png,image/jpg" required>
                        <button type="button" class="btn btn-sm btn-primary" onclick="document.getElementById('groupCover').click()">
                            <i class="fas fa-upload me-1"></i>Choose Image
                        </button>
                        <small class="text-muted d-block mt-2">Recommended size: 1200x300 pixels (Max: 2MB)</small>
                    </div>
                    <img id="coverImagePreviewImg" src="" alt="Cover Preview" class="d-none w-100 h-100" style="object-fit: cover; border-radius: 0.375rem;">
                    <button type="button" class="btn btn-sm btn-danger position-absolute top-0 end-0 m-2 d-none" id="removeCoverImage" onclick="removeCoverImage()">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="invalid-feedback">Please select a cover image</div>
            </div>

            <!-- Group Name -->
            <div class="mb-3">
                <label class="form-label">Group Name*</label>
                <input type="text" class="form-control" name="name" placeholder="Enter group name" required>
                <div class="invalid-feedback">Please enter a group name</div>
            </div>

            <!-- Group Description -->
            <div class="mb-3">
                <label class="form-label">Group Description*</label>
                <textarea class="form-control" rows="4" name="description" placeholder="What's your group about? (Minimum 10 characters)" required minlength="10"></textarea>
                <div class="invalid-feedback">Please enter a description with at least 10 characters</div>
            </div>

            <!-- Privacy Settings -->
            <div class="mb-3">
                <label class="form-label">Privacy*</label>
                <select class="form-select" name="privacy" required>
                    <option value="">Select privacy setting</option>
                    <option value="public">Public - Anyone can see and join</option>
                    <option value="private">Private - Only members can see content</option>
                    <option value="hidden">Hidden - Only invited people can join</option>
                </select>
                <div class="invalid-feedback">Please select privacy setting</div>
            </div>

            <!-- Submit Button -->
            <div class="text-end">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-plus-circle me-2"></i>Create Group
                </button>
            </div>
        </form>
    </div>
</div>
@push('scripts')
<script src="{{ asset('assets/js/groups.js') }}"></script>
@endpush
@push('extra-js')
<script>
    // Cover image preview
    document.getElementById('groupCover').addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            // Validate file type
            if (!file.type.match('image/jpeg') && !file.type.match('image/png') && !file.type.match('image/jpg')) {
                alert('Please select a valid image file (JPEG or PNG)');
                e.target.value = '';
                return;
            }
            
            // Validate file size (2MB = 2 * 1024 * 1024 bytes)
            if (file.size > 2 * 1024 * 1024) {
                alert('Image size must be less than 2MB');
                e.target.value = '';
                return;
            }
            
            const reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById('coverImagePreviewImg').src = e.target.result;
                document.getElementById('coverImagePreviewImg').classList.remove('d-none');
                document.getElementById('coverImagePlaceholder').classList.add('d-none');
                document.getElementById('removeCoverImage').classList.remove('d-none');
            };
            reader.readAsDataURL(file);
        }
    });
    
    // Remove cover image
    function removeCoverImage() {
        document.getElementById('groupCover').value = '';
        document.getElementById('coverImagePreviewImg').src = '';
        document.getElementById('coverImagePreviewImg').classList.add('d-none');
        document.getElementById('coverImagePlaceholder').classList.remove('d-none');
        document.getElementById('removeCoverImage').classList.add('d-none');
    }
    
    // Click on cover box to trigger file input
    document.getElementById('coverImagePreview').addEventListener('click', function(e) {
        if (e.target.id !== 'removeCoverImage' && !e.target.closest('#removeCoverImage')) {
            document.getElementById('groupCover').click();
        }
    });
</script>
@endpush

@endsection
