@extends('front_end.layouts.home')

@section('title', 'Search Games')

@section('content')
<div class="container py-4">
    <div class="row">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('games.index') }}">Games</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Search</li>
                </ol>
            </nav>
        </div>
    </div>
    
    <div class="row mb-4">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <h2 class="mb-4">Search Games</h2>
                    <form action="{{ route('search.games') }}" method="GET">
                        <div class="row g-3">
                            <div class="col-md-4">
                                <div class="form-floating">
                                    <input type="text" class="form-control" id="q" name="q" placeholder="Search by title" value="{{ request('q') }}">
                                    <label for="q">Search by title</label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-floating">
                                    <select class="form-select" id="category" name="category">
                                        <option value="">All Categories</option>
                                        @foreach($categories as $category)
                                        <option value="{{ $category->id }}" {{ request('category') == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                                        @endforeach
                                    </select>
                                    <label for="category">Category</label>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-floating">
                                    <select class="form-select" id="max_age" name="max_age">
                                        <option value="">Any Age</option>
                                        <option value="5" {{ request('max_age') == '5' ? 'selected' : '' }}>5+</option>
                                        <option value="7" {{ request('max_age') == '7' ? 'selected' : '' }}>7+</option>
                                        <option value="10" {{ request('max_age') == '10' ? 'selected' : '' }}>10+</option>
                                        <option value="13" {{ request('max_age') == '13' ? 'selected' : '' }}>13+</option>
                                    </select>
                                    <label for="max_age">Age Rating</label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-floating">
                                    <select class="form-select" id="sort" name="sort">
                                        <option value="newest" {{ request('sort') == 'newest' ? 'selected' : '' }}>Newest</option>
                                        <option value="popularity" {{ request('sort') == 'popularity' ? 'selected' : '' }}>Most Popular</option>
                                        <option value="rating" {{ request('sort') == 'rating' ? 'selected' : '' }}>Top Rated</option>
                                    </select>
                                    <label for="sort">Sort By</label>
                                </div>
                            </div>
                            <div class="col-md-6 d-flex align-items-center">
                                <div class="form-check me-4">
                                    <input class="form-check-input" type="checkbox" id="featured" name="featured" value="1" {{ request('featured') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="featured">
                                        Featured Only
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="multiplayer" name="multiplayer" value="1" {{ request('multiplayer') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="multiplayer">
                                        Multiplayer Only
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6 text-end">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search me-2"></i>Search
                                </button>
                                <a href="{{ route('search.games') }}" class="btn btn-outline-secondary">Reset</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <div class="row mb-3">
        <div class="col-12">
            <h3>Search Results <small class="text-muted">({{ $games->total() }} games found)</small></h3>
        </div>
    </div>
    
    <div class="row g-4">
        @forelse($games as $game)
        <div class="col-lg-3 col-md-4 col-sm-6">
            @include('front_end.pages.games.partials.game_card', ['game' => $game])
        </div>
        @empty
        <div class="col-12">
            <div class="alert alert-info">
                No games found matching your criteria. Try adjusting your search parameters.
            </div>
        </div>
        @endforelse
    </div>
    
    <div class="row mt-4">
        <div class="col-12 d-flex justify-content-center">
            {{ $games->links('pagination::bootstrap-5') }}
        </div>
    </div>
</div>
@endsection