@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', 'Events')

@section('left_sidebar')
@include('front_end.pages.events.events_left_sidebar')
@endsection


@section('content')


<div class="bg-white shadow-sm border-0 rounded-3">

    <!-- Create Story Header -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="{{ url('/') }}" class="text-white me-3">
                                    <i class="fas fa-arrow-left fa-lg"></i>
                                </a>

                                <div class="d-flex justify-content-between align-items-center ">
                                    <div>
                                        <h4 class="mb-0 text-white">Events</h4>
                                        <p class="mb-0 text-white">Discover and join events happening around you</p>

                                    </div>
                                </div>

                            </div>
                            <div class="d-flex align-items-center">

                                <a class="btn btn-primary btn-info" href="{{ url('events/create') }}">
                                    <i class="fas fa-plus-circle me-2"></i>Create Event
                                </a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>


    <!-- Pages section start -->
    <div class="container mt-4">
        <!-- Stats Overview -->
        <div class="row mb-4">
                            <div class="col-sm-6 col-lg-3">
                                <div class="card border-0 bg-primary bg-opacity-10 hover-shadow-lg transition-hover">
                                    <div class="card-body text-center">
                                        <div class="icon-xl bg-primary bg-opacity-10 rounded-circle mb-2 mx-auto">
                                            <i class="fas fa-calendar-check fa-2x text-primary"></i>
                                        </div>
                                        <h3 class="mb-0">{{$upcomingEvents->count()}}</h3>
                                        <p class="mb-0">Upcoming Events</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-lg-3">
                                <div class="card border-0 bg-success bg-opacity-10 hover-shadow-lg transition-hover">
                                    <div class="card-body text-center">
                                        <div class="icon-xl bg-success bg-opacity-10 rounded-circle mb-2 mx-auto">
                                            <i class="fas fa-user-check fa-2x text-success"></i>
                                        </div>
                                        <h3 class="mb-0">{{$ongoingEvents->count()}}</h3>
                                        <p class="mb-0">Going</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-lg-3">
                                <div class="card border-0 bg-warning bg-opacity-10 hover-shadow-lg transition-hover">
                                    <div class="card-body text-center">
                                        <div class="icon-xl bg-warning bg-opacity-10 rounded-circle mb-2 mx-auto">
                                            <i class="fas fa-star fa-2x text-warning"></i>
                                        </div>
                                        <h3 class="mb-0">{{$upcomingEvents->count()}}</h3>
                                        <p class="mb-0">Interested</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-lg-3">
                                <div class="card border-0 bg-info bg-opacity-10 hover-shadow-lg transition-hover">
                                    <div class="card-body text-center">
                                        <div class="icon-xl bg-info bg-opacity-10 rounded-circle mb-2 mx-auto">
                                            <i class="fas fa-bullhorn fa-2x text-info"></i>
                                        </div>
                                        <h3 class="mb-0">{{$myEvents->count()}}</h3>
                                        <p class="mb-0">My Events</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                      
                        <!-- Quick Filter Pills -->
                        {{-- <div class="row mb-4">
                            <div class="col-12">
                                <div class="d-flex flex-wrap gap-2">
                                    <button class="btn btn-sm btn-outline-primary rounded-pill active">
                                        All Events <span class="badge bg-primary ms-2">156</span>
                                    </button>
                                    <button class="btn btn-sm btn-outline-primary rounded-pill">
                                        Today <span class="badge bg-secondary ms-2">12</span>
                                    </button>
                                    <button class="btn btn-sm btn-outline-primary rounded-pill">
                                        This Weekend <span class="badge bg-secondary ms-2">45</span>
                                    </button>
                                    <button class="btn btn-sm btn-outline-primary rounded-pill">
                                        Online <span class="badge bg-secondary ms-2">32</span>
                                    </button>
                                    <button class="btn btn-sm btn-outline-primary rounded-pill">
                                        Free <span class="badge bg-secondary ms-2">28</span>
                                    </button>
                                </div>
                            </div>
                        </div> --}}

                        <!-- Search and Filter Section -->
                        <div class="row mb-4">
                            <div class="col-md-8">
                                <div class="input-group">
                                    <span class="input-group-text bg-white">
                                        <i class="fas fa-search"></i>
                                    </span>
                                    <input type="text" class="form-control search-event" placeholder="Search events by name, location, or category">
                                    <span class="input-group-text bg-white">
                                        <i class="fas fa-calendar-alt"></i>
                                    </span>
                                    <input type="datetime-local" class="form-control date-filter" placeholder="Date Range">
                                    <button class="btn btn-primary search-btn" type="button"><i class="fas fa-search"></i></button>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <button class="btn btn-outline-secondary w-100" type="button" data-bs-toggle="collapse" data-bs-target="#filterOptions">
                                    <i class="fas fa-sliders-h me-2"></i>Advanced Filters
                                </button>
                            </div>
                        </div>

                        <!-- Collapsible Filter Options -->
                        <div class="collapse mb-4" id="filterOptions">
                            <div class="card card-body border-0 bg-light-subtle">
                                <div class="row g-4">
                                    <div class="col-md-4">
                                        <label class="form-label fw-bold">Category</label>
                                        <select class="form-select category-filter">
                                            <option value="">All Categories</option>
                                            <option value="social">Social</option>
                                            <option value="business">Business</option>
                                            <option value="education">Education</option>
                                            <option value="entertainment">Entertainment</option>
                                            <option value="other">Other</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label fw-bold">Event Filter</label>
                                        <select class="form-select event-filter">
                                            <option value="">All Events</option>
                                            <option value="events">Upcoming Events</option>
                                            <option value="interested">Events I'm Interested In</option>
                                            <option value="going">Events I'm Going To</option>
                                            <option value="myevents">My Events</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label fw-bold">Time Frame</label>
                                        <select class="form-select timeframe-filter">
                                            <option value="">All Time</option>
                                            <option value="upcoming">Upcoming</option>
                                            <option value="ongoing">Ongoing</option>
                                            <option value="past">Past</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="row mt-4">
                                    <div class="col-12">
                                        <button class="btn btn-primary me-2 apply-filters">Apply Filters</button>
                                        <button class="btn btn-outline-secondary reset-filters">Reset</button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Events Grid -->
                        <div class="row g-4" id="eventholder">
                        </div>

                        

                        <!-- Upcoming Events Near You -->
                        {{-- <div class="row mt-4">
                            <div class="col-12">
                                <div class="d-flex justify-content-between align-items-center mb-4">
                                    <h3 class="mb-0">Events Near You</h3>
                                    <a href="#" class="btn btn-link text-decoration-none">View All</a>
                                </div>
                            </div>
                            <!-- Event List Item -->
                            <div class="col-12">
                                <div class="card border-0 shadow-sm mb-3">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col-auto">
                                                <div class="text-center bg-light rounded-3 p-3">
                                                    <h4 class="mb-0">20</h4>
                                                    <small class="text-muted">FEB</small>
                                                </div>
                                            </div>
                                            <div class="col">
                                                <h5 class="mb-1">Local Art Exhibition</h5>
                                                <div class="d-flex flex-wrap gap-2">
                                                    <span class="badge bg-light text-dark">
                                                        <i class="fas fa-clock me-1"></i>3:00 PM - 8:00 PM
                                                    </span>
                                                    <span class="badge bg-light text-dark">
                                                        <i class="fas fa-map-marker-alt me-1"></i>Art Gallery, Downtown
                                                    </span>
                                                    <span class="badge bg-light text-dark">
                                                        <i class="fas fa-users me-1"></i>45 going
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="col-auto">
                                                <div class="d-flex gap-2">
                                                    <button class="btn btn-sm btn-primary">RSVP</button>
                                                    <button class="btn btn-sm btn-outline-primary">Details</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div> --}}

                        <!-- Create Event Promotion -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="card border-0 bg-primary bg-opacity-10 p-4">
                                    <div class="row align-items-center">
                                        <div class="col-md-8">
                                            <h4 class="text-primary mb-2">Want to host an event?</h4>
                                            <p class="mb-md-0">Create and manage your events with our easy-to-use tools</p>
                                        </div>
                                        <div class="col-md-4 text-md-end">
                                            <a class="btn btn-primary" href="{{ url('events/create') }}">
                                                <i class="fas fa-plus-circle me-2"></i>Host Event
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Pagination -->
                        <div class="row mt-4 mb-4">
                            <div class="col-12">
                                <nav aria-label="Page navigation">
                                    <ul class="pagination justify-content-center" id="pagination">
                                        <!-- Pagination will be dynamically populated via JavaScript -->
                                    </ul>
                                </nav>
                            </div>
                        </div>

    </div>
    <!-- Groups section ends -->

</div>
@push('scripts')
<script src="{{ asset('assets/js/events.js') }}"></script>
<script>
    $(document).ready(function() {
        fetchEvents();
        $(".search-btn").click(function() {
            fetchEvents();
        });
    });
</script>
@endpush
@endsection