<div class="card h-100 border-0 shadow-sm hover-shadow transition-all">
    <a href="{{ route('courses.show', $course->slug) }}">
        <img src="{{ $course->thumbnail ? asset('storage/' . $course->thumbnail) : asset('assets/images/course-placeholder.jpg') }}" 
             class="card-img-top" alt="{{ $course->title }}">
    </a>
    @if($course->discount_price && $course->discount_ends_at > now())
    <div class="position-absolute top-0 end-0 bg-danger text-white px-2 py-1 m-2 rounded">
        {{ round((($course->price - $course->discount_price) / $course->price) * 100) }}% OFF
    </div>
    @endif
    <div class="card-body p-4">
        <div class="d-flex justify-content-between align-items-center mb-2">
            <span class="badge bg-{{ $course->level == 'beginner' ? 'success' : ($course->level == 'intermediate' ? 'warning' : 'danger') }}">
                {{ ucfirst($course->level) }}
            </span>
            <div class="text-warning small">
                <div class="course-rating" data-rating="{{ $course->average_rating }}"></div>
                <span class="ms-1 text-muted">({{ $course->reviews_count ?? 0 }})</span>
            </div>
        </div>
        <h5 class="card-title mb-2">
            <a href="{{ route('courses.show', $course->slug) }}" class="text-decoration-none text-dark">{{ $course->title }}</a>
        </h5>
        <p class="text-muted small mb-3">
            <i class="fas fa-user-tie me-1"></i> {{ $course->instructor->name ?? 'Unknown Instructor' }}
        </p>
        <div class="d-flex justify-content-between align-items-center mb-3">
            <div>
                <i class="fas fa-clock me-1 text-muted"></i>
                <span class="small">{{ $course->total_duration ?? 0 }} hrs</span>
            </div>
            <div>
                <i class="fas fa-book me-1 text-muted"></i>
                <span class="small">{{ $course->total_lessons ?? 0 }} lessons</span>
            </div>
            <div>
                <i class="fas fa-users me-1 text-muted"></i>
                <span class="small">{{ $course->total_students ?? 0 }}</span>
            </div>
        </div>
        <div class="d-flex justify-content-between align-items-center">
            <div>
                @if($course->price == 0)
                <span class="h5 text-success fw-bold">Free</span>
                @elseif($course->discount_price && $course->discount_ends_at > now())
                <span class="h5 fw-bold">${{ number_format($course->discount_price, 2) }}</span>
                <del class="text-muted ms-2">${{ number_format($course->price, 2) }}</del>
                @else
                <span class="h5 fw-bold">${{ number_format($course->price, 2) }}</span>
                @endif
            </div>
            @auth
                <div class="dropdown">
                    <button class="btn btn-sm btn-outline-secondary" type="button" id="dropdownMenuButton{{ $course->id }}" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fas fa-ellipsis-v"></i>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownMenuButton{{ $course->id }}">
                        <li>
                            <a class="dropdown-item" href="{{ route('courses.toggleWishlist', $course->slug) }}">
                                <i class="fas fa-heart me-2 {{ isset($isInWishlist) && $isInWishlist ? 'text-danger' : 'text-muted' }}"></i>
                                {{ isset($isInWishlist) && $isInWishlist ? 'Remove from Wishlist' : 'Add to Wishlist' }}
                            </a>
                        </li>
                        <li><a class="dropdown-item" href="{{ route('courses.show', $course->slug) }}"><i class="fas fa-info-circle me-2"></i>View Details</a></li>
                    </ul>
                </div>
            @endauth
        </div>
    </div>
    <div class="card-footer bg-white border-top-0 p-4">
        <a href="{{ route('courses.show', $course->slug) }}" class="btn btn-primary w-100">
            @if(isset($isEnrolled) && $isEnrolled)
                <i class="fas fa-play-circle me-2"></i>Continue Learning
            @else
                <i class="fas fa-info-circle me-2"></i>View Details
            @endif
        </a>
    </div>
</div>