@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', 'Add Lesson - ' . $course->title)

@section('left_sidebar')
@include('front_end.pages.courses.instructor_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Header Section -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-dark text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center">
                            <a href="{{ route('instructor.courses.edit', $course->id) }}" class="text-white me-3">
                                <i class="fas fa-arrow-left fa-lg"></i>
                            </a>
                            <div>
                                <h4 class="mb-0 text-white">Add Lesson</h4>
                                <p class="mb-0 text-white">Section: {{ $section->title }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container py-5">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-body p-4">
                        <h5 class="card-title mb-4">Lesson Information</h5>
                        
                        <form action="{{ route('instructor.courses.storeLesson', ['courseId' => $course->id, 'sectionId' => $section->id]) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            
                            <div class="mb-3">
                                <label for="title" class="form-label">Lesson Title <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('title') is-invalid @enderror" id="title" name="title" value="{{ old('title') }}" required>
                                @error('title')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="description" class="form-label">Description</label>
                                <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description') }}</textarea>
                                <div class="form-text">A brief overview of what this lesson covers.</div>
                                @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label for="duration" class="form-label">Duration (minutes) <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control @error('duration') is-invalid @enderror" id="duration" name="duration" value="{{ old('duration', 0) }}" min="1" required>
                                    @error('duration')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="video_url" class="form-label">Video URL</label>
                                <input type="url" class="form-control @error('video_url') is-invalid @enderror" id="video_url" name="video_url" value="{{ old('video_url') }}" placeholder="https://...">
                                <div class="form-text">YouTube, Vimeo, or other embedded video URL.</div>
                                @error('video_url')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="content" class="form-label">Lesson Content</label>
                                <textarea class="form-control @error('content') is-invalid @enderror" id="content" name="content" rows="10">{{ old('content') }}</textarea>
                                <div class="form-text">Text content for this lesson (markdown supported).</div>
                                @error('content')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="attachment" class="form-label">Attachment</label>
                                <input type="file" class="form-control @error('attachment') is-invalid @enderror" id="attachment" name="attachment">
                                <div class="form-text">Upload PDF, documents, or other resources for this lesson (max 10MB).</div>
                                @error('attachment')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="is_free" name="is_free" value="1" {{ old('is_free') ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_free">Free Preview</label>
                                    </div>
                                    <div class="form-text">Make this lesson available as a free preview.</div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="is_published" name="is_published" value="1" {{ old('is_published', true) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_published">Publish</label>
                                    </div>
                                    <div class="form-text">Make this lesson visible to enrolled students.</div>
                                </div>
                            </div>

                            <div class="d-flex justify-content-between">
                                <a href="{{ route('instructor.courses.edit', $course->id) }}" class="btn btn-outline-secondary">Cancel</a>
                                <button type="submit" class="btn btn-primary">Add Lesson</button>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-body p-4">
                        <h5 class="card-title mb-3">Lesson Creation Tips</h5>
                        
                        <div class="alert alert-info">
                            <i class="fas fa-lightbulb me-2"></i>
                            <strong>Best Practices:</strong>
                            <ul class="mb-0 mt-2">
                                <li>Keep lessons focused on a single topic or objective.</li>
                                <li>Aim for 5-15 minutes per video to maintain engagement.</li>
                                <li>Include supplementary materials to enhance learning.</li>
                                <li>Use consistent naming conventions for your lessons.</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        // Video URL preview
        $('#video_url').on('blur', function() {
            const url = $(this).val();
            if (url) {
                if (url.includes('youtube.com') || url.includes('youtu.be')) {
                    // YouTube video preview logic
                    $('#videoPreview').removeClass('d-none');
                } else if (url.includes('vimeo.com')) {
                    // Vimeo video preview logic
                    $('#videoPreview').removeClass('d-none');
                }
            }
        });
    });
</script>
@endpush
@endsection