@extends('front_end.layouts.home')

@php
$showLeftSidebar = false;
$showRightSidebar = false;
@endphp
@section('title', 'Checkout - ' . $course->title)

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Header Section -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center">
                            <a href="{{ route('courses.show', $course->slug) }}" class="text-white me-3">
                                <i class="fas fa-arrow-left fa-lg"></i>
                            </a>
                            <div>
                                <h4 class="mb-0 text-white">Checkout</h4>
                                <p class="mb-0 text-white">Complete your purchase</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container py-5">
        <div class="row">
            <!-- Checkout Form -->
            <div class="col-lg-8">
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-body p-4">
                        <h5 class="card-title mb-4">Payment Information</h5>
                        
                        <form action="{{ route('courses.processPayment', $course->slug) }}" method="POST" id="payment-form">
                            @csrf
                            
                            <div class="mb-4">
                                <h6 class="mb-3">Contact Information</h6>
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label for="name" class="form-label">Full Name</label>
                                        <input type="text" class="form-control" id="name" name="name" value="{{ Auth::user()->name }}" readonly>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="email" class="form-label">Email</label>
                                        <input type="email" class="form-control" id="email" name="email" value="{{ Auth::user()->email }}" readonly>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-4">
                                <h6 class="mb-3">Card Details</h6>
                                <div class="row g-3">
                                    <div class="col-12">
                                        <label for="card_number" class="form-label">Card Number</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" id="card_number" name="card_number" placeholder="1234 5678 9012 3456" required>
                                            <span class="input-group-text">
                                                <i class="fab fa-cc-visa me-1"></i>
                                                <i class="fab fa-cc-mastercard me-1"></i>
                                                <i class="fab fa-cc-amex"></i>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="expiry" class="form-label">Expiry Date</label>
                                        <input type="text" class="form-control" id="expiry" name="expiry" placeholder="MM/YY" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="cvv" class="form-label">Security Code (CVV)</label>
                                        <input type="text" class="form-control" id="cvv" name="cvv" placeholder="123" required>
                                    </div>
                                    <div class="col-12">
                                        <label for="name_on_card" class="form-label">Name on Card</label>
                                        <input type="text" class="form-control" id="name_on_card" name="name_on_card" placeholder="John Doe" required>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-4">
                                <h6 class="mb-3">Billing Address</h6>
                                <div class="row g-3">
                                    <div class="col-12">
                                        <label for="address" class="form-label">Address</label>
                                        <input type="text" class="form-control" id="address" name="address" required>
                                    </div>
                                    <div class="col-md-5">
                                        <label for="country" class="form-label">Country</label>
                                        <select class="form-select" id="country" name="country" required>
                                            <option value="">Choose...</option>
                                            <option value="US">United States</option>
                                            <option value="CA">Canada</option>
                                            <option value="UK">United Kingdom</option>
                                            <option value="AU">Australia</option>
                                            <!-- More countries would be listed here -->
                                        </select>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="state" class="form-label">State/Province</label>
                                        <input type="text" class="form-control" id="state" name="state" required>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="zip" class="form-label">Zip/Postal Code</label>
                                        <input type="text" class="form-control" id="zip" name="zip" required>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-check mb-4">
                                <input class="form-check-input" type="checkbox" id="terms" name="terms" required>
                                <label class="form-check-label" for="terms">
                                    I agree to the <a href="#" class="text-decoration-none">Terms and Conditions</a> and <a href="#" class="text-decoration-none">Privacy Policy</a>
                                </label>
                            </div>
                            
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary btn-lg">Complete Payment</button>
                            </div>
                        </form>
                    </div>
                </div>
                
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-body p-4">
                        <h5 class="card-title mb-3">Secure Payment</h5>
                        <p class="text-muted mb-0">
                            <i class="fas fa-lock me-2"></i>
                            Your payment information is secure. We use industry-standard encryption to protect your data.
                        </p>
                    </div>
                </div>
            </div>
            
            <!-- Order Summary -->
            <div class="col-lg-4">
                <div class="card border-0 shadow-sm sticky-top" style="top: 20px; z-index: 1000;">
                    <div class="card-body p-4">
                        <h5 class="card-title mb-4">Order Summary</h5>
                        
                        <div class="d-flex align-items-center mb-4">
                            <img src="{{ $course->thumbnail ? asset('storage/' . $course->thumbnail) : asset('assets/images/course-placeholder.jpg') }}" 
                                 alt="{{ $course->title }}" class="rounded me-3" width="60" height="60">
                            <div>
                                <h6 class="mb-1">{{ $course->title }}</h6>
                                <p class="text-muted small mb-0">by {{ $course->instructor->name }}</p>
                            </div>
                        </div>
                        
                        <div class="d-flex justify-content-between mb-2">
                            <span>Original Price:</span>
                            <span>${{ number_format($course->price, 2) }}</span>
                        </div>
                        
                        @if(session()->has('coupon_discount'))
                        <div class="d-flex justify-content-between mb-2 text-success">
                            <span>Coupon Discount:</span>
                            <span>-${{ number_format(session()->get('coupon_discount'), 2) }}</span>
                        </div>
                        @endif
                        
                        <hr class="my-3">
                        
                        <div class="d-flex justify-content-between mb-4">
                            <span class="fw-bold">Total:</span>
                            <span class="fw-bold">
                                @if(session()->has('coupon_discount'))
                                ${{ number_format($course->price - session()->get('coupon_discount'), 2) }}
                                @else
                                ${{ number_format($course->price, 2) }}
                                @endif
                            </span>
                        </div>
                        
                        <!-- Coupon Code Form -->
                        <form action="{{ route('courses.applyCoupon', $course->slug) }}" method="POST" class="mb-4">
                            @csrf
                            <div class="input-group">
                                <input type="text" class="form-control" id="coupon_code" name="coupon_code" placeholder="Coupon code">
                                <button class="btn btn-outline-primary" type="submit">Apply</button>
                            </div>
                            @if(session()->has('coupon_code'))
                            <div class="text-success small mt-2">
                                <i class="fas fa-check-circle me-1"></i>
                                Coupon "{{ session()->get('coupon_code') }}" applied
                            </div>
                            @endif
                        </form>
                        
                        <div class="alert alert-info mb-0">
                            <i class="fas fa-info-circle me-2"></i>
                            <span class="small">By completing your purchase, you'll have lifetime access to this course.</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        // Credit card formatting
        $('#card_number').on('input', function() {
            var val = $(this).val().replace(/\D/g, '');
            var newVal = '';
            for(var i = 0; i < val.length; i++) {
                if(i > 0 && i % 4 == 0) {
                    newVal += ' ';
                }
                newVal += val.charAt(i);
            }
            $(this).val(newVal);
        });
        
        // Expiry date formatting
        $('#expiry').on('input', function() {
            var val = $(this).val().replace(/\D/g, '');
            var newVal = '';
            
            if (val.length > 0) {
                newVal = val.substring(0, Math.min(2, val.length));
                if (val.length > 2) {
                    newVal += '/' + val.substring(2, Math.min(4, val.length));
                }
            }
            
            $(this).val(newVal);
        });
        
        // Form validation
        $('#payment-form').on('submit', function(event) {
            // Simple validation for demo purposes
            let isValid = true;
            
            if ($('#card_number').val().replace(/\s/g, '').length < 16) {
                $('#card_number').addClass('is-invalid');
                isValid = false;
            } else {
                $('#card_number').removeClass('is-invalid');
            }
            
            // Add more validation as needed
            
            if (!isValid) {
                event.preventDefault();
                alert('Please check the form for errors.');
            }
        });
    });
</script>
@endpush
@endsection