@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp

@section('left_sidebar')
@include('front_end.pages.blogs.blogs_left_sidebar')
@endsection

@section('title', $category->name . ' - ' . __('Blog Categories'))

@section('content')
<section class="blog-section section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="section-heading text-center">
                    <h2>{{ $category->name }}</h2>
                    <p>{{ $category->description }}</p>
                </div>
                
                <div class="row">
                    @forelse($blogs as $blog)
                        <div class="col-md-6 mb-4">
                            <div class="card h-100 border-0 shadow-sm rounded-lg hover-shadow transition-300">
                                <div class="position-relative">
                                    @if($blog->thumbnail)
                                    <img src="{{ asset('storage/' . $blog->thumbnail) }}" class="card-img-top rounded-top" alt="{{ $blog->title }}" style="height: 200px; object-fit: cover;">
                                    @else
                                    <div class="bg-light text-center py-5 rounded-top">
                                        <i class="bi bi-image text-muted" style="font-size: 3rem;" title="{{ __('No Image') }}"></i>
                                    </div>
                                    @endif
                                </div>
                                <div class="card-body d-flex flex-column">
                                    <h5 class="card-title font-weight-bold">{{ $blog->title }}</h5>
                                    <p class="card-text text-muted flex-grow-1">{{ Str::limit($blog->description, 120) }}</p>
                                    <div class="d-flex justify-content-between align-items-center mt-3">
                                        <small class="text-muted">
                                            <i class="bi bi-calendar-date mr-1"></i> {{ $blog->created_at->format('M d, Y') }}
                                        </small>
                                        <a href="{{ route('blogs.show', $blog->slug) }}" class="btn btn-sm btn-outline-primary rounded-pill px-3">
                                            {{ __('Read More') }} <i class="bi bi-arrow-right ml-1"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @empty
                        <div class="col-12">
                            <div class="alert alert-info shadow-sm">
                                <i class="bi bi-info-circle mr-2"></i> {{ __('No blog posts found in this category.') }}
                            </div>
                        </div>
                    @endforelse
                </div>
                
                <div class="d-flex justify-content-center mt-4">
                    {{ $blogs->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>
</section>
@endsection