   <!-- Header START -->
   <header class="navbar-light fixed-top header-static bg-mode">
        <!-- Logo Nav START -->
        <nav class="navbar navbar-expand-lg">
            <div class="container">
                <!-- Logo START -->
                <a class="navbar-brand p-0" href="{{ url('/') }}">
                    <img src="{{asset('assets/images/logo.png')}}" alt="Socialink Logo" class="socialink-logo">
                </a>
                <!-- Logo END -->

                <!-- Responsive navbar toggler -->
                <button class="navbar-toggler ms-auto icon-md btn btn-light p-0" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarCollapse" aria-controls="navbarCollapse" aria-expanded="false"
                    aria-label="Toggle navigation">
                    <span class="navbar-toggler-animation">
                        <span></span>
                        <span></span>
                        <span></span>
                    </span>
                </button>

                <!-- Main navbar START -->
                <div class="collapse navbar-collapse" id="navbarCollapse">
                    <!-- Nav Search START -->
                    <div class="nav mt-3 mt-lg-0 flex-nowrap align-items-center w-100 d-flex justify-content-center">
                        <div class="nav-item w-75 position-relative">
                            <form id="searchForm" class="rounded position-relative" onsubmit="performSearch(event)">
                                <input 
                                    id="searchInput" 
                                    class="form-control ps-5 bg-light" 
                                    type="search"
                                    placeholder="Search people, posts, groups..." 
                                    aria-label="Search"
                                    autocomplete="off"
                                    oninput="handleSearchInput(this.value)"
                                    onfocus="showSearchDropdown()"
                                >
                                <button
                                    class="btn bg-transparent px-2 py-0 position-absolute top-50 start-0 translate-middle-y"
                                    type="submit">
                                    <i class="bi bi-search fs-5"></i>
                                </button>
                                
                                <!-- Search Dropdown START -->
                                <div id="searchDropdown" class="dropdown-menu w-100 shadow-lg border-0 mt-1" style="display: none; max-height: 400px; overflow-y: auto;">
                                    <!-- Trending Searches -->
                                    <div id="trendingSection" class="px-3 py-2">
                                        <h6 class="text-muted mb-2">
                                            <i class="bi bi-clock-history me-2"></i>Recent searches
                                        </h6>
                                        <div id="recentSearches" class="d-flex flex-wrap gap-1">
                                            <!-- Recent searches will be loaded here -->
                                        </div>
                                        <hr class="my-2">
                                        <h6 class="text-muted mb-2">
                                            <i class="bi bi-fire me-2"></i>Trending
                                        </h6>
                                        <div id="trendingSearches">
                                            <!-- Trending searches will be loaded here -->
                                        </div>
                                    </div>
                                    
                                    <!-- Autocomplete Suggestions -->
                                    <div id="suggestionsSection" style="display: none;">
                                        <div class="px-3 py-2">
                                            <h6 class="text-muted mb-2">
                                                <i class="bi bi-search me-2"></i>Suggestions
                                            </h6>
                                        </div>
                                        <div id="searchSuggestions">
                                            <!-- Auto-suggestions will be loaded here -->
                                        </div>
                                    </div>
                                    
                                    <!-- Quick Actions -->
                                    <div class="border-top px-3 py-2">
                                        <div class="d-flex gap-2">
                                            <button type="button" class="btn btn-outline-primary btn-sm flex-fill" onclick="setSearchFilter('users')">
                                                <i class="bi bi-people me-1"></i>People
                                            </button>
                                            <button type="button" class="btn btn-outline-primary btn-sm flex-fill" onclick="setSearchFilter('posts')">
                                                <i class="bi bi-file-post me-1"></i>Posts
                                            </button>
                                            <button type="button" class="btn btn-outline-primary btn-sm flex-fill" onclick="setSearchFilter('groups')">
                                                <i class="bi bi-people-fill me-1"></i>Groups
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <!-- Search Dropdown END -->
                            </form>
                        </div>
                    </div>
                    <!-- Nav Search END -->
                </div>
                <!-- Main navbar END -->

                <!-- Nav right START -->
                <ul class="nav flex-nowrap align-items-center ms-sm-3 list-unstyled">
                    <!-- Create Button -->
                    <li class="nav-item ms-2 dropdown">
                        <a class="nav-link btn btn-primary-soft btn-sm" href="#" id="createDropdown" role="button"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-plus-lg"></i> Create
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                     
                            <li><a class="dropdown-item" href="{{ route('create_story') }}"><i class="bi bi-camera-video me-2"></i>Create
                                    Story</a></li>
                            <li><a class="dropdown-item" href="{{ url('events/create') }}"><i class="bi bi-calendar-event me-2"></i>Create
                                    Event</a></li>
                            <li><a class="dropdown-item" href="{{ route('create_group') }}"><i class="bi bi-people me-2"></i>Create Group</a></li>
                        </ul>
                    </li>

                    <!-- Message Button -->
                    <li class="nav-item ms-3">
                        <a class="nav-link bg-light icon-md btn btn-light p-0" href="{{ route('messenger') }}"
                            aria-label="Messages">
                            <i class="bi bi-chat-left-text-fill fs-6"></i>
                            <span
                                class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger d-none"
                                id="message-counter">
                                0
                            </span>
                        </a>
                    </li>

                    <!-- Notification Dropdown -->
                    <li class="nav-item ms-3 dropdown">
                        <a class="nav-link bg-light icon-md btn btn-light p-0" href="#" id="notifDropdown" role="button"
                            data-bs-toggle="dropdown" aria-expanded="false" data-bs-auto-close="outside">
                            <i class="bi bi-bell-fill fs-6"></i>
                            <span
                                class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger"
                                id="notification-count">
                                0
                            </span>
                        </a>
                        <div
                            class="dropdown-menu dropdown-animation dropdown-menu-end dropdown-menu-size-md p-0 shadow-lg border-0">
                            <div class="card">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h6 class="m-0">Notifications <span
                                            class="badge bg-danger bg-opacity-10 text-danger ms-2" id="notification-badge">0 new</span></h6>
                                    <button class="btn btn-sm btn-link p-0 text-decoration-none" id="markAllRead">Clear
                                        all</button>
                                </div>
                                <div class="card-body p-0">
                                    <div id="notifications-loading" class="text-center p-4">
                                        <div class="spinner-border spinner-border-sm text-primary" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                    </div>
                                    <ul class="list-group list-group-flush list-unstyled p-2" id="notificationList">
                                        <!-- Notification items will be dynamically loaded here -->
                                    </ul>
                                    <div id="notifications-empty" class="text-center p-4 text-muted" style="display: none;">
                                        <i class="bi bi-bell-slash fs-1 d-block mb-2"></i>
                                        <p class="small mb-0">No new notifications</p>
                                    </div>
                                </div>
                                <div class="card-footer text-center">
                                    <a href="{{route('notifications.index')}}" class="btn btn-sm btn-primary-soft w-100">See all notifications</a>
                                </div>
                            </div>
                        </div>
                    </li>

                    <!-- Profile Dropdown -->
                    <li class="nav-item ms-3 dropdown">
                        <a class="nav-link btn icon-md p-0" href="#" id="profileDropdown" role="button"
                            data-bs-auto-close="outside" data-bs-display="static" data-bs-toggle="dropdown"
                            aria-expanded="false">
                            <img class="avatar rounded-2" src="{{getMedia(@Auth::user()->avatar,'avatar')}}" alt="avatar">
                            <span class="position-absolute bottom-0 end-0 bg-success rounded-circle p-1"
                                style="width: 10px; height: 10px;"></span>
                        </a>
                        <ul class="dropdown-menu dropdown-animation dropdown-menu-end pt-3 small me-md-n3">
                            <!-- Profile info -->
                            <li class="px-3">
                                <div class="d-flex align-items-center position-relative">
                                    <div class="avatar me-3">
                                        <img class="rounded-circle" src="{{getMedia(@Auth::user()->avatar,'avatar')}}"
                                            alt="avatar">
                                    </div>
                                    <div>
                                        <h6 class="mb-0">{{ Auth::user()->name }}</h6>
                                        <p class="text-muted small mb-0">{{ Auth::user()->email }}</p>
                                    </div>
                                </div>
                                <a class="dropdown-item btn btn-primary-soft btn-sm my-2 text-center"
                                    href="{{ route('settings.profile') }}">
                                    View profile
                                </a>
                            </li>

                            <!-- Quick Links -->
                            <li class="px-3">
                                <div class="d-flex gap-2 my-2">
                                    <a class="btn btn-sm btn-light-primary flex-grow-1" href="{{ route('newsfeed') }}">
                                        <i class="bi bi-pencil-square"></i> Post
                                    </a>
                                    <a class="btn btn-sm btn-light-success flex-grow-1" href="{{ route('groups') }}">
                                        <i class="bi bi-people"></i> Group
                                    </a>
                                </div>
                            </li>

                            <!-- Links -->
                            <li><a class="dropdown-item" href="{{ route('settings.account') }}">
                                    <i class="bi bi-gear fa-fw me-2"></i>Settings & Privacy</a>
                            </li>
                            <li><a class="dropdown-item" href="{{ route('help-center.index') }}">
                                    <i class="bi bi-life-preserver fa-fw me-2"></i>Help Center</a>
                            </li>
                            <li><a class="dropdown-item" href="{{ route('help-center.index') }}">
                                    <i class="bi bi-card-text fa-fw me-2"></i>Support Guides</a>
                            </li>
                            <li class="dropdown-divider"></li>
                            <li><a class="dropdown-item bg-danger-soft-hover text-danger" href="{{ url('logout') }}">
                                    <i class="bi bi-power fa-fw me-2"></i>Sign Out</a>
                            </li>

                            

                            <!-- Dark mode options -->
                            <!-- <li>
                                <div class="modeswitch-wrap dropdown-item" id="darkModeSwitch">
                                    <div class="modeswitch-item">
                                        <div class="modeswitch-icon"></div>
                                    </div>
                                    <i class="bi bi-moon-stars me-2"></i>
                                    <span>Dark mode</span>
                                </div>
                            </li> -->
                        </ul>
                    </li>
                </ul>
                <!-- Nav right END -->
            </div>
        </nav>
    </header>
    <!-- Header END -->

    <!-- Search CSS -->
    <link rel="stylesheet" href="{{ asset('assets/css/search.css') }}">

    <!-- Search JavaScript -->
    <script>
        let searchTimeout;
        let currentSearchFilter = 'all';
        let recentSearches = JSON.parse(localStorage.getItem('recentSearches') || '[]');
        
        // Authentication token - Get from Laravel Sanctum or session
        const authToken = '{{ Auth::user()?->createToken("search")->plainTextToken ?? "" }}';
        const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');
        
        // Initialize search functionality
        document.addEventListener('DOMContentLoaded', function() {
            loadTrendingSearches();
            loadRecentSearches();
            
            // Close dropdown when clicking outside
            document.addEventListener('click', function(e) {
                const searchInput = document.getElementById('searchInput');
                const searchDropdown = document.getElementById('searchDropdown');
                
                if (searchInput && searchDropdown &&
                    !searchInput.contains(e.target) && 
                    !searchDropdown.contains(e.target)) {
                    hideSearchDropdown();
                }
            });
        });
        
        // Handle search input with debouncing
        function handleSearchInput(query) {
            clearTimeout(searchTimeout);
            
            if (query.length === 0) {
                showTrendingSection();
                return;
            }
            
            if (query.length < 2) {
                return;
            }
            
            searchTimeout = setTimeout(() => {
                fetchAutocompleteSuggestions(query);
            }, 300);
        }
        
        // Fetch autocomplete suggestions
        async function fetchAutocompleteSuggestions(query) {
            try {
                const headers = {
                    'Accept': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                };
                
                // Add CSRF token if available
                if (csrfToken) {
                    headers['X-CSRF-TOKEN'] = csrfToken;
                }
                
                // Add auth token if user is logged in
                if (authToken && authToken.trim() !== '') {
                    headers['Authorization'] = `Bearer ${authToken}`;
                }
                
                console.log('Fetching autocomplete for:', query);
                
                const response = await fetch(`/api/search/autocomplete?query=${encodeURIComponent(query)}&limit=8`, {
                    headers: headers
                });
                
                console.log('Autocomplete response status:', response.status);
                
                if (response.ok) {
                    const data = await response.json();
                    console.log('Autocomplete data:', data);
                    displayAutocompleteSuggestions(data.data || []);
                } else {
                    console.log('Autocomplete request failed:', response.status, await response.text());
                    // Hide suggestions on error
                    document.getElementById('suggestionsSection').style.display = 'none';
                    showTrendingSection();
                }
            } catch (error) {
                console.error('Error fetching autocomplete suggestions:', error);
                // Hide suggestions on error
                document.getElementById('suggestionsSection').style.display = 'none';
                showTrendingSection();
            }
        }
        
        // Display autocomplete suggestions
        function displayAutocompleteSuggestions(suggestions) {
            const suggestionsContainer = document.getElementById('searchSuggestions');
            const suggestionsSection = document.getElementById('suggestionsSection');
            const trendingSection = document.getElementById('trendingSection');
            
            if (!suggestionsContainer) return;
            
            suggestionsContainer.innerHTML = '';
            
            suggestions.forEach(suggestion => {
                const item = document.createElement('div');
                item.className = 'dropdown-item d-flex align-items-center py-2 search-suggestion-item';
                item.style.cursor = 'pointer';
                
                const icon = getIconForType(suggestion.type);
                const avatar = suggestion.avatar ? 
                    `<img src="${suggestion.avatar}" class="avatar rounded-circle me-3" style="width: 40px; height: 40px;">` :
                    `<div class="bg-primary rounded-circle me-3 d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;"><i class="${icon} text-white"></i></div>`;
                
                item.innerHTML = `
                    ${avatar}
                    <div class="flex-grow-1">
                        <div class="fw-bold">${suggestion.title}</div>
                        <small class="text-muted">${suggestion.subtitle}</small>
                    </div>
                    <span class="badge bg-light text-dark">${suggestion.type}</span>
                `;
                
                item.addEventListener('click', () => {
                    selectSuggestion(suggestion);
                });
                
                suggestionsContainer.appendChild(item);
            });
            
            if (trendingSection) trendingSection.style.display = 'none';
            if (suggestionsSection) suggestionsSection.style.display = 'block';
        }
        
        // Get icon for suggestion type
        function getIconForType(type) {
            switch(type) {
                case 'user': return 'bi bi-person-fill';
                case 'group': return 'bi bi-people-fill';
                case 'post': return 'bi bi-file-post-fill';
                default: return 'bi bi-search';
            }
        }
        
        // Select a suggestion
        function selectSuggestion(suggestion) {
            const searchInput = document.getElementById('searchInput');
            if (searchInput) {
                searchInput.value = suggestion.title;
                hideSearchDropdown();
                
                // Navigate based on suggestion type
                if (suggestion.type === 'user') {
                    window.location.href = `/profile/${suggestion.id}`;
                } else if (suggestion.type === 'group') {
                    window.location.href = `/group/${suggestion.id}`;
                } else {
                    performSearchNavigation(suggestion.title, suggestion.type);
                }
            }
        }
        
        // Load trending searches
        async function loadTrendingSearches() {
            try {
                const headers = {
                    'Accept': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                };
                
                // Add auth token if user is logged in
                if (authToken && authToken.trim() !== '') {
                    headers['Authorization'] = `Bearer ${authToken}`;
                }
                
                const response = await fetch(base_url+'/api/search/trending?limit=5', { headers });
                
                if (response.ok) {
                    const data = await response.json();
                    displayTrendingSearches(data.data || []);
                } else {
                    // Show default trending searches if API fails
                    displayTrendingSearches([
                        {query: 'technology', count: 150},
                        {query: 'sports', count: 120},
                        {query: 'music', count: 98}
                    ]);
                }
            } catch (error) {
                console.error('Error loading trending searches:', error);
                // Show default trending searches
                displayTrendingSearches([
                    {query: 'technology', count: 150},
                    {query: 'sports', count: 120},
                    {query: 'music', count: 98}
                ]);
            }
        }
        
        // Display trending searches
        function displayTrendingSearches(trending) {
            const container = document.getElementById('trendingSearches');
            if (!container) return;
            
            container.innerHTML = '';
            
            trending.forEach(item => {
                const element = document.createElement('div');
                element.className = 'trending-item d-flex justify-content-between align-items-center py-1 px-2 rounded';
                element.style.cursor = 'pointer';
                element.innerHTML = `
                    <span><i class="bi bi-fire text-warning me-2"></i>${item.query}</span>
                    <small class="text-muted">${item.count}</small>
                `;
                element.addEventListener('click', () => {
                    const searchInput = document.getElementById('searchInput');
                    if (searchInput) {
                        searchInput.value = item.query;
                        performSearchNavigation(item.query, 'all');
                    }
                });
                container.appendChild(element);
            });
        }
        
        // Load recent searches
        function loadRecentSearches() {
            const container = document.getElementById('recentSearches');
            if (!container) return;
            
            container.innerHTML = '';
            
            recentSearches.slice(0, 5).forEach(search => {
                const element = document.createElement('span');
                element.className = 'badge bg-light text-dark me-1 mb-1 recent-search-tag';
                element.style.cursor = 'pointer';
                element.textContent = search;
                element.addEventListener('click', () => {
                    const searchInput = document.getElementById('searchInput');
                    if (searchInput) {
                        searchInput.value = search;
                        performSearchNavigation(search, 'all');
                    }
                });
                container.appendChild(element);
            });
        }
        
        // Show search dropdown
        function showSearchDropdown() {
            const dropdown = document.getElementById('searchDropdown');
            if (dropdown) {
                dropdown.style.display = 'block';
                showTrendingSection();
            }
        }
        
        // Hide search dropdown
        function hideSearchDropdown() {
            const dropdown = document.getElementById('searchDropdown');
            if (dropdown) {
                dropdown.style.display = 'none';
            }
        }
        
        // Show trending section
        function showTrendingSection() {
            const trendingSection = document.getElementById('trendingSection');
            const suggestionsSection = document.getElementById('suggestionsSection');
            
            if (trendingSection) trendingSection.style.display = 'block';
            if (suggestionsSection) suggestionsSection.style.display = 'none';
        }
        
        // Set search filter
        function setSearchFilter(filter) {
            currentSearchFilter = filter;
            const query = document.getElementById('searchInput')?.value;
            if (query && query.length > 0) {
                performSearchNavigation(query, filter);
            }
        }
        
        // Perform search
        function performSearch(event) {
            event.preventDefault();
            const query = document.getElementById('searchInput')?.value?.trim();
            if (query && query.length > 0) {
                performSearchNavigation(query, currentSearchFilter);
            }
        }
        
        // Navigate to search results
        function performSearchNavigation(query, type = 'all') {
            // Add to recent searches
            if (!recentSearches.includes(query)) {
                recentSearches.unshift(query);
                recentSearches = recentSearches.slice(0, 10); // Keep only last 10
                localStorage.setItem('recentSearches', JSON.stringify(recentSearches));
            }
            
            hideSearchDropdown();
            
            // Navigate to search results page
            const params = new URLSearchParams({
                query: query,
                type: type
            });
            window.location.href = `/search?${params.toString()}`;
        }
    </script>

    <style>
        .hover-bg-light:hover {
            background-color: rgba(var(--bs-light-rgb), 0.5) !important;
        }
        
        .trending-item:hover {
            background-color: rgba(var(--bs-primary-rgb), 0.1) !important;
        }
        
        #searchDropdown {
            position: absolute;
            top: 100%;
            left: 0;
            right: 0;
            z-index: 1050;
        }
        
        .dropdown-item:hover {
            background-color: rgba(var(--bs-primary-rgb), 0.1);
        }
    </style>

    <!-- Notifications JavaScript -->
    <script>
        // Notifications functionality
        document.addEventListener('DOMContentLoaded', function() {
            const notifDropdown = document.getElementById('notifDropdown');
            const notificationList = document.getElementById('notificationList');
            const notificationCount = document.getElementById('notification-count');
            const notificationBadge = document.getElementById('notification-badge');
            const markAllReadBtn = document.getElementById('markAllRead');
            const notificationsLoading = document.getElementById('notifications-loading');
            const notificationsEmpty = document.getElementById('notifications-empty');
            
            let notificationsLoaded = false;
            const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');
            
            // Load notification count on page load
            loadNotificationCount();
            
            // Load notifications when dropdown opens
            if (notifDropdown) {
                notifDropdown.addEventListener('show.bs.dropdown', function() {
                    if (!notificationsLoaded) {
                        loadNotifications();
                    }
                });
            }
            
            // Mark all as read handler
            if (markAllReadBtn) {
                markAllReadBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    markAllNotificationsAsRead();
                });
            }
            
            // Load notification count
            async function loadNotificationCount() {
                try {
                    const headers = {
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    };
                    
                    if (csrfToken) {
                        headers['X-CSRF-TOKEN'] = csrfToken;
                    }
                    
                    const response = await fetch(`${base_url || window.location.origin}/notifications/unread-count`, {
                        headers: headers,
                        credentials: 'same-origin'
                    });
                    
                    if (response.ok) {
                        const data = await response.json();
                        const count = data.count || 0;
                        updateNotificationCount(count);
                    }
                } catch (error) {
                    console.error('Error loading notification count:', error);
                }
            }
            
            // Load notifications
            async function loadNotifications() {
                try {
                    notificationsLoading.style.display = 'block';
                    notificationList.style.display = 'none';
                    notificationsEmpty.style.display = 'none';
                    
                    const headers = {
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    };
                    
                    if (csrfToken) {
                        headers['X-CSRF-TOKEN'] = csrfToken;
                    }
                    
                    const response = await fetch(`${base_url || window.location.origin}/notifications/new?limit=10`, {
                        headers: headers,
                        credentials: 'same-origin'
                    });
                    
                    if (response.ok) {
                        const result = await response.json();
                        const notifications = result.data || [];
                        displayNotifications(notifications);
                        notificationsLoaded = true;
                    } else {
                        showEmptyState();
                    }
                } catch (error) {
                    console.error('Error loading notifications:', error);
                    showEmptyState();
                } finally {
                    notificationsLoading.style.display = 'none';
                }
            }
            
            // Display notifications
            function displayNotifications(notifications) {
                notificationList.innerHTML = '';
                
                if (notifications.length === 0) {
                    showEmptyState();
                    return;
                }
                
                notificationList.style.display = 'block';
                notificationsEmpty.style.display = 'none';
                
                notifications.forEach(notification => {
                    const li = document.createElement('li');
                    li.className = 'list-group-item list-group-item-action rounded d-flex border-0 mb-1 p-3' + (notification.seen === 0 ? ' bg-light' : '');
                    li.style.cursor = 'pointer';
                    
                    const notifier = notification.notifier || {};
                    const avatar = notifier.avatar || '{{ asset("assets/images/avatar/01.jpg") }}';
                    const userName = notifier.full_name || notifier.first_name + ' ' + (notifier.last_name || '') || 'User';
                    const timeAgo = getTimeAgo(notification.created_at);
                    const notificationUrl = getNotificationUrl(notification);
                    
                    li.innerHTML = `
                        <div class="avatar text-center d-none d-sm-inline-block">
                            <img class="avatar rounded-circle" src="${avatar}" alt="${userName}" style="width: 40px; height: 40px; object-fit: cover;">
                        </div>
                        <div class="ms-sm-3 flex-grow-1">
                            <div class="d-flex justify-content-between align-items-start">
                                <p class="small mb-2 flex-grow-1">
                                    <b>${escapeHtml(userName)}</b> ${escapeHtml(notification.text || '')}
                                </p>
                                <p class="small ms-2 text-muted">${timeAgo}</p>
                            </div>
                        </div>
                    `;
                    
                    if (notificationUrl) {
                        li.addEventListener('click', function() {
                            window.location.href = notificationUrl;
                        });
                    }
                    
                    notificationList.appendChild(li);
                });
            }
            
            // Show empty state
            function showEmptyState() {
                notificationList.style.display = 'none';
                notificationsEmpty.style.display = 'block';
            }
            
            // Mark all notifications as read
            async function markAllNotificationsAsRead() {
                try {
                    const headers = {
                        'Accept': 'application/json',
                        'Content-Type': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    };
                    
                    if (csrfToken) {
                        headers['X-CSRF-TOKEN'] = csrfToken;
                    }
                    
                    const response = await fetch(`${base_url || window.location.origin}/notifications/mark-all-read`, {
                        method: 'POST',
                        headers: headers,
                        credentials: 'same-origin'
                    });
                    
                    if (response.ok) {
                        // Update UI
                        updateNotificationCount(0);
                        notificationBadge.textContent = '0 new';
                        notificationBadge.style.display = 'none';
                        
                        // Reload notifications to reflect read status
                        notificationsLoaded = false;
                        loadNotifications();
                    } else {
                        console.error('Failed to mark all notifications as read');
                    }
                } catch (error) {
                    console.error('Error marking all notifications as read:', error);
                }
            }
            
            // Update notification count
            function updateNotificationCount(count) {
                if (notificationCount) {
                    notificationCount.textContent = count;
                    if (count === 0) {
                        notificationCount.style.display = 'none';
                    } else {
                        notificationCount.style.display = 'block';
                    }
                }
                
                if (notificationBadge) {
                    notificationBadge.textContent = `${count} new`;
                    if (count === 0) {
                        notificationBadge.style.display = 'none';
                    } else {
                        notificationBadge.style.display = 'inline';
                    }
                }
            }
            
            // Get notification URL based on type
            function getNotificationUrl(notification) {
                if (notification.post_id) {
                    return `${base_url || window.location.origin}/post/${notification.post_id}`;
                } else if (notification.group_id) {
                    return `${base_url || window.location.origin}/group/${notification.group_id}`;
                } else if (notification.page_id) {
                    return `${base_url || window.location.origin}/page/${notification.page_id}`;
                } else if (notification.notifier && notification.notifier.id) {
                    return `${base_url || window.location.origin}/profile/${notification.notifier.username || notification.notifier.id}`;
                }
                return null;
            }
            
            // Format time ago
            function getTimeAgo(dateString) {
                if (!dateString) return 'Just now';
                
                const date = new Date(dateString);
                const now = new Date();
                const seconds = Math.floor((now - date) / 1000);
                
                if (seconds < 60) return 'Just now';
                if (seconds < 3600) return `${Math.floor(seconds / 60)}m ago`;
                if (seconds < 86400) return `${Math.floor(seconds / 3600)}h ago`;
                if (seconds < 604800) return `${Math.floor(seconds / 86400)}d ago`;
                
                return date.toLocaleDateString();
            }
            
            // Escape HTML to prevent XSS
            function escapeHtml(text) {
                const div = document.createElement('div');
                div.textContent = text;
                return div.innerHTML;
            }
            
            // Refresh notification count periodically (every 60 seconds)
            setInterval(loadNotificationCount, 60000);
        });
    </script>

    

