@extends('admin.layouts.home')

@section('title', 'Withdraw Request Details')

@section('content')
<div class="container-fluid p-0">
    <div class="content-wrapper p-3">
        <!-- Page Header with Breadcrumbs -->
        <div class="content-header mb-4">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="card bg-primary text-white mb-3">
                            <div class="card-body py-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-lg rounded-circle bg-white text-primary me-3">
                                        <i class="bi bi-wallet2 fs-1"></i>
                                    </div>
                                    <div>
                                        <h1 class="m-0 fw-bold">Withdraw Request Details</h1>
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb mb-0 text-white-50">
                                                <li class="breadcrumb-item"><i class="bi bi-speedometer2 me-1"></i><a href="{{ url('/admin') }}" class="text-white-50">Dashboard</a></li>
                                                <li class="breadcrumb-item"><a href="{{ route('admin.withdraw-requests.index') }}" class="text-white-50">Withdraw Requests</a></li>
                                                <li class="breadcrumb-item active text-white" aria-current="page">Details</li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- User Information Card -->
            <div class="col-md-4 mb-4">
                <div class="card h-100">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">User Information</h5>
                        <span class="badge bg-primary">ID: {{ $withdrawRequest->user->id }}</span>
                    </div>
                    <div class="card-body">
                        <div class="text-center mb-4">
                            <img src="{{ $withdrawRequest->user->profile_photo ?? asset('assets/images/default-avatar.png') }}" 
                                 class="rounded-circle img-thumbnail" 
                                 style="width: 100px; height: 100px; object-fit: cover;" 
                                 alt="User Profile">
                            <h5 class="mt-3 mb-1">{{ $withdrawRequest->user->name }}</h5>
                            <p class="text-muted mb-1">{{ $withdrawRequest->user->email }}</p>
                            <p class="mb-0">
                                <span class="badge bg-{{ $withdrawRequest->user->status ? 'success' : 'danger' }}">
                                    {{ $withdrawRequest->user->status ? 'Active' : 'Inactive' }}
                                </span>
                            </p>
                        </div>
                        <hr>
                        <div class="user-stats">
                            <div class="row text-center">
                                <div class="col">
                                    <h6 class="mb-1">${{ number_format($withdrawRequest->user->wallet->balance ?? 0, 2) }}</h6>
                                    <small class="text-muted">Balance</small>
                                </div>
                                <div class="col">
                                    <h6 class="mb-1">{{ $withdrawRequest->user->total_withdrawals ?? 0 }}</h6>
                                    <small class="text-muted">Withdrawals</small>
                                </div>
                                <div class="col">
                                    <h6 class="mb-1">{{ $withdrawRequest->user->created_at->format('M Y') }}</h6>
                                    <small class="text-muted">Joined</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Withdraw Request Details -->
            <div class="col-md-8 mb-4">
                <div class="card h-100">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            Withdraw Request #{{ $withdrawRequest->id }}
                            <span class="ms-2">
                                @if($withdrawRequest->status == 1)
                                    <span class="badge bg-warning">Pending</span>
                                @elseif($withdrawRequest->status == 2)
                                    <span class="badge bg-success">Approved</span>
                                @else
                                    <span class="badge bg-danger">Rejected</span>
                                @endif
                            </span>
                        </h5>
                        <a href="{{ route('admin.withdraw-requests.index') }}" class="btn btn-secondary btn-sm">
                            <i class="bi bi-arrow-left"></i> Back to List
                        </a>
                    </div>
                    <div class="card-body">
                        @php
                            $withdrawMethod = [
                                1=>'Stripe',
                                2=>'Paypal',
                                3=>'Flutterwave',
                                4=>'Paystack'
                            ];
                        @endphp
                        
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <div class="info-box bg-light rounded p-3">
                                    <h6 class="text-muted mb-2">Amount Requested</h6>
                                    <h4 class="mb-0 text-success">${{ number_format($withdrawRequest->amount, 2) }}</h4>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-box bg-light rounded p-3">
                                    <h6 class="text-muted mb-2">Payment Method</h6>
                                    <h4 class="mb-0">{{ $withdrawMethod[$withdrawRequest->type] ?? $withdrawRequest->type }}</h4>
                                </div>
                            </div>
                        </div>

                        <div class="payment-details bg-light p-3 rounded mb-4">
                            <h6 class="mb-3">Payment Details</h6>
                            @if($withdrawRequest->type == 'Bank')
                                <div class="row">
                                    <div class="col-md-6">
                                        <p class="mb-2">
                                            <strong>Bank Name:</strong><br>
                                            {{ $withdrawRequest->bank_name }}
                                        </p>
                                        <p class="mb-2">
                                            <strong>Account Number:</strong><br>
                                            {{ $withdrawRequest->bank_account_no }}
                                        </p>
                                        <p class="mb-2">
                                            <strong>Account Holder:</strong><br>
                                            {{ $withdrawRequest->full_name }}
                                        </p>
                                    </div>
                                    <div class="col-md-6">
                                        <p class="mb-2">
                                            <strong>SWIFT Code:</strong><br>
                                            {{ $withdrawRequest->swift_code }}
                                        </p>
                                        <p class="mb-2">
                                            <strong>IBAN:</strong><br>
                                            {{ $withdrawRequest->iban }}
                                        </p>
                                        <p class="mb-2">
                                            <strong>Country:</strong><br>
                                            {{ $withdrawRequest->country }}
                                        </p>
                                    </div>
                                </div>
                            @else
                                <p class="mb-2">
                                    <strong>PayPal Email:</strong><br>
                                    {{ $withdrawRequest->paypal_email }}
                                </p>
                            @endif
                        </div>

                        <div class="timeline mb-4">
                            <h6 class="mb-3">Request Timeline</h6>
                            <div class="timeline-item">
                                <i class="bi bi-circle-fill text-primary"></i>
                                <div class="timeline-content">
                                    <h6 class="mb-1">Request Created</h6>
                                    <small class="text-muted">{{ $withdrawRequest->created_at->format('M d, Y H:i:s') }}</small>
                                </div>
                            </div>
                            @if($withdrawRequest->status != 1)
                                <div class="timeline-item">
                                    <i class="bi bi-circle-fill {{ $withdrawRequest->status == 2 ? 'text-success' : 'text-danger' }}"></i>
                                    <div class="timeline-content">
                                        <h6 class="mb-1">Request {{ $withdrawRequest->status == 2 ? 'Approved' : 'Rejected' }}</h6>
                                        <small class="text-muted">{{ $withdrawRequest->updated_at->format('M d, Y H:i:s') }}</small>
                                    </div>
                                </div>
                            @endif
                        </div>

                        @if($withdrawRequest->status == 1)
                            <div class="action-buttons">
                                <h6 class="mb-3">Take Action</h6>
                                <form action="{{ route('admin.withdraw-requests.update-status', $withdrawRequest->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('PUT')
                                    <button type="submit" name="status" value="2" class="btn btn-success me-2">
                                        <i class="bi bi-check-circle"></i> Approve Request
                                    </button>
                                    <button type="submit" name="status" value="3" class="btn btn-danger">
                                        <i class="bi bi-x-circle"></i> Reject Request
                                    </button>
                                </form>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.timeline {
    position: relative;
    padding-left: 30px;
}

.timeline-item {
    position: relative;
    padding-bottom: 1.5rem;
    border-left: 1px solid #dee2e6;
    padding-left: 20px;
}

.timeline-item:last-child {
    padding-bottom: 0;
}

.timeline-item i {
    position: absolute;
    left: -6px;
    top: 0;
    font-size: 12px;
    background: white;
}

.info-box {
    border: 1px solid #dee2e6;
}

.user-stats {
    background-color: #f8f9fa;
    padding: 1rem;
    border-radius: 0.5rem;
}
</style>
@endsection