@extends('admin.layouts.home')

@section('title', 'Verification Request Details')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Verification Request Details</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ url('admin') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.verification.index') }}">Verification Requests</a></li>
                        <li class="breadcrumb-item active">Request #{{ $verificationRequest->id }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">User Information</h4>
                    <div class="text-center mb-4">
                        @if($verificationRequest->user->avatar)
                            <img src="{{ asset('storage/' . $verificationRequest->user->avatar) }}" alt="{{ $verificationRequest->user->name }}" class="rounded-circle avatar-xl">
                        @else
                            <div class="avatar-xl mx-auto">
                                <span class="avatar-title rounded-circle bg-primary text-white font-size-24">
                                    {{ substr($verificationRequest->user->name, 0, 1) }}
                                </span>
                            </div>
                        @endif
                        <h5 class="mt-3 mb-1">{{ $verificationRequest->user->name }}</h5>
                        <p class="text-muted">{{ $verificationRequest->user->email }}</p>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-nowrap mb-0">
                            <tbody>
                                <tr>
                                    <th scope="row">Username:</th>
                                    <td>{{ $verificationRequest->user->username }}</td>
                                </tr>
                                <tr>
                                    <th scope="row">User ID:</th>
                                    <td>{{ $verificationRequest->user->id }}</td>
                                </tr>
                                <tr>
                                    <th scope="row">Joined:</th>
                                    <td>{{ $verificationRequest->user->created_at->format('M d, Y') }}</td>
                                </tr>
                                <tr>
                                    <th scope="row">Status:</th>
                                    <td>
                                        @if($verificationRequest->user->status == 1)
                                            <span class="badge bg-success">Active</span>
                                        @else
                                            <span class="badge bg-danger">Inactive</span>
                                        @endif
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-8">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">Verification Request Details</h4>
                    
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    <div class="table-responsive mb-4">
                        <table class="table table-nowrap mb-0">
                            <tbody>
                                <tr>
                                    <th scope="row" width="20%">Request ID:</th>
                                    <td>{{ $verificationRequest->id }}</td>
                                </tr>
                                <tr>
                                    <th scope="row">Submitted:</th>
                                    <td>{{ $verificationRequest->created_at->format('M d, Y h:i A') }}</td>
                                </tr>
                                <tr>
                                    <th scope="row">Status:</th>
                                    <td>
                                        @if($verificationRequest->status === 'pending')
                                            <span class="badge bg-warning">Pending</span>
                                        @elseif($verificationRequest->status === 'approved')
                                            <span class="badge bg-success">Approved</span>
                                        @elseif($verificationRequest->status === 'rejected')
                                            <span class="badge bg-danger">Rejected</span>
                                        @endif
                                    </td>
                                </tr>
                                @if($verificationRequest->status !== 'pending')
                                <tr>
                                    <th scope="row">Reviewed:</th>
                                    <td>{{ $verificationRequest->reviewed_at->format('M d, Y h:i A') }}</td>
                                </tr>
                                <tr>
                                    <th scope="row">Reviewed By:</th>
                                    <td>{{ $verificationRequest->reviewer ? $verificationRequest->reviewer->name : 'N/A' }}</td>
                                </tr>
                                @endif
                                @if($verificationRequest->admin_notes)
                                <tr>
                                    <th scope="row">Admin Notes:</th>
                                    <td>{{ $verificationRequest->admin_notes }}</td>
                                </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>

                    <h5 class="font-size-15 mb-3">User Message</h5>
                    <div class="p-3 bg-light rounded mb-4">
                        {{ $verificationRequest->message ?: 'No message provided.' }}
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h5 class="font-size-15 mb-3">Photo ID</h5>
                            <div class="border p-2 rounded">
                                <img src="{{ asset('storage/' . $verificationRequest->photo) }}" alt="Photo ID" class="img-fluid">
                                <div class="mt-2 text-center">
                                    <a href="{{ route('admin.verification.download', ['id' => $verificationRequest->id, 'type' => 'photo']) }}" class="btn btn-sm btn-primary">
                                        <i class="fas fa-download me-1"></i> Download
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5 class="font-size-15 mb-3">Document</h5>
                            <div class="border p-2 rounded">
                                @if(pathinfo($verificationRequest->document, PATHINFO_EXTENSION) === 'pdf')
                                    <div class="text-center p-4">
                                        <i class="fas fa-file-pdf text-danger fa-4x mb-3"></i>
                                        <p>PDF Document</p>
                                    </div>
                                @else
                                    <img src="{{ asset('storage/' . $verificationRequest->document) }}" alt="Document" class="img-fluid">
                                @endif
                                <div class="mt-2 text-center">
                                    <a href="{{ route('admin.verification.download', ['id' => $verificationRequest->id, 'type' => 'document']) }}" class="btn btn-sm btn-primary">
                                        <i class="fas fa-download me-1"></i> Download
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if($verificationRequest->status === 'pending')
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="card border border-success">
                                <div class="card-header bg-transparent border-success">
                                    <h5 class="my-0 text-success">Approve Request</h5>
                                </div>
                                <div class="card-body">
                                    <form action="{{ route('admin.verification.approve', $verificationRequest->id) }}" method="POST">
                                        @csrf
                                        <div class="mb-3">
                                            <label for="admin_notes_approve" class="form-label">Admin Notes (Optional)</label>
                                            <textarea class="form-control" id="admin_notes_approve" name="admin_notes" rows="3" placeholder="Add any notes about this approval"></textarea>
                                        </div>
                                        <button type="submit" class="btn btn-success w-100">
                                            <i class="fas fa-check-circle me-1"></i> Approve Verification
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="card border border-danger">
                                <div class="card-header bg-transparent border-danger">
                                    <h5 class="my-0 text-danger">Reject Request</h5>
                                </div>
                                <div class="card-body">
                                    <form action="{{ route('admin.verification.reject', $verificationRequest->id) }}" method="POST">
                                        @csrf
                                        <div class="mb-3">
                                            <label for="admin_notes_reject" class="form-label">Rejection Reason <span class="text-danger">*</span></label>
                                            <textarea class="form-control @error('admin_notes') is-invalid @enderror" id="admin_notes_reject" name="admin_notes" rows="3" placeholder="Explain why this request is being rejected" required></textarea>
                                            @error('admin_notes')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <button type="submit" class="btn btn-danger w-100">
                                            <i class="fas fa-times-circle me-1"></i> Reject Verification
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection