@extends('admin.layouts.home')

@section('title', 'Space Details')

@section('styles')
<style>
    .nav-tabs .nav-item.show .nav-link, .nav-tabs .nav-link.active {
        background-color: #f8f9fc;
        border-color: #dee2e6 #dee2e6 #f8f9fc;
    }
    .tab-content {
        border: 1px solid #dee2e6;
        border-top: none;
        padding: 20px;
        background-color: #f8f9fc;
    }
    .member-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        object-fit: cover;
    }
    .space-info-card {
        border-left: 4px solid #4e73df;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Space Details</h1>
        <div>
            <a href="{{ route('admin.spaces.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
                <i class="fas fa-arrow-left fa-sm text-white-50"></i> Back to Spaces
            </a>
        </div>
    </div>

    <!-- Space Info Card -->
    <div class="card shadow mb-4 space-info-card">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">Space Information</h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                    <h4>{{ $space->title }}
                        <span class="badge bg-{{ $space->status === 'active' ? 'success' : ($space->status === 'completed' ? 'secondary' : 'warning') }}">
                            {{ ucfirst($space->status) }}
                        </span>
                        <span class="badge bg-{{ $space->privacy == 1 ? 'success' : ($space->privacy == 2 ? 'info' : 'warning') }}">
                            {{ $privacyLabels[$space->privacy] ?? 'Unknown' }}
                        </span>
                        @if($space->is_paid)
                            <span class="badge bg-warning">
                                <i class="fas fa-dollar-sign"></i> Paid: ${{ number_format($space->amount, 2) }}
                            </span>
                        @else
                            <span class="badge bg-success">
                                <i class="fas fa-gift"></i> Free
                            </span>
                        @endif
                    </h4>
                    
                    <p class="text-muted mt-3">{{ $space->description }}</p>
                    
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <p><strong>Topic:</strong> 
                                <span class="badge bg-info">
                                    {{ $space->topic ?? 'N/A' }}
                                </span>
                            </p>
                            <p><strong>Created:</strong> {{ $space->created_at->format('M d, Y H:i') }}</p>
                            @if($space->start_time)
                                <p><strong>Start Time:</strong> {{ \Carbon\Carbon::parse($space->start_time)->format('M d, Y H:i') }}</p>
                            @endif
                            <p><strong>Host:</strong> 
                                @if($space->user)
                                    <a href="{{ url('admin/users/' . $space->user_id) }}">
                                        <img src="{{ getMedia($space->user->profile_photo) ?? asset('assets/images/default-avatar.png') }}" class="rounded-circle me-2" width="24" height="24" onerror="this.src='{{ asset('assets/images/default-avatar.png') }}'">
                                        {{ $space->user->name }}
                                    </a>
                                @else
                                    <span class="text-muted">Unknown User</span>
                                @endif
                            </p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Total Members:</strong> 
                                <span class="badge bg-primary">{{ $totalMembers }}</span>
                            </p>
                            <p><strong>Hosts:</strong> 
                                <span class="badge bg-danger">{{ $totalHosts }}</span>
                            </p>
                            <p><strong>Co-Hosts:</strong> 
                                <span class="badge bg-warning">{{ $totalCoHosts }}</span>
                            </p>
                            <p><strong>Listeners:</strong> 
                                <span class="badge bg-info">{{ $totalListeners }}</span>
                            </p>
                            @if($space->agora_token_id)
                                <p><strong>Agora Token:</strong> 
                                    <span class="badge bg-secondary">{{ \Str::limit($space->agora_token_id, 20) }}...</span>
                                </p>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Tabs Navigation -->
    <ul class="nav nav-tabs" id="spaceTabs" role="tablist">
        <li class="nav-item">
            <a class="nav-link active" id="members-tab" data-toggle="tab" href="#members" role="tab" aria-controls="members" aria-selected="true">
                <i class="fas fa-users"></i> Members ({{ $totalMembers }})
            </a>
        </li>
    </ul>

    <!-- Tab Content -->
    <div class="tab-content" id="spaceTabsContent">
        <!-- Members Tab -->
        <div class="tab-pane fade show active" id="members" role="tabpanel" aria-labelledby="members-tab">
            @if($members->isEmpty())
                <div class="alert alert-info" role="alert">
                    <i class="fas fa-info-circle"></i> This space has no members yet.
                </div>
            @else
                <div class="table-responsive">
                    <table class="table table-bordered" id="membersTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>User</th>
                                <th>Role</th>
                                <th>Join Status</th>
                                <th>Joined</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($members as $member)
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        @if($member->user)
                                            @if($member->user->profile_photo)
                                                <img src="{{ getMedia($member->user->profile_photo) }}" class="member-avatar mr-2" alt="{{ $member->user->name }}" onerror="this.src='{{ asset('assets/images/default-avatar.png') }}'">
                                            @else
                                                <div class="bg-primary text-white rounded-circle mr-2 d-flex align-items-center justify-content-center member-avatar">
                                                    {{ strtoupper(substr($member->user->name, 0, 1)) }}
                                                </div>
                                            @endif
                                            <div>
                                                <a href="{{ url('admin/users/' . $member->user_id) }}">
                                                    {{ $member->user->name }}
                                                </a>
                                                <div class="small text-muted">{{ $member->user->email ?? 'N/A' }}</div>
                                            </div>
                                        @else
                                            <span class="text-muted">Unknown User (ID: {{ $member->user_id }})</span>
                                        @endif
                                    </div>
                                </td>
                                <td>
                                    @if($member->is_host)
                                        <span class="badge bg-danger">
                                            <i class="fas fa-crown"></i> Host
                                        </span>
                                    @elseif($member->is_cohost)
                                        <span class="badge bg-warning">
                                            <i class="fas fa-microphone"></i> Co-Host
                                        </span>
                                    @else
                                        <span class="badge bg-info">
                                            <i class="fas fa-headphones"></i> Listener
                                        </span>
                                    @endif
                                </td>
                                <td>
                                    @if(isset($member->join_status))
                                        @if($member->join_status == 1)
                                            <span class="badge bg-success">Joined</span>
                                        @else
                                            <span class="badge bg-warning">Pending</span>
                                        @endif
                                    @else
                                        <span class="badge bg-secondary">N/A</span>
                                    @endif
                                </td>
                                <td>{{ $member->created_at->format('M d, Y H:i') }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        $('#membersTable').DataTable({
            "order": [[3, "desc"]]
        });
        
        // Handle tab switching using URL hash
        var hash = window.location.hash;
        if (hash) {
            $('#spaceTabs a[href="'+hash+'"]').tab('show');
        }
        
        // Change hash on tab click
        $('#spaceTabs a').on('click', function(e) {
            window.location.hash = $(this).attr('href');
        });
    });
</script>
@endsection

