@extends('admin.layouts.home')

@section('title')
    {{ __('NodeJs Settings') }}
@endsection

@section('content')
<div class="main-content">
    <div class="page-content">
        <!-- Page Header with Breadcrumbs -->
        <div class="content-header mb-4">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="card bg-primary text-white mb-3">
                            <div class="card-body py-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-lg rounded-circle bg-white text-primary me-3">
                                        <i class="bi bi-hdd-network-fill fs-1"></i>
                                    </div>
                                    <div>
                                        <h1 class="m-0 fw-bold">{{ __('NodeJs Settings') }}</h1>
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb mb-0 text-white-50">
                                                <li class="breadcrumb-item"><i class="bi bi-speedometer2 me-1"></i><a href="{{ url('/admin') }}" class="text-white-50">{{ __('Dashboard') }}</a></li>
                                                <li class="breadcrumb-item active text-white" aria-current="page">{{ __('NodeJs Settings') }}</li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons Row -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-body p-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-0">{{ __('NodeJs Configuration') }}</h5>
                                <p class="text-muted mb-0">{{ __('Configure your NodeJs server settings for real-time features') }}</p>
                            </div>
                            <div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Settings Content -->
        <div class="row">
            <div class="col-6">
                <div class="card shadow-sm">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-primary text-white me-3">
                                <i class="bi bi-gear-fill"></i>
                            </div>
                            <h5 class="card-title mb-0">{{ __('Server Configuration') }}</h5>
                        </div>
                    </div>
                    <div class="card-body">
                <form action="" method="POST" class="form-horizontal">
                    @csrf
                    
                    <!-- Basic Settings Card -->
                    <div class="card shadow-sm mb-4">
                        <div class="card-header bg-white py-3">
                            <div class="d-flex align-items-center">
                                <div class="icon-circle bg-primary text-white me-3">
                                    <i class="bi bi-toggle-on"></i>
                                </div>
                                <h5 class="card-title mb-0">{{ __('Basic Settings') }}</h5>
                            </div>
                        </div>
                        <div class="card-body">
                            <!-- NodeJS Toggle -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="nodeJsEnabled" class="form-label fw-bold mb-0">{{ __('NodeJS') }}</label>
                                    <p class="text-muted small mb-0">{{ __('Get real time messaging, real time notifications and decrease server load by 80% less.') }}</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="nodejs_enabled" name="nodejs_enabled" {{active_value_check(setting('nodejs_enabled') ?? 0)}}> 
                                </div>
                            </div>

                            <!-- SSL Connection Toggle -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="sslEnabled" class="form-label fw-bold mb-0">{{ __('NodeJs SSL Connection') }}</label>
                                    <p class="text-muted small mb-0">{{ __('Enable this feature if you are using your site under SSL.') }}</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="nodejs_ssl" name="nodejs_ssl" {{active_value_check(setting('nodejs_ssl') ?? 0)}}> 
                                </div>
                            </div>

                            <!-- Live Notification Bar Toggle -->
                            <div class="mb-3 d-flex justify-content-between align-items-center">
                                <div>
                                    <label for="notificationBarEnabled" class="form-label fw-bold mb-0">{{ __('Live Notification Bar') }}</label>
                                    <p class="text-muted small mb-0">{{ __('Enable this feature and users will get fixed notifications on bottom left of the screen.') }}</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="notification_bar_enabled" name="notification_bar_enabled" {{active_value_check(setting('notification_bar_enabled') ?? 0)}}> 
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Port Configuration Card -->
                    <div class="card shadow-sm mb-4">
                        <div class="card-header bg-white py-3">
                            <div class="d-flex align-items-center">
                                <div class="icon-circle bg-primary text-white me-3">
                                    <i class="bi bi-hdd-network"></i>
                                </div>
                                <h5 class="card-title mb-0">{{ __('Port Configuration') }}</h5>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group mb-3">
                                        <label for="http_port" class="form-label fw-bold">{{ __('NodeJs HTTP Port') }}</label>
                                        <input type="number" class="form-control" id="http_port" name="http_port" value="{{setting('http_port') ?? 356}}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="https_port" class="form-label fw-bold">{{ __('NodeJs HTTPS (SSL) Port') }}</label>
                                        <input type="number" class="form-control" id="https_port" name="https_port" value="{{setting('https_port') ?? 449}}">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- SSL Certificate Configuration Card -->
                    <div class="card shadow-sm mb-4">
                        <div class="card-header bg-white py-3">
                            <div class="d-flex align-items-center">
                                <div class="icon-circle bg-primary text-white me-3">
                                    <i class="bi bi-shield-lock"></i>
                                </div>
                                <h5 class="card-title mb-0">{{ __('SSL Certificate Configuration') }}</h5>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group mb-3">
                                        <label for="ssl_key_path" class="form-label fw-bold">{{ __('NodeJs SSL Certificate Key Path (.key)') }}</label>
                                        <input type="text" class="form-control" id="ssl_key_path" name="ssl_key_path" value="{{setting('ssl_key_path') ?? '/var/cpanel/ssl/apache_tls/demo.wowonder.com/combined'}}">
                                        <small class="text-muted">{{ __('Only required if NodeJs SSL is enabled.') }}</small>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="ssl_cert_path" class="form-label fw-bold">{{ __('NodeJs SSL Certificate Path (.crt)') }}</label>
                                        <input type="text" class="form-control" id="ssl_cert_path" name="ssl_cert_path" value="{{setting('ssl_cert_path') ?? '/var/cpanel/ssl/apache_tls/demo.wowonder.com/certificates'}}">
                                        <small class="text-muted">{{ __('Only required if NodeJs SSL is enabled.') }}</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="alert alert-info mb-4">
                        <div class="d-flex align-items-center">
                            <i class="bi bi-info-circle-fill me-2"></i>
                            <p class="mb-0">{{ __('If you disable NodeJs system, the default ajax system will be enabled for chat and notifications system.') }}</p>
                        </div>
                    </div>
                </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('admin.update_settings')
@endsection