@extends('admin.layouts.home')

@section('title', 'Manage Reactions')

@section('content')
@push('styles')
<style>
    .custom-file-upload {
        position: relative;
    }
    .file-upload-label {
        cursor: pointer;
        padding: 0.5rem;
        border: 1px dashed var(--bs-primary);
        border-radius: 0.375rem;
        background-color: rgba(var(--bs-primary-rgb), 0.05);
        transition: all 0.3s ease;
    }
    .file-upload-label:hover {
        background-color: rgba(var(--bs-primary-rgb), 0.1);
    }
    .preview-image {
        border-radius: 4px;
        object-fit: contain;
    }
</style>
@endpush
<div class="container-fluid p-0">
    <div class="content-wrapper p-3">
        <!-- Page Header with Breadcrumbs -->
        <div class="content-header mb-4">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="card bg-primary text-white mb-3">
                            <div class="card-body py-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-lg rounded-circle bg-white text-primary me-3">
                                        <i class="bi bi-emoji-smile fs-1"></i>
                                    </div>
                                    <div>
                                        <h1 class="m-0 fw-bold">Manage Reactions</h1>
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb mb-0 text-white-50">
                                                <li class="breadcrumb-item"><i class="bi bi-speedometer2 me-1"></i><a href="index.html" class="text-white-50">Dashboard</a></li>
                                                <li class="breadcrumb-item"><a href="#" class="text-white-50">Settings</a></li>
                                                <li class="breadcrumb-item active text-white" aria-current="page">Manage Reactions</li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Add New Reaction -->
            <div class="col-lg-12 col-md-12 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-primary text-white me-3">
                                <i class="bi bi-plus-circle"></i>
                            </div>
                            <h5 class="card-title mb-0">Add New Reaction</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info">
                            <p class="mb-0">You can add new reactions from here. Note: you should write the reaction name in every language.</p>
                        </div>
                        <form action="" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <!-- Language Inputs -->
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Arabic</label>
                                    <input type="text" class="form-control" name="name[ar]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Bengali</label>
                                    <input type="text" class="form-control" name="name[bn]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Chinese</label>
                                    <input type="text" class="form-control" name="name[zh]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Croatian</label>
                                    <input type="text" class="form-control" name="name[hr]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Danish</label>
                                    <input type="text" class="form-control" name="name[da]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Dutch</label>
                                    <input type="text" class="form-control" name="name[nl]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">English</label>
                                    <input type="text" class="form-control" name="name[en]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Filipino</label>
                                    <input type="text" class="form-control" name="name[fil]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">French</label>
                                    <input type="text" class="form-control" name="name[fr]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">German</label>
                                    <input type="text" class="form-control" name="name[de]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Hebrew</label>
                                    <input type="text" class="form-control" name="name[he]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Hindi</label>
                                    <input type="text" class="form-control" name="name[hi]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Indonesian</label>
                                    <input type="text" class="form-control" name="name[id]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Italian</label>
                                    <input type="text" class="form-control" name="name[it]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Japanese</label>
                                    <input type="text" class="form-control" name="name[ja]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Korean</label>
                                    <input type="text" class="form-control" name="name[ko]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Persian</label>
                                    <input type="text" class="form-control" name="name[fa]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Portuguese</label>
                                    <input type="text" class="form-control" name="name[pt]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Russian</label>
                                    <input type="text" class="form-control" name="name[ru]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Spanish</label>
                                    <input type="text" class="form-control" name="name[es]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Swedish</label>
                                    <input type="text" class="form-control" name="name[sv]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Turkish</label>
                                    <input type="text" class="form-control" name="name[tr]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Urdu</label>
                                    <input type="text" class="form-control" name="name[ur]" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Vietnamese</label>
                                    <input type="text" class="form-control" name="name[vi]" required>
                                </div>

                                <!-- Reaction Icon Upload -->
                                <div class="col-12 mb-3">
                                    <label class="form-label">Reaction Icon</label>
                                    <div class="custom-file-upload">
                                        <input type="file" class="file-upload-input" name="icon" id="reactionIcon" accept="image/*" required hidden>
                                        <label for="reactionIcon" class="file-upload-label d-flex align-items-center">
                                            <div class="icon-circle bg-primary text-white me-2">
                                                <i class="bi bi-upload"></i>
                                            </div>
                                            <span class="upload-text">Choose Reaction Icon</span>
                                        </label>
                                        <div id="imagePreview" class="mt-2 d-none">
                                            <img src="" alt="Preview" class="preview-image" style="max-width: 32px; max-height: 32px;">
                                            <button type="button" class="btn btn-sm btn-outline-danger ms-2" id="removeImage">
                                                <i class="bi bi-x"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <small class="text-muted d-block mt-1">Recommended size: 32x32px</small>
                                </div>

                                @push('scripts')
                                <script>
                                    document.getElementById('reactionIcon').addEventListener('change', function(e) {
                                        const file = e.target.files[0];
                                        if (file) {
                                            const reader = new FileReader();
                                            reader.onload = function(e) {
                                                const preview = document.getElementById('imagePreview');
                                                preview.querySelector('img').src = e.target.result;
                                                preview.classList.remove('d-none');
                                                document.querySelector('.upload-text').textContent = file.name;
                                            }
                                            reader.readAsDataURL(file);
                                        }
                                    });

                                    document.getElementById('removeImage').addEventListener('click', function() {
                                        const input = document.getElementById('reactionIcon');
                                        input.value = '';
                                        document.getElementById('imagePreview').classList.add('d-none');
                                        document.querySelector('.upload-text').textContent = 'Choose Reaction Icon';
                                    });
                                </script>
                                @endpush

                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary">Add Reaction</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Manage Reactions Table -->
            <div class="col-lg-12 col-md-12">
                <div class="card shadow-sm">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-primary text-white me-3">
                                <i class="bi bi-list"></i>
                            </div>
                            <h5 class="card-title mb-0">Manage Reactions</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover align-middle">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Icon</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1</td>
                                        <td>Like</td>
                                        <td><img src="#" alt="Like" width="24"></td>
                                        <td><span class="badge bg-success">Active</span></td>
                                        <td>
                                            <button class="btn btn-sm btn-outline-primary me-1">Edit</button>
                                            <button class="btn btn-sm btn-outline-danger">Disable</button>
                                        </td>
                                    </tr>
                                    <!-- Add more rows dynamically -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection