@extends('admin.layouts.home')

@section('title', 'Manage Colored Posts')

<style>
    .color-preview {
        height: 200px;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 20px 0;
        font-size: 24px;
        color: #fff;
        text-shadow: 1px 1px 3px rgba(0,0,0,0.3);
    }
    .image-preview {
        height: 200px;
        border-radius: 8px;
        background-size: cover;
        background-position: center;
        background: url('{{asset("assets/images/course-placeholder.jpg")}}');
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 20px 0;
        font-size: 24px;
        color: #fff;
        text-shadow: 1px 1px 3px rgba(0,0,0,0.3);
    }
    .existing-backgrounds {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
        gap: 20px;
        margin-top: 30px;
    }
    .background-item {
        height: 150px;
        border-radius: 8px;
        position: relative;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #fff;
        text-shadow: 1px 1px 3px rgba(0,0,0,0.3);
        overflow: hidden;
    }
    .background-item .delete-btn {
        position: absolute;
        top: 10px;
        right: 10px;
        background: rgba(255,255,255,0.9);
        border: none;
        border-radius: 50%;
        width: 30px;
        height: 30px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        color: #dc3545;
    }
</style>

@section('content')
<div class="container-fluid p-0">
    <div class="content-wrapper p-3">
        <!-- Page Header with Breadcrumbs -->
        <div class="content-header mb-4">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="card bg-primary text-white mb-3">
                            <div class="card-body py-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-lg rounded-circle bg-white text-primary me-3">
                                        <i class="bi bi-palette fs-1"></i>
                                    </div>
                                    <div>
                                        <h1 class="m-0 fw-bold">Manage Colored Posts</h1>
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb mb-0 text-white-50">
                                                <li class="breadcrumb-item"><i class="bi bi-speedometer2 me-1"></i><a href="{{ url('admin') }}" class="text-white-50">Dashboard</a></li>
                                                <li class="breadcrumb-item"><a href="#" class="text-white-50">Settings</a></li>
                                                <li class="breadcrumb-item active text-white" aria-current="page">Manage Colored Posts</li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Add Colored Posts -->
            <div class="col-lg-6 col-md-6 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-primary text-white me-3">
                                <i class="bi bi-brush"></i>
                            </div>
                            <h5 class="card-title mb-0">Add Colored Posts</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Color 1</label>
                                    <input type="color" class="form-control form-control-color w-100" id="gradient_1st_color" name="gradient_1st_color" value="{{setting('gradient_1st_color') ?? '#ff69b4'}}">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Color 2</label>
                                    <input type="color" class="form-control form-control-color w-100" id="gradient_2nd_color" name="gradient_2nd_color" value="{{setting('gradient_2nd_color') ?? '#0000ff'}}">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Text Color</label>
                                    <input type="color" class="form-control form-control-color w-100" id="post_text_color" name="post_text_color" value="{{setting('post_text_color') ?? '#ffffff'}}">
                                </div>
                            </div>

                            <div class="color-preview" id="gradientPreview">
                                Hello World !!
                            </div>

                            <button type="submit" class="btn btn-danger">Create Color</button>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Add Image Posts -->
            <div class="col-lg-6 col-md-6 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-primary text-white me-3">
                                <i class="bi bi-image"></i>
                            </div>
                            <h5 class="card-title mb-0">Add Image Posts</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-md-8 mb-3">
                                    <label class="form-label">Background Image</label>
                                    <input type="file" class="form-control" id="post_background_image" name="post_background_image" accept="image/*">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Text Color</label>
                                    <input type="color" class="form-control form-control-color w-100" id="post_image_text_color" name="post_image_text_color" value="{{setting('post_image_text_color') ?? '#ffffff'}}">
                                </div>
                            </div>

                            <div class="image-preview" id="imagePreview">
                                Hello World !!
                            </div>

                            <button type="submit" class="btn btn-danger">Create Color</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Existing Backgrounds -->
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-white py-3">
                <div class="d-flex align-items-center">
                    <div class="icon-circle bg-primary text-white me-3">
                        <i class="bi bi-grid"></i>
                    </div>
                    <h5 class="card-title mb-0">Existing Backgrounds</h5>
                </div>
            </div>
            <div class="card-body">
                <div class="existing-backgrounds">
                    <!-- Sample backgrounds -->
                    <div class="background-item" style="background: linear-gradient(45deg, #ff69b4, #0000ff)">
                        <button class="delete-btn"><i class="bi bi-x"></i></button>
                        Hello World !!
                    </div>
                    <div class="background-item" style="background-image: url('{{asset("assets/images/course-placeholder.jpg")}}')">
                        <button class="delete-btn"><i class="bi bi-x"></i></button>
                        Hello World !!
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Color picker preview with smooth transitions
        const color1Input = document.getElementById('gradient_1st_color');
        const color2Input = document.getElementById('gradient_2nd_color');
        const textColorInput = document.getElementById('post_text_color');
        const gradientPreview = document.getElementById('gradientPreview');

        // Add transition for smooth color changes
        gradientPreview.style.transition = 'all 0.3s ease';

        function updateGradientPreview() {
            const gradient = `linear-gradient(45deg, ${color1Input.value}, ${color2Input.value})`;
            gradientPreview.style.background = gradient;
            gradientPreview.style.color = textColorInput.value;
        }

        // Add input and change event listeners for real-time updates
        [color1Input, color2Input, textColorInput].forEach(input => {
            input.addEventListener('input', updateGradientPreview);
            input.addEventListener('change', updateGradientPreview);
        });

        // Image preview with smooth transitions
        const imageInput = document.getElementById('post_background_image');
        const imagePreview = document.getElementById('imagePreview');
        const imageTextColor = document.getElementById('post_image_text_color');

        // Add transition for smooth text color changes
        imagePreview.style.transition = 'color 0.3s ease';

        imageInput.addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    imagePreview.style.backgroundImage = `url(${e.target.result})`;
                }
                reader.readAsDataURL(file);
            }
        });

        // Add both input and change events for real-time text color updates
        imageTextColor.addEventListener('input', function() {
            imagePreview.style.color = this.value;
        });
        imageTextColor.addEventListener('change', function() {
            imagePreview.style.color = this.value;
        });

        // Initial preview updates
        updateGradientPreview();
    });
</script>

@endsection
