@extends('admin.layouts.home')

@section('title')
    {{ __('CronJob Settings') }}
@endsection

@section('content')
<div class="main-content">
    <div class="page-content">
        <!-- Page Header with Breadcrumbs -->
        <div class="content-header mb-4">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="card bg-primary text-white mb-3">
                            <div class="card-body py-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-lg rounded-circle bg-white text-primary me-3">
                                        <i class="bi bi-clock-history fs-1"></i>
                                    </div>
                                    <div>
                                        <h1 class="m-0 fw-bold">{{ __('CronJob Settings') }}</h1>
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb mb-0 text-white-50">
                                                <li class="breadcrumb-item"><i class="bi bi-speedometer2 me-1"></i><a href="{{ url('/admin') }}" class="text-white-50">{{ __('Dashboard') }}</a></li>
                                                <li class="breadcrumb-item active text-white" aria-current="page">{{ __('CronJob Settings') }}</li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons Row -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-body p-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-0">{{ __('CronJob Configuration') }}</h5>
                                <p class="text-muted mb-0">{{ __('Configure your CronJob settings for automated tasks') }}</p>
                            </div>
                            <div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Settings Content -->
        <div class="row">
            <div class="col-6">
                <div class="card shadow-sm">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-primary text-white me-3">
                                <i class="bi bi-gear-fill"></i>
                            </div>
                            <h5 class="card-title mb-0">{{ __('CronJob Configuration') }}</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-warning mb-4">
                            <div class="d-flex align-items-center">
                                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                                <p class="mb-0">{{ __('Make sure to add this cronjob to your crontab list, the target file is: cron-job.php, should run every 5 minutes as the command below:') }}</p>
                            </div>
                        </div>

                        <form action="" method="POST" class="form-horizontal">
                            @csrf
                            <div class="form-group mb-4">
                                <label for="cronjob_command" class="form-label fw-bold">{{ __('CronJob Command') }}</label>
                                <input type="text" class="form-control" id="cronjob_command" name="cronjob_command" value="*/5 * * * * curl https://demo.wowonder.com/cron-job.php &>/dev/null" readonly>
                            </div>

                            <div class="form-group">
                                <label for="last_run" class="form-label fw-bold">{{ __('CronJob Last Run') }}</label>
                                <input type="text" class="form-control" id="last_run" name="last_run" value="31-03-2025 12:15:02" readonly>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('admin.update_settings')
@endsection