@extends('admin.layouts.home')

@section('title', 'Dashboard')

@section('content')
<div class="container-fluid p-0">
    <div class="content-wrapper p-3">
        <!-- Page Header with Breadcrumbs -->
        <div class="content-header mb-4">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="card bg-primary text-white mb-3">
                            <div class="card-body py-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-lg rounded-circle bg-white text-primary me-3">
                                        <i class="bi bi-robot fs-1"></i>
                                    </div>
                                    <div>
                                        <h1 class="m-0 fw-bold">AI Settings</h1>
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb mb-0 text-white-50">
                                                <li class="breadcrumb-item"><i
                                                        class="bi bi-speedometer2 me-1"></i><a
                                                        href="index.html"
                                                        class="text-white-50">Dashboard</a></li>
                                                <li class="breadcrumb-item active text-white"
                                                    aria-current="page">AI Settings</li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons Row -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-body p-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-0">AI Configuration</h5>
                                <p class="text-muted mb-0">Configure your AI settings and credit system</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Left Column -->
            <div class="col-lg-6 col-md-6">
                <!-- OpenAI Settings Card -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-primary text-white me-3">
                                <i class="bi bi-key"></i>
                            </div>
                            <h5 class="card-title mb-0">Open AI settings</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="openai_api_key" class="form-label">OpenAI API key</label>
                            <input type="password" class="form-control" id="openai_api_key" name="openai_api_key" value="{{setting('openai_api_key') ?? ''}}">
                            <div class="form-text text-danger">The secret key is not showing due security reasons, you can still overwrite the current one.</div>
                        </div>
                        <div class="mb-3">
                            <label for="openai_model" class="form-label">OpenAI text model</label>
                            <select class="form-control" id="openai_model" name="openai_model">
                                <option value="gpt-3.5-turbo" {{setting('openai_model') == 'gpt-3.5-turbo' ? 'selected' : ''}}>gpt-3.5-turbo</option>
                                <option value="gpt-4" {{setting('openai_model') == 'gpt-4' ? 'selected' : ''}}>gpt-4</option>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- AI Features Card -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-success text-white me-3">
                                <i class="bi bi-toggles"></i>
                            </div>
                            <h5 class="card-title mb-0">AI Settings</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <!-- AI Images System -->
                        <div class="row mb-3 border-bottom pb-3">
                            <div class="col-10">
                                <div class="d-flex align-items-center mb-1">
                                    <div class="icon-circle bg-light text-primary me-2" style="width: 28px; height: 28px">
                                        <i class="bi bi-image"></i>
                                    </div>
                                    <strong>AI Images System</strong>
                                </div>
                                <p class="text-muted mb-0">
                                    <small>Allow AI to generate images.</small>
                                </p>
                            </div>
                            <div class="col-2 d-flex align-items-center justify-content-end">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="ai_images_system" name="ai_images_system" {{active_value_check(setting('ai_images_system') ?? 1)}}>
                                </div>
                            </div>
                        </div>

                        <!-- AI Post System -->
                        <div class="row mb-3 border-bottom pb-3">
                            <div class="col-10">
                                <div class="d-flex align-items-center mb-1">
                                    <div class="icon-circle bg-light text-success me-2" style="width: 28px; height: 28px">
                                        <i class="bi bi-file-post"></i>
                                    </div>
                                    <strong>AI Post System</strong>
                                </div>
                                <p class="text-muted mb-0">
                                    <small>Allow AI to generate posts.</small>
                                </p>
                            </div>
                            <div class="col-2 d-flex align-items-center justify-content-end">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="ai_post_system" name="ai_post_system" {{active_value_check(setting('ai_post_system') ?? 1)}}>
                                </div>
                            </div>
                        </div>

                        <!-- AI Blog System -->
                        <div class="row mb-3 border-bottom pb-3">
                            <div class="col-10">
                                <div class="d-flex align-items-center mb-1">
                                    <div class="icon-circle bg-light text-info me-2" style="width: 28px; height: 28px">
                                        <i class="bi bi-newspaper"></i>
                                    </div>
                                    <strong>AI Blog System</strong>
                                </div>
                                <p class="text-muted mb-0">
                                    <small>Allow AI to generate articles.</small>
                                </p>
                            </div>
                            <div class="col-2 d-flex align-items-center justify-content-end">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="ai_blog_system" name="ai_blog_system" {{active_value_check(setting('ai_blog_system') ?? 1)}}>
                                </div>
                            </div>
                        </div>

                        <!-- AI Avatar/Cover System -->
                        <div class="row mb-3">
                            <div class="col-10">
                                <div class="d-flex align-items-center mb-1">
                                    <div class="icon-circle bg-light text-warning me-2" style="width: 28px; height: 28px">
                                        <i class="bi bi-person-square"></i>
                                    </div>
                                    <strong>AI Avatar/Cover System</strong>
                                </div>
                                <p class="text-muted mb-0">
                                    <small>Allow users to edit Avatar/Cover using AI.</small>
                                </p>
                            </div>
                            <div class="col-2 d-flex align-items-center justify-content-end">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="ai_avatar_system" name="ai_avatar_system" {{active_value_check(setting('ai_avatar_system') ?? 0)}}> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Column -->
            <div class="col-lg-6 col-md-6">
                <!-- Replicate AI Settings Card -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-info text-white me-3">
                                <i class="bi bi-gear"></i>
                            </div>
                            <h5 class="card-title mb-0">Replicate AI Settings</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="replicate_model" class="form-label">Replicate Model</label>
                            <select class="form-control" id="replicate_model" name="replicate_model">
                                <option value="prompthero/openjourney" {{setting('replicate_model') == 'prompthero/openjourney' ? 'selected' : ''}}>prompthero/openjourney</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="replicate_api_token" class="form-label">Replicate API Token</label>
                            <input type="text" class="form-control" id="replicate_api_token" name="replicate_api_token" value="{{setting('replicate_api_token') ?? ''}}">
                        </div>
                        <div class="mb-3">
                            <label for="num_inference_steps" class="form-label">num_inference_steps</label>
                            <input type="number" class="form-control" id="num_inference_steps" name="num_inference_steps" value="{{setting('num_inference_steps') ?? 1}}">
                            <div class="form-text">Number of denoising steps (minimum: 1; maximum: 500)</div>
                        </div>
                        <div class="mb-3">
                            <label for="guidance_scale" class="form-label">guidance_scale</label>
                            <input type="number" class="form-control" id="guidance_scale" name="guidance_scale" value="{{setting('guidance_scale') ?? 1}}">
                            <div class="form-text">Scale for classifier-free guidance (minimum: 1; maximum: 20)</div>
                        </div>
                        <div class="mb-3">
                            <label for="seed" class="form-label">seed</label>
                            <input type="text" class="form-control" id="seed" name="seed" value="{{setting('seed') ?? ''}}">
                            <div class="form-text">Random seed. Leave blank to randomize the seed</div>
                        </div>
                    </div>
                </div>

                <!-- AI Credit Settings Card -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-warning text-white me-3">
                                <i class="bi bi-currency-dollar"></i>
                            </div>
                            <h5 class="card-title mb-0">AI Credit Settings</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="credit_price" class="form-label">Credit Price</label>
                            <input type="number" class="form-control" id="ai_credit_cost" name="ai_credit_cost" value="{{setting('ai_credit_cost') ?? 1}}">
                            <div class="form-text">Credit Price Ex: $1 = 10 credits</div>
                        </div>

                        <!-- AI Images Credit System -->
                        <div class="row mb-3 border-bottom pb-3">
                            <div class="col-10">
                                <div class="d-flex align-items-center mb-1">
                                    <strong>AI Images Credit System</strong>
                                </div>
                                <p class="text-muted mb-0">
                                    <small>AI Images Credit System.</small>
                                </p>
                            </div>
                            <div class="col-2 d-flex align-items-center justify-content-end">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="ai_images_credit_system" name="ai_images_credit_system" {{active_value_check(setting('ai_images_credit_system') ?? 1)}}> 
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="generated_image_price" class="form-label">Generated Image Price</label>
                            <input type="number" class="form-control" id="generated_image_price" name="generated_image_price" value="{{setting('generated_image_price') ?? 10}}">
                            <div class="form-text">Generated Image Price</div>
                        </div>

                        <!-- AI Text Credit System -->
                        <div class="row mb-3 border-bottom pb-3">
                            <div class="col-10">
                                <div class="d-flex align-items-center mb-1">
                                    <strong>AI Text Credit System</strong>
                                </div>
                                <p class="text-muted mb-0">
                                    <small>AI Text Credit System.</small>
                                </p>
                            </div>
                            <div class="col-2 d-flex align-items-center justify-content-end">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="ai_text_credit_system" name="ai_text_credit_system" {{active_value_check(setting('ai_text_credit_system') ?? 1)}}> 
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="generated_word_price" class="form-label">Generated Word Price</label>
                            <input type="number" class="form-control" id="generated_word_price" name="generated_word_price" value="{{setting('generated_word_price') ?? 1}}">
                            <div class="form-text">Generated Word Price</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@include('admin.update_settings')
@endsection