@extends('layouts.master')

@section('title')
    {{ __($page_title) }}
@endsection

@section('extracsslibrary')
    <style>
        #myTable_filter {
            float: right;
        }
    </style>
@endsection

@section('main_content')
    <div class="container-fluid">
        <div class="card shadow-sm">
            <div class="card-header bg-light">
                <h3>Edit Role</h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 offset-md-3">
                        <h3>Edit Role</h3>
                        <form action="{{ route('admin.roles.update', $role) }}" method="post">
                            @csrf
                            @method('PUT')
                            <div class="form-group">
                                <label for="name">Role Name</label>
                                <input type="text" class="form-control" name="name" placeholder="Enter Name of role" value="{{ $role->name }}">
                                @if($errors->has('name'))
                                    <p class="help-block text-danger">
                                        {{ $errors->first('name') }}
                                    </p>
                                @endif
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-success">Submit</button>
                                <a href="{{ route('admin.roles.index') }}" class="btn btn-danger">Back</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('extraJs')
    <!-- Any additional JS or custom scripts can go here if necessary -->
@endsection
