@extends('admin.layouts.home')

@section('title', 'Assign Permissions to Role')

@section('extra-css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />


@endsection

@section('content')
    <div class="container-fluid">
        <!-- Page Heading -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0 text-gray-800">Assign Permissions to Role: {{ $role->name }}</h1>
        </div>
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                <h6 class="m-0 font-weight-bold text-primary">Permissions Management</h6>
            </div>
            <div class="card-body">
                @if (session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                @endif

                <div class="permission-container">
                    <div class="permission-header">
                        <h4 class="mb-0">Manage Permissions</h4>
                        <div class="action-buttons">
                            <button type="button" class="btn-action btn-select-all" id="selectall">Select All</button>
                            <button type="button" class="btn-action btn-deselect-all" id="deselectall">Deselect
                                All</button>
                        </div>
                    </div>

                    <div class="permission-info">
                        <i class="fas fa-info-circle"></i>
                        Currently assigned: <strong>{{ $role->permissions->count() }}</strong> permissions |
                        Available: <strong>{{ $permissions->count() }}</strong> total permissions
                    </div>

                    <form action="{{ route('admin.roles.allowpermissions', $role) }}" method="post"
                        id="assign-permission-form">
                        @csrf
                        <div class="form-group">
                            <label for="permissions" class="font-weight-bold">Select Permissions:</label>
                            <small class="form-text text-muted mb-2">
                                Selected permissions will be assigned to this role. Deselected permissions will be removed.
                            </small>

                            <select name="permissions[]" id="permissions" class="form-control" multiple>
                                <optgroup label="Currently Assigned Permissions">
                                    @foreach ($permissions as $permission)
                                        @if ($role->hasPermissionTo($permission->name))
                                            <option value="{{ $permission->name }}" selected>{{ $permission->name }}
                                            </option>
                                        @endif
                                    @endforeach
                                </optgroup>
                                <optgroup label="Available Permissions">
                                    @foreach ($permissions as $permission)
                                        @if (!$role->hasPermissionTo($permission->name))
                                            <option value="{{ $permission->name }}">{{ $permission->name }}</option>
                                        @endif
                                    @endforeach
                                </optgroup>
                            </select>
                        </div>

                        <div class="form-group mt-4">
                            <button type="submit" class="btn btn-success btn-lg">
                                <i class="fas fa-save"></i> Save Changes
                            </button>
                            <a href="{{ route('admin.roles.index') }}" class="btn btn-secondary btn-lg ml-2">
                                <i class="fas fa-arrow-left"></i> Back to Roles
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('extraJs')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            // Initialize Select2
            $('#permissions').select2({
                placeholder: "Select permissions...",
                allowClear: true,
                width: '100%',
                theme: 'bootstrap5' // Make sure your project uses Bootstrap 5 or switch to bootstrap4
            });

            // Select/Deselect All functionality
            $(document).on('click', '#selectall', function() {
                $('#permissions').find('option').prop('selected', true);
                $('#permissions').trigger('change');
                $(this).addClass('btn-success').removeClass('btn-action');
                $('#deselectall').removeClass('btn-success').addClass('btn-action');
            });

            $(document).on('click', '#deselectall', function() {
                $('#permissions').find('option').prop('selected', false);
                $('#permissions').trigger('change');
                $(this).addClass('btn-success').removeClass('btn-action');
                $('#selectall').removeClass('btn-success').addClass('btn-action');
            });
        });
    </script>
@endsection
