@extends('admin.layouts.home')

@section('title', 'Reports Dashboard')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Reports Dashboard</h1>
    </div>

    <!-- Content Row -->
    <div class="row">
        <!-- Pending Reports Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Pending Reports</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $totalPendingReports }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-flag fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Resolved Reports Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Resolved Reports</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $totalResolvedReports }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Dismissed Reports Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-danger shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                Dismissed Reports</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $totalDismissedReports }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-ban fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Total Reports Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Total Reports</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $totalPendingReports + $totalResolvedReports + $totalDismissedReports }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clipboard-list fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Content Row -->
    <div class="row">
        <!-- User Reports Card -->
        <div class="col-xl-6 col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">User Reports</h6>
                    <a href="{{ route('admin.reports.user-reports') }}" class="btn btn-sm btn-primary">
                        View All
                    </a>
                </div>
                <div class="card-body">
                    <div class="text-center">
                        <i class="fas fa-user-shield fa-4x mb-3 text-gray-300"></i>
                        <h5>Pending User Reports</h5>
                        <h2 class="display-4">{{ $pendingUserReports }}</h2>
                        <p class="text-muted">Reports about users that require moderation</p>
                        <a href="{{ route('admin.reports.user-reports') }}" class="btn btn-primary btn-block">
                            <i class="fas fa-eye"></i> Manage User Reports
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Post Reports Card -->
        <div class="col-xl-6 col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Post Reports</h6>
                    <a href="{{ route('admin.reports.post-reports') }}" class="btn btn-sm btn-primary">
                        View All
                    </a>
                </div>
                <div class="card-body">
                    <div class="text-center">
                        <i class="fas fa-newspaper fa-4x mb-3 text-gray-300"></i>
                        <h5>Pending Post Reports</h5>
                        <h2 class="display-4">{{ $pendingPostReports }}</h2>
                        <p class="text-muted">Reports about posts that require moderation</p>
                        <a href="{{ route('admin.reports.post-reports') }}" class="btn btn-primary btn-block">
                            <i class="fas fa-eye"></i> Manage Post Reports
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions Card -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Quick Actions</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <a href="{{ route('admin.reports.user-reports') }}" class="btn btn-warning btn-lg btn-block mb-3">
                                <i class="fas fa-user-shield mr-2"></i> Review User Reports
                            </a>
                        </div>
                        <div class="col-md-6">
                            <a href="{{ route('admin.reports.post-reports') }}" class="btn btn-warning btn-lg btn-block mb-3">
                                <i class="fas fa-newspaper mr-2"></i> Review Post Reports
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    // Initialize any dashboard widgets or charts here
});
</script>
@endsection 