@extends('admin.layouts.home')

@section('title', 'Dashboard')

@section('content')

<div class="container-fluid p-0">
    <div class="content-wrapper p-3">
        <!-- Page Header with Breadcrumbs -->
        <div class="content-header mb-4">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="card bg-primary text-white mb-3">
                            <div class="card-body py-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-lg rounded-circle bg-white text-primary me-3">
                                        <i class="bi bi-star-fill fs-1"></i>
                                    </div>
                                    <div>
                                        <h1 class="m-0 fw-bold">Pro System Settings</h1>
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb mb-0 text-white-50">
                                                <li class="breadcrumb-item"><i
                                                        class="bi bi-speedometer2 me-1"></i><a
                                                        href="index.html"
                                                        class="text-white-50">Dashboard</a></li>
                                                <li class="breadcrumb-item active text-white"
                                                    aria-current="page">Pro System Settings</li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons Row -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-body p-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-0">Pro System Configuration</h5>
                                <p class="text-muted mb-0">Configure premium features and membership options</p>
                            </div>
                            <div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-6 col-md-6">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-warning text-white me-3">
                                <i class="bi bi-gear"></i>
                            </div>
                            <h5 class="card-title mb-0">Pro System Settings</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="pro-settings-alert"></div>
                        <form class="pro-settings" method="POST">
                            <!-- Pro System -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-pro" class="form-label fw-bold mb-0">Pro System</label>
                                    <p class="text-muted mb-0 small">If you disable Pro Mode, all features will be free and activated without the boost feature.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="pro" value="0">
                                    <input class="form-check-input" type="checkbox" name="pro" id="chck-pro" value="1" checked>
                                </div>
                            </div>

                            <!-- Recurring Payment -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-recurring_payment" class="form-label fw-bold mb-0">Recurring Payment</label>
                                    <p class="text-muted mb-0 small">Enable automatic payments (cronjob)</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="recurring_payment" value="0">
                                    <input class="form-check-input" type="checkbox" name="recurring_payment" id="chck-recurring_payment" value="1">
                                </div>
                            </div>

                            <!-- Refund System -->
                            <div class="mb-3 d-flex justify-content-between align-items-center">
                                <div>
                                    <label for="chck-refund_system" class="form-label fw-bold mb-0">Refund System</label>
                                    <p class="text-muted mb-0 small">Allow users to request refund.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="refund_system" value="off">
                                    <input class="form-check-input" type="checkbox" name="refund_system" id="chck-refund_system" value="on" checked>
                                </div>
                            </div>

                            <input type="hidden" name="hash_id" value="00ddcc06d83d0faf07a6899229ca696359406f2a">
                        </form>
                    </div>
                </div>

                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-info text-white me-3">
                                <i class="bi bi-person-badge"></i>
                            </div>
                            <h5 class="card-title mb-0">Pro Membership Features</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="pro-settings" method="POST">
                            <!-- Pro Membership On Sign Up -->
                            <div class="mb-3 d-flex justify-content-between align-items-center">
                                <div>
                                    <label for="chck-membership_system" class="form-label fw-bold mb-0">Pro Membership On Sign Up</label>
                                    <p class="text-muted mb-0 small">Require Pro Membership from users on sign up page.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="membership_system" value="0">
                                    <input class="form-check-input" type="checkbox" name="membership_system" id="chck-membership_system" value="1">
                                </div>
                            </div>

                            <input type="hidden" name="hash_id" value="00ddcc06d83d0faf07a6899229ca696359406f2a">
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-lg-6 col-md-6">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-success text-white me-3">
                                <i class="bi bi-tags"></i>
                            </div>
                            <h5 class="card-title mb-0">Edit Pro Packages</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <button type="button" class="btn btn-primary mb-3" onclick="AddNewPackage()">
                            <i class="bi bi-plus-circle me-1"></i> Add New Package
                        </button>

                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>Name</th>
                                        <th width="150">Status</th>
                                        <th width="150">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <span class="badge rounded-pill me-2" style="background-color:#79c149">
                                                    <i class="bi bi-star-fill"></i>
                                                </span>
                                                <span style="color:#79c149" class="fw-bold">Star</span>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge bg-success">
                                                <i class="bi bi-check-lg me-1"></i> Enabled
                                            </span>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-info" onclick="ShowEditPro(this)" data_pro_type="1">
                                                <i class="bi bi-pencil-square me-1"></i> Edit
                                            </button>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <span class="badge rounded-pill me-2" style="background-color:#dd3c3c">
                                                    <i class="bi bi-fire"></i>
                                                </span>
                                                <span style="color:#dd3c3c" class="fw-bold">Hot</span>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge bg-success">
                                                <i class="bi bi-check-lg me-1"></i> Enabled
                                            </span>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-info" onclick="ShowEditPro(this)" data_pro_type="2">
                                                <i class="bi bi-pencil-square me-1"></i> Edit
                                            </button>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <span class="badge rounded-pill me-2" style="background-color:#fb924b">
                                                    <i class="bi bi-lightning-charge-fill"></i>
                                                </span>
                                                <span style="color:#fb924b" class="fw-bold">Ultima</span>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge bg-success">
                                                <i class="bi bi-check-lg me-1"></i> Enabled
                                            </span>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-info" onclick="ShowEditPro(this)" data_pro_type="3">
                                                <i class="bi bi-pencil-square me-1"></i> Edit
                                            </button>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <span class="badge rounded-pill me-2" style="background-color:#5bbaf5">
                                                    <i class="bi bi-rocket-takeoff-fill"></i>
                                                </span>
                                                <span style="color:#5bbaf5" class="fw-bold">VIP</span>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge bg-success">
                                                <i class="bi bi-check-lg me-1"></i> Enabled
                                            </span>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-info" onclick="ShowEditPro(this)" data_pro_type="4">
                                                <i class="bi bi-pencil-square me-1"></i> Edit
                                            </button>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Save Changes Button -->
        <div class="row mt-3 mb-4">
            <div class="col-12">
                <div class="card bg-light">
                    <div class="card-body p-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <p class="mb-0"><i class="bi bi-info-circle me-1"></i> Changes will be applied to the Pro System immediately.</p>
                            </div>
                            <div>
                                <button type="button" class="btn btn-outline-secondary me-2">
                                    <i class="bi bi-arrow-counterclockwise me-1"></i> Reset
                                </button>
                                <button type="submit" class="btn btn-success">
                                    <i class="bi bi-save me-1"></i> Save Configuration
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection