@extends('admin.layouts.home')

@section('title', __('Post Details'))

@section('content')
<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-1 text-gray-800">
                <i class="fas fa-newspaper text-primary mr-2"></i>{{ __('Post Details') }}
            </h1>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin.posts.index') }}">Posts</a></li>
                    <li class="breadcrumb-item active">Post #{{ $post->id }}</li>
                </ol>
            </nav>
        </div>
        <div>
            <a href="{{ route('admin.posts.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left mr-1"></i> {{ __('Back to Posts') }}
            </a>
        </div>
    </div>

    <div class="row">
        <!-- Main Content -->
        <div class="col-lg-8">
            <!-- Post Header Card -->
            <div class="card shadow mb-4 border-left-primary">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div class="flex-grow-1">
                            <div class="d-flex align-items-center mb-2">
                                <span class="badge badge-primary badge-lg mr-2">
                                    <i class="fas fa-tag mr-1"></i>{{ ucfirst(str_replace('_', ' ', $post->post_type ?? 'post')) }}
                                </span>
                                @if($post->is_anonymous)
                                    <span class="badge badge-warning mr-2">
                                        <i class="fas fa-user-secret mr-1"></i>Anonymous
                                    </span>
                                @endif
                                @if($post->tips_enabled)
                                    <span class="badge badge-success mr-2">
                                        <i class="fas fa-coins mr-1"></i>Tips Enabled
                                    </span>
                                @endif
                                @if($post->comments_status === 0)
                                    <span class="badge badge-danger">
                                        <i class="fas fa-comment-slash mr-1"></i>Comments Disabled
                                    </span>
                                @endif
                            </div>
                            <div class="text-muted small">
                                <i class="fas fa-user mr-1"></i>
                                <strong>Author:</strong> {{ $post->user->name ?? $post->user->username ?? 'Unknown' }}
                                <span class="mx-2">•</span>
                                <i class="fas fa-calendar mr-1"></i>
                                {{ $post->created_at->format('M d, Y') }}
                                <span class="mx-2">•</span>
                                <i class="fas fa-clock mr-1"></i>
                                {{ $post->created_at->format('H:i') }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Post Text Content -->
            @if($post->post_text)
            <div class="card shadow mb-4">
                <div class="card-header bg-white py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-align-left mr-2"></i>Post Content
                    </h6>
                </div>
                <div class="card-body">
                    <div class="post-content-text" style="font-size: 15px; line-height: 1.8; color: #333;">
                        {!! nl2br(e($post->post_text)) !!}
                    </div>
                </div>
            </div>
            @endif

            <!-- Shared Text -->
            @if($post->shared_text)
            <div class="card shadow mb-4 border-left-info">
                <div class="card-header bg-light py-3">
                    <h6 class="m-0 font-weight-bold text-info">
                        <i class="fas fa-share-alt mr-2"></i>Shared Text
                    </h6>
                </div>
                <div class="card-body">
                    <div class="shared-text-content" style="font-size: 15px; line-height: 1.8; color: #555;">
                        {!! nl2br(e($post->shared_text)) !!}
                    </div>
                </div>
            </div>
            @endif

            <!-- Media Gallery -->
            @if($post->media->count() > 0)
            <div class="card shadow mb-4">
                <div class="card-header bg-white py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-images mr-2"></i>Media Gallery
                    </h6>
                </div>
                <div class="card-body">
                    <!-- Images -->
                    @if($post->media->where('image_or_video', 1)->count() > 0)
                    <div class="mb-4">
                        <h6 class="text-muted mb-3">
                            <i class="fas fa-image mr-2"></i>Images ({{ $post->media->where('image_or_video', 1)->count() }})
                        </h6>
                        <div class="row g-3">
                            @foreach($post->media->where('image_or_video', 1) as $image)
                            <div class="col-md-4 col-sm-6">
                                <div class="card border-0 shadow-sm h-100">
                                    <div class="position-relative">
                                        <img src="{{ getMedia($image->media_path, 'image') }}" 
                                             alt="Post Image" 
                                             class="card-img-top" 
                                             style="height: 200px; object-fit: cover; cursor: pointer;"
                                             onclick="openImageModal('{{ getMedia($image->media_path, 'image') }}')">
                                        <div class="position-absolute top-0 end-0 m-2">
                                            <span class="badge bg-dark">{{ $image->original_name ?? 'Image' }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    @endif

                    <!-- Videos -->
                    @if($post->media->where('image_or_video', 2)->count() > 0)
                    <div class="mb-4">
                        <h6 class="text-muted mb-3">
                            <i class="fas fa-video mr-2"></i>Videos ({{ $post->media->where('image_or_video', 2)->count() }})
                        </h6>
                        <div class="row g-3">
                            @foreach($post->media->where('image_or_video', 2) as $video)
                            <div class="col-md-6">
                                <div class="card border-0 shadow-sm">
                                    <div class="card-body p-0">
                                        <video controls class="w-100" style="max-height: 400px;">
                                            <source src="{{ getMedia($video->media_path, 'video') }}" type="{{ $video->mime_type ?? 'video/mp4' }}">
                                            Your browser does not support the video tag.
                                        </video>
                                        <div class="p-3">
                                            <h6 class="mb-1">{{ $video->original_name ?? 'Video' }}</h6>
                                            @if($video->file_size)
                                                <small class="text-muted">
                                                    <i class="fas fa-hdd mr-1"></i>
                                                    {{ number_format($video->file_size / 1024 / 1024, 2) }} MB
                                                </small>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    @endif

                    <!-- Audio -->
                    @if($post->media->where('image_or_video', 3)->count() > 0)
                    <div class="mb-4">
                        <h6 class="text-muted mb-3">
                            <i class="fas fa-music mr-2"></i>Audio Files ({{ $post->media->where('image_or_video', 3)->count() }})
                        </h6>
                        @foreach($post->media->where('image_or_video', 3) as $audio)
                        <div class="card border-0 shadow-sm mb-3">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="flex-grow-1">
                                        <h6 class="mb-1">{{ $audio->original_name ?? 'Audio File' }}</h6>
                                        @if($audio->file_size)
                                            <small class="text-muted">
                                                <i class="fas fa-hdd mr-1"></i>
                                                {{ number_format($audio->file_size / 1024 / 1024, 2) }} MB
                                            </small>
                                        @endif
                                    </div>
                                </div>
                                <audio controls class="w-100 mt-2">
                                    <source src="{{ getMedia($audio->media_path, 'audio') }}" type="{{ $audio->mime_type ?? 'audio/mpeg' }}">
                                    Your browser does not support the audio tag.
                                </audio>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    @endif

                    <!-- Attachments -->
                    @if($post->media->where('image_or_video', 4)->count() > 0)
                    <div class="mb-4">
                        <h6 class="text-muted mb-3">
                            <i class="fas fa-paperclip mr-2"></i>Attachments ({{ $post->media->where('image_or_video', 4)->count() }})
                        </h6>
                        <div class="list-group">
                            @foreach($post->media->where('image_or_video', 4) as $attachment)
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <i class="fas fa-file text-primary mr-2"></i>
                                    <strong>{{ $attachment->original_name ?? 'Attachment' }}</strong>
                                    @if($attachment->file_size)
                                        <small class="text-muted ml-2">
                                            ({{ number_format($attachment->file_size / 1024, 2) }} KB)
                                        </small>
                                    @endif
                                </div>
                                <a href="{{ getMedia($attachment->media_path, 'document') }}" 
                                   target="_blank" 
                                   class="btn btn-sm btn-primary">
                                    <i class="fas fa-download mr-1"></i>Download
                                </a>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    @endif
                </div>
            </div>
            @endif

            <!-- GIF -->
            @if($post->gif_url)
            <div class="card shadow mb-4">
                <div class="card-header bg-white py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-gift mr-2"></i>GIF
                    </h6>
                </div>
                <div class="card-body text-center">
                    <img src="{{ $post->gif_url }}" 
                         alt="{{ $post->gif_title ?? 'GIF' }}" 
                         class="img-fluid rounded shadow-sm" 
                         style="max-height: 400px;">
                    @if($post->gif_title)
                        <p class="mt-3 mb-0 text-muted">{{ $post->gif_title }}</p>
                    @endif
                </div>
            </div>
            @endif

            <!-- Video Thumbnail -->
            @if($post->video_thumbnail_url || $post->video_thumbnail)
            <div class="card shadow mb-4">
                <div class="card-header bg-white py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-film mr-2"></i>Video Thumbnail
                    </h6>
                </div>
                <div class="card-body text-center">
                    <img src="{{ getMedia($post->video_thumbnail_url ?? $post->video_thumbnail, 'image') }}" 
                         alt="Video Thumbnail" 
                         class="img-fluid rounded shadow-sm" 
                         style="max-height: 400px;">
                </div>
            </div>
            @endif

            <!-- External Videos -->
            @if(($post->youtube_urls ?? $post->youtube_links) || ($post->vimeo_urls ?? $post->vimeo_links))
            <div class="card shadow mb-4">
                <div class="card-header bg-white py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-external-link-alt mr-2"></i>External Videos
                    </h6>
                </div>
                <div class="card-body">
                    @if($post->youtube_urls ?? $post->youtube_links)
                        <div class="mb-3">
                            <strong><i class="fab fa-youtube text-danger mr-2"></i>YouTube:</strong>
                            <a href="{{ $post->youtube_urls ?? $post->youtube_links }}" 
                               target="_blank" 
                               class="ml-2">
                                {{ $post->youtube_urls ?? $post->youtube_links }}
                                <i class="fas fa-external-link-alt ml-1"></i>
                            </a>
                        </div>
                    @endif
                    @if($post->vimeo_urls ?? $post->vimeo_links)
                        <div>
                            <strong><i class="fab fa-vimeo text-info mr-2"></i>Vimeo:</strong>
                            <a href="{{ $post->vimeo_urls ?? $post->vimeo_links }}" 
                               target="_blank" 
                               class="ml-2">
                                {{ $post->vimeo_urls ?? $post->vimeo_links }}
                                <i class="fas fa-external-link-alt ml-1"></i>
                            </a>
                        </div>
                    @endif
                </div>
            </div>
            @endif

            <!-- Poll -->
            @if($post->post_type == 'poll' && $post->poll)
            <div class="card shadow mb-4 border-left-warning">
                <div class="card-header bg-light py-3">
                    <h6 class="m-0 font-weight-bold text-warning">
                        <i class="fas fa-poll mr-2"></i>Poll
                    </h6>
                </div>
                <div class="card-body">
                    <h5 class="mb-4">{{ $post->poll->title }}</h5>
                    @if($post->poll->options && $post->poll->options->count() > 0)
                        <div class="list-group">
                            @foreach($post->poll->options as $option)
                            <div class="list-group-item">
                                <i class="fas fa-circle text-primary mr-2" style="font-size: 8px;"></i>
                                {{ $option->option_text }}
                            </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>
            @endif

            <!-- Donation -->
            @if($post->post_type == 'donation' && $post->fund)
            <div class="card shadow mb-4 border-left-success">
                <div class="card-header bg-light py-3">
                    <h6 class="m-0 font-weight-bold text-success">
                        <i class="fas fa-hand-holding-heart mr-2"></i>Donation Details
                    </h6>
                </div>
                <div class="card-body">
                    @if($post->fund->donation_title)
                        <h5 class="mb-3">{{ $post->fund->donation_title }}</h5>
                    @endif
                    @if($post->fund->amount)
                        <div class="mb-3">
                            <strong>Amount:</strong>
                            <span class="badge badge-success badge-lg ml-2" style="font-size: 1.1rem;">
                                ${{ number_format($post->fund->amount, 2) }}
                            </span>
                        </div>
                    @endif
                    @if($post->fund->description)
                        <p class="mb-3">{{ $post->fund->description }}</p>
                    @endif
                    @if($post->fund->donation_image)
                        <img src="{{ getMedia($post->fund->donation_image, 'image') }}" 
                             alt="Donation Image" 
                             class="img-fluid rounded shadow-sm" 
                             style="max-height: 300px;">
                    @endif
                </div>
            </div>
            @endif

            <!-- Parent Post (Shared Post) -->
            @if($post->parentPost)
            <div class="card shadow mb-4 border-left-info">
                <div class="card-header bg-light py-3">
                    <h6 class="m-0 font-weight-bold text-info">
                        <i class="fas fa-share mr-2"></i>Original Post
                    </h6>
                </div>
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="flex-grow-1">
                            <strong>User:</strong> {{ $post->parentPost->user->name ?? 'Unknown' }}
                        </div>
                        <a href="{{ route('admin.posts.show', $post->parentPost->id) }}" 
                           class="btn btn-sm btn-primary">
                            <i class="fas fa-eye mr-1"></i>View Original
                        </a>
                    </div>
                    @if($post->parentPost->post_text)
                        <p class="text-muted mb-0">{{ Str::limit($post->parentPost->post_text, 150) }}</p>
                    @endif
                </div>
            </div>
            @endif
        </div>
        
        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Post Information Card -->
            <div class="card shadow mb-4">
                <div class="card-header bg-primary text-white py-3">
                    <h6 class="m-0 font-weight-bold">
                        <i class="fas fa-info-circle mr-2"></i>Post Information
                    </h6>
                </div>
                <div class="card-body">
                    <!-- Statistics -->
                    <div class="row text-center mb-4">
                        <div class="col-4">
                            <div class="border-right">
                                <div class="h4 mb-0 text-primary">{{ $totalReactions ?? array_sum($reactionCounts) }}</div>
                                <small class="text-muted">Reactions</small>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="border-right">
                                <div class="h4 mb-0 text-info">{{ $commentCount ?? 0 }}</div>
                                <small class="text-muted">Comments</small>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="h4 mb-0 text-success">{{ $shareCount ?? 0 }}</div>
                            <small class="text-muted">Shares</small>
                        </div>
                    </div>

                    <hr>

                    <!-- Details -->
                    <div class="mb-3">
                        <small class="text-muted d-block mb-1">Post ID</small>
                        <strong>#{{ $post->id }}</strong>
                    </div>

                    <div class="mb-3">
                        <small class="text-muted d-block mb-1">Post Type</small>
                        @php
                            $postType = $post->post_type ?? 'post';
                            $postTypeDisplay = ucfirst(str_replace('_', ' ', $postType));
                        @endphp
                        <span class="badge badge-info">
                            {{ $postTypeDisplay }}
                        </span>
                    </div>

                    <div class="mb-3">
                        <small class="text-muted d-block mb-1">Privacy Level</small>
                        @php
                            $privacyLevels = [
                                1 => ['name' => 'Public', 'color' => 'success'],
                                2 => ['name' => 'Friends Only', 'color' => 'info'],
                                3 => ['name' => 'Private', 'color' => 'warning'],
                                4 => ['name' => 'Followers Only', 'color' => 'secondary']
                            ];
                            $privacyLevel = $post->privacy_level ?? 1;
                            $privacy = $privacyLevels[$privacyLevel] ?? ['name' => 'Unknown', 'color' => 'secondary'];
                        @endphp
                        <span class="badge badge-{{ $privacy['color'] }}">
                            {{ $privacy['name'] }}
                        </span>
                    </div>

                    @if($post->page)
                    <div class="mb-3">
                        <small class="text-muted d-block mb-1">Page</small>
                        <strong>{{ $post->page->name ?? 'Unknown' }}</strong>
                    </div>
                    @endif

                    @if($post->group)
                    <div class="mb-3">
                        <small class="text-muted d-block mb-1">Group</small>
                        <strong>{{ $post->group->name ?? 'Unknown' }}</strong>
                    </div>
                    @endif

                    @if($post->location)
                    <div class="mb-3">
                        <small class="text-muted d-block mb-1">
                            <i class="fas fa-map-marker-alt mr-1"></i>Location
                        </small>
                        <strong>{{ $post->location }}</strong>
                    </div>
                    @endif

                    @if($post->feeling)
                    <div class="mb-3">
                        <small class="text-muted d-block mb-1">
                            <i class="fas fa-smile mr-1"></i>Feeling
                        </small>
                        <strong>{{ $post->feeling }}</strong>
                    </div>
                    @endif

                    @if($post->background_color)
                    <div class="mb-3">
                        <small class="text-muted d-block mb-1">Background Color</small>
                        <div class="d-flex align-items-center">
                            <div style="width: 40px; height: 40px; background-color: {{ $post->background_color }}; border: 2px solid #ddd; border-radius: 4px; margin-right: 10px;"></div>
                            <code>{{ $post->background_color }}</code>
                        </div>
                    </div>
                    @endif

                    <div class="mb-3">
                        <small class="text-muted d-block mb-1">
                            <i class="fas fa-eye mr-1"></i>Views
                        </small>
                        <strong>{{ $post->views_count ?? 0 }}</strong>
                    </div>

                    @if($post->scheduled_at)
                    <div class="mb-3">
                        <small class="text-muted d-block mb-1">
                            <i class="fas fa-clock mr-1"></i>Scheduled At
                        </small>
                        <strong>{{ $post->scheduled_at->format('M d, Y H:i') }}</strong>
                    </div>
                    @endif

                    <hr>

                    <div class="mb-3">
                        <small class="text-muted d-block mb-1">Created</small>
                        <strong>{{ $post->created_at->format('M d, Y H:i') }}</strong>
                    </div>
                    
                    <div class="mb-3">
                        <small class="text-muted d-block mb-1">Last Updated</small>
                        <strong>{{ $post->updated_at->format('M d, Y H:i') }}</strong>
                    </div>

                    @if($post->ip_address)
                    <div class="mb-3">
                        <small class="text-muted d-block mb-1">IP Address</small>
                        <code class="small">{{ $post->ip_address }}</code>
                    </div>
                    @endif

                    @if($post->taggedUsers && $post->taggedUsers->count() > 0)
                    <div class="mb-3">
                        <small class="text-muted d-block mb-2">
                            <i class="fas fa-user-tag mr-1"></i>Tagged Users ({{ $post->taggedUsers->count() }})
                        </small>
                        <div class="d-flex flex-wrap">
                            @foreach($post->taggedUsers as $user)
                            <span class="badge badge-secondary mr-1 mb-1">
                                {{ $user->name ?? $user->username }}
                            </span>
                            @endforeach
                        </div>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Actions Card -->
            <div class="card shadow border-danger">
                <div class="card-header bg-danger text-white py-3">
                    <h6 class="m-0 font-weight-bold">
                        <i class="fas fa-exclamation-triangle mr-2"></i>Danger Zone
                    </h6>
                </div>
                <div class="card-body">
                    <p class="text-muted small mb-3">
                        Deleting this post will permanently remove it and all associated data. This action cannot be undone.
                    </p>
                    <form action="{{ route('admin.posts.destroy', $post->id) }}" 
                          method="POST" 
                          onsubmit="return confirm('Are you sure you want to delete this post? This action cannot be undone.');">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-block">
                            <i class="fas fa-trash mr-2"></i>Delete Post
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Image Modal -->
<div class="modal fade" id="imageModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Image Preview</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body text-center">
                <img id="modalImage" src="" class="img-fluid" alt="Preview">
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
function openImageModal(imageSrc) {
    document.getElementById('modalImage').src = imageSrc;
    $('#imageModal').modal('show');
}
</script>
@endsection

@section('styles')
<style>
.badge-lg {
    font-size: 0.9rem;
    padding: 0.5rem 0.75rem;
}

.border-left-primary {
    border-left: 4px solid #4e73df !important;
}

.border-left-info {
    border-left: 4px solid #36b9cc !important;
}

.border-left-warning {
    border-left: 4px solid #f6c23e !important;
}

.border-left-success {
    border-left: 4px solid #1cc88a !important;
}

.post-content-text, .shared-text-content {
    word-wrap: break-word;
    white-space: pre-wrap;
}

.card-img-top {
    transition: transform 0.2s;
}

.card-img-top:hover {
    transform: scale(1.02);
}

.list-group-item {
    border: 1px solid #e3e6f0;
    margin-bottom: 0.5rem;
    border-radius: 0.35rem;
}

.border-right {
    border-right: 1px solid #e3e6f0 !important;
}

@media (max-width: 768px) {
    .border-right {
        border-right: none !important;
        border-bottom: 1px solid #e3e6f0;
        padding-bottom: 1rem;
        margin-bottom: 1rem;
    }
}
</style>
@endsection
