@extends('admin.layouts.home')

@section('title', __('Manage Posts'))

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">{{ __('Manage Posts') }}</h1>
    </div>

    <!-- Post List Card -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">{{ __('Posts List') }}</h6>
            <div>
                <form action="{{ route('admin.posts.index') }}" method="GET" class="d-inline-flex">
                    <div class="input-group">
                        <select name="post_type" class="form-control me-2" style="max-width: 150px;">
                            <option value="">All Types</option>
                            <option value="post" {{ request('post_type') == 'post' ? 'selected' : '' }}>Post</option>
                            <option value="page_post" {{ request('post_type') == 'page_post' ? 'selected' : '' }}>Page Post</option>
                            <option value="group_post" {{ request('post_type') == 'group_post' ? 'selected' : '' }}>Group Post</option>
                            <option value="event" {{ request('post_type') == 'event' ? 'selected' : '' }}>Event</option>
                            <option value="product" {{ request('post_type') == 'product' ? 'selected' : '' }}>Product</option>
                            <option value="offer" {{ request('post_type') == 'offer' ? 'selected' : '' }}>Offer</option>
                            <option value="job" {{ request('post_type') == 'job' ? 'selected' : '' }}>Job</option>
                            <option value="poll" {{ request('post_type') == 'poll' ? 'selected' : '' }}>Poll</option>
                            <option value="donation" {{ request('post_type') == 'donation' ? 'selected' : '' }}>Donation</option>
                            <option value="reel" {{ request('post_type') == 'reel' ? 'selected' : '' }}>Reel</option>
                            <option value="shared_post" {{ request('post_type') == 'shared_post' ? 'selected' : '' }}>Shared Post</option>
                        </select>
                        <input type="text" class="form-control" name="search" placeholder="{{ __('Search posts...') }}" value="{{ request('search') }}">
                        <div class="input-group-append">
                            <button class="btn btn-primary" type="submit">
                                <i class="bi bi-search"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="card-body">
            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif

            @if(session('error'))
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
            @endif

            <div class="table-responsive">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>{{ __('ID') }}</th>
                            <th>{{ __('Post Type') }}</th>
                            <th>{{ __('Text Preview') }}</th>
                            <th>{{ __('User') }}</th>
                            <th>{{ __('Created') }}</th>
                            <th>{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($posts as $post)
                        <tr>
                            <td>{{ $post->id }}</td>
                            <td>
                                <span class="badge bg-info">{{ ucfirst(str_replace('_', ' ', $post->post_type ?? 'post')) }}</span>
                            </td>
                            <td>
                                @if($post->post_text)
                                    {{ Str::limit(strip_tags($post->post_text), 20) }}
                                @else
                                    <span class="text-muted">{{ __('No text') }}</span>
                                @endif
                            </td>
                            <td>
                                @if($post->user)
                                    {{ $post->user->name ?? $post->user->username ?? 'Unknown' }}
                                @else
                                    <span class="text-muted">{{ __('Unknown') }}</span>
                                @endif
                            </td>
                            <td>{{ $post->created_at->format('M d, Y H:i') }}</td>
                            <td>
                                <a href="{{ route('admin.posts.show', $post->id) }}" class="btn btn-sm btn-primary" title="{{ __('View') }}">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <form action="{{ route('admin.posts.destroy', $post->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('{{ __('Are you sure you want to delete this post?') }}')" title="{{ __('Delete') }}">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="6" class="text-center">{{ __('No posts found') }}</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-3">
                {{ $posts->links('pagination::bootstrap-5') }}
            </div>
        </div>
    </div>
</div>
@endsection

