@extends('admin.layouts.home')

@section('title', 'Featured Pages')

@section('content')
<style>
    .active-badge{
        position: absolute;
        top: 10px;
        right: 10px;
    }

    .card-title a{
        text-decoration: none;
    }

    .featured{
        position: absolute;
        top: 10px;
        left: 10px;
        color: white;
        font-size: 20px;
        border: none;
        background: none;
        cursor: pointer;
        background-color: none !important;
    }

    .featured:hover, .featured:active{
        border: none;
        background: none;
        cursor: pointer;
        background-color: none !important;
        color: important;
    }

    .featured.active, .featured:hover{
        color: #ffc107 !important;
    }

    .btn-del{
        position: absolute;
        bottom: 10px;
        right: 10px;
        color: white;
    }
</style>
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Featured Pages</h1>
        <div>
            <a href="{{ route('admin.pages.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
                <i class="fas fa-arrow-left fa-sm text-white-50"></i> Back to All Pages
            </a>
        </div>
    </div>
    
    <!-- Info Card -->
    <div class="card mb-4 border-left-warning">
        <div class="card-body">
            <h5 class="mb-2"><i class="fas fa-star text-warning"></i> Featured Pages</h5>
            <p class="mb-0">
                Featured pages are displayed prominently throughout the application. They appear in the "Featured Pages" section on the home page and discovery feeds.
                To add or remove a page from the featured list, go to the page details page or use the toggle button below.
            </p>
        </div>
    </div>
    
    <!-- Featured Pages -->
    @if($featuredPages->isEmpty())
        <div class="alert alert-info text-center py-4">
            <i class="fas fa-info-circle fa-2x mb-3"></i>
            <h4>No Featured Pages</h4>
            <p>You haven't featured any pages yet. Go to the Pages list and click the star icon to feature a page.</p>
            <a href="{{ route('admin.pages.index') }}" class="btn btn-primary mt-2">
                <i class="fas fa-list"></i> Go to Pages List
            </a>
        </div>
    @else
        <div class="row">
            @foreach($featuredPages as $page)
            <div class="col-xl-3 col-lg-4 col-md-6 mb-4">
                <div class="card shadow h-100 page-card position-relative">
                        <div class="position-relative">
                            <img src="{{ getMedia($page->cover_photo) }}" class="card-img-top" alt="{{ $page->page_title }}" style="height: 150px; object-fit: cover;">
                            <form action="{{ route('admin.pages.destroy', $page->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm text-danger btn-del" title="Delete" onclick="return confirm('Are you sure you want to delete this page?')">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                        <span class="badge bg-{{ $page->active ? 'success' : 'danger' }} active-badge">
                            {{ $page->active ? 'Active' : 'Inactive' }}
                        </span>
                        
                        <form action="{{ route('admin.pages.toggle-featured', $page->id) }}" method="POST" class="d-inline">
                            @csrf
                                <button type="submit" class="featured btn btn-sm {{ $page->is_featured ? 'active' : '' }}" title="{{ $page->is_featured ? 'Remove from featured' : 'Add to featured' }}"><i class="fa fa-star"></i></button>
                        </form>
                    <div class="card-body">
                        <h5 class="card-title">
                            <a href="{{ route('admin.pages.show', $page->id) }}">{{ $page->page_title }}</a>
                        </h5>
                        <p class="card-text small text-muted">{{ Str::limit($page->description, 50) }}</p>
                        
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            @if($page->category)
                                <span class="badge bg-info">{{ $page->category->name }}</span>
                            @else
                                <span class="badge bg-secondary">Uncategorized</span>
                            @endif
                        </div>
                        
                        <div class="d-flex justify-content-between align-items-center">
                            <small class="text-muted">{{ $page->created_at->format('M d, Y') }}</small>
                            <span class="badge bg-{{ $page->is_featured ? 'warning' : 'secondary' }}">
                                {{ $page->is_featured ? 'Featured' : 'Unfeatured' }}
                            </span>
                        </div>
                    </div>
                    
                    <div class="card-footer bg-white">
                        <div class="btn-group d-flex w-100">
                            <a href="{{ route('admin.pages.edit', $page->id) }}" class="btn btn-sm btn-primary" title="Edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            
                            {{-- <form action="{{ route('admin.pages.update-status', $page->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('PUT')
                                <input type="hidden" name="active" value="{{ $page->active ? 0 : 1 }}">
                                <button type="submit" class="btn btn-sm btn-{{ $page->active ? 'success' : 'danger' }}" title="{{ $page->active ? 'Deactivate' : 'Activate' }}">
                                    <i class="fas fa-{{ $page->active ? 'check' : 'times' }}"></i>
                                </button>
                            </form> --}}
                            
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        
        <!-- Pagination -->
        <div class="row">
            <div class="col-12">
                {{ $featuredPages->links('pagination::bootstrap-5') }}
            </div>
        </div>
    @endif

    <!-- Suggestions Card -->
    {{-- @if($suggestedPages->isNotEmpty())
        <div class="card shadow mb-4 mt-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Suggested Pages to Feature</h6>
            </div>
            <div class="card-body">
                <p>These pages are popular and might be good candidates for featuring:</p>
                
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Page Name</th>
                                <th>Likes</th>
                                <th>Category</th>
                                <th>Creator</th>
                                <th>Created On</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($suggestedPages as $page)
                                <tr>
                                    <td>
                                        <a href="{{ route('admin.pages.show', $page->id) }}">
                                            {{ $page->name }}
                                        </a>
                                    </td>
                                    <td>{{ $page->likes_count }}</td>
                                    <td>
                                        @if($page->category)
                                            <span class="badge bg-info">
                                                {{ $page->category->name }}
                                            </span>
                                        @else
                                            <span class="badge bg-secondary">
                                                Uncategorized
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($page->creator)
                                            <a href="{{ url('admin/users', $page->creator->id) }}">
                                                {{ $page->creator->name }}
                                            </a>
                                        @else
                                            <span class="text-muted">Unknown</span>
                                        @endif
                                    </td>
                                    <td>{{ $page->created_at->format('M d, Y') }}</td>
                                    <td>
                                        <form action="{{ route('admin.pages.toggle-featured', $page->id) }}" method="POST">
                                            @csrf
                                            <button type="submit" class="btn btn-sm btn-outline-warning">
                                                <i class="far fa-star"></i> Feature
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    @endif --}}
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Any custom scripts for this page
    });
</script>
@endsection 