@extends('admin.layouts.home')

@section('title', 'Packages')

@section('content')
<div class="container-fluid p-0">
    <div class="content-wrapper p-3">
        <!-- Page Header with Breadcrumbs -->
        <div class="content-header mb-4">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="card bg-primary text-white mb-3">
                            <div class="card-body py-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-lg rounded-circle bg-white text-primary me-3">
                                        <i class="bi bi-box fs-1"></i>
                                    </div>
                                    <div>
                                        <h1 class="m-0 fw-bold">Packages</h1>
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb mb-0 text-white-50">
                                                <li class="breadcrumb-item">
                                                    <i class="bi bi-speedometer2 me-1"></i>
                                                    <a href="{{ url('/admin') }}" class="text-white-50">Dashboard</a>
                                                </li>
                                                <li class="breadcrumb-item active text-white" aria-current="page">Packages</li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Packages Table -->
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-end mb-3">
                    <a href="{{ route('admin.packages.create') }}" class="btn btn-primary">
                        <i class="bi bi-plus-circle me-1"></i> Create Package
                    </a>
                </div>
                <div class="table-responsive">
                    
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                             
                                <th>Name</th>
                                <th>Price</th>
                                <th>Duration</th>
                                <th>Status</th>
                                <th>Created At</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($packages as $package)
                                <tr>
                                    
                                    <td>
                                        <span >{{ $package->name }}</span>
                                    </td>
                                    <td>{{ number_format($package->package_price, 2) }}</td>
                                    <td>{{ ucfirst($package->duration) }}</td>
                                    <td>
                                        @if($package->status === 'active')
                                            <span class="badge bg-success">Active</span>
                                        @else
                                            <span class="badge bg-danger">Inactive</span>
                                        @endif
                                    </td>
                                    <td>{{ $package->created_at->format('Y-m-d H:i:s') }}</td>
                                    <td>
                                        <a href="{{ route('admin.packages.edit', $package->id) }}" class="btn btn-primary">
                                            <i class="bi bi-pencil-square me-1"></i> Edit
                                        </a>
                                        <a href="{{ route('admin.packages.destroy', $package->id) }}" class="btn btn-danger">
                                            <i class="bi bi-trash me-1"></i> Delete
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="text-center">No packages found</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="mt-3">
                    {{ $packages->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
