@extends('admin.layouts.home')

@section('title', 'Movies')

@section('content')

<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">Manage Movies</h1>
        <a href="{{ route('admin.movies.create') }}" class="btn btn-primary">
            <i class="fas fa-plus-circle mr-1"></i> Add New Movie
        </a>
    </div>

    <!-- Movie List Card -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">Movies List</h6>
            <div>
                <form action="{{ route('admin.movies.index') }}" method="GET" class="d-inline-flex">
                    <div class="input-group">
                        <input type="text" class="form-control" name="search" placeholder="Search movies..." value="{{ request('search') }}">
                        <div class="input-group-append">
                            <button class="btn btn-primary" type="submit">
                                <i class="fas fa-search fa-sm"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="card-body">
            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif

            <div class="table-responsive">
                <table class="table table-bordered" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th width="60">ID</th>
                            <th width="80">Poster</th>
                            <th>Title</th>
                            <th>Genre</th>
                            <th>Release Year</th>
                            <th>Duration</th>
                            <th>Status</th>
                            <th>Featured</th>
                            <th>Views</th>
                            <th width="120">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if($movies->isEmpty())
                        <tr>
                            <td colspan="10" class="text-center">No movies found</td>
                        </tr>
                        @else
                        @foreach($movies as $movie)
                        <tr>
                            <td>{{ $movie->id }}</td>
                            <td>
                                @if($movie->poster_url)
                                <img src="{{ $movie->poster_url }}" alt="{{ $movie->title }}" class="img-thumbnail" width="50">
                                @else
                                <div class="bg-light text-center p-2">
                                    <i class="fas fa-film text-secondary"></i>
                                </div>
                                @endif
                            </td>
                            <td>{{ $movie->title }}</td>
                            <td>{{ $movie->genre->name }}</td>
                            <td>{{ $movie->release_year }}</td>
                            <td>{{ $movie->duration }} min</td>
                            <td>
                                @if($movie->is_active)
                                <span class="badge text-bg-success">Active</span>
                                @else
                                <span class="badge text-bg-secondary">Inactive</span>

                                @endif
                            </td>
                            <td>
                                @if($movie->featured)
                                <span class="badge text-bg-warning">Featured</span>
                                @else
                                <span class="badge text-bg-light">No</span>
                                @endif
                            </td>
                            <td>{{ number_format($movie->views_count) }}</td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="{{ route('admin.movies.edit', $movie) }}" class="btn btn-sm btn-primary">
                                        <i class="bi bi-pencil-square"></i> <!-- Bootstrap Edit Icon -->
                                    </a>
                                    <a href="{{ route('movies.show', $movie->slug) }}" class="btn btn-sm btn-info" target="_blank">
                                        <i class="bi bi-eye"></i> <!-- Bootstrap Eye Icon -->
                                    </a>
                                    <form action="{{ route('admin.movies.destroy', $movie) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this movie?')">
                                            <i class="bi bi-trash"></i> <!-- Bootstrap Trash Icon -->
                                        </button>
                                    </form>
                                </div>
                            </td>

                        </tr>
                        @endforeach
                        @endif
                    </tbody>
                </table>
            </div>

            <div class="mt-3">
                {{ $movies->links('pagination::bootstrap-5') }}
            </div>
        </div>
    </div>
</div>
@endsection