@extends('admin.layouts.home')

@section('title', 'Stores Management')

@section('styles')
<style>
    .store-card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        border-radius: 10px;
        overflow: hidden;
    }
    
    .store-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
    }
    
    .store-logo {
        width: 60px;
        height: 60px;
        object-fit: cover;
        border-radius: 8px;
    }
    
    .status-badge {
        padding: 5px 10px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 500;
    }
    
    .filter-card {
        border-radius: 10px;
        margin-bottom: 20px;
    }
    
    .action-btn {
        width: 32px;
        height: 32px;
        border-radius: 50%;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s ease;
    }
    
    .action-btn:hover {
        transform: translateY(-2px);
    }
    
    .store-stats {
        display: flex;
        gap: 15px;
    }
    
    .store-stat-item {
        display: flex;
        align-items: center;
    }
    
    .store-stat-icon {
        width: 30px;
        height: 30px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 8px;
    }
</style>
@endsection

@section('content')
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="mt-4">Stores Management</h1>
        <div>
            <a href="{{ route('admin.marketplace.dashboard') }}" class="btn btn-outline-primary me-2">
                <i class="fas fa-chart-line me-1"></i> Dashboard
            </a>
        </div>
    </div>
    
    <!-- Filter Card -->
    <div class="card filter-card mb-4">
        <div class="card-header bg-light">
            <i class="fas fa-filter me-1"></i> Filter Stores
        </div>
        <div class="card-body">
            <form action="{{ route('admin.marketplace.stores') }}" method="GET" class="row g-3">
                <div class="col-md-3">
                    <label for="status" class="form-label">Status</label>
                    <select class="form-select" id="status" name="status">
                        <option value="">All Status</option>
                        <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                        <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                        <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                    </select>
                </div>
                
                <div class="col-md-3">
                    <label for="order_by" class="form-label">Order By</label>
                    <select class="form-select" id="order_by" name="order_by">
                        <option value="created_at" {{ request('order_by') == 'created_at' ? 'selected' : '' }}>Date Created</option>
                        <option value="name" {{ request('order_by') == 'name' ? 'selected' : '' }}>Name</option>
                        <option value="products_count" {{ request('order_by') == 'products_count' ? 'selected' : '' }}>Products Count</option>
                    </select>
                </div>
                
                <div class="col-md-2">
                    <label for="order_direction" class="form-label">Direction</label>
                    <select class="form-select" id="order_direction" name="order_direction">
                        <option value="desc" {{ request('order_direction') == 'desc' ? 'selected' : '' }}>Descending</option>
                        <option value="asc" {{ request('order_direction') == 'asc' ? 'selected' : '' }}>Ascending</option>
                    </select>
                </div>
                
                <div class="col-md-4">
                    <label for="search" class="form-label">Search</label>
                    <input type="text" class="form-control" id="search" name="search" value="{{ request('search') }}" placeholder="Search by store name or description...">
                </div>
                
                <div class="col-md-12 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">
                        <i class="fas fa-search me-1"></i> Apply Filters
                    </button>
                    <a href="{{ route('admin.marketplace.stores') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-redo me-1"></i> Reset
                    </a>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Stores Table -->
    <div class="card mb-4">
        <div class="card-header">
            <i class="fas fa-store me-1"></i>
            Stores List
            <span class="badge bg-primary ms-2">{{ $stores->total() }} Stores</span>
        </div>
        <div class="card-body">
            @if($stores->isEmpty())
                <div class="alert alert-info">
                    No stores found. Try adjusting your filters.
                </div>
            @else
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Store</th>
                                <th>Owner</th>
                                <th>Products</th>
                                <th>Status</th>
                                <th>Created</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($stores as $store)
                                <tr>
                                    <td>{{ $store->id }}</td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            @if($store->logo)
                                                <img src="{{ asset('storage/' . $store->logo) }}" alt="{{ $store->name }}" class="store-logo me-2">
                                            @else
                                                <div class="store-logo bg-light d-flex align-items-center justify-content-center me-2">
                                                    <i class="fas fa-store text-secondary"></i>
                                                </div>
                                            @endif
                                            <div>
                                                <div class="fw-bold">{{ $store->name }}</div>
                                                <div class="small text-muted">{{ Str::limit($store->description, 50) }}</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        @if($store->owner)
                                            <a href="#" class="text-decoration-none">
                                                {{ $store->owner->name }}
                                            </a>
                                        @else
                                            <span class="text-muted">No owner</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="store-stats">
                                            <div class="store-stat-item">
                                                <div class="store-stat-icon bg-light text-primary">
                                                    <i class="fas fa-box"></i>
                                                </div>
                                                <span>{{ $store->products_count ?? 0 }}</span>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        @php
                                            $statusClass = [
                                                'active' => 'bg-success',
                                                'inactive' => 'bg-danger',
                                                'pending' => 'bg-warning text-dark',
                                            ][$store->status] ?? 'bg-secondary';
                                        @endphp
                                        <span class="status-badge {{ $statusClass }}">
                                            {{ ucfirst($store->status) }}
                                        </span>
                                    </td>
                                    <td>{{ $store->created_at->format('M d, Y') }}</td>
                                    <td>
                                        <div class="d-flex">
                                            <a href="{{ route('admin.marketplace.stores.show', $store->id) }}" class="btn btn-sm btn-info action-btn me-1" title="View Details">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            
                                            <button type="button" class="btn btn-sm btn-warning action-btn me-1" title="Update Status" data-bs-toggle="modal" data-bs-target="#statusModal{{ $store->id }}">
                                                <i class="fas fa-sync-alt"></i>
                                            </button>
                                            
                                            <!-- Status Modal -->
                                            <div class="modal fade" id="statusModal{{ $store->id }}" tabindex="-1" aria-labelledby="statusModalLabel{{ $store->id }}" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="statusModalLabel{{ $store->id }}">Update Store Status</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <form action="{{ route('admin.marketplace.stores.update-status', $store->id) }}" method="POST">
                                                            @csrf
                                                            <div class="modal-body">
                                                                <p>Update status for <strong>{{ $store->name }}</strong>:</p>
                                                                <div class="form-check mb-2">
                                                                    <input class="form-check-input" type="radio" name="status" id="statusActive{{ $store->id }}" value="active" {{ $store->status == 'active' ? 'checked' : '' }}>
                                                                    <label class="form-check-label" for="statusActive{{ $store->id }}">
                                                                        Active
                                                                    </label>
                                                                </div>
                                                                <div class="form-check mb-2">
                                                                    <input class="form-check-input" type="radio" name="status" id="statusInactive{{ $store->id }}" value="inactive" {{ $store->status == 'inactive' ? 'checked' : '' }}>
                                                                    <label class="form-check-label" for="statusInactive{{ $store->id }}">
                                                                        Inactive
                                                                    </label>
                                                                </div>
                                                                <div class="form-check">
                                                                    <input class="form-check-input" type="radio" name="status" id="statusPending{{ $store->id }}" value="pending" {{ $store->status == 'pending' ? 'checked' : '' }}>
                                                                    <label class="form-check-label" for="statusPending{{ $store->id }}">
                                                                        Pending
                                                                    </label>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                                <button type="submit" class="btn btn-primary">Update Status</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="d-flex justify-content-center mt-4">
                    {{ $stores->appends(request()->query())->links('pagination::bootstrap-5') }}
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize any JavaScript functionality here
    });
</script>
@endsection 