@extends('admin.layouts.home')

@section('title', 'Store Details')

@section('styles')
<style>
    .store-banner-container {
        position: relative;
        overflow: hidden;
        border-radius: 10px;
        height: 200px;
    }
    
    .store-banner {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }
    
    .store-logo {
        width: 100px;
        height: 100px;
        object-fit: cover;
        border-radius: 10px;
        border: 4px solid white;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        margin-top: -50px;
        position: relative;
        background-color: white;
    }
    
    .status-badge {
        padding: 5px 10px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 500;
    }
    
    .detail-card {
        border-radius: 10px;
        overflow: hidden;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    
    .detail-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
    }
    
    .stat-card {
        border-radius: 10px;
        overflow: hidden;
        transition: all 0.3s ease;
    }
    
    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
    }
    
    .stat-icon {
        width: 50px;
        height: 50px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .product-card {
        border-radius: 10px;
        overflow: hidden;
        transition: all 0.3s ease;
    }
    
    .product-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
    }
    
    .product-image {
        height: 150px;
        object-fit: cover;
    }
    
    .nav-tabs .nav-link {
        border: none;
        border-bottom: 3px solid transparent;
        color: #6c757d;
    }
    
    .nav-tabs .nav-link.active {
        border-bottom: 3px solid #0d6efd;
        color: #0d6efd;
        background: transparent;
    }
    
    .rating-stars {
        color: #ffc107;
    }
</style>
@endsection

@section('content')
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="mt-4">Store Details</h1>
        <div>
            <a href="{{ route('admin.marketplace.stores') }}" class="btn btn-outline-primary">
                <i class="fas fa-arrow-left me-1"></i> Back to Stores
            </a>
        </div>
    </div>
    
    <!-- Store Header -->
    <div class="card detail-card mb-4">
        <div class="card-body p-0">
            <div class="store-banner-container">
                @if($store->banner)
                    <img src="{{ asset('storage/' . $store->banner) }}" alt="{{ $store->name }} banner" class="store-banner">
                @else
                    <div class="d-flex align-items-center justify-content-center h-100 bg-light">
                        <i class="fas fa-image fa-3x text-secondary"></i>
                    </div>
                @endif
            </div>
            
            <div class="px-4 pb-4">
                <div class="d-flex align-items-end">
                    @if($store->logo)
                        <img src="{{ asset('storage/' . $store->logo) }}" alt="{{ $store->name }} logo" class="store-logo me-3">
                    @else
                        <div class="store-logo d-flex align-items-center justify-content-center me-3">
                            <i class="fas fa-store fa-3x text-secondary"></i>
                        </div>
                    @endif
                    
                    <div class="mt-3">
                        <div class="d-flex align-items-center">
                            <h2 class="mb-0 me-2">{{ $store->name }}</h2>
                            @php
                                $statusClass = [
                                    'active' => 'bg-success',
                                    'inactive' => 'bg-danger',
                                    'pending' => 'bg-warning text-dark',
                                ][$store->status] ?? 'bg-secondary';
                            @endphp
                            <span class="status-badge {{ $statusClass }}">
                                {{ ucfirst($store->status) }}
                            </span>
                        </div>
                        <p class="text-muted mb-0">{{ $store->tagline ?? 'No tagline available' }}</p>
                    </div>
                    
                    <div class="ms-auto">
                        <button type="button" class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#statusModal">
                            <i class="fas fa-sync-alt me-1"></i> Update Status
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Store Stats -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card stat-card h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="stat-icon bg-primary-subtle text-primary me-3">
                        <i class="fas fa-box fa-2x"></i>
                    </div>
                    <div>
                        <div class="small text-muted">Total Products</div>
                        <h5 class="mb-0">{{ $store->products_count }}</h5>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card stat-card h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="stat-icon bg-success-subtle text-success me-3">
                        <i class="fas fa-shopping-cart fa-2x"></i>
                    </div>
                    <div>
                        <div class="small text-muted">Total Orders</div>
                        <h5 class="mb-0">{{ $totalOrders }}</h5>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card stat-card h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="stat-icon bg-warning-subtle text-warning me-3">
                        <i class="fas fa-dollar-sign fa-2x"></i>
                    </div>
                    <div>
                        <div class="small text-muted">Total Sales</div>
                        <h5 class="mb-0">${{ number_format($totalSales, 2) }}</h5>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card stat-card h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="stat-icon bg-info-subtle text-info me-3">
                        <i class="fas fa-star fa-2x"></i>
                    </div>
                    <div>
                        <div class="small text-muted">Average Rating</div>
                        <h5 class="mb-0">
                            @if($averageRating)
                                <span class="rating-stars">
                                    @for($i = 1; $i <= 5; $i++)
                                        @if($i <= round($averageRating))
                                            <i class="fas fa-star"></i>
                                        @else
                                            <i class="far fa-star"></i>
                                        @endif
                                    @endfor
                                </span>
                                <span class="ms-2">{{ number_format($averageRating, 1) }}</span>
                            @else
                                <span class="text-muted">No ratings yet</span>
                            @endif
                        </h5>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="row">
        <!-- Store Info -->
        <div class="col-lg-4 mb-4">
            <div class="card detail-card h-100">
                <div class="card-header">
                    <i class="fas fa-info-circle me-1"></i>
                    Store Information
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <h6 class="text-muted">Description</h6>
                        <p>{{ $store->description ?? 'No description available.' }}</p>
                    </div>
                    
                    <div class="mb-3">
                        <h6 class="text-muted">Owner</h6>
                        @if($store->owner)
                            <div class="d-flex align-items-center">
                                @if($store->owner->avatar)
                                    <img src="{{ asset('storage/' . $store->owner->avatar) }}" alt="{{ $store->owner->name }}" class="rounded-circle me-2" style="width: 40px; height: 40px; object-fit: cover;">
                                @else
                                    <div class="rounded-circle bg-light d-flex align-items-center justify-content-center me-2" style="width: 40px; height: 40px;">
                                        <i class="fas fa-user text-secondary"></i>
                                    </div>
                                @endif
                                <div>
                                    <div>{{ $store->owner->name }}</div>
                                    <div class="small text-muted">{{ $store->owner->email }}</div>
                                </div>
                            </div>
                        @else
                            <p class="text-muted">No owner assigned</p>
                        @endif
                    </div>
                    
                    <div class="mb-3">
                        <h6 class="text-muted">Contact Information</h6>
                        <ul class="list-unstyled">
                            @if($store->email)
                                <li class="mb-2">
                                    <i class="fas fa-envelope me-2 text-muted"></i>
                                    <a href="mailto:{{ $store->email }}">{{ $store->email }}</a>
                                </li>
                            @endif
                            
                            @if($store->phone)
                                <li class="mb-2">
                                    <i class="fas fa-phone me-2 text-muted"></i>
                                    <a href="tel:{{ $store->phone }}">{{ $store->phone }}</a>
                                </li>
                            @endif
                            
                            @if($store->website)
                                <li class="mb-2">
                                    <i class="fas fa-globe me-2 text-muted"></i>
                                    <a href="{{ $store->website }}" target="_blank">{{ $store->website }}</a>
                                </li>
                            @endif
                            
                            @if($store->address)
                                <li>
                                    <i class="fas fa-map-marker-alt me-2 text-muted"></i>
                                    {{ $store->address }}
                                </li>
                            @endif
                        </ul>
                    </div>
                    
                    <div>
                        <h6 class="text-muted">Store Details</h6>
                        <ul class="list-unstyled">
                            <li class="mb-2">
                                <span class="text-muted">Created:</span>
                                {{ $store->created_at->format('M d, Y') }}
                            </li>
                            <li>
                                <span class="text-muted">Last Updated:</span>
                                {{ $store->updated_at->format('M d, Y') }}
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Store Products -->
        <div class="col-lg-8 mb-4">
            <div class="card detail-card h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div>
                        <i class="fas fa-box me-1"></i>
                        Store Products
                    </div>
                    <a href="{{ route('admin.marketplace.products', ['store' => $store->id]) }}" class="btn btn-sm btn-primary">
                        View All Products
                    </a>
                </div>
                <div class="card-body">
                    @if($store->products->isEmpty())
                        <div class="alert alert-info">
                            This store has no products yet.
                        </div>
                    @else
                        <div class="row">
                            @foreach($store->products->take(6) as $product)
                                <div class="col-md-4 mb-4">
                                    <div class="card product-card h-100">
                                        @if($product->thumbnail)
                                            <img src="{{ asset('storage/' . $product->thumbnail) }}" alt="{{ $product->name }}" class="product-image">
                                        @else
                                            <div class="product-image bg-light d-flex align-items-center justify-content-center">
                                                <i class="fas fa-box fa-2x text-secondary"></i>
                                            </div>
                                        @endif
                                        
                                        <div class="card-body">
                                            <h6 class="card-title">{{ Str::limit($product->name, 30) }}</h6>
                                            <p class="card-text text-primary mb-1">${{ number_format($product->price, 2) }}</p>
                                            
                                            @php
                                                $statusClass = [
                                                    'active' => 'bg-success',
                                                    'inactive' => 'bg-danger',
                                                    'pending' => 'bg-warning text-dark',
                                                ][$product->status] ?? 'bg-secondary';
                                            @endphp
                                            <span class="status-badge {{ $statusClass }} mb-2 d-inline-block">
                                                {{ ucfirst($product->status) }}
                                            </span>
                                            
                                            <a href="{{ route('admin.marketplace.products.show', $product->id) }}" class="btn btn-sm btn-outline-primary w-100">View Details</a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        
                        @if($store->products->count() > 6)
                            <div class="text-center mt-3">
                                <a href="{{ route('admin.marketplace.products', ['store' => $store->id]) }}" class="btn btn-outline-primary">
                                    View All {{ $store->products->count() }} Products
                                </a>
                            </div>
                        @endif
                    @endif
                </div>
            </div>
        </div>
    </div>
    
    <!-- Status Modal -->
    <div class="modal fade" id="statusModal" tabindex="-1" aria-labelledby="statusModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="statusModalLabel">Update Store Status</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{ route('admin.marketplace.stores.update-status', $store->id) }}" method="POST">
                    @csrf
                    <div class="modal-body">
                        <p>Update status for <strong>{{ $store->name }}</strong>:</p>
                        <div class="form-check mb-2">
                            <input class="form-check-input" type="radio" name="status" id="statusActive" value="active" {{ $store->status == 'active' ? 'checked' : '' }}>
                            <label class="form-check-label" for="statusActive">
                                Active
                            </label>
                        </div>
                        <div class="form-check mb-2">
                            <input class="form-check-input" type="radio" name="status" id="statusInactive" value="inactive" {{ $store->status == 'inactive' ? 'checked' : '' }}>
                            <label class="form-check-label" for="statusInactive">
                                Inactive
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="status" id="statusPending" value="pending" {{ $store->status == 'pending' ? 'checked' : '' }}>
                            <label class="form-check-label" for="statusPending">
                                Pending
                            </label>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Update Status</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection 