@extends('admin.layouts.home')

@section('title', 'Group Statistics')

@section('styles')
<style>
    .chart-container {
        position: relative;
        height: 300px;
    }
    .stat-card {
        border-radius: 0.5rem;
        box-shadow: 0 0.15rem 1.75rem rgba(0, 0, 0, 0.1) !important;
    }
    .stat-card-icon {
        font-size: 2rem;
        opacity: 0.3;
    }
    .group-row:hover {
        background-color: rgba(0, 0, 0, 0.03);
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Group Statistics</h1>
        <div>
            <a href="{{ route('admin.groups.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
                <i class="fas fa-arrow-left fa-sm text-white-50"></i> Back to Groups
            </a>
        </div>
    </div>

    <!-- Stats Overview Cards -->
    <div class="row">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card bg-primary text-white shadow stat-card h-100">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">Total Groups</div>
                            <div class="h1 mb-0 font-weight-bold">{{ $totalGroups }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-white stat-card-icon"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card bg-success text-white shadow stat-card h-100">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">Public Groups</div>
                            <div class="h1 mb-0 font-weight-bold">{{ $totalPublicGroups }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-globe fa-2x text-white stat-card-icon"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card bg-warning text-white shadow stat-card h-100">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">Private Groups</div>
                            <div class="h1 mb-0 font-weight-bold">{{ $totalPrivateGroups }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-lock fa-2x text-white stat-card-icon"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card bg-info text-white shadow stat-card h-100">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">Total Members</div>
                            <div class="h1 mb-0 font-weight-bold">{{ $totalMembers }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-friends fa-2x text-white stat-card-icon"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="row">
        <!-- Groups by Category Chart -->
        <div class="col-xl-6 mb-4">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Groups by Category</h6>
                </div>
                <div class="card-body">
                    <div class="chart-container">
                        <canvas id="groupsByCategoryChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Group Creation Trend Chart -->
        <div class="col-xl-6 mb-4">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Group Creation Trend (Last 12 Months)</h6>
                </div>
                <div class="card-body">
                    <div class="chart-container">
                        <canvas id="groupCreationTrendChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Group Rankings Row -->
    <div class="row">
        <!-- Most Active Groups -->
        <div class="col-xl-4 mb-4">
            <div class="card shadow h-100">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Most Active Groups</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm">
                            <thead>
                                <tr>
                                    <th>Group</th>
                                    <th>Posts</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($mostActiveGroups as $group)
                                <tr class="group-row">
                                    <td>
                                        <a href="{{ route('admin.groups.show', $group->id) }}">
                                            {{ $group->name }}
                                        </a>
                                    </td>
                                    <td>
                                        <span class="badge bg-primary">{{ $group->posts_count }} posts</span>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="2" class="text-center">No data available</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Largest Groups -->
        <div class="col-xl-4 mb-4">
            <div class="card shadow h-100">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Largest Groups</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm">
                            <thead>
                                <tr>
                                    <th>Group</th>
                                    <th>Members</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($largestGroups as $group)
                                <tr class="group-row">
                                    <td>
                                        <a href="{{ route('admin.groups.show', $group->id) }}">
                                            {{ $group->name }}
                                        </a>
                                    </td>
                                    <td>
                                        <span class="badge bg-success">{{ $group->members_count }} members</span>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="2" class="text-center">No data available</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Most Moderated Groups -->
        <div class="col-xl-4 mb-4">
            <div class="card shadow h-100">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Most Moderated Groups</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm">
                            <thead>
                                <tr>
                                    <th>Group</th>
                                    <th>Admins & Mods</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($mostModeratedGroups as $group)
                                <tr class="group-row">
                                    <td>
                                        <a href="{{ route('admin.groups.show', $group->id) }}">
                                            {{ $group->name }}
                                        </a>
                                    </td>
                                    <td>
                                        <span class="badge bg-info">{{ $group->moderators_count }} moderators</span>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="2" class="text-center">No data available</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Categories Breakdown -->
    <div class="row">
        <div class="col-12 mb-4">
            <div class="card shadow">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Category Breakdown</h6>
                    <a href="{{ route('admin.groups.categories') }}" class="btn btn-sm btn-primary">
                        <i class="fas fa-tags fa-sm text-white-50"></i> Manage Categories
                    </a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Category</th>
                                    <th>Total Groups</th>
                                    <th>Percentage</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php 
                                    $totalGroups = $totalGroups > 0 ? $totalGroups : 1; // Prevent division by zero
                                @endphp
                                
                                @forelse($groupsByCategory as $category)
                                <tr>
                                    <td>{{ $category->name }}</td>
                                    <td>{{ $category->groups_count }}</td>
                                    <td>
                                        <div class="progress" style="height: 20px;">
                                            <div class="progress-bar" role="progressbar" 
                                                style="width: {{ ($category->groups_count / $totalGroups) * 100 }}%;" 
                                                aria-valuenow="{{ ($category->groups_count / $totalGroups) * 100 }}" 
                                                aria-valuemin="0" 
                                                aria-valuemax="100">
                                                {{ number_format(($category->groups_count / $totalGroups) * 100, 1) }}%
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="3" class="text-center">No categories found</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Categories chart
        const categoryLabels = {!! $categoryLabels !!};
        const categoryCounts = {!! $categoryCounts !!};
        
        new Chart(
            document.getElementById('groupsByCategoryChart'),
            {
                type: 'doughnut',
                data: {
                    labels: categoryLabels,
                    datasets: [{
                        data: categoryCounts,
                        backgroundColor: [
                            '#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', '#e74a3b',
                            '#5a5c69', '#858796', '#f8f9fc', '#d1d3e2', '#a2a5af',
                            '#6c757d', '#343a40', '#007bff', '#6610f2', '#6f42c1'
                        ],
                        hoverOffset: 4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'right',
                        }
                    }
                }
            }
        );
        
        // Trend chart
        const trendLabels = {!! $trendLabels !!};
        const trendCounts = {!! $trendCounts !!};
        
        new Chart(
            document.getElementById('groupCreationTrendChart'),
            {
                type: 'line',
                data: {
                    labels: trendLabels,
                    datasets: [{
                        label: 'New Groups',
                        data: trendCounts,
                        fill: false,
                        borderColor: '#4e73df',
                        tension: 0.1
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                precision: 0
                            }
                        }
                    }
                }
            }
        );
    });
</script>
@endsection 