@extends('admin.layouts.home')

@section('title', 'Event Statistics')

@section('styles')
<style>
    .stat-card {
        transition: all 0.3s;
    }
    .stat-card:hover {
        transform: translateY(-5px);
    }
    .chart-container {
        position: relative;
        height: 300px;
        margin-bottom: 1rem;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Event Statistics</h1>
        <div>
            <a href="{{ route('admin.events.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
                <i class="fas fa-arrow-left fa-sm text-white-50"></i> Back to All Events
            </a>
            <a href="#" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm" id="downloadReport">
                <i class="fas fa-download fa-sm text-white-50"></i> Generate Report
            </a>
        </div>
    </div>

    <!-- Overview Stats -->
    <div class="row">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2 stat-card">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Events</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $totalEvents }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-calendar fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2 stat-card">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Upcoming Events</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $upcomingEvents }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-calendar-alt fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2 stat-card">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Featured Events</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $featuredEvents }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-star fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2 stat-card">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Total Attendees</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $totalAttendees }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row 1 -->
    <div class="row">
        <!-- Monthly Events Chart -->
        <div class="col-xl-8 col-lg-7">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Events by Month</h6>
                </div>
                <div class="card-body">
                    <div class="chart-container">
                        <canvas id="eventsByMonthChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Events by Day of Week -->
        <div class="col-xl-4 col-lg-5">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Events by Day of Week</h6>
                </div>
                <div class="card-body">
                    <div class="chart-container">
                        <canvas id="eventsByDayChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row 2 -->
    <div class="row">
        <!-- Top Events by Attendees -->
        <div class="col-xl-6 col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Top Events by Attendees</h6>
                </div>
                <div class="card-body">
                    <div class="chart-container">
                        <canvas id="topEventsByAttendeesChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Top Events by Interests -->
        <div class="col-xl-6 col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Top Events by Interests</h6>
                </div>
                <div class="card-body">
                    <div class="chart-container">
                        <canvas id="topEventsByInterestsChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Event Engagement Stats -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Event Engagement</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 col-lg-3 mb-4">
                            <div class="card bg-light">
                                <div class="card-body text-center">
                                    <h5 class="text-primary">Total Attendees</h5>
                                    <h2 class="display-4">{{ $totalAttendees }}</h2>
                                    <p class="text-muted">Users who have confirmed attending events</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-3 mb-4">
                            <div class="card bg-light">
                                <div class="card-body text-center">
                                    <h5 class="text-primary">Total Interests</h5>
                                    <h2 class="display-4">{{ $totalInterests }}</h2>
                                    <p class="text-muted">Users who have expressed interest in events</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-3 mb-4">
                            <div class="card bg-light">
                                <div class="card-body text-center">
                                    <h5 class="text-primary">Average Attendees</h5>
                                    <h2 class="display-4">{{ $totalEvents > 0 ? round($totalAttendees / $totalEvents, 1) : 0 }}</h2>
                                    <p class="text-muted">Average attendees per event</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-3 mb-4">
                            <div class="card bg-light">
                                <div class="card-body text-center">
                                    <h5 class="text-primary">Average Interests</h5>
                                    <h2 class="display-4">{{ $totalEvents > 0 ? round($totalInterests / $totalEvents, 1) : 0 }}</h2>
                                    <p class="text-muted">Average interests per event</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Top Events Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Top Events</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="topEventsTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>Event Name</th>
                            <th>Date</th>
                            <th>Location</th>
                            <th>Attendees</th>
                            <th>Interests</th>
                            <th>Creator</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($topEvents as $event)
                        <tr>
                            <td>
                                <a href="{{ route('admin.events.show', $event->id) }}">
                                    {{ $event->title }}
                                </a>
                            </td>
                            <td>{{ \Carbon\Carbon::parse($event->event_date)->format('M d, Y') }}</td>
                            <td>{{ Str::limit($event->location, 30) }}</td>
                            <td>{{ $event->attendees_count }}</td>
                            <td>{{ $event->interests_count }}</td>
                            <td>
                                @if($event->creator)
                                    <a href="{{ url('admin/users', $event->creator->id) }}">
                                        {{ $event->creator->name }}
                                    </a>
                                @else
                                    <span class="text-muted">Unknown</span>
                                @endif
                            </td>
                            <td>
                                <span class="badge badge-{{ $event->active ? 'success' : 'danger' }}">
                                    {{ $event->active ? 'Active' : 'Inactive' }}
                                </span>
                                @if($event->is_featured)
                                    <span class="badge badge-warning">Featured</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('admin.events.show', $event->id) }}" class="btn btn-sm btn-primary">
                                    <i class="fas fa-eye"></i>
                                </a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Events by Month Chart
        const monthlyCtx = document.getElementById('eventsByMonthChart').getContext('2d');
        const monthlyChart = new Chart(monthlyCtx, {
            type: 'bar',
            data: {
                labels: @json($eventsByMonth),
                datasets: [
                    {
                        label: 'Past Events',
                        data: @json($pastEvents),
                        backgroundColor: '#e74a3b',
                    },
                    {
                        label: 'Upcoming Events',
                        data: @json($upcomingEvents),
                        backgroundColor: '#1cc88a',
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    x: {
                        stacked: true
                    },
                    y: {
                        stacked: true,
                        beginAtZero: true,
                        ticks: {
                            precision: 0
                        }
                    }
                }
            }
        });

        // Events by Day of Week Chart
        const dayOfWeekCtx = document.getElementById('eventsByDayChart').getContext('2d');
        const dayOfWeekChart = new Chart(dayOfWeekCtx, {
            type: 'pie',
            data: {
                labels: Object.keys(@json($eventsByDayOfWeek)),
                datasets: [{
                    data: Object.values(@json($eventsByDayOfWeek)),
                    backgroundColor: @json($chartColors)
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'right'
                    }
                }
            }
        });

        // Top Events by Attendees Chart
        const attendeesCtx = document.getElementById('topEventsByAttendeesChart').getContext('2d');
        const attendeesChart = new Chart(attendeesCtx, {
            type: 'horizontalBar',
            data: {
                labels: @json(array_column($topEventsByAttendees, 'title')),
                datasets: [{
                    label: 'Attendees',
                    data: @json(array_column($topEventsByAttendees, 'count')),
                    backgroundColor: '#4e73df',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    x: {
                        beginAtZero: true,
                        ticks: {
                            precision: 0
                        }
                    }
                }
            }
        });

        // Top Events by Interests Chart
        const interestsCtx = document.getElementById('topEventsByInterestsChart').getContext('2d');
        const interestsChart = new Chart(interestsCtx, {
            type: 'horizontalBar',
            data: {
                labels: @json(array_column($topEventsByInterests, 'title')),
                datasets: [{
                    label: 'Interests',
                    data: @json(array_column($topEventsByInterests, 'count')),
                    backgroundColor: '#36b9cc',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    x: {
                        beginAtZero: true,
                        ticks: {
                            precision: 0
                        }
                    }
                }
            }
        });

        // Initialize DataTable
        $('#topEventsTable').DataTable({
            paging: true,
            pageLength: 10,
            lengthMenu: [[5, 10, 25, -1], [5, 10, 25, "All"]],
            ordering: true,
            info: true,
            autoWidth: false,
            responsive: true
        });

        // Download Report
        $('#downloadReport').click(function(e) {
            e.preventDefault();
            alert('Generating PDF report... This feature will be implemented soon.');
        });
    });
</script>
@endsection 